/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export.servlets;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.html.HtmlCleaner;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayColumn;
import com.stratelia.webactiv.util.viewGenerator.html.arrayPanes.ArrayLine;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ExportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1717365114830659355L;
    private static final String TYPE_ARRAYPANE = "ArrayPane";
    private static final String FIELD_SEPARATOR = ";";
    private static final String EXPORT_ENCODING_DEFAULT = "UTF8";
    private static final String exportEncoding = new ResourceLocator("com.stratelia.webactiv.util.viewGenerator.settings.graphicElementFactorySettings", "").getString("gef.arraypane.export.encoding", "UTF8");
    private HtmlCleaner cleaner = new HtmlCleaner();

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SilverTrace.debug((String)"Export", (String)ExportServlet.class.getName(), (String)"service() enter method");
        response.setContentType("text/csv");
        response.setCharacterEncoding(exportEncoding);
        response.setHeader("Content-Disposition", "attachment; fileName=export_data_" + System.currentTimeMillis() + ".csv");
        PrintWriter out = response.getWriter();
        HttpSession session = request.getSession(true);
        String type = request.getParameter("type");
        String name = request.getParameter("name");
        if (TYPE_ARRAYPANE.equals(type) && StringUtil.isDefined((String)name)) {
            List columns = (List)session.getAttribute(name + "_columns");
            StringBuilder listColumns = new StringBuilder();
            int lastIndex = columns.size() - 1;
            for (ArrayColumn curCol : columns) {
                String str = curCol.toString();
                SilverTrace.debug((String)"Export", (String)ExportServlet.class.getName(), (String)("column =" + str));
                listColumns.append("\"").append(this.formatCSVCell(curCol.getTitle())).append("\"");
                if (columns.indexOf(curCol) == lastIndex) continue;
                listColumns.append(FIELD_SEPARATOR);
            }
            out.println(listColumns.toString());
            List lines = (List)session.getAttribute(name + "_lines");
            SilverTrace.debug((String)"Export", (String)ExportServlet.class.getName(), (String)("number of exported lines" + lines.size()));
            for (ArrayLine curLine : lines) {
                listColumns = new StringBuilder();
                for (ArrayColumn curCol : columns) {
                    String fullCell = curLine.getCellAt(curCol.getColumnNumber()).print();
                    String cleanCell = this.cleanHtmlCode(fullCell);
                    cleanCell = cleanCell.replaceAll("(\\r|\\n)", "");
                    listColumns.append("\"").append(this.formatCSVCell(cleanCell)).append("\"");
                    if (columns.indexOf(curCol) == lastIndex) continue;
                    listColumns.append(FIELD_SEPARATOR);
                }
                out.println(listColumns.toString());
            }
        }
    }

    private String cleanHtmlCode(String html) throws IOException {
        return this.cleaner.cleanHtmlFragment(html);
    }

    private String formatCSVCell(String cell) {
        return cell.replaceAll("\"", "\"\"");
    }
}

