/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.external.webConnections.dao;

import com.silverpeas.external.webConnections.model.ConnectionDetail;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.crypto.Cipher;
import org.silverpeas.util.crypto.CipherFactory;
import org.silverpeas.util.crypto.CipherKey;
import org.silverpeas.util.crypto.CryptoException;
import org.silverpeas.util.crypto.CryptographicAlgorithmName;

public class ConnectionDAO {
    private static String tableName = "SB_webConnections_info";
    private static ResourceLocator settings = new ResourceLocator("com.silverpeas.external.webConnections.settings.webConnectionsSettings", "fr");
    private static String keyCode = settings.getString("keycode");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionDetail getConnection(Connection con, String componentId, String userId) throws SQLException {
        ConnectionDetail connection = null;
        String query = "select * from " + tableName + " where componentId = ? and userId = ? ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, componentId);
            prepStmt.setInt(2, Integer.parseInt(userId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                connection = this.recupConnection(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionDetail getConnectionById(Connection con, String connectionId) throws SQLException {
        ConnectionDetail connection = null;
        String query = "select * from " + tableName + " where connectionId = ? ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(connectionId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                connection = this.recupConnection(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createConnection(Connection con, ConnectionDetail connection) throws SQLException, UtilException {
        String id = "";
        PreparedStatement prepStmt = null;
        try {
            int newId = DBUtil.getNextId((String)tableName, (String)"connectionId");
            id = String.valueOf(newId);
            String query = "INSERT INTO " + tableName + " (connectionId, userId, componentId, paramLogin, paramPassword) " + "VALUES (?,?,?,?,?)";
            prepStmt = con.prepareStatement(query);
            ConnectionDAO.initParam(prepStmt, newId, connection);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConnection(Connection con, String connectionId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "delete from " + tableName + " where connectionId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(connectionId));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(Connection con, String connectionId, String login, String password) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "update " + tableName + " set paramLogin = ? , paramPassword = ? where connectionId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, login);
            byte[] crypPassword = null;
            try {
                crypPassword = ConnectionDAO.getCryptString(password);
            }
            catch (CryptoException e) {
                crypPassword = null;
            }
            prepStmt.setBytes(2, crypPassword);
            prepStmt.setInt(3, Integer.parseInt(connectionId));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionDetail> getConnectionsByUser(Connection con, String userId) throws SQLException {
        ArrayList<ConnectionDetail> connections = null;
        String query = "select * from " + tableName + " where userId = ? ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(userId));
            rs = prepStmt.executeQuery();
            connections = new ArrayList<ConnectionDetail>();
            while (rs.next()) {
                ConnectionDetail connection = this.recupConnection(rs);
                connections.add(connection);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return connections;
    }

    protected ConnectionDetail recupConnection(ResultSet rs) throws SQLException {
        String decryptPassword;
        ConnectionDetail connection = new ConnectionDetail();
        connection.setConnectionId(rs.getInt("connectionId"));
        connection.setUserId(rs.getString("userId"));
        connection.setComponentId(rs.getString("componentId"));
        HashMap<String, String> param = new HashMap<String, String>();
        String login = rs.getString("paramLogin");
        byte[] password = rs.getBytes("paramPassword");
        ComponentInst inst = OrganisationControllerFactory.getOrganisationController().getComponentInst(connection.getComponentId());
        String nameLogin = inst.getParameterValue("login");
        String namePassword = inst.getParameterValue("password");
        param.put(nameLogin, login);
        try {
            decryptPassword = ConnectionDAO.getUncryptString(password);
        }
        catch (CryptoException e) {
            decryptPassword = "";
        }
        param.put(namePassword, decryptPassword);
        connection.setParam(param);
        return connection;
    }

    private static void initParam(PreparedStatement prepStmt, int id, ConnectionDetail connection) throws SQLException {
        prepStmt.setInt(1, id);
        prepStmt.setInt(2, Integer.parseInt(connection.getUserId()));
        prepStmt.setString(3, connection.getComponentId());
        ComponentInst inst = OrganisationControllerFactory.getOrganisationController().getComponentInst(connection.getComponentId());
        String login = connection.getParam().get(inst.getParameterValue("login"));
        String password = connection.getParam().get(inst.getParameterValue("password"));
        byte[] crypPassword = null;
        try {
            crypPassword = ConnectionDAO.getCryptString(password);
        }
        catch (CryptoException e) {
            e.printStackTrace();
        }
        prepStmt.setString(4, login);
        prepStmt.setBytes(5, crypPassword);
    }

    private static byte[] getCryptString(String text) throws CryptoException {
        CipherFactory cipherFactory = CipherFactory.getFactory();
        Cipher blowfish = cipherFactory.getCipher(CryptographicAlgorithmName.Blowfish);
        try {
            return blowfish.encrypt(text, CipherKey.aKeyFromHexText((String)keyCode));
        }
        catch (ParseException e) {
            throw new CryptoException("The key isn't in hexadecimal: '" + keyCode + "'", (Throwable)e);
        }
    }

    private static String getUncryptString(byte[] cipherText) throws CryptoException {
        CipherFactory cipherFactory = CipherFactory.getFactory();
        Cipher blowfish = cipherFactory.getCipher(CryptographicAlgorithmName.Blowfish);
        try {
            return blowfish.decrypt(cipherText, CipherKey.aKeyFromHexText((String)keyCode));
        }
        catch (ParseException e) {
            throw new CryptoException("The key isn't in hexadecimal: '" + keyCode + "'", (Throwable)e);
        }
    }
}

