/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.external.webConnections.dao;

import com.silverpeas.external.webConnections.dao.ConnectionDAO;
import com.silverpeas.external.webConnections.dao.WebConnectionsRuntimeException;
import com.silverpeas.external.webConnections.model.ConnectionDetail;
import com.silverpeas.external.webConnections.model.WebConnectionsInterface;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class WebConnectionService
implements WebConnectionsInterface {
    private ConnectionDAO dao = new ConnectionDAO();

    @Override
    public ConnectionDetail getWebConnection(String componentId, String userId) {
        Connection con = this.initCon();
        try {
            ConnectionDetail connectionDetail = this.dao.getConnection(con, componentId, userId);
            return connectionDetail;
        }
        catch (SQLException e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.getConnection()", 4, "webConnections.MSG_CONNECTION_NOT_EXIST", e);
        }
        finally {
            this.fermerCon(con);
        }
    }

    @Override
    public ConnectionDetail getWebConnectionById(String connectionId) {
        Connection con = this.initCon();
        try {
            ConnectionDetail connectionDetail = this.dao.getConnectionById(con, connectionId);
            return connectionDetail;
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.getConnectionById()", 4, "webConnections.MSG_CONNECTION_NOT_EXIST", e);
        }
        finally {
            this.fermerCon(con);
        }
    }

    @Override
    public void createWebConnection(ConnectionDetail connection) {
        Connection con = this.initCon();
        try {
            this.dao.createConnection(con, connection);
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.createConnection()", 4, "webConnections.MSG_CONNECTION_NOT_CREATE", e);
        }
        finally {
            this.fermerCon(con);
        }
    }

    @Override
    public void deleteWebConnection(String connectionId) {
        Connection con = this.initCon();
        try {
            this.dao.deleteConnection(con, connectionId);
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.deleteConnection()", 4, "webConnections.MSG_CONNECTION_NOT_DELETE", e);
        }
        finally {
            this.fermerCon(con);
        }
    }

    @Override
    public void updateWebConnection(String connectionId, String login, String password) {
        Connection con = this.initCon();
        try {
            this.dao.updateConnection(con, connectionId, login, password);
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.updateConnection()", 4, "webConnections.MSG_CONNECTION_NOT_UPDATE", e);
        }
        finally {
            this.fermerCon(con);
        }
    }

    @Override
    public List<ConnectionDetail> listWebConnectionsOfUser(String userId) throws RemoteException {
        Connection con = this.initCon();
        try {
            List<ConnectionDetail> list = this.dao.getConnectionsByUser(con, userId);
            return list;
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.getConnectionsByUser()", 4, "webConnections.MSG_CONNECTIONS_NOT_EXIST", e);
        }
        finally {
            this.fermerCon(con);
        }
    }

    private Connection initCon() {
        Connection con = null;
        try {
            con = DBUtil.makeConnection((String)JNDINames.DATABASE_DATASOURCE);
        }
        catch (UtilException e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.initCon()", 4, "root.EX_CONNECTION_OPEN_FAILED", (Exception)((Object)e));
        }
        return con;
    }

    private void fermerCon(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            throw new WebConnectionsRuntimeException("WebConnectionsInterface.fermerCon()", 4, "root.EX_CONNECTION_CLOSE_FAILED", e);
        }
    }
}

