/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.glossary;

import com.silverpeas.glossary.TermComparator;
import com.stratelia.silverpeas.pdc.control.PdcBmImpl;
import com.stratelia.silverpeas.pdc.model.Axis;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.pdc.model.Value;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class HighlightGlossaryTerms {
    private final PdcBmImpl pdc;

    HighlightGlossaryTerms(PdcBmImpl pdc) {
        this.pdc = pdc;
    }

    public HighlightGlossaryTerms() {
        this.pdc = new PdcBmImpl();
    }

    public String searchReplace(String publicationContent, String className, String axisId, boolean onlyFirst, String language) {
        String replacedContent = publicationContent;
        List glossary = null;
        try {
            Axis axis = this.pdc.getAxisDetail(axisId);
            if (axis != null) {
                glossary = axis.getValues();
                Collections.sort(glossary, new TermComparator());
            }
        }
        catch (PdcException pdcEx) {
            // empty catch block
        }
        if (glossary != null && !glossary.isEmpty()) {
            for (Value node : glossary) {
                replacedContent = this.highlight(node.getName(language), replacedContent, node.getDescription(language), className, onlyFirst);
            }
        }
        return replacedContent;
    }

    String highlight(String term, String content, String definition, String className, boolean onlyFirst) {
        String escapedTerm = StringEscapeUtils.escapeHtml((String)term);
        String regex = "((?i)\\b" + escapedTerm + "\\b)(?=[^>]*<(?!/a))";
        String replacement = "<a href=\"#\" class=\"" + className + "\" title=\"" + definition.replaceAll("\"", "&quot;") + "\">" + escapedTerm + "</a>";
        if (onlyFirst) {
            return content.replaceFirst(regex, replacement);
        }
        return content.replaceAll(regex, replacement);
    }
}

