/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.ical;

import com.silverpeas.calendar.CalendarEvent;
import com.silverpeas.calendar.Datable;
import com.silverpeas.export.ExportDescriptor;
import com.silverpeas.export.Exporter;
import com.silverpeas.export.ExporterFactory;
import com.silverpeas.export.ical.ExportableCalendar;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.agenda.control.AgendaException;
import com.stratelia.webactiv.agenda.control.AgendaRuntimeException;
import com.stratelia.webactiv.agenda.control.AgendaSessionController;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.calendar.control.SilverpeasCalendar;
import com.stratelia.webactiv.calendar.model.Attendee;
import com.stratelia.webactiv.calendar.model.Category;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.calendar.model.ParticipationStatus;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class ExportIcalManager {
    private SilverpeasCalendar calendarBm;
    private static final String firstDate = "1970/01/01";
    private static final String lastDate = "2050/01/01";
    private String userId;
    private String language = "fr";

    public ExportIcalManager(AgendaSessionController agendaSessionController) {
        this.userId = agendaSessionController.getUserId();
        this.language = agendaSessionController.getLanguage();
        this.setCalendarBm();
    }

    public ExportIcalManager(String userId) {
        this.userId = userId;
        this.setCalendarBm();
    }

    private String getUserId() {
        return this.userId;
    }

    private String getLanguage() {
        return this.language;
    }

    public String exportIcalAgenda(String startDate, String endDate) throws AgendaException {
        String returnCode = "0";
        String calendarIcsFileName = "agenda" + this.getUserId() + ".ics";
        String filePath = FileRepositoryManager.getTemporaryPath() + calendarIcsFileName;
        ExporterFactory exporterFactory = ExporterFactory.getFactory();
        Exporter iCalExporter = exporterFactory.getICalExporter();
        try {
            FileWriter fileWriter = new FileWriter(filePath);
            ExportDescriptor descriptor = ExportDescriptor.withWriter((Writer)fileWriter);
            List<CalendarEvent> events = this.getCalendarEvents(startDate, endDate);
            if (events.isEmpty()) {
                returnCode = "2";
            } else {
                iCalExporter.export(descriptor, (Serializable)ExportableCalendar.with(events));
            }
        }
        catch (Exception ex) {
            try {
                SilverTrace.error((String)"agenda", (String)(this.getClass().getSimpleName() + ".exportIcalAgenda()"), (String)"root.EX_NO_MESSAGE", (Throwable)ex);
                FileFolderManager.deleteFile((String)filePath);
            }
            catch (UtilException ex1) {
                SilverTrace.error((String)"agenda", (String)(this.getClass().getSimpleName() + ".exportIcalAgenda()"), (String)"root.EX_NO_MESSAGE", (Throwable)ex1);
            }
            throw new AgendaException("ExportIcalManager.exportIcalAgenda()", 4, "agenda.EXPORT_ICAL_FAILED", ex);
        }
        return returnCode;
    }

    public String exportIcalAgenda() throws AgendaException {
        return this.exportIcalAgenda(null, null);
    }

    public String exportIcalAgendaForSynchro() throws AgendaException {
        String calendarIcsFileName = "agenda" + this.getUserId() + ".ics";
        String filePath = null;
        ExporterFactory exporterFactory = ExporterFactory.getFactory();
        Exporter iCalExporter = exporterFactory.getICalExporter();
        try {
            List<CalendarEvent> events = this.getCalendarEvents(null, null);
            if (!events.isEmpty()) {
                filePath = FileRepositoryManager.getTemporaryPath() + calendarIcsFileName;
                FileWriter fileWriter = new FileWriter(filePath);
                ExportDescriptor descriptor = ExportDescriptor.withWriter((Writer)fileWriter);
                iCalExporter.export(descriptor, (Serializable)ExportableCalendar.with(events));
            }
        }
        catch (Exception ex) {
            try {
                SilverTrace.error((String)"agenda", (String)(this.getClass().getSimpleName() + ".exportIcalAgenda()"), (String)"root.EX_NO_MESSAGE", (Throwable)ex);
                FileFolderManager.deleteFile((String)filePath);
            }
            catch (UtilException ex1) {
                SilverTrace.error((String)"agenda", (String)(this.getClass().getSimpleName() + ".exportIcalAgenda()"), (String)"root.EX_NO_MESSAGE", (Throwable)ex1);
            }
            throw new AgendaException("ExportIcalManager.exportIcalAgendaForSynchro()", 4, "agenda.EXPORT_ICAL_FAILED", ex);
        }
        return filePath;
    }

    private Collection<JournalHeader> getSchedulableCalendar(String startDate, String endDate) throws ParseException {
        return this.calendarBm.getPeriodSchedulablesForUser(DateUtil.date2SQLDate((String)startDate, (String)this.getLanguage()), DateUtil.date2SQLDate((String)endDate, (String)this.getLanguage()), this.getUserId(), null, new ParticipationStatus("accepted").getString());
    }

    private List<CalendarEvent> getCalendarEvents(String startDate, String endDate) throws ParseException {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        String fromDate = this.at(startDate, this.or(firstDate));
        String toDate = this.at(endDate, this.or(lastDate));
        Collection<JournalHeader> schedulables = this.getSchedulableCalendar(fromDate, toDate);
        for (JournalHeader schedulable : schedulables) {
            Datable eventStartDate = DateUtil.asDatable((Date)schedulable.getStartDate(), (boolean)StringUtil.isDefined((String)schedulable.getStartHour()));
            Datable eventEndDate = DateUtil.asDatable((Date)schedulable.getEndDate(), (boolean)StringUtil.isDefined((String)schedulable.getEndHour()));
            CalendarEvent event = CalendarEvent.anEventAt((Datable)eventStartDate, (Datable)eventEndDate).withTitle(schedulable.getName()).withDescription(schedulable.getDescription());
            event.withAccessLevel(schedulable.getClassification().getString());
            event.withPriority(schedulable.getPriority().getValue());
            Collection categories = this.calendarBm.getJournalCategories(schedulable.getId());
            for (Category category : categories) {
                event.getCategories().add(category.getName());
            }
            Collection attendees = this.calendarBm.getJournalAttendees(schedulable.getId());
            for (Attendee attendee : attendees) {
                String email;
                UserDetail user = OrganisationControllerFactory.getOrganisationController().getUserDetail(attendee.getUserId());
                if (user == null || !StringUtil.isDefined((String)(email = user.geteMail()))) continue;
                event.getAttendees().add(email);
            }
            events.add(event);
        }
        return events;
    }

    private void setCalendarBm() {
        if (this.calendarBm == null) {
            try {
                this.calendarBm = (SilverpeasCalendar)EJBUtilitaire.getEJBObjectRef((String)JNDINames.CALENDARBM_EJBHOME, SilverpeasCalendar.class);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException("ExportIcalManager.setCalendarBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
    }

    private String at(String aDate, String defaultDate) throws ParseException {
        String at = aDate;
        if (!StringUtil.isDefined((String)aDate)) {
            at = DateUtil.getInputDate((String)defaultDate, (String)this.getLanguage());
        }
        return at;
    }

    private String or(String defaultDate) {
        return defaultDate;
    }
}

