/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.ical;

import com.silverpeas.ical.StringUtils;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.silverpeas.util.Charsets;

public final class FeedUtilities {
    private static final String USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 5.1; hu; rv:1.8.0.8) Gecko/20061025 Thunderbird/1.5.0.8";
    private static final long REMOTE_CALENDAR_RETURNCODE_OK = 200L;
    private static final long FEED_RETRY_MILLIS = 1000L;
    private static final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private static final HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);

    private FeedUtilities() {
    }

    public static final byte[] loadFeed(String feedURL) throws Exception {
        return FeedUtilities.loadFeed(feedURL, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadFeed(String feedURL, String username, String password) throws Exception {
        GetMethod get = new GetMethod(feedURL);
        get.addRequestHeader("User-Agent", USER_AGENT);
        get.setFollowRedirects(true);
        SilverTrace.info((String)"agenda", (String)"FeedUtilities.loadFeed()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("username=" + username + " - pwd=" + password));
        if (StringUtil.isDefined((String)username)) {
            byte[] auth = StringUtils.encodeString(username + ':' + StringUtils.decodePassword(password), Charsets.UTF_8);
            get.addRequestHeader("Authorization", "Basic " + StringUtils.encodeBASE64(auth));
        }
        byte[] bytes = null;
        for (int tries = 0; tries < 5; ++tries) {
            try {
                int status = httpClient.executeMethod((HttpMethod)get);
                SilverTrace.warn((String)"agenda", (String)"FeedUtilities.loadFeed()", (String)("Http connection status : " + status));
                if ((long)status == 200L) {
                    bytes = get.getResponseBody();
                    SilverTrace.info((String)"agenda", (String)"FeedUtilities.loadFeed()", (String)"agenda.FEED_LOADING_SUCCESSFULLY", (String)(bytes.length + " bytes."));
                    continue;
                }
                SilverTrace.warn((String)"agenda", (String)"FeedUtilities.loadFeed()", (String)"agenda.FEED_LOADING_FAILED", (String)("Status Http Client=" + status + " Content=" + Arrays.toString(bytes)));
                bytes = null;
                continue;
            }
            catch (Exception loadError) {
                SilverTrace.warn((String)"agenda", (String)"FeedUtilities.loadFeed()", (String)("Attempt #" + tries + " Status="), (String)loadError.getMessage());
                if (tries == 5) {
                    bytes = null;
                    SilverTrace.warn((String)"agenda", (String)"FeedUtilities.loadFeed()", (String)"agenda.CONNECTIONS_REFUSED", (String)loadError.getMessage());
                }
                Thread.sleep(1000L);
                continue;
            }
            finally {
                get.releaseConnection();
            }
        }
        return bytes;
    }

    public static Calendar convertFeedToCalendar(SyndFeed feed, long eventLength) throws Exception {
        Calendar calendar = new Calendar();
        PropertyList props = calendar.getProperties();
        props.add((Property)new ProdId("-//Silverpeas//iCal4j 1.0//FR"));
        props.add((Property)Version.VERSION_2_0);
        props.add((Property)CalScale.GREGORIAN);
        SyndEntry[] entries = FeedUtilities.getFeedEntries(feed);
        ComponentList events = calendar.getComponents();
        java.util.Date now = new java.util.Date();
        for (SyndEntry entry1 : entries) {
            SyndEntry entry = entry1;
            String url = entry.getLink();
            if (url == null || url.length() == 0) continue;
            java.util.Date date = entry.getPublishedDate();
            if (date == null) {
                date = now;
            }
            DateTime startDate = new DateTime(date);
            DateTime endDate = new DateTime(date.getTime() + eventLength);
            String title = entry.getTitle();
            title = title == null || title.length() == 0 ? url : title.trim();
            VEvent event = new VEvent((Date)startDate, (Date)endDate, title);
            PropertyList args = event.getProperties();
            URI uri = new URI(url);
            args.add((Property)new Url(uri));
            Location location = new Location(uri.getHost());
            args.add((Property)location);
            Uid uid = new Uid(url);
            args.add((Property)uid);
            SyndContent syndContent = entry.getDescription();
            String content = null;
            if (syndContent != null) {
                content = syndContent.getValue();
            }
            if (content == null) {
                content = url;
            }
            Description desc = new Description(content);
            args.add((Property)desc);
            events.add((Component)event);
        }
        return calendar;
    }

    private static final SyndEntry[] getFeedEntries(SyndFeed feed) throws Exception {
        List list = feed.getEntries();
        SyndEntry[] entries = new SyndEntry[list.size()];
        list.toArray(entries);
        return entries;
    }

    public static final SyndFeed parseFeed(byte[] feedBytes) throws Exception {
        SyndFeed synFeed = null;
        try {
            SyndFeedInput input = new SyndFeedInput();
            XmlReader xmlReader = new XmlReader((InputStream)new ByteArrayInputStream(feedBytes));
            synFeed = input.build((Reader)xmlReader);
        }
        catch (Exception e) {
            SilverTrace.warn((String)"agenda", (String)"FeedUtilities.parseFeed()", (String)"agenda.EX_CANT_PARSE_FEED", (Throwable)e);
        }
        return synFeed;
    }
}

