/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.ical;

import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.agenda.control.AgendaRuntimeException;
import com.stratelia.webactiv.agenda.control.AgendaSessionController;
import com.stratelia.webactiv.calendar.control.SilverpeasCalendar;
import com.stratelia.webactiv.calendar.model.Category;
import com.stratelia.webactiv.calendar.model.Schedulable;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.io.IOUtils;

public class ImportIcalManager {
    public static final String IMPORT_SUCCEEDED = "0";
    public static final String IMPORT_EMPTY = "1";
    private static final long YEAR = 31536000000L;
    public static String charset = null;
    private AgendaSessionController agendaSessionController;
    private SilverpeasCalendar calendarBm;

    public ImportIcalManager(AgendaSessionController agendaSessionController) {
        this.agendaSessionController = agendaSessionController;
        this.setCalendarBm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importIcalAgenda(File file) throws Exception {
        SilverTrace.debug((String)"agenda", (String)"ImportIcalManager.importIcalAgenda()", (String)"root.MSG_GEN_ENTER_METHOD");
        String returnCode = IMPORT_EMPTY;
        InputStreamReader inputStream = null;
        XmlReader xr = null;
        try {
            String charsetUsed = this.agendaSessionController.getSettings().getString("defaultCharset");
            if (StringUtil.isDefined((String)charset)) {
                charsetUsed = charset;
            }
            xr = new XmlReader(file);
            SilverTrace.debug((String)"agenda", (String)"ImportIcalManager.importIcalAgenda()", (String)("Encoding = " + xr.getEncoding()));
            if (StringUtil.isDefined((String)xr.getEncoding())) {
                charsetUsed = xr.getEncoding();
            }
            inputStream = new InputStreamReader((InputStream)new FileInputStream(file), charsetUsed);
            CalendarBuilder builder = new CalendarBuilder();
            Calendar calendar = builder.build((Reader)inputStream);
            for (Object o : calendar.getComponents("VEVENT")) {
                Collection reccurenceDates;
                String priority;
                VEvent eventIcal = (VEvent)o;
                String name = this.getFieldEvent(eventIcal.getProperty("SUMMARY"));
                String description = null;
                if (StringUtil.isDefined((String)this.getFieldEvent(eventIcal.getProperty("DESCRIPTION")))) {
                    description = this.getFieldEvent(eventIcal.getProperty("DESCRIPTION"));
                }
                if (!StringUtil.isDefined((String)name)) {
                    name = StringUtil.isDefined(description) ? description : " ";
                }
                if (!StringUtil.isDefined((String)(priority = this.getFieldEvent(eventIcal.getProperty("PRIORITY"))))) {
                    priority = Priority.UNDEFINED.getValue();
                }
                String classification = this.getFieldEvent(eventIcal.getProperty("CLASS"));
                String startDate = this.getFieldEvent(eventIcal.getProperty("DTSTART"));
                String endDate = this.getFieldEvent(eventIcal.getProperty("DTEND"));
                Date startDay = this.getDay(startDate);
                String startHour = this.getHour(startDate);
                Date endDay = this.getDay(endDate);
                String endHour = this.getHour(endDate);
                long duration = endDay.getTime() - startDay.getTime();
                boolean allDay = false;
                if ("00:00".equals(startHour) && "00:00".equals(endHour) || !StringUtil.isDefined((String)startHour) && !StringUtil.isDefined((String)endHour)) {
                    startHour = "";
                    endHour = "";
                    allDay = true;
                }
                if ((reccurenceDates = ImportIcalManager.getRecurrenceDates(eventIcal)) == null) {
                    String idEvent = this.isExist((Component)eventIcal);
                    if (StringUtil.isDefined((String)idEvent)) {
                        this.agendaSessionController.updateJournal(idEvent, name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
                    } else {
                        idEvent = this.agendaSessionController.addJournal(name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
                    }
                    this.processCategories((Component)eventIcal, idEvent);
                    continue;
                }
                for (Object reccurenceDate : reccurenceDates) {
                    String idEvent;
                    startDay = (DateTime)reccurenceDate;
                    long newEndDay = startDay.getTime() + duration;
                    endDay = new DateTime(newEndDay);
                    if (allDay) {
                        GregorianCalendar gregCalendar = new GregorianCalendar();
                        gregCalendar.setTime((java.util.Date)endDay);
                        gregCalendar.add(5, -1);
                        endDay = new Date(gregCalendar.getTime());
                    }
                    if (StringUtil.isDefined((String)(idEvent = this.isExist((Component)eventIcal, startDay, endDay, startHour)))) {
                        SilverTrace.debug((String)"agenda", (String)"ImportIcalManager.importIcalAgenda()", (String)("root.MSG_GEN_PARAM_VALUEUpdate event: " + DateUtil.date2SQLDate((java.util.Date)startDay) + " " + startHour + " to " + DateUtil.date2SQLDate((java.util.Date)endDay) + " " + endHour));
                        this.agendaSessionController.updateJournal(idEvent, name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
                    } else {
                        SilverTrace.debug((String)"agenda", (String)"ImportIcalManager.importIcalAgenda()", (String)("root.MSG_GEN_PARAM_VALUECreate event: " + DateUtil.date2SQLDate((java.util.Date)startDay) + " " + startHour + " to " + DateUtil.date2SQLDate((java.util.Date)endDay) + " " + endHour));
                        idEvent = this.agendaSessionController.addJournal(name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
                    }
                    this.processCategories((Component)eventIcal, idEvent);
                }
            }
            returnCode = IMPORT_SUCCEEDED;
        }
        catch (Exception e) {
            try {
                SilverTrace.error((String)"agenda", (String)"ImportIcalManager.importIcalAgenda()", (String)e.getCause().toString());
                returnCode = IMPORT_EMPTY;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(xr);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly((Reader)xr);
        }
        IOUtils.closeQuietly((Reader)inputStream);
        IOUtils.closeQuietly((Reader)xr);
        SilverTrace.debug((String)"agenda", (String)"ImportIcalManager.importIcalAgenda()", (String)"root.MSG_GEN_EXIT_METHOD");
        return returnCode;
    }

    private String isExist(Component eventIcal) throws Exception {
        return this.isExist(eventIcal, null, null, null);
    }

    private String isExist(Component eventIcal, Date startDateReccurent, Date endDateReccurent, String startHourReccurent) throws Exception {
        Collection events;
        SilverTrace.debug((String)"agenda", (String)"ImportIcalManager.isExist()", (String)"root.MSG_GEN_ENTER_METHOD");
        String name = this.getFieldEvent(eventIcal.getProperty("SUMMARY"));
        String description = null;
        if (StringUtil.isDefined((String)this.getFieldEvent(eventIcal.getProperty("DESCRIPTION")))) {
            description = this.getFieldEvent(eventIcal.getProperty("DESCRIPTION"));
        }
        if (!StringUtil.isDefined((String)name)) {
            name = StringUtil.isDefined(description) ? description : " ";
        }
        String startDate = DateUtil.date2SQLDate((java.util.Date)this.getDay(this.getFieldEvent(eventIcal.getProperty("DTSTART"))));
        String endDate = DateUtil.date2SQLDate((java.util.Date)this.getDay(this.getFieldEvent(eventIcal.getProperty("DTEND"))));
        String startHour = this.getHour(this.getFieldEvent(eventIcal.getProperty("DTSTART")));
        if (startDateReccurent != null) {
            startDate = DateUtil.date2SQLDate((java.util.Date)startDateReccurent);
            endDate = DateUtil.date2SQLDate((java.util.Date)endDateReccurent);
            startHour = startHourReccurent;
        }
        if (!(events = this.calendarBm.getPeriodSchedulablesForUser(startDate, endDate, this.agendaSessionController.getAgendaUserId(), null, this.agendaSessionController.getParticipationStatus().getString())).isEmpty()) {
            for (Object obj : events) {
                Schedulable eventAgenda;
                if (!(obj instanceof Schedulable) || !(eventAgenda = (Schedulable)obj).getName().equals(name) || !DateUtil.date2SQLDate((java.util.Date)eventAgenda.getStartDate()).equals(startDate)) continue;
                if (StringUtil.isDefined((String)eventAgenda.getStartHour()) && StringUtil.isDefined((String)startHour)) {
                    if (!eventAgenda.getStartHour().equals(startHour)) continue;
                    return eventAgenda.getId();
                }
                return eventAgenda.getId();
            }
        }
        return null;
    }

    private void processCategories(Component eventIcal, String idEvent) throws Exception {
        if (eventIcal.getProperty("CATEGORIES") != null) {
            String categories = eventIcal.getProperty("CATEGORIES").getValue();
            StringTokenizer st = new StringTokenizer(categories, ",");
            String[] categoryIds = new String[st.countTokens()];
            int j = 0;
            boolean addCategoryToEvent = false;
            while (st.hasMoreTokens()) {
                String categIcal = st.nextToken();
                for (Category category : this.agendaSessionController.getAllCategories()) {
                    if (!categIcal.equals(EncodeHelper.htmlStringToJavaString((String)category.getName()))) continue;
                    addCategoryToEvent = true;
                    categoryIds[j++] = category.getId();
                }
            }
            if (addCategoryToEvent) {
                this.agendaSessionController.setJournalCategories(idEvent, categoryIds);
            }
        }
    }

    private void setCalendarBm() {
        if (this.calendarBm == null) {
            try {
                this.calendarBm = (SilverpeasCalendar)EJBUtilitaire.getEJBObjectRef((String)JNDINames.CALENDARBM_EJBHOME, SilverpeasCalendar.class);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException("ImportIcalManager.setCalendarBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
    }

    private Date getDay(String dateTime) throws ParseException {
        Object day = dateTime.length() > 8 ? new DateTime(dateTime) : new Date(dateTime);
        return day;
    }

    private String getHour(String dateTime) throws ParseException {
        String hour = null;
        if (dateTime.length() > 8) {
            hour = DateUtil.getFormattedTime((java.util.Date)new DateTime(dateTime));
        }
        return hour;
    }

    private String getFieldEvent(Property property) {
        String fieldValue = null;
        if (property != null) {
            fieldValue = EncodeHelper.transformStringForBD((String)property.getValue());
        }
        return fieldValue;
    }

    private static final Collection getRecurrenceDates(VEvent event) {
        RRule rule = (RRule)event.getProperty("RRULE");
        if (rule != null) {
            Recur recur = rule.getRecur();
            DateTime startDate = new DateTime((java.util.Date)event.getStartDate().getDate());
            long interval = 63072000000L;
            if ("YEARLY".equals(recur.getFrequency())) {
                interval *= 5L;
            }
            DateTime endDate = new DateTime(startDate.getTime() + interval);
            DateList dates = recur.getDates((Date)startDate, (Date)endDate, Value.DATE_TIME);
            return dates;
        }
        return null;
    }
}

