/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.ical;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import org.silverpeas.util.Charsets;

public final class StringUtils {
    public static byte[] encodeString(String string, Charset encoding) throws CharacterCodingException {
        return StringUtils.encodeArray(string.toCharArray(), encoding);
    }

    public static byte[] encodeString(String string, String encoding) throws CharacterCodingException {
        return StringUtils.encodeString(string, Charsets.toCharset((String)encoding));
    }

    static byte[] encodeArray(char[] chars, Charset encoding) throws CharacterCodingException {
        if ("US-ASCII".equals(encoding.name())) {
            byte[] array = new byte[chars.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)chars[i];
            }
            return array;
        }
        ByteBuffer buffer = encoding.newEncoder().encode(CharBuffer.wrap(chars));
        byte[] array = new byte[buffer.limit()];
        System.arraycopy(buffer.array(), 0, array, 0, array.length);
        return array;
    }

    public static String decodeToString(byte[] bytes, String encoding) {
        return new String(StringUtils.decodeToArray(bytes, Charsets.toCharset((String)encoding)));
    }

    public static String decodeToString(byte[] bytes, Charset encoding) {
        return new String(StringUtils.decodeToArray(bytes, encoding));
    }

    static char[] decodeToArray(byte[] bytes, Charset encoding) {
        if ("US-ASCII".equals(encoding.name())) {
            char[] array = new char[bytes.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (char)bytes[i];
            }
            return array;
        }
        try {
            CharBuffer buffer = encoding.newDecoder().decode(ByteBuffer.wrap(bytes));
            char[] array = new char[buffer.limit()];
            System.arraycopy(buffer.array(), 0, array, 0, array.length);
            return array;
        }
        catch (Exception nioException) {
            return new String(bytes, encoding).toCharArray();
        }
    }

    public static String decodePassword(String encodedPassword) throws Exception {
        StringBuilder buffer = new StringBuilder(encodedPassword.substring(3));
        return StringUtils.decodeBASE64(buffer.reverse().toString().replace('$', '=')).trim();
    }

    public static long stringToLong(String string) throws NumberFormatException {
        StringBuffer buffer = new StringBuffer(string.toLowerCase());
        long unit = StringUtils.resolveUnit(buffer);
        long value = Long.parseLong(buffer.toString().trim());
        if (unit != 1L) {
            value *= unit;
        }
        return value;
    }

    private static long resolveUnit(StringBuffer buffer) {
        long unit = 1L;
        int i = -1;
        i = buffer.indexOf("msec", 0);
        if (i == -1 && (i = buffer.indexOf("mill", 0)) == -1) {
            i = buffer.indexOf("sec", 0);
            if (i != -1) {
                unit = 1000L;
            } else {
                i = buffer.indexOf("min", 0);
                if (i != -1) {
                    unit = 60000L;
                } else {
                    i = buffer.indexOf("hour", 0);
                    if (i != -1) {
                        unit = 3600000L;
                    } else {
                        i = buffer.indexOf("day", 0);
                        if (i != -1) {
                            unit = 86400000L;
                        } else {
                            i = buffer.indexOf("week", 0);
                            if (i != -1) {
                                unit = 604800000L;
                            } else {
                                i = buffer.indexOf("month", 0);
                                if (i != -1) {
                                    unit = 2592000000L;
                                } else {
                                    i = buffer.indexOf("year", 0);
                                    if (i != -1) {
                                        unit = 31536000000L;
                                    } else {
                                        i = buffer.indexOf("kbyte", 0);
                                        if (i != -1) {
                                            unit = 1024L;
                                        } else {
                                            i = buffer.indexOf("mbyte", 0);
                                            if (i != -1) {
                                                unit = 0x100000L;
                                            } else {
                                                i = buffer.indexOf("gbyte", 0);
                                                if (i != -1) {
                                                    unit = 0x40000000L;
                                                } else {
                                                    i = buffer.indexOf("tbyte", 0);
                                                    if (i != -1) {
                                                        unit = 0x10000000000L;
                                                    } else {
                                                        i = buffer.indexOf("byte", 0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (i != -1) {
            buffer.setLength(i);
        }
        return unit;
    }

    public static String decodeBASE64(String string) {
        return StringUtils.decodeToString(DatatypeConverter.parseBase64Binary((String)string), "UTF-8");
    }

    public static String encodeBASE64(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }
}

