/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.ical;

import com.silverpeas.ical.FeedUtilities;
import com.silverpeas.ical.ImportIcalManager;
import com.silverpeas.ical.StringUtils;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.sun.syndication.feed.synd.SyndFeed;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;

public final class SyncEngine {
    public static final String REMOTE_CONNECT_SUCCEEDED = "0";
    public static final String AUTHENT_LOGIN_FAILED = "1";
    public static final String AUTHENT_PWD_FAILED = "2";
    public static final String REMOTE_CONNECT_FAILED = "3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String synchronize(File localCalendar, URL remoteCalendar, String username, String password) throws Exception {
        SilverTrace.info((String)"agenda", (String)"SyncEngine.synchronize()", (String)"root.MSG_GEN_ENTER_METHOD");
        if (username == null || username.length() == 0) {
            return AUTHENT_LOGIN_FAILED;
        }
        if (password == null || password.length() == 0) {
            return AUTHENT_PWD_FAILED;
        }
        String returnCode = REMOTE_CONNECT_FAILED;
        byte[] feedBytes = FeedUtilities.loadFeed(remoteCalendar.toString(), username, password);
        FileOutputStream fileOutputStream = new FileOutputStream(localCalendar);
        OutputStreamWriter fileOutput = new OutputStreamWriter((OutputStream)fileOutputStream, ImportIcalManager.charset);
        try {
            if (feedBytes != null) {
                if (this.isRssFeed(feedBytes, remoteCalendar)) {
                    SilverTrace.info((String)"agenda", (String)"SyncEngine.synchronize()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"Feed RSS");
                    CalendarOutputter outputter = new CalendarOutputter();
                    SyndFeed feed = FeedUtilities.parseFeed(feedBytes);
                    Calendar feedCalendar = FeedUtilities.convertFeedToCalendar(feed, 100000000L);
                    outputter.output(feedCalendar, (Writer)fileOutput);
                } else {
                    SilverTrace.info((String)"agenda", (String)"SyncEngine.synchronize()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"Feed File");
                    fileOutput.write(StringUtils.decodeToString(feedBytes, ImportIcalManager.charset));
                    fileOutput.flush();
                }
                returnCode = REMOTE_CONNECT_SUCCEEDED;
            } else {
                returnCode = REMOTE_CONNECT_FAILED;
            }
        }
        catch (Exception e) {
            returnCode = REMOTE_CONNECT_FAILED;
        }
        finally {
            if (fileOutput != null) {
                fileOutput.close();
            }
        }
        SilverTrace.info((String)"agenda", (String)"SyncEngine.synchronize()", (String)"root.MSG_GEN_EXIT_METHOD");
        return returnCode;
    }

    private boolean isRssFeed(byte[] bytes, URL feedUrl) throws Exception {
        boolean isRssFeed = false;
        SyndFeed syndFeed = FeedUtilities.parseFeed(bytes);
        if (syndFeed != null && syndFeed.getFeedType() != null) {
            isRssFeed = true;
        }
        return isRssFeed;
    }
}

