/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.importExport.FormTemplateImportExport;
import com.silverpeas.form.importExport.XMLField;
import com.silverpeas.formTemplate.ejb.FormTemplateBm;
import com.silverpeas.importExport.control.ComponentImportExport;
import com.silverpeas.importExport.control.ImportSettings;
import com.silverpeas.importExport.model.ImportExportException;
import com.silverpeas.importExport.model.PublicationType;
import com.silverpeas.importExport.report.ImportReportManager;
import com.silverpeas.importExport.report.MassiveReport;
import com.silverpeas.importExport.report.UnitReport;
import com.silverpeas.node.importexport.NodePositionType;
import com.silverpeas.publication.importExport.DBModelContentType;
import com.silverpeas.publication.importExport.PublicationContentType;
import com.silverpeas.publication.importExport.XMLModelContentType;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.thumbnail.control.ThumbnailController;
import com.silverpeas.thumbnail.model.ThumbnailDetail;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.wysiwyg.importExport.WysiwygContentType;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.OrganizationController;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.coordinates.model.Coordinate;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.info.model.InfoDetail;
import com.stratelia.webactiv.util.publication.info.model.InfoImageDetail;
import com.stratelia.webactiv.util.publication.info.model.InfoTextDetail;
import com.stratelia.webactiv.util.publication.info.model.ModelDetail;
import com.stratelia.webactiv.util.publication.info.model.ModelPK;
import com.stratelia.webactiv.util.publication.model.Alias;
import com.stratelia.webactiv.util.publication.model.CompletePublication;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.attachment.AttachmentImportExport;
import org.silverpeas.wysiwyg.WysiwygException;
import org.silverpeas.wysiwyg.control.WysiwygController;

public abstract class GEDImportExport
extends ComponentImportExport {
    private static final OrganizationController organizationController = new OrganizationController();
    private PublicationBm publicationBm = null;
    private FormTemplateBm formTemplateBm = null;
    private NodeBm nodeBm = null;
    private AttachmentImportExport attachmentIE = new AttachmentImportExport();

    public GEDImportExport(UserDetail curentUserDetail, String currentComponentId) {
        super(curentUserDetail, currentComponentId);
    }

    protected PublicationBm getPublicationBm() throws ImportExportException {
        if (this.publicationBm == null) {
            try {
                this.publicationBm = (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
            }
            catch (Exception e) {
                throw new ImportExportException("GEDImportExport.getPublicationBm()", "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.publicationBm;
    }

    protected FormTemplateBm getFormTemplateBm() throws ImportExportException {
        if (this.formTemplateBm == null) {
            try {
                this.formTemplateBm = (FormTemplateBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.FORMTEMPLATEBM_EJBHOME, FormTemplateBm.class);
            }
            catch (Exception e) {
                throw new ImportExportException("GEDImportExport.getPublicationBm()", "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.formTemplateBm;
    }

    protected NodeBm getNodeBm() throws ImportExportException {
        if (this.nodeBm == null) {
            try {
                this.nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
            }
            catch (Exception e) {
                throw new ImportExportException("GEDImportExport.getNodeBm()", "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.nodeBm;
    }

    private List<NodePositionType> processTopics(String userId, List<NodePositionType> topics, String componentId) {
        if (this.isKmax()) {
            return topics;
        }
        return this.getExistingTopics(userId, topics, componentId);
    }

    private PublicationDetail processPublicationDetail(UnitReport unitReport, ImportSettings settings, PublicationDetail pubDetailToCreate, List<NodePositionType> listOfNodeTypes) {
        NodePositionType node_Type;
        Iterator<NodePositionType> itListNode_Type;
        List<NodePositionType> existingTopics = this.processTopics(settings.getUser().getId(), listOfNodeTypes, pubDetailToCreate.getPK().getInstanceId());
        if (existingTopics.isEmpty() && !this.isKmax()) {
            unitReport.setStatus(3);
            unitReport.setError(5);
            return null;
        }
        PublicationDetail pubDet_temp = null;
        boolean pubAlreadyExist = true;
        if (this.isKmax()) {
            pubAlreadyExist = false;
        }
        String pubId = null;
        boolean pubIdExists = false;
        if (pubDetailToCreate.getId() != null) {
            pubIdExists = StringUtil.isInteger((String)pubDetailToCreate.getId());
        }
        if (!pubIdExists) {
            if (!settings.isPublicationMergeEnabled()) {
                pubAlreadyExist = false;
            } else {
                try {
                    itListNode_Type = existingTopics.iterator();
                    if (itListNode_Type.hasNext()) {
                        node_Type = itListNode_Type.next();
                        pubDet_temp = this.getPublicationBm().getDetailByNameAndNodeId(pubDetailToCreate.getPK(), pubDetailToCreate.getName(), node_Type.getId());
                    }
                }
                catch (Exception pre) {
                    pubAlreadyExist = false;
                }
            }
        } else {
            try {
                pubDet_temp = this.getPublicationBm().getDetail(pubDetailToCreate.getPK());
            }
            catch (Exception ex) {
                unitReport.setError(12);
                return null;
            }
        }
        if (this.isKmax()) {
            try {
                pubDet_temp = this.getPublicationBm().getDetailByName(pubDetailToCreate.getPK(), pubDetailToCreate.getName());
                if (pubDet_temp != null) {
                    pubAlreadyExist = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (pubAlreadyExist) {
            try {
                this.updatePublication(pubDet_temp, pubDetailToCreate, settings.getUser());
                unitReport.setStatus(1);
            }
            catch (Exception e) {
                unitReport.setError(0);
                return null;
            }
        } else {
            pubDet_temp = pubDetailToCreate;
        }
        if (pubIdExists && StringUtil.isDefined((String)pubDetailToCreate.getImage())) {
            this.processThumbnail(pubDetailToCreate.getImage(), pubDet_temp);
        }
        if (this.isKmax() && !pubAlreadyExist) {
            try {
                pubDet_temp = this.createPublication(pubDet_temp);
                unitReport.setStatus(0);
            }
            catch (Exception e) {
                unitReport.setError(0);
            }
        } else {
            NodePK topicPK;
            itListNode_Type = existingTopics.iterator();
            if (!pubAlreadyExist) {
                node_Type = itListNode_Type.next();
                try {
                    topicPK = new NodePK(Integer.toString(node_Type.getId()), (WAPrimaryKey)pubDetailToCreate.getPK());
                    pubId = this.createPublicationIntoTopic(pubDet_temp, topicPK, settings.getUser());
                    pubDet_temp.getPK().setId(pubId);
                }
                catch (Exception e) {
                    unitReport.setError(0);
                }
                unitReport.setStatus(0);
            }
            if (this.isKmelia()) {
                while (itListNode_Type.hasNext()) {
                    node_Type = itListNode_Type.next();
                    try {
                        topicPK = new NodePK(Integer.toString(node_Type.getId()), (WAPrimaryKey)pubDetailToCreate.getPK());
                        PublicationPK pubPK = new PublicationPK(pubId, (WAPrimaryKey)pubDetailToCreate.getPK());
                        if (pubAlreadyExist) {
                            try {
                                this.getPublicationBm().getDetailByNameAndNodeId(pubDet_temp.getPK(), pubDet_temp.getName(), node_Type.getId());
                            }
                            catch (Exception ex) {
                                this.addPublicationToTopic(pubPK, topicPK);
                            }
                            continue;
                        }
                        this.addPublicationToTopic(pubPK, topicPK);
                    }
                    catch (Exception ex) {
                        unitReport.setError(0);
                    }
                }
            }
        }
        return pubDet_temp;
    }

    private boolean isKmelia() {
        return this.getCurrentComponentId().startsWith("kmelia");
    }

    public boolean isKmax() {
        return this.getCurrentComponentId().startsWith("kmax");
    }

    public void createPublicationContent(ImportReportManager reportManager, UnitReport unitReport, int pubId, PublicationContentType pubContent, String userId, String language) throws ImportExportException {
        this.createPublicationContent(reportManager, unitReport, pubId, pubContent, userId, FileServerUtils.getApplicationContext(), language);
    }

    public void createPublicationContent(ImportReportManager reportManager, UnitReport unitReport, int pubId, PublicationContentType pubContent, String userId, String webContext, String language) throws ImportExportException {
        WysiwygContentType wysiwygType = pubContent.getWysiwygContentType();
        XMLModelContentType xmlModel = pubContent.getXMLModelContentType();
        try {
            if (wysiwygType != null) {
                this.createWysiwygContent(reportManager, unitReport, pubId, wysiwygType, userId, language);
            } else if (xmlModel != null) {
                this.createXMLModelContent(xmlModel, Integer.toString(pubId), userId);
            }
        }
        catch (ImportExportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImportExportException("GEDImportExport.createPublicationContent()", "importExport.EX_CANT_CREATE_CONTENT", "pubId = " + pubId, ex);
        }
    }

    private void createXMLModelContent(XMLModelContentType xmlModel, String pubId, String userId) throws Exception {
        PublicationTemplate pub;
        RecordSet set;
        DataRecord data;
        PublicationPK pubPK = new PublicationPK(pubId, this.getCurrentComponentId());
        PublicationDetail pubDetail = this.getPublicationBm().getDetail(pubPK);
        String infoId = pubDetail.getInfoId();
        PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
        if (infoId == null || "0".equals(infoId)) {
            String xmlFormShortName = xmlModel.getName();
            pubDetail.setInfoId(xmlFormShortName);
            pubDetail.setIndexOperation(-1);
            this.getPublicationBm().setDetail(pubDetail);
            publicationTemplateManager.addDynamicPublicationTemplate(this.getCurrentComponentId() + ':' + xmlFormShortName, xmlFormShortName + ".xml");
        }
        if ((data = (set = (pub = publicationTemplateManager.getPublicationTemplate(this.getCurrentComponentId() + ':' + xmlModel.getName())).getRecordSet()).getRecord(pubId)) == null) {
            data = set.getEmptyRecord();
            data.setId(pubId);
        }
        PagesContext formContext = new PagesContext();
        formContext.setComponentId(this.getCurrentComponentId());
        formContext.setObjectId(pubId);
        for (XMLField xmlField : xmlModel.getFields()) {
            String xmlFieldName = xmlField.getName();
            String xmlFieldValue = xmlField.getValue();
            try {
                FieldTemplate fieldTemplate;
                Field field = data.getField(xmlFieldName);
                if (field == null || (fieldTemplate = pub.getRecordTemplate().getFieldTemplate(xmlFieldName)) == null) continue;
                FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(field.getTypeName(), fieldTemplate.getDisplayerName());
                String fieldValue = field.getTypeName().equals("file") && StringUtil.isDefined((String)xmlFieldValue) ? new FormTemplateImportExport().manageFileField(new ForeignPK((WAPrimaryKey)pubPK), userId, xmlFieldValue, fieldTemplate) : xmlFieldValue;
                fieldDisplayer.update(fieldValue, field, fieldTemplate, formContext);
            }
            catch (Exception e) {
                SilverTrace.warn((String)"importExport", (String)"GEDImportExport.createXMLModelContent", (String)"importExport.EX_CANT_IMPORT_XML_FIELD", (String)("xmlField = " + xmlFieldName), (Throwable)e);
            }
        }
        set.save(data);
    }

    private void createWysiwygContent(ImportReportManager reportManager, UnitReport unitReport, int pubId, WysiwygContentType wysiwygType, String userId, String lang) throws UtilException, WysiwygException, ImportExportException {
        File wysiwygFile = null;
        String wysiwygText = "";
        try {
            wysiwygFile = new File(FileUtil.convertPathToServerOS((String)wysiwygType.getPath()));
            if (!wysiwygFile.exists() && !wysiwygFile.isFile()) {
                String baseDir = this.resources.getString("importRepository");
                wysiwygFile = new File(FileUtil.convertPathToServerOS((String)(baseDir + File.separatorChar + wysiwygType.getPath())));
            }
            wysiwygText = FileFolderManager.getCode((String)wysiwygFile.getParent(), (String)wysiwygFile.getName());
        }
        catch (UtilException ex) {
            unitReport.setError(11);
            if (wysiwygFile != null) {
                throw new ImportExportException("GEDImportExport.createPublicationContent()", "importExport.EX_CANT_CREATE_CONTENT", "file = " + wysiwygFile.getPath(), (Exception)((Object)ex));
            }
            throw new ImportExportException("GEDImportExport.createPublicationContent()", "importExport.EX_CANT_CREATE_CONTENT", "file = null", (Exception)((Object)ex));
        }
        if (wysiwygText == null) {
            unitReport.setError(11);
            if (wysiwygFile != null) {
                throw new ImportExportException("GEDImportExport.createPublicationContent()", "importExport.EX_CANT_CREATE_CONTENT", "file = " + wysiwygFile.getPath());
            }
        }
        if (WysiwygController.haveGotWysiwyg((String)this.getCurrentComponentId(), (String)String.valueOf(pubId), (String)lang)) {
            try {
                WysiwygController.deleteWysiwygAttachmentsOnly((String)"useless", (String)this.getCurrentComponentId(), (String)String.valueOf(pubId));
            }
            catch (WysiwygException ex) {
                // empty catch block
            }
        }
        String imagesContext = WysiwygController.getImagesFileName((String)String.valueOf(pubId));
        String newWysiwygText = this.replaceWysiwygImagesPathForImport(reportManager, unitReport, pubId, wysiwygFile.getParent(), wysiwygText, imagesContext);
        newWysiwygText = this.removeWysiwygStringsForImport(newWysiwygText);
        newWysiwygText = this.replaceWysiwygStringsForImport(newWysiwygText);
        WysiwygController.createFileAndAttachment((String)newWysiwygText, (WAPrimaryKey)new ForeignPK(String.valueOf(pubId), this.getCurrentComponentId()), (String)WysiwygController.WYSIWYG_CONTEXT, (String)userId, (String)lang);
    }

    private String replaceWysiwygImagesPathForImport(ImportReportManager reportManager, UnitReport unitReport, int pubId, String wysiwygImportedPath, String wysiwygText, String imageContext) throws ImportExportException {
        int finPath = 0;
        StringBuilder newWysiwygText = new StringBuilder();
        if (wysiwygText.indexOf("img src=\"", finPath) == -1) {
            newWysiwygText.append(wysiwygText);
        } else {
            int debutPath;
            while ((debutPath = wysiwygText.indexOf("img src=\"", finPath)) != -1) {
                newWysiwygText.append(wysiwygText.substring(finPath, debutPath += 9));
                finPath = wysiwygText.indexOf(34, debutPath);
                String imageSrc = wysiwygText.substring(debutPath, finPath);
                if (imageSrc.indexOf("http://") != 0) {
                    AttachmentDetail attDetail = new AttachmentDetail();
                    attDetail.setPhysicalName(imageSrc);
                    File f = new File(imageSrc);
                    if (!f.isAbsolute()) {
                        attDetail.setPhysicalName(wysiwygImportedPath + File.separator + attDetail.getPhysicalName());
                    }
                    try {
                        attDetail = this.attachmentIE.importWysiwygAttachment(String.valueOf(pubId), this.getCurrentComponentId(), attDetail, imageContext);
                        reportManager.addNumberOfFilesProcessed(1);
                        if (attDetail == null || attDetail.getSize() == 0L) {
                            unitReport.setError(11);
                            throw new ImportExportException("GEDImportExport.replaceWysiwygImagesPathForImport()", "importExport.EX_CANT_CREATE_CONTENT", "pic = " + imageSrc);
                        }
                        reportManager.addImportedFileSize(attDetail.getSize(), this.getCurrentComponentId());
                    }
                    catch (Exception e) {
                        SilverTrace.error((String)"importExport", (String)"GEDImportExport.replaceWysiwygImagesPathForImport()", (String)"importExport.CANNOT_FIND_FILE", (Throwable)e);
                        newWysiwygText.append(imageSrc);
                    }
                    continue;
                }
                newWysiwygText.append(imageSrc);
            }
            newWysiwygText.append(wysiwygText.substring(finPath));
        }
        return newWysiwygText.toString();
    }

    private String replaceWysiwygStringsForImport(String wysiwygText) {
        ResourceLocator mapping = new ResourceLocator("com.silverpeas.importExport.settings.stringsMapping", "");
        String newWysiwygText = wysiwygText;
        Enumeration classes = mapping.getKeys();
        while (mapping != null && classes.hasMoreElements()) {
            String oldString = (String)classes.nextElement();
            String newString = mapping.getString(oldString);
            newWysiwygText = this.replaceWysiwygStringForImport(oldString, newString, newWysiwygText);
        }
        return newWysiwygText;
    }

    private String replaceWysiwygStringForImport(String oldCssClass, String newCssClass, String wysiwygText) {
        if (!StringUtil.isDefined((String)wysiwygText)) {
            return "";
        }
        return wysiwygText.replaceAll(oldCssClass, newCssClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String removeWysiwygStringsForImport(String wysiwygText) {
        String currentWysiwygText;
        block10: {
            currentWysiwygText = wysiwygText;
            ResourceLocator resource = new ResourceLocator("com.silverpeas.importExport.settings.mapping", "");
            String dir = resource.getString("mappingDir");
            if (StringUtil.isDefined((String)dir)) {
                BufferedReader reader = null;
                try {
                    String ligne;
                    reader = new BufferedReader(new FileReader(dir + File.separator + "strings2Remove.txt"));
                    while ((ligne = reader.readLine()) != null) {
                        if ("$$removeAnchors$$".equalsIgnoreCase(ligne)) {
                            currentWysiwygText = GEDImportExport.removeAnchors(currentWysiwygText);
                            continue;
                        }
                        currentWysiwygText = currentWysiwygText.replaceAll(ligne, "");
                    }
                    IOUtils.closeQuietly((Reader)reader);
                }
                catch (FileNotFoundException e) {
                    SilverTrace.info((String)"importExport", (String)"GEDImportExport", (String)"importExport.FILE_NOT_FOUND", (Throwable)e);
                }
                catch (IOException e2) {
                    SilverTrace.info((String)"importExport", (String)"GEDImportExport", (String)"importExport.FILE_NOT_FOUND", (Throwable)e2);
                    break block10;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(reader);
                }
            }
        }
        return currentWysiwygText;
    }

    private static String removeAnchors(String wysiwygText) {
        int fin = 0;
        StringBuilder newWysiwygText = new StringBuilder();
        if (wysiwygText.indexOf("<a name=", fin) == -1) {
            newWysiwygText.append(wysiwygText);
        } else {
            int debut;
            while ((debut = wysiwygText.indexOf("<a name=", fin)) != -1) {
                newWysiwygText.append(wysiwygText.substring(fin, debut));
                fin = wysiwygText.indexOf(62, debut += 8);
                debut = wysiwygText.indexOf("</a>", fin);
                newWysiwygText.append(wysiwygText.substring(fin + 1, debut));
                fin = debut + 4;
            }
            newWysiwygText.append(wysiwygText.substring(fin));
        }
        return newWysiwygText.toString();
    }

    public List<String> copyDBmodelImagePartsForExport(String exportPublicationPath, List<String> listImageParts, String exportPublicationRelativePath) {
        ArrayList<String> result = new ArrayList<String>();
        if (listImageParts != null && !listImageParts.isEmpty()) {
            Iterator<String> iter = listImageParts.iterator();
            while (iter.hasNext()) {
                String imagePath = iter.next();
                File f = new File(imagePath);
                try {
                    FileRepositoryManager.copyFile((String)imagePath, (String)(exportPublicationPath + File.separator + f.getName()));
                    iter.remove();
                    result.add(exportPublicationRelativePath + File.separator + f.getName());
                }
                catch (IOException ex) {}
            }
        }
        return result;
    }

    public void copyWysiwygImageForExport(String pubId, String componentId, String exportPublicationPath) {
        ForeignPK foreignKey = new ForeignPK(pubId, componentId);
        List documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey((WAPrimaryKey)foreignKey, null);
        for (SimpleDocument attDetail : documents) {
            try {
                FileRepositoryManager.copyFile((String)attDetail.getAttachmentPath(), (String)(exportPublicationPath + File.separator + attDetail.getFilename()));
            }
            catch (IOException ex) {}
        }
    }

    private List<NodePositionType> getExistingTopics(String userId, List<NodePositionType> nodeTypes, String componentId) {
        ArrayList<NodePositionType> topics = new ArrayList<NodePositionType>();
        for (NodePositionType node : nodeTypes) {
            if (node.getId() >= 0) {
                if (!this.isTopicExist(node.getId(), componentId)) continue;
                topics.add(node);
                continue;
            }
            if (!StringUtil.isDefined((String)node.getExplicitPath()) || node.getId() != -1) continue;
            String[] path = node.getExplicitPath().substring(1).split("/");
            NodePK nodePK = new NodePK("unknown", componentId);
            String parentId = "0";
            for (String name : path) {
                NodePK newNodePK;
                NodeDetail existingNode = null;
                try {
                    existingNode = this.getNodeBm().getDetailByNameAndFatherId(nodePK, name, Integer.parseInt(parentId));
                }
                catch (Exception e) {
                    SilverTrace.info((String)"importExport", (String)"GEDImportExport.getExistingTopics", (String)"root.MSG_GEN_PARAM_VALUE", (String)("node named '" + name + "' in path '" + node.getExplicitPath() + "' does not exist"));
                }
                if (existingNode != null) {
                    parentId = existingNode.getNodePK().getId();
                    continue;
                }
                NodeDetail newNode = new NodeDetail();
                newNode.setName(name);
                newNode.setNodePK(new NodePK("unknown", componentId));
                newNode.setFatherPK(new NodePK(parentId, componentId));
                newNode.setCreatorId(userId);
                try {
                    newNodePK = this.getNodeBm().createNode(newNode);
                }
                catch (Exception e) {
                    SilverTrace.error((String)"importExport", (String)"GEDImportExport.getExistingTopics", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Can't create node named '" + name + "' in path '" + node.getExplicitPath() + "'"), (Throwable)e);
                    return new ArrayList<NodePositionType>();
                }
                parentId = newNodePK.getId();
            }
            node.setId(Integer.parseInt(parentId));
            topics.add(node);
        }
        return topics;
    }

    private boolean isTopicExist(int nodeId, String componentId) {
        try {
            this.getNodeBm().getHeader(new NodePK(Integer.toString(nodeId), "useless", componentId));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected abstract NodePK addSubTopicToTopic(NodeDetail var1, int var2, UnitReport var3) throws ImportExportException;

    protected abstract NodePK addSubTopicToTopic(NodeDetail var1, int var2, MassiveReport var3) throws ImportExportException;

    public NodeDetail createTopicForUnitImport(UnitReport unitReport, NodeDetail nodeDetail, int parentTopicId) throws ImportExportException {
        unitReport.setItemName(nodeDetail.getName());
        NodePK nodePk = this.addSubTopicToTopic(nodeDetail, parentTopicId, unitReport);
        try {
            return this.getNodeBm().getDetail(nodePk);
        }
        catch (Exception ex) {
            unitReport.setError(5);
            SilverTrace.error((String)"importExport", (String)"GEDImportExport.createTopicForUnitImport()", (String)"root.EX_NO_MESSAGE", (Throwable)ex);
            throw new ImportExportException("GEDImportExport.createTopicForUnitImport", "importExport.EX_NODE_CREATE", ex);
        }
    }

    public PublicationDetail createPublicationForUnitImport(UnitReport unitReport, ImportSettings settings, PublicationDetail pubDetail, List<NodePositionType> listNode_Type) {
        unitReport.setItemName(pubDetail.getName());
        return this.processPublicationDetail(unitReport, settings, pubDetail, listNode_Type);
    }

    public PublicationDetail createPublicationForMassiveImport(UnitReport unitReport, PublicationDetail pubDetail, ImportSettings settings) throws ImportExportException {
        unitReport.setItemName(pubDetail.getName());
        NodePositionType nodePosType = new NodePositionType();
        nodePosType.setId(Integer.valueOf(settings.getFolderId()).intValue());
        ArrayList<NodePositionType> listNode_Type = new ArrayList<NodePositionType>(1);
        listNode_Type.add(nodePosType);
        return this.processPublicationDetail(unitReport, settings, pubDetail, listNode_Type);
    }

    public NodeDetail addSubTopicToTopic(File directory, int topicId, MassiveReport massiveReport) throws ImportExportException {
        try {
            String directoryName = directory.getName();
            NodeDetail nodeDetail = new NodeDetail("unknow", directoryName, directoryName, null, null, null, "0", "useless");
            nodeDetail.setNodePK(this.addSubTopicToTopic(nodeDetail, topicId, massiveReport));
            return nodeDetail;
        }
        catch (Exception ex) {
            throw new ImportExportException("GEDImportExport.addSubTopicToTopic", "importExport.EX_NODE_CREATE", ex);
        }
    }

    public abstract int getSilverObjectId(String var1) throws Exception;

    public PublicationType getPublicationCompleteById(String pubId, String componentId) throws ImportExportException {
        PublicationType publicationType = new PublicationType();
        try {
            CompletePublication pubComplete = this.getCompletePublication(new PublicationPK(pubId, this.getCurrentComponentId()));
            PublicationDetail publicationDetail = pubComplete.getPublicationDetail();
            InfoDetail infoDetail = pubComplete.getInfoDetail();
            PublicationContentType pubContent = null;
            if (!(infoDetail == null || infoDetail.getInfoImageList().isEmpty() && infoDetail.getInfoTextList().isEmpty())) {
                Collection listInfoImage;
                pubContent = new PublicationContentType();
                DBModelContentType dbModel = new DBModelContentType();
                pubContent.setDBModelContentType(dbModel);
                Collection listInfoText = infoDetail.getInfoTextList();
                if (listInfoText != null && !listInfoText.isEmpty()) {
                    ArrayList<String> listTextParts = new ArrayList<String>();
                    for (InfoTextDetail infoText : listInfoText) {
                        listTextParts.add(infoText.getContent());
                    }
                    dbModel.setListTextParts(listTextParts);
                }
                if ((listInfoImage = infoDetail.getInfoImageList()) != null && !listInfoImage.isEmpty()) {
                    ArrayList<String> listImageParts = new ArrayList<String>();
                    for (InfoImageDetail imageDetail : listInfoImage) {
                        String path = FileRepositoryManager.getAbsolutePath((String)componentId) + File.separator + "images";
                        listImageParts.add(path + File.separator + imageDetail.getPhysicalName());
                    }
                    dbModel.setListImageParts(listImageParts);
                }
                ModelDetail modelDetail = pubComplete.getModelDetail();
                dbModel.setId(Integer.parseInt(modelDetail.getId()));
            } else if (!StringUtil.isInteger((String)publicationDetail.getInfoId())) {
                pubContent = new PublicationContentType();
                List xmlFields = this.getFormTemplateBm().getXMLFieldsForExport(publicationDetail.getPK().getInstanceId() + ":" + publicationDetail.getInfoId(), pubId);
                SilverTrace.info((String)"importExport", (String)"GEDImportExport.getPublicationCompleteById()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("# of xmlField = " + xmlFields.size()));
                XMLModelContentType xmlModel = new XMLModelContentType(publicationDetail.getInfoId());
                xmlModel.setFields(xmlFields);
                pubContent.setXMLModelContentType(xmlModel);
            } else if (WysiwygController.haveGotWysiwyg((String)componentId, (String)pubId, (String)I18NHelper.checkLanguage((String)publicationDetail.getLanguage()))) {
                pubContent = new PublicationContentType();
                WysiwygContentType wysiwygContentType = new WysiwygContentType();
                String wysiwygFileName = WysiwygController.getWysiwygFileName((String)pubId, (String)I18NHelper.checkLanguage((String)publicationDetail.getLanguage()));
                wysiwygContentType.setPath(wysiwygFileName);
                pubContent.setWysiwygContentType(wysiwygContentType);
            }
            publicationType.setPublicationContentType(pubContent);
            publicationType.setPublicationDetail(publicationDetail);
            publicationType.setId(Integer.parseInt(pubId));
            publicationType.setComponentId(componentId);
            UserDetail userDetail = organizationController.getUserDetail(publicationDetail.getCreatorId());
            if (userDetail != null) {
                String nomPrenomCreator = userDetail.getDisplayedName().trim();
                publicationDetail.setCreatorName(nomPrenomCreator);
            }
        }
        catch (Exception ex) {
            throw new ImportExportException("importExport", "", "", ex);
        }
        return publicationType;
    }

    public List<NodePK> getAllTopicsOfPublication(PublicationPK pubPK) throws ImportExportException {
        Collection listNodePk = this.getPublicationBm().getAllFatherPK(pubPK);
        return new ArrayList<NodePK>(listNodePk);
    }

    public List<NodePK> getAliases(PublicationPK pubPK) throws ImportExportException {
        ArrayList<NodePK> pks = new ArrayList<NodePK>();
        Collection aliases = this.getPublicationBm().getAlias(pubPK);
        for (Alias alias : aliases) {
            if (alias.getInstanceId().equals(pubPK.getInstanceId())) continue;
            pks.add(new NodePK(alias.getId(), alias.getInstanceId()));
        }
        return pks;
    }

    public List<NodePK> getTopicTree(NodePK pk) throws ImportExportException {
        ArrayList<NodePK> listNodePk = new ArrayList<NodePK>();
        Collection path = this.getNodeBm().getPath(pk);
        for (NodeDetail detail : path) {
            listNodePk.add(detail.getNodePK());
        }
        return listNodePk;
    }

    public ModelDetail getModelDetail(int idModelDetail) throws ImportExportException {
        return this.getPublicationBm().getModelDetail(new ModelPK(String.valueOf(idModelDetail)));
    }

    @Override
    public void setCurrentComponentId(String string) {
        super.setCurrentComponentId(string);
    }

    public abstract void publicationNotClassifiedOnPDC(String var1) throws Exception;

    protected abstract PublicationDetail createPublication(PublicationDetail var1) throws Exception;

    public Collection<Coordinate> getPublicationCoordinates(String pubId, String componentId) throws ImportExportException {
        try {
            return this.getPublicationBm().getCoordinates(pubId, componentId);
        }
        catch (Exception e) {
            throw new ImportExportException("GEDImportExport.getPublicationCoordinates(String)", "importExport.EX_GET_SILVERPEASOBJECTID", "pubId = " + pubId, e);
        }
    }

    private void processThumbnail(String filePath, PublicationDetail pubDetail) {
        String logicalName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        String type = FileRepositoryManager.getFileExtension((String)logicalName);
        String mimeType = FileUtil.getMimeType((String)logicalName);
        String physicalName = Long.toString(System.currentTimeMillis()) + "." + type;
        if (FileUtil.isImage((String)logicalName)) {
            String dest = FileRepositoryManager.getAbsolutePath((String)pubDetail.getPK().getInstanceId()) + "images" + File.separator + physicalName;
            try {
                FileRepositoryManager.copyFile((String)filePath, (String)dest);
            }
            catch (Exception e) {
                SilverTrace.error((String)"importExport", (String)"GEDImportExport.processThumbnail()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("filePath = " + filePath), (Throwable)e);
            }
            ThumbnailDetail thumbnailDetail = new ThumbnailDetail(pubDetail.getPK().getComponentName(), Integer.valueOf(pubDetail.getPK().getId()).intValue(), 1);
            thumbnailDetail.setOriginalFileName(physicalName);
            thumbnailDetail.setOriginalFileName(mimeType);
            ThumbnailController.createThumbnail((ThumbnailDetail)thumbnailDetail, (int)50, (int)50);
        }
    }

    protected abstract void updatePublication(PublicationDetail var1, PublicationDetail var2, UserDetail var3) throws Exception;

    protected abstract String createPublicationIntoTopic(PublicationDetail var1, NodePK var2, UserDetail var3) throws Exception;

    protected abstract void addPublicationToTopic(PublicationPK var1, NodePK var2) throws Exception;

    protected abstract CompletePublication getCompletePublication(PublicationPK var1) throws Exception;
}

