/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.silverpeas.admin.importExport.AdminImportExport;
import com.silverpeas.coordinates.importExport.CoordinateImportExport;
import com.silverpeas.coordinates.importExport.CoordinatesPositionsType;
import com.silverpeas.importExport.control.GEDImportExport;
import com.silverpeas.importExport.control.ImportExportFactory;
import com.silverpeas.importExport.control.ImportExportNamespaceHandler;
import com.silverpeas.importExport.control.ImportSettings;
import com.silverpeas.importExport.control.NodeTreesTypeManager;
import com.silverpeas.importExport.control.PublicationImportExport;
import com.silverpeas.importExport.control.PublicationsTypeManager;
import com.silverpeas.importExport.control.RepositoriesTypeManager;
import com.silverpeas.importExport.model.ImportExportErrorHandler;
import com.silverpeas.importExport.model.ImportExportException;
import com.silverpeas.importExport.model.PublicationType;
import com.silverpeas.importExport.model.PublicationsType;
import com.silverpeas.importExport.model.SilverPeasExchangeType;
import com.silverpeas.importExport.report.ExportPDFReport;
import com.silverpeas.importExport.report.ExportReport;
import com.silverpeas.importExport.report.HtmlExportGenerator;
import com.silverpeas.importExport.report.HtmlExportPublicationGenerator;
import com.silverpeas.importExport.report.ImportReport;
import com.silverpeas.importExport.report.ImportReportManager;
import com.silverpeas.importExport.report.UnitReport;
import com.silverpeas.node.importexport.NodeImportExport;
import com.silverpeas.node.importexport.NodePositionType;
import com.silverpeas.node.importexport.NodeTreesType;
import com.silverpeas.pdc.importExport.PdcImportExport;
import com.silverpeas.pdc.importExport.PdcPositionsType;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.ZipManager;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAAttributeValuePair;
import com.stratelia.webactiv.util.coordinates.model.Coordinate;
import com.stratelia.webactiv.util.coordinates.model.CoordinatePoint;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.node.model.NodeRuntimeException;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.util.Charsets;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ImportExport {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.importExport.settings.mapping", "");
    public static final String iframePublication = "publications";
    public static final String iframeIndexPublications = "indexPublications";
    public static final int EXPORT_FULL = 0;
    public static final int EXPORT_FILESONLY = 1;
    public static final int EXPORT_PUBLICATIONSONLY = 2;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveToSilverpeasExchangeFile(SilverPeasExchangeType silverPeasExchangeType, String xmlToExportPath) throws ImportExportException {
        OutputStreamWriter writer = null;
        Mapping mapping = new Mapping();
        try {
            String mappingDir = settings.getString("mappingDir");
            String mappingFileName = settings.getString("importExportMapping");
            if (!mappingDir.endsWith("/")) {
                mappingDir = mappingDir + "/";
            }
            mapping.loadMapping(new URL(mappingDir + mappingFileName));
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlToExportPath), Charsets.UTF_8);
            Marshaller mar = new Marshaller((Writer)writer);
            String xsdPublicId = settings.getString("xsdPublicId");
            String xsdSystemId = settings.getString("xsdDefaultSystemId");
            mar.setSchemaLocation(xsdPublicId + " " + xsdSystemId);
            mar.setNamespaceMapping("sp", xsdPublicId);
            mar.setEncoding(Charsets.UTF_8.name());
            mar.setMapping(mapping);
            mar.marshal((Object)silverPeasExchangeType);
        }
        catch (MappingException me) {
            try {
                throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_LOADING_XML_MAPPING_FAILED", "XML Filename : ", (Exception)((Object)me));
                catch (MarshalException me2) {
                    throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_UNMARSHALLING_FAILED", "XML Filename : ", (Exception)((Object)me2));
                }
                catch (ValidationException ve) {
                    throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename : ", (Exception)((Object)ve));
                }
                catch (IOException ioe) {
                    throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_LOADING_XML_MAPPING_FAILED", "XML Filename : ", (Exception)ioe);
                }
                catch (Exception ioe) {
                    throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.", "XML Filename : ", ioe);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    SilverPeasExchangeType loadSilverpeasExchange(String xmlFileName) throws ImportExportException {
        SilverTrace.debug((String)"importExport", (String)"ImportExportSessionController.loadSilverpeasExchange", (String)"root.MSG_GEN_ENTER_METHOD", (String)("xmlFileName = " + xmlFileName));
        try {
            InputSource xmlInputSource = new InputSource(xmlFileName);
            String xsdPublicId = settings.getString("xsdPublicId");
            String xsdSystemId = settings.getString("xsdDefaultSystemId");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", null);
            Schema schema = schemaFactory.newSchema(new StreamSource(xsdSystemId));
            SAXParserFactory factory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            SAXParser parser = factory.newSAXParser();
            ImportExportErrorHandler errorHandler = new ImportExportErrorHandler();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setErrorHandler((ErrorHandler)errorHandler);
            try {
                xmlReader.parse(xmlInputSource);
            }
            catch (SAXException ex) {
                SilverTrace.debug((String)"importExport", (String)"ImportExportSessionController.loadSilverpeasExchange", (String)"root.MSG_GEN_PARAM_VALUE", (String)("XML File " + xmlFileName + " is not valid according to default schema"));
                ImportExportNamespaceHandler nsHandler = new ImportExportNamespaceHandler();
                factory.setSchema(null);
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(nsHandler);
                xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                xmlReader.parse(xmlInputSource);
                String nsSpec = nsHandler.getNsSpec();
                if (nsSpec == null || xsdPublicId.equals(nsSpec)) {
                    throw ex;
                }
                String nsVersion = this.extractUriNameIndex(nsSpec);
                if (nsVersion.length() == 0) {
                    throw ex;
                }
                String altXsdSystemId = settings.getStringWithParam("xsdSystemId", nsVersion);
                if (altXsdSystemId == null || altXsdSystemId.equals(xsdSystemId)) {
                    throw ex;
                }
                SilverTrace.debug((String)"importExport", (String)"ImportExportSessionController.loadSilverpeasExchange", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Trying again using schema specification located at " + altXsdSystemId));
                schema = schemaFactory.newSchema(new StreamSource(altXsdSystemId));
                factory.setSchema(schema);
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setErrorHandler((ErrorHandler)errorHandler);
                xmlReader.parse(xmlInputSource);
            }
            SilverTrace.debug((String)"importExport", (String)"ImportExportSessionController.loadSilverpeasExchange", (String)"root.MSG_GEN_PARAM_VALUE", (String)"XML Validation complete");
            String mappingDir = settings.getString("mappingDir");
            String mappingFileName = settings.getString("importExportMapping");
            String mappingFile = mappingDir + mappingFileName;
            Mapping mapping = new Mapping();
            mapping.loadMapping(mappingFile);
            Unmarshaller unmar = new Unmarshaller(SilverPeasExchangeType.class);
            unmar.setMapping(mapping);
            unmar.setValidation(false);
            SilverPeasExchangeType silverpeasExchange = (SilverPeasExchangeType)unmar.unmarshal(xmlInputSource);
            SilverTrace.debug((String)"importExport", (String)"ImportExportSessionController.loadSilverpeasExchange", (String)"root.MSG_GEN_PARAM_VALUE", (String)"Unmarshalling complete");
            return silverpeasExchange;
        }
        catch (MappingException me) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_LOADING_XML_MAPPING_FAILED", "XML Filename " + xmlFileName + ": " + me.getLocalizedMessage(), (Exception)((Object)me));
        }
        catch (MarshalException me) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_UNMARSHALLING_FAILED", "XML Filename " + xmlFileName + ": " + me.getLocalizedMessage(), (Exception)((Object)me));
        }
        catch (ValidationException ve) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename " + xmlFileName + ": " + ve.getLocalizedMessage(), (Exception)((Object)ve));
        }
        catch (IOException ioe) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_LOADING_XML_MAPPING_FAILED", "XML Filename " + xmlFileName + ": " + ioe.getLocalizedMessage(), (Exception)ioe);
        }
        catch (ParserConfigurationException ex) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename " + xmlFileName + ": " + ex.getLocalizedMessage(), (Exception)ex);
        }
        catch (SAXNotRecognizedException snre) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename " + xmlFileName + ": " + snre.getLocalizedMessage(), (Exception)snre);
        }
        catch (SAXNotSupportedException snse) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename " + xmlFileName + ": " + snse.getLocalizedMessage(), (Exception)snse);
        }
        catch (SAXException se) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename " + xmlFileName + ": " + se.getLocalizedMessage(), (Exception)se);
        }
    }

    private String extractUriNameIndex(String uri) {
        if (uri == null || uri.length() == 0) {
            return "";
        }
        int first = 0;
        int last = uri.length();
        int i = uri.lastIndexOf(35);
        if (i >= 0) {
            last = i;
        }
        if ((i = uri.lastIndexOf(63, last)) >= 0) {
            last = i;
        }
        if ((i = uri.lastIndexOf(47, last)) >= 0) {
            first = i + 1;
        }
        if ((i = uri.indexOf("://") + 2) >= 2 && i > first && i < last) {
            first = i + 1;
        }
        return uri.substring(first, last);
    }

    public ImportReport processImport(UserDetail userDetail, String xmlFileName) throws ImportExportException {
        ImportSettings importSettings;
        Object typeMgr;
        SilverPeasExchangeType silverExType;
        ImportReportManager reportManager = new ImportReportManager();
        if (!StringUtil.isDefined((String)xmlFileName)) {
            UnitReport unitReport = new UnitReport("No XML file specified");
            unitReport.setError(0);
            unitReport.setStatus(3);
            reportManager.addUnitReport(unitReport, "");
        }
        if ((silverExType = this.loadSilverpeasExchange(xmlFileName)).getNodeTreesType() != null) {
            typeMgr = new NodeTreesTypeManager();
            ((NodeTreesTypeManager)typeMgr).processImport(userDetail, silverExType.getNodeTreesType(), silverExType.getTargetComponentId(), reportManager);
        }
        if (silverExType.getPublicationsType() != null) {
            typeMgr = new PublicationsTypeManager();
            importSettings = new ImportSettings(null, userDetail, silverExType.getTargetComponentId(), null, false, silverExType.isPOIUsed(), 0);
            ((PublicationsTypeManager)typeMgr).processImport(silverExType.getPublicationsType(), importSettings, reportManager);
        }
        if (silverExType.getRepositoriesType() != null) {
            typeMgr = new RepositoriesTypeManager();
            importSettings = new ImportSettings(null, userDetail, silverExType.getTargetComponentId(), null, false, silverExType.isPOIUsed(), 0);
            ((RepositoriesTypeManager)typeMgr).processImport(silverExType.getRepositoriesType(), importSettings, reportManager);
        }
        reportManager.reportImportEnd();
        return reportManager.getImportReport();
    }

    public ExportReport processExport(UserDetail userDetail, String language, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK, int mode) throws ImportExportException {
        ExportReport report = null;
        switch (mode) {
            case 0: {
                report = this.processExport(userDetail, language, listItemsToExport, rootPK);
                break;
            }
            case 1: {
                report = this.processExportOfFilesOnly(userDetail, language, listItemsToExport, rootPK);
                break;
            }
            case 2: {
                report = this.processExportOfPublicationsOnly(userDetail, language, listItemsToExport, rootPK);
            }
        }
        return report;
    }

    private ExportReport processExport(UserDetail userDetail, String language, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK) throws ImportExportException {
        ResourceLocator resourceLocator = new ResourceLocator("com.silverpeas.importExport.multilang.importExportBundle", language);
        PublicationsTypeManager pub_Typ_Mger = new PublicationsTypeManager();
        PdcImportExport pdcIE = new PdcImportExport();
        NodeImportExport nodeIE = new NodeImportExport();
        AdminImportExport adminIE = new AdminImportExport();
        SilverPeasExchangeType silverPeasExch = new SilverPeasExchangeType();
        ExportReport exportReport = new ExportReport();
        try {
            PublicationsType publicationsType;
            File fileExportDir;
            String tempDir;
            String thisExportDir;
            block19: {
                exportReport.setDateDebut(new Date());
                thisExportDir = this.generateExportDirName(userDetail, "export");
                tempDir = FileRepositoryManager.getTemporaryPath();
                fileExportDir = new File(tempDir + thisExportDir);
                if (!fileExportDir.exists()) {
                    try {
                        FileFolderManager.createFolder((File)fileExportDir);
                    }
                    catch (UtilException ex) {
                        throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
                    }
                }
                try {
                    publicationsType = pub_Typ_Mger.processExport(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), true, true, rootPK);
                    if (publicationsType != null) break block19;
                    try {
                        exportReport = new ExportReport();
                        exportReport.setDateDebut(new Date());
                        fileExportDir.delete();
                        try {
                            FileFolderManager.deleteFolder((String)fileExportDir.getPath());
                        }
                        catch (Exception ex) {
                            throw new ImportExportException("ImportExport", "importExport.EX_CANT_DELETE_FOLDER", ex);
                        }
                        thisExportDir = this.generateExportDirName(userDetail, "export");
                        tempDir = FileRepositoryManager.getTemporaryPath();
                        fileExportDir = new File(tempDir + thisExportDir);
                        publicationsType = pub_Typ_Mger.processExport(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), false, true, rootPK);
                    }
                    catch (IOException e) {
                        throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)e);
                    }
                }
                catch (IOException e1) {
                    throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)e1);
                }
            }
            silverPeasExch.setPublicationsType(publicationsType);
            HashSet<String> componentIds = new HashSet<String>();
            ArrayList listClassifyPosition = new ArrayList();
            List listPubType = publicationsType.getListPublicationType();
            for (PublicationType pubType : listPubType) {
                componentIds.add(pubType.getComponentId());
                PdcPositionsType pdcPos = pubType.getPdcPositionsType();
                if (pdcPos == null) continue;
                listClassifyPosition.addAll(pdcPos.getListClassifyPosition());
            }
            ArrayList listComponentId = new ArrayList(componentIds);
            silverPeasExch.setComponentsType(adminIE.getComponents(listComponentId));
            NodeTreesType nodeTreesType = nodeIE.getTrees(listComponentId);
            silverPeasExch.setNodeTreesType(nodeTreesType);
            if (!listClassifyPosition.isEmpty()) {
                silverPeasExch.setPdcType(pdcIE.getPdc(listClassifyPosition));
            }
            if (rootPK == null) {
                this.createSummary(exportReport, thisExportDir, tempDir, fileExportDir);
            } else {
                HtmlExportGenerator htmlGenerator = new HtmlExportGenerator(exportReport, fileExportDir.getName(), resourceLocator);
                Map<String, List<String>> topicIds = this.prepareTopicsMap(publicationsType);
                Set<String> keys = topicIds.keySet();
                for (String topicId : keys) {
                    this.createTopicHtmlFile(thisExportDir, tempDir, htmlGenerator, topicIds, topicId);
                }
                this.createEmptySummary(thisExportDir, tempDir, htmlGenerator);
                this.createTreeview(rootPK.getId(), thisExportDir, tempDir, nodeTreesType, htmlGenerator, topicIds);
                this.createExportDirectory(thisExportDir, tempDir);
            }
            try {
                this.saveToSilverpeasExchangeFile(silverPeasExch, fileExportDir.getPath() + File.separatorChar + "importExport.xml");
            }
            catch (ImportExportException iex) {
                SilverTrace.error((String)"ImportExport", (String)"ImportExport.processExport()", (String)"root.EX_CANT_WRITE_FILE", (Throwable)iex);
            }
            this.createZipFile(fileExportDir, exportReport);
        }
        catch (NodeRuntimeException ex) {
            throw new ImportExportException("importExport", "ImportExport.processExport()", (Exception)((Object)ex));
        }
        catch (PdcException ex) {
            throw new ImportExportException("importExport", "ImportExport.processExport()", (Exception)((Object)ex));
        }
        return exportReport;
    }

    private void createSummary(ExportReport exportReport, String thisExportDir, String tempDir, File fileExportDir) throws ImportExportException {
        File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
        HtmlExportGenerator h = new HtmlExportGenerator(exportReport, fileExportDir.getName());
        OutputStreamWriter fileWriter = null;
        try {
            fileHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
            fileWriter.write(h.toHTML());
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private void createEmptySummary(String thisExportDir, String tempDir, HtmlExportGenerator htmlGenerator) throws ImportExportException {
        File fileTopicHTML = new File(tempDir + thisExportDir + File.separatorChar + "indexTopicEmpty.html");
        OutputStreamWriter fileWriter = null;
        try {
            fileTopicHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileTopicHTML.getPath()), Charsets.UTF_8);
            fileWriter.write(htmlGenerator.toHTML(fileTopicHTML.getName()));
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private void createExportDirectory(String thisExportDir, String tempDir) throws ImportExportException {
        try {
            FileFolderManager.createFolder((String)(tempDir + thisExportDir + File.separator + "treeview"));
            String chemin = settings.getString("mappingDir");
            if (chemin.startsWith("file:")) {
                chemin = chemin.substring(8);
            }
            chemin = chemin + "treeview";
            Collection files = FileFolderManager.getAllFile((String)chemin);
            for (File file : files) {
                File newFile = new File(tempDir + thisExportDir + File.separator + "treeview" + File.separator + file.getName());
                FileRepositoryManager.copyFile((String)file.getPath(), (String)newFile.getPath());
            }
        }
        catch (Exception e) {
            throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", e);
        }
    }

    private void createTreeview(String rootId, String thisExportDir, String tempDir, NodeTreesType nodeTreesType, HtmlExportGenerator htmlGenerator, Map<String, List<String>> topicIds) throws ImportExportException {
        File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
        OutputStreamWriter fileWriter = null;
        try {
            fileHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
            Set<String> topics = topicIds.keySet();
            fileWriter.write(htmlGenerator.indexToHTML(fileHTML.getName(), topics, nodeTreesType, rootId));
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private Map<String, List<String>> prepareTopicsMap(PublicationsType publicationsType) {
        List listPubType = publicationsType.getListPublicationType();
        HashMap<String, List<String>> topicIds = new HashMap<String, List<String>>(listPubType.size());
        for (PublicationType publicationType : listPubType) {
            String pubId = Integer.toString(publicationType.getId());
            List listNodePositionType = publicationType.getNodePositionsType().getListNodePositionType();
            for (NodePositionType nodePositionType : listNodePositionType) {
                String topicId = String.valueOf(nodePositionType.getId());
                ArrayList<String> pubIds = topicIds.containsKey(topicId) ? (ArrayList<String>)topicIds.get(topicId) : new ArrayList<String>(listPubType.size());
                pubIds.add(pubId);
                topicIds.put(topicId, pubIds);
            }
        }
        return topicIds;
    }

    private void createTopicHtmlFile(String thisExportDir, String tempDir, HtmlExportGenerator h, Map<String, List<String>> topicIds, String topicId) throws ImportExportException {
        File fileTopicHTML = new File(tempDir + thisExportDir, "indexTopic" + topicId + ".html");
        OutputStreamWriter fileWriter = null;
        try {
            fileTopicHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileTopicHTML.getPath()), Charsets.UTF_8);
            fileWriter.write(h.toHTML(fileTopicHTML.getName(), (Collection<String>)topicIds.get(topicId)));
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public ExportPDFReport processExportPDF(UserDetail userDetail, List<WAAttributeValuePair> itemsToExport, NodePK rootPK) throws ImportExportException {
        ExportPDFReport report = new ExportPDFReport();
        report.setDateDebut(new Date());
        PublicationsTypeManager pubTypeManager = new PublicationsTypeManager();
        String fileExportName = this.generateExportDirName(userDetail, "fusion");
        String tempDir = FileRepositoryManager.getTemporaryPath();
        File fileExportDir = new File(tempDir + fileExportName);
        if (!fileExportDir.exists()) {
            try {
                FileFolderManager.createFolder((File)fileExportDir);
            }
            catch (UtilException ex) {
                throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
            }
        }
        File pdfFileName = new File(tempDir + fileExportName + ".pdf");
        try {
            List<AttachmentDetail> pdfList = pubTypeManager.processPDFExport(report, userDetail, itemsToExport, fileExportDir.getPath(), true, rootPK);
            try {
                int pageOffset = 0;
                ArrayList master = new ArrayList();
                Document document = null;
                PdfCopy writer = null;
                if (!pdfList.isEmpty()) {
                    boolean firstPage = true;
                    for (AttachmentDetail attDetail : pdfList) {
                        PdfReader reader = null;
                        try {
                            reader = new PdfReader(fileExportDir.getPath() + File.separatorChar + attDetail.getLogicalName());
                        }
                        catch (IOException ioe) {
                            SilverTrace.error((String)"importExport", (String)"PublicationTypeManager.processExportPDF", (String)"CANT_FIND_PDF_FILE", (String)("PDF file '" + attDetail.getLogicalName() + "' is not present on disk"), (Throwable)ioe);
                        }
                        if (reader == null) continue;
                        reader.consolidateNamedDestinations();
                        int nbPages = reader.getNumberOfPages();
                        List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                        if (bookmarks != null) {
                            if (pageOffset != 0) {
                                SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                            }
                            master.addAll(bookmarks);
                        }
                        pageOffset += nbPages;
                        if (firstPage) {
                            document = new Document(reader.getPageSizeWithRotation(1));
                            writer = new PdfCopy(document, (OutputStream)new FileOutputStream(pdfFileName));
                            document.open();
                            firstPage = false;
                        }
                        for (int i = 1; i <= nbPages; ++i) {
                            try {
                                PdfImportedPage page = writer.getImportedPage(reader, i);
                                writer.addPage(page);
                                continue;
                            }
                            catch (Exception e) {
                                SilverTrace.error((String)"importExport", (String)"PublicationTypeManager.processExportPDF", (String)"CANT_MERGE_PDF_FILE", (String)("PDF file is " + attDetail.getLogicalName()), (Throwable)e);
                            }
                        }
                        PRAcroForm form = reader.getAcroForm();
                        if (form == null) continue;
                        writer.copyAcroForm(reader);
                    }
                    if (!master.isEmpty()) {
                        writer.setOutlines(master);
                    }
                } else {
                    return null;
                }
                writer.flush();
                document.close();
            }
            catch (BadPdfFormatException e) {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)((Object)e));
            }
            catch (DocumentException e) {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)((Object)e));
            }
        }
        catch (IOException e) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)e);
        }
        report.setPdfFileName(pdfFileName.getName());
        report.setPdfFileSize(pdfFileName.length());
        report.setPdfFilePath(FileServerUtils.getUrlToTempDir((String)pdfFileName.getName()));
        report.setDateFin(new Date());
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportReport processExportKmax(UserDetail userDetail, String language, List<WAAttributeValuePair> itemsToExport, List<String> combination, String timeCriteria) throws ImportExportException {
        ResourceLocator resourceLocator = new ResourceLocator("com.silverpeas.importExport.multilang.importExportBundle", language);
        PublicationsTypeManager pub_Typ_Mger = new PublicationsTypeManager();
        AdminImportExport adminIE = new AdminImportExport();
        SilverPeasExchangeType silverPeasExch = new SilverPeasExchangeType();
        ExportReport exportReport = new ExportReport();
        CoordinateImportExport coordinateImportExport = new CoordinateImportExport();
        try {
            File fileExportDir;
            block59: {
                String exportPath;
                String componentId;
                String tempDir;
                String thisExportDir;
                block58: {
                    PublicationsType publicationsType;
                    exportReport.setDateDebut(new Date());
                    thisExportDir = this.generateExportDirName(userDetail, "export");
                    tempDir = FileRepositoryManager.getTemporaryPath();
                    fileExportDir = new File(tempDir + thisExportDir);
                    if (!fileExportDir.exists()) {
                        try {
                            FileFolderManager.createFolder((File)fileExportDir);
                        }
                        catch (UtilException ex) {
                            throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
                        }
                    }
                    try {
                        publicationsType = pub_Typ_Mger.processExport(exportReport, userDetail, itemsToExport, fileExportDir.getPath(), false, true, null);
                    }
                    catch (IOException e) {
                        throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)e);
                    }
                    HashSet<String> listComponentId = new HashSet<String>();
                    List listPubType = publicationsType.getListPublicationType();
                    componentId = null;
                    for (PublicationType pubType : listPubType) {
                        listComponentId.add(pubType.getComponentId());
                        componentId = pubType.getComponentId();
                    }
                    silverPeasExch.setComponentsType(adminIE.getComponents(new ArrayList(listComponentId)));
                    if (combination == null) break block58;
                    File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
                    HtmlExportGenerator h = new HtmlExportGenerator(exportReport, fileExportDir.getName(), resourceLocator);
                    OutputStreamWriter fileWriter = null;
                    try {
                        fileHTML.createNewFile();
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
                        List positionsLabels = coordinateImportExport.getCombinationLabels(combination, componentId);
                        fileWriter.write(h.kmaxPublicationsToHTML(positionsLabels, timeCriteria, iframePublication));
                    }
                    catch (IOException ex) {
                        try {
                            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fileWriter);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Writer)fileWriter);
                    break block59;
                }
                File emptyFileHTML = new File(tempDir + thisExportDir + File.separatorChar + "empty.html");
                OutputStreamWriter fileWriter = null;
                try {
                    emptyFileHTML.createNewFile();
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(emptyFileHTML.getPath()), Charsets.UTF_8);
                }
                catch (IOException ex) {
                    try {
                        throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileWriter);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)fileWriter);
                ComponentInst componentInst = OrganisationControllerFactory.getOrganisationController().getComponentInst(componentId);
                GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
                String unbalancedFileNameRelativePath = "index-2.html";
                File unclassifiedFileHTML = new File(tempDir + thisExportDir + File.separatorChar + unbalancedFileNameRelativePath);
                HtmlExportGenerator h = new HtmlExportGenerator(exportReport, fileExportDir.getName(), resourceLocator);
                try {
                    unclassifiedFileHTML.createNewFile();
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(unclassifiedFileHTML.getPath(), true), Charsets.UTF_8);
                    fileWriter.write(h.toHtmlPublicationsByPositionStart());
                }
                catch (IOException ex) {
                    throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
                }
                finally {
                    IOUtils.closeQuietly((Writer)fileWriter);
                }
                String publicationFileNameRelativePath = null;
                List<PublicationDetail> unbalancedPublications = PublicationImportExport.getUnbalancedPublications(componentId);
                String componentLabel = FileServerUtils.replaceAccentChars((String)componentInst.getLabel());
                for (PublicationDetail pubDetail : unbalancedPublications) {
                    PublicationType publicationType = gedIE.getPublicationCompleteById(String.valueOf(pubDetail.getId()), componentId);
                    publicationFileNameRelativePath = componentLabel + File.separator + pubDetail.getId() + File.separator + "index.html";
                    pub_Typ_Mger.fillPublicationType(gedIE, publicationType, null);
                    int nbThemes = pub_Typ_Mger.getNbThemes(gedIE, publicationType, null);
                    HtmlExportPublicationGenerator unbalanced = new HtmlExportPublicationGenerator(publicationType, null, null, publicationFileNameRelativePath, nbThemes);
                    exportReport.addHtmlIndex(pubDetail.getId(), unbalanced);
                    fileWriter = null;
                    try {
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(unclassifiedFileHTML.getPath(), true), Charsets.UTF_8);
                        fileWriter.write(unbalanced.toHtmlSommairePublication(iframePublication));
                    }
                    catch (IOException ex) {
                        throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Writer)fileWriter);
                    }
                }
                File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
                h = new HtmlExportGenerator(exportReport, fileExportDir.getName(), resourceLocator);
                try {
                    fileHTML.createNewFile();
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
                    List axis = coordinateImportExport.getAxis(componentId);
                    fileWriter.write(h.kmaxAxisToHTML(axis, language));
                }
                catch (IOException ex) {
                    throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
                }
                finally {
                    IOUtils.closeQuietly((Writer)fileWriter);
                }
                String exportSummaryPath = exportPath = fileExportDir.getPath();
                List listAxis = coordinateImportExport.getAxisHeadersWithChildren(componentId, true, true);
                listAxis.remove(0);
                int nbAxis = listAxis.size();
                ArrayList<Collection> listAxisWithChildren = new ArrayList<Collection>();
                for (NodeDetail currentAxisNodeDetail : listAxis) {
                    Collection childrenNodeDetails = currentAxisNodeDetail.getChildrenDetails();
                    if (childrenNodeDetails == null || childrenNodeDetails.isEmpty()) continue;
                    listAxisWithChildren.add(childrenNodeDetails);
                }
                ArrayList<String> nodesIds = new ArrayList<String>();
                for (Collection currentAxis : listAxisWithChildren) {
                    for (NodeDetail axisNode : currentAxis) {
                        String nodeId = String.valueOf(axisNode.getId());
                        nodesIds.add(nodeId);
                    }
                }
                List indexFilesPositions = new ArrayList();
                for (int i = 1; i <= nodesIds.size(); ++i) {
                    indexFilesPositions = coordinateImportExport.coupleIds(indexFilesPositions, nodesIds, 0, 0, i, null, nbAxis);
                }
                for (String positionNameId : indexFilesPositions) {
                    fileHTML = new File(exportSummaryPath + File.separator + positionNameId);
                    fileWriter = null;
                    try {
                        fileHTML.createNewFile();
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
                        fileWriter.write(h.toHtmlPublicationsByPositionStart());
                    }
                    finally {
                        try {
                            ((Writer)fileWriter).close();
                        }
                        catch (Exception ex) {
                            SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Exception = " + ex));
                        }
                    }
                }
                exportSummaryPath = exportPath = fileExportDir.getPath();
                for (WAAttributeValuePair attValue : itemsToExport) {
                    ArrayList<String> filesPositionsHTMLToFill = new ArrayList<String>();
                    String pubId = attValue.getName();
                    componentId = attValue.getValue();
                    gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
                    PublicationType publicationType = gedIE.getPublicationCompleteById(pubId, componentId);
                    pub_Typ_Mger.fillPublicationType(gedIE, publicationType, null);
                    publicationType.setCoordinatesPositionsType(new CoordinatesPositionsType());
                    ArrayList<CoordinatePoint> listCoordinatesPositions = new ArrayList<CoordinatePoint>();
                    Collection<Coordinate> coordinates = gedIE.getPublicationCoordinates(pubId, componentId);
                    for (Coordinate coordinate : coordinates) {
                        String positionFileNameHTML = "index";
                        Collection coordinatesPoints = coordinate.getCoordinatePoints();
                        for (CoordinatePoint coordinatePoint : coordinatesPoints) {
                            positionFileNameHTML = positionFileNameHTML + "-" + coordinatePoint.getNodeId();
                            listCoordinatesPositions.add(coordinatePoint);
                        }
                        if (!filesPositionsHTMLToFill.contains(positionFileNameHTML + ".html")) {
                            filesPositionsHTMLToFill.add(positionFileNameHTML + ".html");
                        }
                        List<String> nodeIds = new ArrayList<String>();
                        StringTokenizer st = new StringTokenizer(positionFileNameHTML, "-");
                        while (st.hasMoreTokens()) {
                            String nodeId = st.nextToken();
                            if ("index".equals(nodeId)) continue;
                            NodeDetail currentNodeDetail = coordinateImportExport.getNodeHeader(new NodePK(String.valueOf(nodeId), componentId));
                            nodeIds.add(String.valueOf(currentNodeDetail.getId()));
                            if (currentNodeDetail.getLevel() >= 3) {
                                nodeIds = this.addNodeToList(nodeIds, currentNodeDetail);
                                continue;
                            }
                            List axisChildren = coordinateImportExport.getAxisChildren(currentNodeDetail.getNodePK(), false);
                            for (NodeDetail nodeDetail : axisChildren) {
                                nodeIds.add(String.valueOf(nodeDetail.getId()));
                            }
                        }
                        List otherPositionsFilesNameHTML = new ArrayList();
                        otherPositionsFilesNameHTML = coordinateImportExport.coupleIds(otherPositionsFilesNameHTML, nodeIds, 0, 0, nbAxis, null, nbAxis);
                        for (String otherPositionFileNameHTML : otherPositionsFilesNameHTML) {
                            if (filesPositionsHTMLToFill.contains(otherPositionFileNameHTML)) continue;
                            filesPositionsHTMLToFill.add(otherPositionFileNameHTML);
                        }
                    }
                    publicationType.getCoordinatesPositionsType().setCoordinatesPositions(listCoordinatesPositions);
                    SilverTrace.debug((String)"importExport", (String)"ImportExport.processExportKmax", (String)"root.MSG_GEN_PARAM_VALUE", (String)"coordinatePositions added");
                    publicationFileNameRelativePath = componentLabel + File.separator + pubId + File.separator + "index.html";
                    int nbThemes = pub_Typ_Mger.getNbThemes(gedIE, publicationType, null);
                    HtmlExportPublicationGenerator s = new HtmlExportPublicationGenerator(publicationType, null, null, publicationFileNameRelativePath, nbThemes);
                    exportReport.addHtmlIndex(pubId, s);
                    for (String filePositions : filesPositionsHTMLToFill) {
                        fileHTML = new File(exportSummaryPath + File.separator + filePositions);
                        SilverTrace.debug((String)"importExport", (String)"ImportExport.processExportKmax", (String)"root.MSG_GEN_PARAM_VALUE", (String)("pubId = " + pubId));
                        fileWriter = null;
                        try {
                            if (!fileHTML.exists()) continue;
                            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath(), true), Charsets.UTF_8);
                            fileWriter.write(s.toHtmlSommairePublication(iframePublication));
                        }
                        finally {
                            IOUtils.closeQuietly((Writer)fileWriter);
                        }
                    }
                }
            }
            this.saveToSilverpeasExchangeFile(silverPeasExch, fileExportDir.getPath() + File.separator + "importExport.xml");
            this.createZipFile(fileExportDir, exportReport);
        }
        catch (Exception ex) {
            throw new ImportExportException("importExport", "ImportExport.processExportKmax()", ex);
        }
        return exportReport;
    }

    String generateExportDirName(UserDetail userDetail, String name) {
        StringBuilder sb = new StringBuilder(name);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH'H'mm'm'ss's'");
        String dateFormatee = dateFormat.format(date);
        sb.append(dateFormatee);
        sb.append('_').append(userDetail.getId());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImportToLog(ImportReport importReport, ResourcesWrapper resource) {
        if (importReport != null) {
            String reportLogFile = settings.getString("importExportLogFile");
            ResourceBundle resources = FileUtil.loadBundle((String)"com.stratelia.silverpeas.silvertrace.settings.silverTrace", (Locale)new Locale("", ""));
            String reportLogPath = resources.getString("ErrorDir");
            File file = new File(reportLogPath + File.separator + reportLogFile);
            OutputStreamWriter fileWriter = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getPath(), true), Charsets.UTF_8);
                fileWriter.write(importReport.writeToLog(resource));
                IOUtils.closeQuietly((Writer)fileWriter);
            }
            catch (IOException ex) {
                SilverTrace.error((String)"ImportExport", (String)"ImportExport.writeImportToLog()", (String)"root.EX_CANT_WRITE_FILE", (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly(fileWriter);
            }
        }
    }

    private List<String> addNodeToList(List<String> nodesIds, NodeDetail nodeDetail) {
        CoordinateImportExport cie = new CoordinateImportExport();
        nodesIds.add(String.valueOf(nodeDetail.getFatherPK().getId()));
        if (nodeDetail.getLevel() >= 4) {
            NodeDetail parentNodeDetail = cie.getNodeHeader(nodeDetail.getFatherPK());
            this.addNodeToList(nodesIds, parentNodeDetail);
        }
        return nodesIds;
    }

    private ExportReport processExportOfFilesOnly(UserDetail userDetail, String language, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK) throws ImportExportException {
        PublicationsTypeManager pub_Typ_Mger = new PublicationsTypeManager();
        ExportReport exportReport = new ExportReport();
        File fileExportDir = this.createExportDir(userDetail);
        try {
            pub_Typ_Mger.processExportOfFilesOnly(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), rootPK);
        }
        catch (IOException e1) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_EXPORT_FILES", (Exception)e1);
        }
        this.createZipFile(fileExportDir, exportReport);
        return exportReport;
    }

    private ExportReport processExportOfPublicationsOnly(UserDetail userDetail, String language, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK) throws ImportExportException {
        PublicationsTypeManager pub_Typ_Mger = new PublicationsTypeManager();
        ExportReport exportReport = new ExportReport();
        exportReport.setDateDebut(new Date());
        File fileExportDir = this.createExportDir(userDetail);
        try {
            pub_Typ_Mger.processExport(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), true, rootPK != null, rootPK);
        }
        catch (IOException e1) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)e1);
        }
        this.createZipFile(fileExportDir, exportReport);
        return exportReport;
    }

    private File createExportDir(UserDetail userDetail) throws ImportExportException {
        String thisExportDir = this.generateExportDirName(userDetail, "export");
        String tempDir = FileRepositoryManager.getTemporaryPath();
        File fileExportDir = new File(tempDir + thisExportDir);
        if (!fileExportDir.exists()) {
            try {
                FileFolderManager.createFolder((File)fileExportDir);
            }
            catch (UtilException ex) {
                throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
            }
        }
        return fileExportDir;
    }

    private void createZipFile(File fileExportDir, ExportReport exportReport) throws ImportExportException {
        try {
            String zipFileName = fileExportDir.getName() + ".zip";
            String tempDir = FileRepositoryManager.getTemporaryPath();
            long zipFileSize = ZipManager.compressPathToZip((String)fileExportDir.getPath(), (String)(tempDir + zipFileName));
            exportReport.setZipFileName(zipFileName);
            exportReport.setZipFileSize(zipFileSize);
            exportReport.setZipFilePath(FileServerUtils.getUrlToTempDir((String)zipFileName));
            exportReport.setDateFin(new Date());
        }
        catch (IOException ex) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)ex);
        }
    }
}

