/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import org.apache.commons.io.FilenameUtils;

public class ImportSettings
implements Cloneable {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.importExport.settings.importSettings", "");
    public static final int FROM_XML = 0;
    public static final int FROM_DRAGNDROP = 1;
    public static final int FROM_MANUAL = 2;
    private String pathToImport;
    private UserDetail user;
    private String componentId;
    private String folderId;
    private boolean draftUsed;
    private boolean poiUsed;
    private boolean versioningUsed;
    private int versionType;
    private int method;

    public ImportSettings(String pathToImport, UserDetail user, String componentId, String folderId, boolean draftUsed, boolean poiUsed, int method) {
        this.pathToImport = pathToImport;
        this.user = user;
        this.componentId = componentId;
        this.folderId = folderId;
        this.draftUsed = draftUsed;
        this.poiUsed = poiUsed;
        this.method = method;
    }

    public String getPathToImport() {
        return this.pathToImport;
    }

    public void setPathToImport(String path) {
        this.pathToImport = path;
    }

    public UserDetail getUser() {
        return this.user;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public boolean isDraftUsed() {
        return this.draftUsed;
    }

    public boolean isPoiUsed() {
        if (this.getMethod() == 0) {
            return this.poiUsed;
        }
        if (this.getMethod() == 1) {
            return settings.getBoolean("dnd.publication.usePOI", true);
        }
        return settings.getBoolean("manual.publication.usePOI", true);
    }

    public void setVersioningUsed(boolean versioningUsed) {
        this.versioningUsed = versioningUsed;
    }

    public boolean isVersioningUsed() {
        return this.versioningUsed;
    }

    public void setFrom(int from) {
        this.method = from;
    }

    public int getMethod() {
        return this.method;
    }

    public boolean isPublicationMergeEnabled() {
        if (this.getMethod() == 0) {
            return settings.getBoolean("xml.publication.merge", true);
        }
        if (this.getMethod() == 1) {
            return settings.getBoolean("dnd.publication.merge", false);
        }
        return settings.getBoolean("manual.publication.merge", false);
    }

    public String getPublicationName(String filename) {
        if (settings.getBoolean("publication.name.with.extension", false)) {
            return filename;
        }
        return FilenameUtils.getBaseName((String)filename);
    }

    public void setVersionType(int versionType) {
        this.versionType = versionType;
    }

    public int getVersionType() {
        return this.versionType;
    }

    public boolean useFileDates() {
        if (this.getMethod() == 0) {
            return settings.getBoolean("xml.publication.useFileDates", false);
        }
        if (this.getMethod() == 1) {
            return settings.getBoolean("dnd.publication.useFileDates", false);
        }
        return settings.getBoolean("manual.publication.useFileDates", false);
    }

    public ImportSettings clone() {
        return new ImportSettings(this.pathToImport, this.user, this.componentId, this.folderId, this.draftUsed, this.poiUsed, this.method);
    }
}

