/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.silverpeas.importExport.control.GEDImportExport;
import com.silverpeas.importExport.control.ImportExportFactory;
import com.silverpeas.importExport.model.ImportExportException;
import com.silverpeas.importExport.report.ImportReportManager;
import com.silverpeas.importExport.report.UnitReport;
import com.silverpeas.node.importexport.NodeTreeType;
import com.silverpeas.node.importexport.NodeTreesType;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class NodeTreesTypeManager {
    public void processImport(UserDetail userDetail, NodeTreesType nodeTreesType, String targetComponentId, ImportReportManager reportManager) {
        int nbTopicTree = 1;
        int nbTopic = 1;
        GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, targetComponentId);
        List listNodeTreeType = nodeTreesType.getListNodeTreeType();
        if (!listNodeTreeType.isEmpty()) {
            for (NodeTreeType nodeTreeType : listNodeTreeType) {
                String componentId = !StringUtil.isDefined((String)nodeTreeType.getComponentId()) ? targetComponentId : nodeTreeType.getComponentId();
                gedIE.setCurrentComponentId(componentId);
                UnitReport unitReport = new UnitReport("<topicTree> #" + nbTopicTree);
                reportManager.addUnitReport(unitReport, componentId);
                ComponentInst component = OrganisationControllerFactory.getOrganisationController().getComponentInst(componentId);
                if (component == null) {
                    unitReport.setError(1);
                    unitReport.setStatus(3);
                    continue;
                }
                reportManager.setComponentName(componentId, component.getLabel());
                nbTopic = this.processImportNodeInternal(nodeTreeType.getNodeDetail(), null, gedIE, nbTopic, componentId, reportManager);
                ++nbTopicTree;
            }
        }
    }

    private int processImportNodeInternal(NodeDetail node, NodeDetail parentNode, GEDImportExport gedIE, int nbTopic, String componentId, ImportReportManager reportManager) {
        if (node != null) {
            Collection children;
            NodeDetail newNode;
            int parentNodeId;
            try {
                String parentNodeIdStr = parentNode != null ? parentNode.getNodePK().getId() : null;
                parentNodeId = parentNodeIdStr != null ? Integer.parseInt(parentNodeIdStr) : 0;
            }
            catch (NumberFormatException ex) {
                parentNodeId = 0;
            }
            UnitReport unitReport = new UnitReport("<topic> #" + nbTopic);
            reportManager.addUnitReport(unitReport, componentId);
            try {
                newNode = gedIE.createTopicForUnitImport(unitReport, node, parentNodeId);
            }
            catch (ImportExportException e) {
                return nbTopic;
            }
            if (newNode != null) {
                ++nbTopic;
            }
            if ((children = node.getChildrenDetails()) == null) {
                return nbTopic;
            }
            for (NodeDetail childNode : children) {
                nbTopic = this.processImportNodeInternal(childNode, newNode, gedIE, nbTopic, componentId, reportManager);
            }
        }
        return nbTopic;
    }
}

