/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.silverpeas.importExport.control.ImportSettings;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.MetaData;
import com.silverpeas.util.MetadataExtractor;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang.StringUtils;
import org.silverpeas.util.mail.Extractor;
import org.silverpeas.util.mail.Mail;
import org.silverpeas.util.mail.MailExtractor;

public class PublicationImportExport {
    static final MetadataExtractor metadataExtractor = new MetadataExtractor();
    static final ResourceLocator multilang = new ResourceLocator("org.silverpeas.importExport.multilang.importExportBundle", "fr");

    private PublicationImportExport() {
    }

    public static PublicationDetail convertFileInfoToPublicationDetail(File file, ImportSettings settings) {
        String fileName = file.getName();
        String nomPub = settings.getPublicationName(fileName);
        String description = "";
        String motsClefs = "";
        String content = "";
        Date creationDate = new Date();
        Date lastModificationDate = null;
        if (FileUtil.isMail((String)file.getName())) {
            try {
                MailExtractor extractor = Extractor.getExtractor((File)file);
                Mail mail = extractor.getMail();
                creationDate = mail.getDate();
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("subject", mail.getSubject());
                InternetAddress address = mail.getFrom();
                if (StringUtil.isDefined((String)address.getPersonal())) {
                    attributes.put("fromPersonal", address.getPersonal());
                    description = description + address.getPersonal() + " - ";
                }
                attributes.put("fromAddress", address.getAddress());
                StringTemplate titleST = new StringTemplate(multilang.getString("importExport.import.mail.title"));
                titleST.setAttributes(attributes);
                nomPub = titleST.toString();
                StringTemplate descriptionST = new StringTemplate(multilang.getString("importExport.import.mail.description"));
                descriptionST.setAttributes(attributes);
                description = descriptionST.toString();
            }
            catch (Exception e) {
                SilverTrace.error((String)"importExport", (String)"PublicationImportExport.convertFileInfoToPublicationDetail", (String)"importExport.EX_CANT_EXTRACT_MAIL_DATA", (Throwable)e);
            }
        } else {
            MetaData metaData = null;
            if (settings.isPoiUsed()) {
                metaData = metadataExtractor.extractMetadata(file.getAbsolutePath());
                if (StringUtil.isDefined((String)metaData.getTitle())) {
                    nomPub = metaData.getTitle();
                }
                if (StringUtil.isDefined((String)metaData.getSubject())) {
                    description = metaData.getSubject();
                }
                if (metaData.getKeywords() != null && metaData.getKeywords().length > 0) {
                    motsClefs = StringUtils.join((Object[])metaData.getKeywords(), (char)';');
                }
            }
            if (settings.useFileDates()) {
                if (metaData == null) {
                    metaData = metadataExtractor.extractMetadata(file.getAbsolutePath());
                }
                if (metaData.getCreationDate() != null) {
                    creationDate = metaData.getCreationDate();
                }
                if (metaData.getLastSaveDateTime() != null) {
                    lastModificationDate = metaData.getLastSaveDateTime();
                }
            }
        }
        PublicationDetail publication = new PublicationDetail("unknown", nomPub, description, creationDate, new Date(), null, settings.getUser().getId(), "5", null, motsClefs, content);
        if (lastModificationDate != null) {
            publication.setUpdateDate(lastModificationDate);
            publication.setUpdateDateMustBeSet(true);
        }
        return publication;
    }

    public static void addNodesToPublication(PublicationPK pubPK, List<Integer> nodes) {
        for (Integer coordinateId : nodes) {
            PublicationImportExport.getPublicationBm().addFather(pubPK, new NodePK(coordinateId.toString(), (WAPrimaryKey)pubPK));
        }
    }

    private static PublicationBm getPublicationBm() {
        return (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
    }

    public static List<PublicationDetail> getUnbalancedPublications(String componentId) {
        return new ArrayList<PublicationDetail>(PublicationImportExport.getPublicationBm().getOrphanPublications(new PublicationPK("useless", componentId)));
    }
}

