/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.silverpeas.coordinates.importExport.CoordinateImportExport;
import com.silverpeas.coordinates.importExport.CoordinatePointType;
import com.silverpeas.coordinates.importExport.CoordinatesPositionsType;
import com.silverpeas.form.importExport.XMLField;
import com.silverpeas.importExport.control.DirectoryUtils;
import com.silverpeas.importExport.control.GEDImportExport;
import com.silverpeas.importExport.control.ImportExportFactory;
import com.silverpeas.importExport.control.ImportExportHelper;
import com.silverpeas.importExport.control.ImportSettings;
import com.silverpeas.importExport.control.PublicationImportExport;
import com.silverpeas.importExport.model.ImportExportException;
import com.silverpeas.importExport.model.PublicationType;
import com.silverpeas.importExport.model.PublicationsType;
import com.silverpeas.importExport.report.ExportPDFReport;
import com.silverpeas.importExport.report.ExportReport;
import com.silverpeas.importExport.report.HtmlExportPublicationGenerator;
import com.silverpeas.importExport.report.ImportReportManager;
import com.silverpeas.importExport.report.UnitReport;
import com.silverpeas.node.importexport.NodeImportExport;
import com.silverpeas.node.importexport.NodePositionType;
import com.silverpeas.node.importexport.NodePositionsType;
import com.silverpeas.pdc.importExport.PdcImportExport;
import com.silverpeas.pdc.importExport.PdcPositionsType;
import com.silverpeas.publication.importExport.DBModelContentType;
import com.silverpeas.publication.importExport.PublicationContentType;
import com.silverpeas.publication.importExport.XMLModelContentType;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.MetaData;
import com.silverpeas.util.MetadataExtractor;
import com.silverpeas.util.StringUtil;
import com.silverpeas.wysiwyg.importExport.WysiwygContentType;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAAttributeValuePair;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.coordinates.model.Coordinate;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.info.model.ModelDetail;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.attachment.AttachmentImportExport;
import org.silverpeas.importExport.attachment.AttachmentsType;
import org.silverpeas.importExport.versioning.Document;
import org.silverpeas.importExport.versioning.DocumentVersion;
import org.silverpeas.importExport.versioning.VersioningImportExport;
import org.silverpeas.util.Charsets;
import org.silverpeas.wysiwyg.control.WysiwygController;

public class PublicationsTypeManager {
    static final MetadataExtractor metadataExtractor = new MetadataExtractor();

    public PublicationsType processExport(ExportReport exportReport, UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, String exportPath, boolean useNameForFolders, boolean bExportPublicationPath, NodePK rootPK) throws ImportExportException, IOException {
        AttachmentImportExport attachmentIE = new AttachmentImportExport();
        PublicationsType publicationsType = new PublicationsType();
        ArrayList<PublicationType> listPubType = new ArrayList<PublicationType>();
        PdcImportExport pdc_impExp = new PdcImportExport();
        String wysiwygText = null;
        SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("useNameForFolders = " + useNameForFolders));
        for (WAAttributeValuePair attValue : listItemsToExport) {
            String exportPublicationPath;
            String exportPublicationRelativePath;
            SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("objectId = " + attValue.getName() + ", instanceId = " + attValue.getValue()));
            String pubId = attValue.getName();
            String componentId = attValue.getValue();
            ComponentInstLight componentInst = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(componentId);
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
            PublicationType publicationType = gedIE.getPublicationCompleteById(pubId, componentId);
            SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)"publicationType retrieved");
            PublicationDetail publicationDetail = publicationType.getPublicationDetail();
            listPubType.add(publicationType);
            if (gedIE.isKmax()) {
                publicationType.setCoordinatesPositionsType(new CoordinatesPositionsType());
                exportPublicationRelativePath = this.createPathDirectoryForKmaxPublicationExport(exportPath, componentId, componentInst.getLabel(), publicationDetail, useNameForFolders);
                exportPublicationPath = exportPath + File.separator + exportPublicationRelativePath;
            } else {
                this.fillPublicationType(gedIE, publicationType, rootPK);
                SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)"nodePositions added");
                NodePositionType nodePositionType = (NodePositionType)publicationType.getNodePositionsType().getListNodePositionType().get(0);
                String nodeInstanceId = componentId;
                if (rootPK != null && !(nodeInstanceId = rootPK.getInstanceId()).equals(componentId)) {
                    componentInst = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(nodeInstanceId);
                }
                exportPublicationRelativePath = this.createPathDirectoryForPublicationExport(exportPath, nodePositionType.getId(), nodeInstanceId, componentInst.getLabel(), publicationDetail, useNameForFolders, bExportPublicationPath);
                exportPublicationPath = exportPath + File.separator + exportPublicationRelativePath;
            }
            if (exportPublicationPath != null && exportPublicationPath.length() > 250) {
                return null;
            }
            PublicationContentType pubContent = publicationType.getPublicationContentType();
            ModelDetail modelDetail = null;
            if (pubContent != null) {
                DBModelContentType dbModelContent = pubContent.getDBModelContentType();
                WysiwygContentType wysiwygContent = pubContent.getWysiwygContentType();
                XMLModelContentType xmlModel = pubContent.getXMLModelContentType();
                if (dbModelContent != null) {
                    List<String> listImageParts = dbModelContent.getListImageParts();
                    if (listImageParts != null && !listImageParts.isEmpty()) {
                        listImageParts = gedIE.copyDBmodelImagePartsForExport(exportPublicationPath, listImageParts, exportPublicationRelativePath);
                        dbModelContent.setListImageParts(listImageParts);
                    }
                    modelDetail = gedIE.getModelDetail(dbModelContent.getId());
                } else if (wysiwygContent != null) {
                    wysiwygText = this.exportWysiwygContent(pubId, componentId, gedIE, exportPublicationRelativePath, exportPublicationPath, wysiwygContent, publicationType.getPublicationDetail().getLanguage());
                } else if (xmlModel != null) {
                    this.exportXmlForm(new PublicationPK(pubId, componentId), exportPublicationRelativePath, exportPublicationPath, xmlModel);
                }
            }
            this.exportAttachments(attachmentIE, publicationType, publicationDetail.getPK(), exportPublicationRelativePath, exportPublicationPath);
            this.exportPdc(pdc_impExp, pubId, gedIE, publicationType);
            int nbThemes = 1;
            if (!gedIE.isKmax()) {
                nbThemes = this.getNbThemes(gedIE, publicationType, rootPK);
            }
            if (!this.writePublicationHtml(exportReport, wysiwygText, pubId, publicationType, exportPublicationRelativePath, exportPublicationPath, modelDetail, nbThemes)) {
                return null;
            }
            wysiwygText = null;
        }
        publicationsType.setListPublicationType(listPubType);
        return publicationsType;
    }

    String exportWysiwygContent(String pubId, String componentId, GEDImportExport gedIE, String exportPublicationRelativePath, String exportPublicationPath, WysiwygContentType wysiwygContent, String language) throws ImportExportException {
        String wysiwygText;
        String wysiwygFileName = wysiwygContent.getPath();
        gedIE.copyWysiwygImageForExport(pubId, componentId, exportPublicationPath);
        try {
            wysiwygText = WysiwygController.load((String)componentId, (String)pubId, (String)language);
            wysiwygText = HtmlExportPublicationGenerator.replaceImagesPathForExport(wysiwygText);
            if (wysiwygText == null) {
                wysiwygText = "";
            }
            FileFolderManager.createFile((String)exportPublicationPath, (String)wysiwygFileName, (String)wysiwygText);
        }
        catch (Exception e) {
            throw new ImportExportException("importExport", "importExport.EX_CANT_GET_WYSIWYG", e);
        }
        wysiwygContent.setPath(exportPublicationRelativePath + File.separator + wysiwygFileName);
        return wysiwygText;
    }

    boolean writePublicationHtml(ExportReport exportReport, String wysiwygText, String pubId, PublicationType publicationType, String exportPublicationRelativePath, String exportPublicationPath, ModelDetail modelDetail, int nbThemes) {
        String htmlNameIndex = "index.html";
        HtmlExportPublicationGenerator s = new HtmlExportPublicationGenerator(publicationType, modelDetail, wysiwygText, exportPublicationRelativePath + File.separator + htmlNameIndex, nbThemes);
        exportReport.addHtmlIndex(pubId, s);
        File fileHTML = new File(exportPublicationPath + File.separator + htmlNameIndex);
        SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("pubId = " + pubId));
        try {
            fileHTML.createNewFile();
            FileUtils.write((File)fileHTML, (CharSequence)s.toHtml(), (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    void exportPdc(PdcImportExport pdc_impExp, String pubId, GEDImportExport gedIE, PublicationType publicationType) throws ImportExportException {
        try {
            List listClassifyPostion = pdc_impExp.getPositions(gedIE.getSilverObjectId(pubId), publicationType.getComponentId());
            if (listClassifyPostion != null && !listClassifyPostion.isEmpty()) {
                publicationType.setPdcPositionsType(new PdcPositionsType());
                publicationType.getPdcPositionsType().setListClassifyPosition(listClassifyPostion);
            }
        }
        catch (Exception ex) {
            throw new ImportExportException("importExport", "importExport.EX_CANT_GET_PDC_POSITION", ex);
        }
    }

    void exportAttachments(AttachmentImportExport attachmentIE, PublicationType publicationType, PublicationPK publicationPK, String exportRelativePath, String exportPath) throws ImportExportException {
        List attachments = attachmentIE.getAttachments((WAPrimaryKey)publicationPK, exportPath, exportRelativePath, null);
        if (attachments != null && !attachments.isEmpty() && publicationType != null) {
            publicationType.setAttachmentsType(new AttachmentsType());
            publicationType.getAttachmentsType().setListAttachmentDetail(attachments);
        }
    }

    void exportXmlForm(PublicationPK publicationPk, String exportPublicationRelativePath, String exportPublicationPath, XMLModelContentType xmlModel) {
        List xmlFields = xmlModel.getFields();
        for (XMLField xmlField : xmlFields) {
            SimpleDocument attachment;
            String value = xmlField.getValue();
            if (!StringUtil.isDefined((String)value)) continue;
            if (value.startsWith("xmlWysiwygField")) {
                String wysiwygFile = value.substring(value.indexOf(95) + 1);
                try {
                    String fromPath = FileRepositoryManager.getAbsolutePath((String)publicationPk.getInstanceId()) + "xmlWysiwyg" + File.separator + wysiwygFile;
                    FileRepositoryManager.copyFile((String)fromPath, (String)(exportPublicationPath + File.separator + wysiwygFile));
                }
                catch (Exception e) {
                    SilverTrace.warn((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.EX_CANT_WRITE_FILE_XMLWYSIWYG", (Throwable)e);
                }
                continue;
            }
            if (value.startsWith("image")) {
                String imageId = value.substring(value.indexOf(95) + 1, value.length());
                attachment = null;
                try {
                    attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(imageId, publicationPk.getInstanceId()), null);
                }
                catch (RuntimeException e1) {
                    SilverTrace.warn((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.EX_CANT_WRITE_FILE", (Throwable)e1);
                }
                if (attachment == null) continue;
                String fromPath = attachment.getAttachmentPath();
                try {
                    FileRepositoryManager.copyFile((String)fromPath, (String)(exportPublicationPath + File.separator + attachment.getFilename()));
                }
                catch (Exception e) {
                    SilverTrace.warn((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.EX_CANT_WRITE_FILE", (Throwable)e);
                }
                xmlField.setValue(exportPublicationRelativePath + File.separator + attachment.getFilename());
                continue;
            }
            if (!value.startsWith("file")) continue;
            String fileId = value.substring(value.indexOf(95) + 1, value.length());
            attachment = null;
            try {
                attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(fileId, publicationPk.getInstanceId()), null);
            }
            catch (RuntimeException e1) {
                SilverTrace.warn((String)"importExport", (String)"PublicationTypeManager.processExport", (String)"root.EX_CANT_WRITE_FILE", (Throwable)e1);
            }
            if (attachment == null) continue;
            xmlField.setValue(exportPublicationRelativePath + File.separator + attachment.getFilename());
        }
    }

    private String createDirectoryPathForExport(String exportPath, NodePK rootPK, NodePK pk, boolean useNameForFolders) throws IOException {
        StringBuilder pathToCreate = new StringBuilder(exportPath);
        NodeImportExport nodeIE = new NodeImportExport();
        ArrayList listNodes = new ArrayList(nodeIE.getPathOfNode(pk));
        Collections.reverse(listNodes);
        boolean rootFound = false;
        for (NodeDetail nodeDetail : listNodes) {
            if (nodeDetail.getNodePK().equals((Object)rootPK)) {
                rootFound = true;
            }
            if (!rootFound) continue;
            String nodeNameForm = nodeDetail.getNodePK().getId();
            if (useNameForFolders) {
                nodeNameForm = DirectoryUtils.formatToDirectoryNamingCompliant(nodeDetail.getName());
            }
            pathToCreate.append(File.separator).append(nodeNameForm);
        }
        String pathToCreateAscii = this.createASCIIPath(pathToCreate.toString());
        return pathToCreateAscii;
    }

    private String createASCIIPath(String path) throws IOException {
        boolean creationOK;
        String pathToCreateAscii = FileServerUtils.replaceAccentChars((String)path);
        SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.createASCIIPath", (String)"root.MSG_GEN_PARAM_VALUE", (String)("pathToCreateAscii = " + pathToCreateAscii));
        File dir = new File(pathToCreateAscii);
        if (!dir.exists() && !(creationOK = dir.mkdirs())) {
            throw new IOException();
        }
        return pathToCreateAscii;
    }

    private String createPathDirectoryForPublicationExport(String exportPath, int topicId, String componentId, String componentLabel, PublicationDetail pub, boolean useNameForFolders, boolean exportPublicationPath) throws IOException {
        String pubNameForm = pub.getPK().getId();
        if (useNameForFolders) {
            pubNameForm = DirectoryUtils.formatToDirectoryNamingCompliant(pub.getName());
        }
        StringBuilder relativeExportPath = new StringBuilder();
        StringBuilder pathToCreate = new StringBuilder(exportPath);
        if (exportPublicationPath) {
            String componentLabelForm = componentId;
            if (useNameForFolders || this.isKmax(componentId)) {
                componentLabelForm = DirectoryUtils.formatToDirectoryNamingCompliant(componentLabel);
            }
            NodeImportExport nodeIE = new NodeImportExport();
            relativeExportPath.append(componentLabelForm);
            pathToCreate.append(File.separatorChar).append(componentLabelForm);
            ArrayList listNodes = new ArrayList(nodeIE.getPathOfNode(new NodePK(String.valueOf(topicId), "useless", componentId)));
            Collections.reverse(listNodes);
            for (NodeDetail nodeDetail : listNodes) {
                String nodeNameForm = nodeDetail.getNodePK().getId();
                if (useNameForFolders) {
                    nodeNameForm = DirectoryUtils.formatToDirectoryNamingCompliant(nodeDetail.getName());
                }
                pathToCreate.append(File.separator).append(nodeNameForm);
                relativeExportPath.append(File.separator).append(nodeNameForm);
            }
        }
        relativeExportPath.append(File.separator).append(pubNameForm);
        pathToCreate.append(File.separator).append(pubNameForm);
        String relativeExportPathAscii = FileServerUtils.replaceAccentChars((String)relativeExportPath.toString());
        SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.createPathDirectoryForPublicationExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("relativeExportPathAscii = " + relativeExportPathAscii));
        this.createASCIIPath(pathToCreate.toString());
        return relativeExportPathAscii;
    }

    public void processExportOfFilesOnly(ExportReport exportReport, UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, String exportPath, NodePK nodeRootPK) throws ImportExportException, IOException {
        AttachmentImportExport attachmentIE = new AttachmentImportExport();
        GEDImportExport gedIE = null;
        NodeImportExport nodeIE = new NodeImportExport();
        if (listItemsToExport != null && !listItemsToExport.isEmpty()) {
            String componentId = listItemsToExport.get(0).getValue();
            gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
        }
        block0: for (WAAttributeValuePair attValue : listItemsToExport) {
            SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.processExportOfFilesOnly", (String)"root.MSG_GEN_PARAM_VALUE", (String)("objectId = " + attValue.getName() + ", instanceId = " + attValue.getValue()));
            String pubId = attValue.getName();
            String componentId = attValue.getValue();
            PublicationPK pk = new PublicationPK(pubId, componentId);
            if (nodeRootPK == null || !StringUtil.isDefined((String)nodeRootPK.getId())) {
                this.exportAttachments(attachmentIE, null, pk, "", exportPath);
                continue;
            }
            List<NodePK> folderPKs = gedIE.getAllTopicsOfPublication(pk);
            folderPKs.addAll(gedIE.getAliases(pk));
            NodePK rightFolderPK = null;
            for (NodePK folderPK : folderPKs) {
                if (!folderPK.getInstanceId().equals(nodeRootPK.getInstanceId())) continue;
                ArrayList listNodes = new ArrayList(nodeIE.getPathOfNode(folderPK));
                Collections.reverse(listNodes);
                for (NodeDetail nodeDetail : listNodes) {
                    if (!nodeDetail.getNodePK().equals((Object)nodeRootPK)) continue;
                    rightFolderPK = folderPK;
                    break;
                }
                if (rightFolderPK == null) continue;
                String attachmentsExportPath = this.createDirectoryPathForExport(exportPath, nodeRootPK, rightFolderPK, true);
                this.exportAttachments(attachmentIE, null, pk, "", attachmentsExportPath);
                continue block0;
            }
        }
    }

    public List<AttachmentDetail> processPDFExport(ExportPDFReport exportReport, UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, String exportPath, boolean useNameForFolders, NodePK rootPK) throws ImportExportException, IOException {
        AttachmentImportExport attachmentIE = new AttachmentImportExport();
        ArrayList<AttachmentDetail> result = new ArrayList<AttachmentDetail>();
        for (WAAttributeValuePair attValue : listItemsToExport) {
            String pubId = attValue.getName();
            String componentId = attValue.getValue();
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
            PublicationType publicationType = gedIE.getPublicationCompleteById(pubId, componentId);
            PublicationDetail publicationDetail = publicationType.getPublicationDetail();
            this.fillPublicationType(gedIE, publicationType, rootPK);
            String exportPublicationPath = exportPath;
            List attachments = attachmentIE.getAttachments((WAPrimaryKey)publicationDetail.getPK(), exportPublicationPath, null, "pdf");
            if (attachments == null || attachments.isEmpty()) continue;
            result.addAll(attachments);
        }
        return result;
    }

    private String createPathDirectoryForKmaxPublicationExport(String exportPath, String componentId, String componentLabel, PublicationDetail pub, boolean useNameForFolders) throws IOException {
        String pubNameForm = useNameForFolders ? DirectoryUtils.formatToDirectoryNamingCompliant(pub.getName()) : pub.getPK().getId();
        String componentLabelForm = useNameForFolders || this.isKmax(componentId) ? DirectoryUtils.formatToDirectoryNamingCompliant(componentLabel) : componentId;
        StringBuilder relativeExportPath = new StringBuilder(componentLabelForm);
        StringBuilder pathToCreate = new StringBuilder(exportPath).append(File.separatorChar).append(componentLabelForm);
        relativeExportPath.append(File.separator).append(pubNameForm);
        pathToCreate.append(File.separator).append(pubNameForm);
        String relativeExportPathAscii = FileServerUtils.replaceAccentChars((String)relativeExportPath.toString());
        SilverTrace.debug((String)"importExport", (String)"PublicationTypeManager.createPathDirectoryForKmaxPublicationExport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("relativeExportPathAscii = " + relativeExportPathAscii));
        this.createASCIIPath(pathToCreate.toString());
        return relativeExportPathAscii;
    }

    public void processImport(PublicationsType publicationsType, ImportSettings settings, ImportReportManager reportManager) {
        GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(settings.getUser(), settings.getComponentId());
        AttachmentImportExport attachmentIE = new AttachmentImportExport();
        PdcImportExport pdcIE = new PdcImportExport();
        VersioningImportExport versioningIE = new VersioningImportExport(settings.getUser());
        CoordinateImportExport coordinateIE = new CoordinateImportExport();
        List listPub_Type = publicationsType.getListPublicationType();
        ArrayList<Integer> nodesKmax = new ArrayList<Integer>();
        ArrayList<NodePositionType> nodes = new ArrayList();
        UserDetail userDetail = settings.getUser();
        for (PublicationType pubType : listPub_Type) {
            String componentId = pubType.getComponentId() == null || pubType.getComponentId().length() == 0 ? settings.getComponentId() : pubType.getComponentId();
            gedIE.setCurrentComponentId(componentId);
            UnitReport unitReport = new UnitReport();
            reportManager.addUnitReport(unitReport, componentId);
            ComponentInst componentInst = OrganisationControllerFactory.getOrganisationController().getComponentInst(componentId);
            if (componentInst == null) {
                unitReport.setError(1);
                unitReport.setStatus(3);
                continue;
            }
            reportManager.setComponentName(componentId, componentInst.getLabel());
            PublicationDetail pubDetailToCreate = pubType.getPublicationDetail();
            List attachments = null;
            List documents = null;
            if (pubType.getAttachmentsType() != null) {
                attachments = pubType.getAttachmentsType().getListAttachmentDetail();
            }
            if (pubType.getDocumentsType() != null) {
                documents = pubType.getDocumentsType().getListDocuments();
            }
            if (pubDetailToCreate == null) {
                if (pubType.getId() == -1) {
                    if (attachments != null && !attachments.isEmpty()) {
                        AttachmentDetail attachment = (AttachmentDetail)attachments.get(0);
                        File file = new File(attachment.getPhysicalName());
                        pubDetailToCreate = PublicationImportExport.convertFileInfoToPublicationDetail(file, settings);
                    } else {
                        pubDetailToCreate = new PublicationDetail("unknown", "pub temp", "description", new Date(), new Date(), null, userDetail.getId(), "5", null, null, null);
                    }
                } else {
                    pubDetailToCreate = new PublicationDetail();
                }
            }
            if (pubDetailToCreate == null) continue;
            pubDetailToCreate.setPk(new PublicationPK(null, "useless", componentId));
            if (pubType.getId() != -1) {
                pubDetailToCreate.getPK().setId(Integer.toString(pubType.getId()));
            }
            this.checkPublication(pubDetailToCreate, userDetail);
            if (this.isKmax(componentId)) {
                List coordinates = pubType.getCoordinatesPositionsType().getCoordinatesPositions();
                boolean createCoordinateAllowed = pubType.getCoordinatesPositionsType().getCreateEnable();
                if (coordinates != null) {
                    for (Coordinate coordinate : coordinates) {
                        Collection listCoordinatePointsType;
                        if (coordinate == null || (listCoordinatePointsType = coordinate.getCoordinatePoints()) == null) continue;
                        StringBuffer coordinatePointsPath = new StringBuffer("");
                        boolean first = true;
                        for (CoordinatePointType coordinatePointType : listCoordinatePointsType) {
                            if (!StringUtil.isDefined((String)coordinatePointType.getValue())) continue;
                            NodeDetail nodeDetail = coordinateIE.getNodeDetailByName(coordinatePointType.getValue(), coordinatePointType.getAxisId(), componentId);
                            SilverTrace.debug((String)"importExport", (String)"PublicationsTypeManager.processImport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nodeDetail avant= " + nodeDetail));
                            if (nodeDetail == null && createCoordinateAllowed) {
                                NodeDetail position = new NodeDetail("toDefine", coordinatePointType.getValue(), "", null, userDetail.getId(), null, "0", String.valueOf(coordinatePointType.getAxisId()), null);
                                nodeDetail = coordinateIE.addPosition(position, String.valueOf(coordinatePointType.getAxisId()), componentId);
                                SilverTrace.debug((String)"importExport", (String)"PublicationsTypeManager.processImport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nodeDetail apres cr\u00e9ation= " + nodeDetail));
                            }
                            if (nodeDetail == null) continue;
                            if (first) {
                                coordinatePointsPath.append(nodeDetail.getPath()).append(nodeDetail.getId());
                                first = false;
                                continue;
                            }
                            coordinatePointsPath.append(",").append(nodeDetail.getPath()).append(nodeDetail.getId());
                        }
                        SilverTrace.debug((String)"importExport", (String)"PublicationsTypeManager.processImport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("coordinatePointsPath = " + coordinatePointsPath));
                        int coordinateId = coordinateIE.addPositions(componentId, coordinatePointsPath.toString());
                        if (coordinateId == 0) {
                            unitReport.setError(8);
                            continue;
                        }
                        nodesKmax.add(coordinateId);
                    }
                }
                SilverTrace.debug((String)"importExport", (String)"PublicationsTypeManager.processImport", (String)"root.MSG_GEN_PARAM_VALUE", (String)("TOTAL List coordinatesId = " + nodesKmax));
            } else {
                nodes = pubType.getNodePositionsType().getListNodePositionType();
            }
            PublicationDetail pubDetail = gedIE.createPublicationForUnitImport(unitReport, settings, pubDetailToCreate, nodes);
            try {
                block45: {
                    if (pubDetail == null) continue;
                    unitReport.setLabel(pubDetail.getPK().getId());
                    if (this.isKmax(componentId)) {
                        PublicationImportExport.addNodesToPublication(pubDetail.getPK(), nodesKmax);
                    }
                    if (pubType.getPublicationContentType() != null) {
                        try {
                            gedIE.createPublicationContent(reportManager, unitReport, Integer.parseInt(pubDetail.getId()), pubType.getPublicationContentType(), userDetail.getId(), pubDetail.getLanguage());
                        }
                        catch (ImportExportException ex) {
                            if (unitReport.getError() != -1) break block45;
                            unitReport.setError(9);
                        }
                    }
                }
                ResourceLocator uploadSettings = new ResourceLocator("org.silverpeas.util.uploads.uploadSettings", "");
                long maximumFileSize = uploadSettings.getLong("MaximumFileSize", 0xA00000L);
                if (attachments != null) {
                    List copiedAttachments;
                    ArrayList<AttachmentDetail> attachmentsSizeOk = new ArrayList<AttachmentDetail>();
                    for (AttachmentDetail attdetail : attachments) {
                        long fileSize = attdetail.getSize();
                        if (fileSize > maximumFileSize) {
                            unitReport.setError(13);
                            continue;
                        }
                        MetaData metaData = null;
                        if (settings.isPoiUsed()) {
                            metaData = metadataExtractor.extractMetadata(attdetail.getAttachmentPath());
                            if (!StringUtil.isDefined((String)attdetail.getTitle()) && StringUtil.isDefined((String)metaData.getTitle())) {
                                attdetail.setTitle(metaData.getTitle());
                            }
                            if (!StringUtil.isDefined((String)attdetail.getInfo()) && StringUtil.isDefined((String)metaData.getSubject())) {
                                attdetail.setInfo(metaData.getSubject());
                            }
                        }
                        if (settings.useFileDates()) {
                            if (metaData == null) {
                                metaData = metadataExtractor.extractMetadata(attdetail.getAttachmentPath());
                            }
                            if (metaData.getCreationDate() != null) {
                                attdetail.setCreationDate(metaData.getCreationDate());
                            }
                        }
                        attachmentsSizeOk.add(attdetail);
                    }
                    if (ImportExportHelper.isVersioningUsed(componentInst)) {
                        copiedAttachments = attachmentsSizeOk;
                        versioningIE.importDocuments(pubDetail.getId(), componentId, attachmentsSizeOk, Integer.parseInt(userDetail.getId()), pubDetail.isIndexable());
                    } else {
                        copiedAttachments = attachmentIE.importAttachments(pubDetail.getId(), componentId, attachmentsSizeOk, userDetail.getId(), pubDetail.isIndexable());
                        if (copiedAttachments.size() != attachmentsSizeOk.size()) {
                            unitReport.setError(2);
                        }
                    }
                    reportManager.addNumberOfFilesProcessed(copiedAttachments.size());
                    reportManager.addNumberOfFilesNotImported(attachments.size() - copiedAttachments.size());
                    for (AttachmentDetail attdetail : copiedAttachments) {
                        reportManager.addImportedFileSize(attdetail.getSize(), componentId);
                    }
                }
                if (documents != null && ImportExportHelper.isVersioningUsed(componentInst)) {
                    int nbFiles = 0;
                    ArrayList<Document> documentsSizeOk = new ArrayList<Document>();
                    for (Document documentDetail : documents) {
                        nbFiles += documentDetail.getVersionsType().getListVersions().size();
                        ArrayList<DocumentVersion> documentVersionsSizeOk = new ArrayList<DocumentVersion>();
                        List documentVersions = documentDetail.getVersionsType().getListVersions();
                        for (DocumentVersion documentVersionDetail : documentVersions) {
                            long fileSize = documentVersionDetail.getSize();
                            if (fileSize > maximumFileSize) {
                                unitReport.setError(13);
                                continue;
                            }
                            documentVersionsSizeOk.add(documentVersionDetail);
                        }
                        documentDetail.getVersionsType().setListVersions(documentVersionsSizeOk);
                        documentsSizeOk.add(documentDetail);
                    }
                    List copiedFiles = versioningIE.importDocuments(new ForeignPK(pubDetail.getId(), componentId), documentsSizeOk, Integer.parseInt(userDetail.getId()), ImportExportHelper.isIndexable(pubDetail));
                    reportManager.addNumberOfFilesProcessed(copiedFiles.size());
                    reportManager.addNumberOfFilesNotImported(nbFiles - copiedFiles.size());
                    for (SimpleDocument version : copiedFiles) {
                        reportManager.addImportedFileSize(version.getSize(), componentId);
                    }
                }
                try {
                    List positions;
                    boolean pdcOK;
                    int silverObjectId = gedIE.getSilverObjectId(pubDetail.getId());
                    if (pubType.getPdcPositionsType() != null && !(pdcOK = pdcIE.addPositions(silverObjectId, componentId, pubType.getPdcPositionsType()))) {
                        unitReport.setError(8);
                    }
                    if ((positions = pdcIE.getPositions(silverObjectId, componentId)) != null || !pdcIE.isClassifyingMandatory(componentId) || !ImportExportHelper.isDraftUsed(componentInst)) continue;
                    gedIE.publicationNotClassifiedOnPDC(pubDetail.getId());
                }
                catch (Exception e) {
                    unitReport.setError(8);
                }
            }
            catch (Exception ex) {
                unitReport.setError(0);
                SilverTrace.error((String)"importExport", (String)"PublicationsTypeManager.processImport()", (String)"root.EX_NO_MESSAGE", (Throwable)ex);
            }
        }
    }

    private void checkPublication(PublicationDetail publication, UserDetail userDetail) {
        if (publication.getCreationDate() == null) {
            publication.setCreationDate(new Date());
        }
        publication.setCreatorId(ImportExportHelper.checkUserId(publication.getCreatorId(), userDetail));
        publication.setUpdaterId(ImportExportHelper.checkUserId(publication.getUpdaterId(), userDetail));
        if (publication.getImportance() == 0) {
            publication.setImportance(5);
        }
    }

    private boolean isKmax(String currentComponentId) {
        return currentComponentId.startsWith("kmax");
    }

    public void fillPublicationType(GEDImportExport gedIE, PublicationType publicationType, NodePK rootPK) throws ImportExportException {
        PublicationPK pk = publicationType.getPublicationDetail().getPK();
        publicationType.setNodePositionsType(new NodePositionsType());
        ArrayList<NodePositionType> listNodePos = new ArrayList<NodePositionType>();
        List<NodePK> listNodePK = gedIE.getAllTopicsOfPublication(pk);
        if (rootPK != null && !rootPK.getInstanceId().equals(pk.getInstanceId())) {
            listNodePK = gedIE.getAliases(pk);
        }
        for (NodePK nodePK : listNodePK) {
            if (rootPK != null && !nodePK.getInstanceId().equals(rootPK.getInstanceId())) continue;
            NodePositionType nodePos = new NodePositionType();
            nodePos.setId(Integer.parseInt(nodePK.getId()));
            listNodePos.add(nodePos);
        }
        if (listNodePos.isEmpty()) {
            NodePositionType nodePos = new NodePositionType();
            nodePos.setId(Integer.parseInt("2"));
            listNodePos.add(nodePos);
        }
        publicationType.getNodePositionsType().setListNodePositionType(listNodePos);
    }

    public int getNbThemes(GEDImportExport gedIE, PublicationType publicationType, NodePK rootPK) throws ImportExportException {
        int nbThemes = 1;
        List positions = publicationType.getNodePositionsType().getListNodePositionType();
        if (positions != null && !positions.isEmpty()) {
            String instanceId = publicationType.getComponentId();
            if (rootPK != null) {
                instanceId = rootPK.getInstanceId();
            }
            NodePK pk = new NodePK(String.valueOf(((NodePositionType)positions.get(0)).getId()), instanceId);
            nbThemes = gedIE.getTopicTree(pk).size();
        }
        return nbThemes;
    }
}

