/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.silverpeas.form.importExport.XMLField;
import com.silverpeas.importExport.control.GEDImportExport;
import com.silverpeas.importExport.control.ImportExportFactory;
import com.silverpeas.importExport.control.ImportSettings;
import com.silverpeas.importExport.control.PublicationImportExport;
import com.silverpeas.importExport.model.ImportExportException;
import com.silverpeas.importExport.model.RepositoriesType;
import com.silverpeas.importExport.model.RepositoryType;
import com.silverpeas.importExport.report.ImportReportManager;
import com.silverpeas.importExport.report.MassiveReport;
import com.silverpeas.importExport.report.UnitReport;
import com.silverpeas.pdc.importExport.PdcImportExport;
import com.silverpeas.publication.importExport.PublicationContentType;
import com.silverpeas.publication.importExport.XMLModelContentType;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.attachment.AttachmentImportExport;
import org.silverpeas.importExport.attachment.AttachmentPK;
import org.silverpeas.importExport.versioning.VersioningImportExport;
import org.silverpeas.util.mail.Extractor;
import org.silverpeas.util.mail.Mail;
import org.silverpeas.util.mail.MailAttachment;
import org.silverpeas.util.mail.MailExtractor;

public class RepositoriesTypeManager {
    public static final CharSequenceTranslator ESCAPE_ISO8859_1 = new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE());

    public void processImport(RepositoriesType repositoriesType, ImportSettings settings, ImportReportManager reportManager) {
        List listRep_Type = repositoriesType.getListRepositoryType();
        Iterator itListRep_Type = listRep_Type.iterator();
        AttachmentImportExport attachmentIE = new AttachmentImportExport();
        VersioningImportExport versioningIE = new VersioningImportExport(settings.getUser());
        PdcImportExport pdcIE = new PdcImportExport();
        while (itListRep_Type.hasNext()) {
            RepositoryType rep_Type = (RepositoryType)itListRep_Type.next();
            String componentId = rep_Type.getComponentId();
            int topicId = rep_Type.getTopicId();
            String sPath = rep_Type.getPath();
            MassiveReport massiveReport = new MassiveReport();
            reportManager.addMassiveReport(massiveReport, componentId);
            massiveReport.setRepositoryPath(sPath);
            ComponentInst componentInst = OrganisationControllerFactory.getOrganisationController().getComponentInst(componentId);
            if (componentInst == null) {
                massiveReport.setError(1);
                continue;
            }
            reportManager.setComponentName(componentId, componentInst.getLabel());
            File path = new File(sPath);
            if (!path.isDirectory()) {
                massiveReport.setError(3);
                continue;
            }
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(settings.getUser(), componentId);
            Iterator<File> itListcontenuPath = this.getPathContent(path);
            while (itListcontenuPath.hasNext()) {
                File file = itListcontenuPath.next();
                if (file.isFile()) {
                    settings.setFolderId(String.valueOf(topicId));
                    this.importFile(file, reportManager, massiveReport, gedIE, pdcIE, settings);
                    continue;
                }
                if (!file.isDirectory()) continue;
                switch (rep_Type.getMassiveTypeInt()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        settings.setPathToImport(file.getAbsolutePath());
                        this.processImportRecursiveNoReplicate(reportManager, massiveReport, gedIE, attachmentIE, versioningIE, pdcIE, settings);
                        break;
                    }
                    case 2: {
                        try {
                            NodeDetail nodeDetail = gedIE.addSubTopicToTopic(file, topicId, massiveReport);
                            settings.setPathToImport(file.getAbsolutePath());
                            settings.setFolderId(nodeDetail.getNodePK().getId());
                            this.processImportRecursiveReplicate(reportManager, massiveReport, gedIE, pdcIE, settings);
                            break;
                        }
                        catch (ImportExportException ex) {
                            massiveReport.setError(3);
                        }
                    }
                }
            }
        }
    }

    private PublicationDetail importFile(File file, ImportReportManager reportManager, MassiveReport massiveReport, GEDImportExport gedIE, PdcImportExport pdcIE, ImportSettings settings) {
        SilverTrace.debug((String)"importExport", (String)"RepositoriesTypeManager.importFile", (String)"root.MSG_GEN_ENTER_METHOD", (String)("file = " + file.getName()));
        String componentId = gedIE.getCurrentComponentId();
        UserDetail userDetail = gedIE.getCurentUserDetail();
        PublicationDetail pubDetailToCreate = null;
        try {
            HistorisedDocument document;
            UnitReport unitReport = new UnitReport();
            massiveReport.addUnitReport(unitReport);
            ResourceLocator uploadSettings = new ResourceLocator("org.silverpeas.util.uploads.uploadSettings", "");
            long maximumFileSize = uploadSettings.getLong("MaximumFileSize", 0xA00000L);
            long fileSize = file.length();
            if (fileSize <= 0L) {
                unitReport.setError(2);
                reportManager.addNumberOfFilesNotImported(1);
                return pubDetailToCreate;
            }
            if (fileSize > maximumFileSize) {
                unitReport.setError(13);
                reportManager.addNumberOfFilesNotImported(1);
                return pubDetailToCreate;
            }
            pubDetailToCreate = PublicationImportExport.convertFileInfoToPublicationDetail(file, settings);
            pubDetailToCreate.setPk(new PublicationPK("unknown", "useless", componentId));
            if (settings.isDraftUsed() && pdcIE.isClassifyingMandatory(componentId) || settings.isDraftUsed()) {
                pubDetailToCreate.setStatus("Draft");
                pubDetailToCreate.setStatusMustBeChecked(false);
            }
            SilverTrace.debug((String)"importExport", (String)"RepositoriesTypeManager.importFile", (String)"root.MSG_GEN_PARAM_VALUE", (String)("pubDetailToCreate.status = " + pubDetailToCreate.getStatus()));
            pubDetailToCreate = gedIE.createPublicationForMassiveImport(unitReport, pubDetailToCreate, settings);
            unitReport.setLabel(pubDetailToCreate.getPK().getId());
            SilverTrace.debug((String)"importExport", (String)"RepositoriesTypeManager.importFile", (String)"root.MSG_GEN_PARAM_VALUE", (String)"pubDetailToCreate created");
            if (FileUtil.isMail((String)file.getName())) {
                this.processMailContent(pubDetailToCreate, file, reportManager, unitReport, gedIE, settings.isVersioningUsed());
            }
            SimpleDocumentPK pk = new SimpleDocumentPK(null, componentId);
            if (settings.isVersioningUsed()) {
                document = new HistorisedDocument();
                document.setPublicDocument(settings.getVersionType() == 0);
            } else {
                document = new SimpleDocument();
            }
            document.setPK(pk);
            document.setFile(new SimpleAttachment());
            document.setFilename(file.getName());
            document.setSize(fileSize);
            document.getFile().setCreatedBy(userDetail.getId());
            if (settings.useFileDates()) {
                document.setCreated(pubDetailToCreate.getCreationDate());
                if (pubDetailToCreate.getUpdateDate() != null) {
                    document.setUpdated(pubDetailToCreate.getUpdateDate());
                }
            } else {
                document.setCreated(new Date());
            }
            document.setForeignId(pubDetailToCreate.getPK().getId());
            document.setContentType(FileUtil.getMimeType((String)file.getName()));
            AttachmentServiceFactory.getAttachmentService().createAttachment((SimpleDocument)document, file, pubDetailToCreate.isIndexable(), false);
            reportManager.addNumberOfFilesProcessed(1);
            reportManager.addImportedFileSize(document.getSize(), componentId);
        }
        catch (Exception ex) {
            massiveReport.setError(0);
            SilverTrace.error((String)"importExport", (String)"RepositoriesTypeManager.importFile", (String)"root.EX_NO_MESSAGE", (Throwable)ex);
        }
        return pubDetailToCreate;
    }

    private void processMailContent(PublicationDetail pubDetail, File file, ImportReportManager reportManager, UnitReport unitReport, GEDImportExport gedIE, boolean isVersioningUsed) throws ImportExportException {
        String componentId = gedIE.getCurrentComponentId();
        UserDetail userDetail = gedIE.getCurentUserDetail();
        MailExtractor extractor = null;
        Mail mail = null;
        try {
            extractor = Extractor.getExtractor((File)file);
            mail = extractor.getMail();
        }
        catch (Exception e) {
            SilverTrace.error((String)"importExport", (String)"RepositoriesTypeManager.processMailContent", (String)"importExport.EX_CANT_EXTRACT_MAIL_DATA", (Throwable)e);
        }
        if (mail != null) {
            String content = mail.getBody();
            PublicationContentType pubContent = new PublicationContentType();
            XMLModelContentType modelContent = new XMLModelContentType("mail");
            pubContent.setXMLModelContentType(modelContent);
            ArrayList<XMLField> fields = new ArrayList<XMLField>();
            modelContent.setFields(fields);
            XMLField subject = new XMLField("subject", mail.getSubject());
            fields.add(subject);
            XMLField body = new XMLField("body", ESCAPE_ISO8859_1.translate((CharSequence)content));
            fields.add(body);
            XMLField date = new XMLField("date", DateUtil.getOutputDateAndHour((Date)mail.getDate(), (String)"fr"));
            fields.add(date);
            InternetAddress address = mail.getFrom();
            String from = "";
            if (StringUtil.isDefined((String)address.getPersonal())) {
                from = from + address.getPersonal() + " - ";
            }
            from = from + "<a href=\"mailto:" + address.getAddress() + "\">" + address.getAddress() + "</a>";
            XMLField fieldFROM = new XMLField("from", from);
            fields.add(fieldFROM);
            Address[] recipients = mail.getAllRecipients();
            String to = "";
            for (Address recipient : recipients) {
                InternetAddress ia = (InternetAddress)recipient;
                if (StringUtil.isDefined((String)ia.getPersonal())) {
                    to = to + ia.getPersonal() + " - ";
                }
                to = to + "<a href=\"mailto:" + ia.getAddress() + "\">" + ia.getAddress() + "</a></br>";
            }
            XMLField fieldTO = new XMLField("to", to);
            fields.add(fieldTO);
            gedIE.createPublicationContent(reportManager, unitReport, Integer.parseInt(pubDetail.getPK().getId()), pubContent, userDetail.getId(), null);
            try {
                ArrayList<AttachmentDetail> documents = new ArrayList<AttachmentDetail>();
                List attachments = extractor.getAttachments();
                for (MailAttachment attachment : attachments) {
                    if (attachment == null) continue;
                    AttachmentDetail attDetail = new AttachmentDetail();
                    AttachmentPK pk = new AttachmentPK("unknown", "useless", componentId);
                    attDetail.setLogicalName(attachment.getName());
                    attDetail.setPhysicalName(attachment.getPath());
                    attDetail.setAuthor(userDetail.getId());
                    attDetail.setSize(attachment.getSize());
                    attDetail.setPK(pk);
                    documents.add(attDetail);
                }
                if (isVersioningUsed) {
                    VersioningImportExport versioningIE = new VersioningImportExport(userDetail);
                    versioningIE.importDocuments(pubDetail.getPK().getId(), componentId, documents, Integer.parseInt(userDetail.getId()), pubDetail.isIndexable());
                } else {
                    AttachmentImportExport attachmentIE = new AttachmentImportExport();
                    attachmentIE.importAttachments(pubDetail.getPK().getId(), componentId, documents, userDetail.getId(), pubDetail.isIndexable());
                }
            }
            catch (Exception e) {
                SilverTrace.error((String)"importExport", (String)"RepositoriesTypeManager.processMailContent", (String)"root.EX_NO_MESSAGE", (Throwable)e);
            }
        }
    }

    public void processImportRecursiveNoReplicate(ImportReportManager reportManager, MassiveReport massiveReport, GEDImportExport gedIE, AttachmentImportExport attachmentIE, VersioningImportExport versioningIE, PdcImportExport pdcIE, ImportSettings settings) {
        Iterator<File> itListcontenuPath = this.getPathContent(new File(settings.getPathToImport()));
        while (itListcontenuPath.hasNext()) {
            File file = itListcontenuPath.next();
            if (file.isFile()) {
                this.importFile(file, reportManager, massiveReport, gedIE, pdcIE, settings);
                continue;
            }
            if (!file.isDirectory()) continue;
            settings.setPathToImport(file.getAbsolutePath());
            this.processImportRecursiveNoReplicate(reportManager, massiveReport, gedIE, attachmentIE, versioningIE, pdcIE, settings);
        }
    }

    public List<PublicationDetail> processImportRecursiveReplicate(ImportReportManager reportManager, MassiveReport massiveReport, GEDImportExport gedIE, PdcImportExport pdcIE, ImportSettings settings) throws ImportExportException {
        ArrayList<PublicationDetail> publications = new ArrayList<PublicationDetail>();
        File path = new File(settings.getPathToImport());
        Iterator<File> itListcontenuPath = this.getPathContent(path);
        while (itListcontenuPath.hasNext()) {
            File file = itListcontenuPath.next();
            if (file.isFile()) {
                PublicationDetail publication = this.importFile(file, reportManager, massiveReport, gedIE, pdcIE, settings);
                if (publication == null) continue;
                publications.add(publication);
                continue;
            }
            if (!file.isDirectory()) continue;
            NodeDetail nodeDetail = gedIE.addSubTopicToTopic(file, (int)Integer.valueOf(settings.getFolderId()), massiveReport);
            ImportSettings recursiveSettings = settings.clone();
            recursiveSettings.setPathToImport(file.getAbsolutePath());
            recursiveSettings.setFolderId(nodeDetail.getNodePK().getId());
            publications.addAll(this.processImportRecursiveReplicate(reportManager, massiveReport, gedIE, pdcIE, recursiveSettings));
        }
        return publications;
    }

    private Iterator<File> getPathContent(File path) {
        SilverTrace.debug((String)"importExport", (String)"RepositoriesTypeManager.getPathContent", (String)"root.MSG_GEN_ENTER_METHOD", (String)("path = " + path.getPath()));
        Object[] listContenuStringPath = path.list();
        Arrays.sort(listContenuStringPath);
        List<File> listcontenuPath = this.convertListStringToListFile((String[])listContenuStringPath, path.getPath());
        return listcontenuPath.iterator();
    }

    private List<File> convertListStringToListFile(String[] listFileName, String path) {
        ArrayList<File> listFile = new ArrayList<File>();
        if (listFileName == null) {
            return null;
        }
        for (String aListFileName : listFileName) {
            listFile.add(new File(path + File.separator + aListFileName));
        }
        return listFile;
    }
}

