/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.control;

import com.silverpeas.importExport.control.ImportExport;
import com.silverpeas.importExport.model.ImportExportException;
import com.silverpeas.importExport.report.ImportReport;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class ScheduledImport
implements SchedulerEventListener {
    public static final String IMPORTENGINE_JOB_NAME = "ImportEngineJob";
    private final ResourceLocator resources = new ResourceLocator("org.silverpeas.importExport.settings.importSettings", "");
    private File dir = null;
    private String postPolicy = null;

    public void initialize() {
        try {
            String cron = this.resources.getString("cronScheduledImport");
            this.postPolicy = this.resources.getString("postPolicy", "remove");
            String sDir = this.resources.getString("importRepository");
            this.dir = new File(sDir);
            if (!this.dir.exists() && !this.dir.isDirectory()) {
                SilverTrace.warn((String)"importExport", (String)"ScheduledImport.initialize()", (String)"importExport.EX_CANT_INIT_SCHEDULED_IMPORT", (String)("Repository '" + sDir + "' does not exists !"));
            } else {
                SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
                Scheduler scheduler = schedulerFactory.getScheduler();
                scheduler.unscheduleJob(IMPORTENGINE_JOB_NAME);
                JobTrigger trigger = JobTrigger.triggerAt((String)cron);
                scheduler.scheduleJob(IMPORTENGINE_JOB_NAME, trigger, (SchedulerEventListener)this);
            }
        }
        catch (Exception e) {
            SilverTrace.error((String)"importExport", (String)"ScheduledImport.initialize()", (String)"importExport.EX_CANT_INIT_SCHEDULED_IMPORT", (Throwable)e);
        }
    }

    public void doScheduledImport() {
        File[] files;
        SilverTrace.info((String)"importExport", (String)"ScheduledImport.doScheduledImport()", (String)"root.MSG_GEN_ENTER_METHOD");
        String userId = this.resources.getString("userIdAsCreatorId");
        ImportExport importExport = new ImportExport();
        UserDetail user = OrganisationControllerFactory.getOrganisationController().getUserDetail(userId);
        ResourceLocator multilang = new ResourceLocator("com.silverpeas.importExportPeas.multilang.importExportPeasBundle", "fr");
        ResourcesWrapper resource = new ResourcesWrapper(multilang, "fr");
        for (File file : files = this.dir.listFiles()) {
            String extension;
            if (!file.isFile() || !"xml".equalsIgnoreCase(extension = FileRepositoryManager.getFileExtension((String)file.getName()))) continue;
            SilverTrace.info((String)"importExport", (String)"ScheduledImport.doScheduledImport()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("file = " + file.getAbsolutePath()));
            try {
                ImportReport importReport = importExport.processImport(user, file.getAbsolutePath());
                importExport.writeImportToLog(importReport, resource);
                if ("remove".equalsIgnoreCase(this.postPolicy)) {
                    file.delete();
                    continue;
                }
                if (!"rename".equalsIgnoreCase(this.postPolicy)) continue;
                file.renameTo(new File(file.getAbsolutePath() + ".old"));
            }
            catch (ImportExportException e) {
                SilverTrace.error((String)"importExport", (String)"ScheduledImport.doScheduledImport()", (String)"importExport.EX_CANT_PROCESS_IMPORT", (String)("file = " + file.getAbsolutePath()), (Throwable)e);
            }
        }
        SilverTrace.info((String)"importExport", (String)"ScheduledImport.doScheduledImport()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    public void triggerFired(SchedulerEvent anEvent) {
        SilverTrace.debug((String)"importExport", (String)"ScheduledImport.handleSchedulerEvent", (String)("The job '" + anEvent.getJobExecutionContext().getJobName() + "' is executing"));
        this.doScheduledImport();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverTrace.debug((String)"importExport", (String)"ScheduledImport.handleSchedulerEvent", (String)("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was successfull"));
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverTrace.error((String)"importExport", (String)"ScheduledImport.handleSchedulerEvent", (String)("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull"));
    }
}

