/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.report;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Form;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordSet;
import com.silverpeas.importExport.model.PublicationType;
import com.silverpeas.importExport.report.HtmlExportGenerator;
import com.silverpeas.publication.importExport.DBModelContentType;
import com.silverpeas.publication.importExport.XMLModelContentType;
import com.silverpeas.publicationTemplate.PublicationTemplateImpl;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.publication.info.model.ModelDetail;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.h1;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.html;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.meta;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.ul;
import org.silverpeas.importExport.attachment.AttachmentDetail;

public class HtmlExportPublicationGenerator {
    private final PublicationDetail publicationDetail;
    private DBModelContentType dbModelContent;
    private XMLModelContentType xmlModelContent;
    private ModelDetail modelDetail;
    private String wysiwygText;
    private List<AttachmentDetail> listAttDetail;
    private final String urlPub;
    private final int nbThemes;

    public HtmlExportPublicationGenerator(PublicationType publicationType, ModelDetail modelDetail, String wysiwygText, String urlPub, int nbThemes) {
        this.publicationDetail = publicationType.getPublicationDetail();
        if (publicationType.getPublicationContentType() != null) {
            this.dbModelContent = publicationType.getPublicationContentType().getDBModelContentType();
            this.xmlModelContent = publicationType.getPublicationContentType().getXMLModelContentType();
        }
        this.nbThemes = nbThemes + 2;
        if (publicationType.getAttachmentsType() != null) {
            this.listAttDetail = publicationType.getAttachmentsType().getListAttachmentDetail();
        }
        this.modelDetail = modelDetail;
        this.wysiwygText = wysiwygText;
        this.urlPub = StringEscapeUtils.escapeHtml((String)urlPub).replaceAll("#", "%23");
    }

    public String toHtmlSommairePublication() {
        return this.toHtmlSommairePublication(null);
    }

    public String toHtmlSommairePublication(String target) {
        ElementContainer xhtmlcontainer = new ElementContainer();
        String htmlPubName = HtmlExportGenerator.encode(this.publicationDetail.getName());
        String htmlPubDescription = HtmlExportGenerator.encode(this.publicationDetail.getDescription());
        String htmlCreatorName = HtmlExportGenerator.encode(this.publicationDetail.getCreatorName());
        String dateString = DateUtil.dateToString((Date)this.publicationDetail.getCreationDate(), (String)"fr");
        li element = new li();
        a link2 = new a();
        link2.setHref(this.urlPub);
        if (StringUtil.isDefined((String)target)) {
            link2.setTarget(target);
        }
        link2.addElement((Element)new b(htmlPubName));
        element.addElement((Element)link2);
        if (StringUtil.isDefined((String)htmlCreatorName)) {
            element.addElement(" - ");
            element.addElement(htmlCreatorName);
        }
        if (StringUtil.isDefined((String)dateString)) {
            element.addElement(" (");
            element.addElement(dateString);
            element.addElement(")");
        }
        if (StringUtil.isDefined((String)htmlPubDescription)) {
            element.addElement((Element)new br());
            element.addElement((Element)new i(htmlPubDescription));
        }
        xhtmlcontainer.addElement((Element)element);
        return xhtmlcontainer.toString();
    }

    String toHtmlEnTetePublication() {
        String htmlPubName = HtmlExportGenerator.encode(this.publicationDetail.getName());
        String htmlCreatorName = HtmlExportGenerator.encode(this.publicationDetail.getCreatorName());
        String dateString = DateUtil.dateToString((Date)this.publicationDetail.getCreationDate(), (String)"fr");
        ElementContainer xhtmlcontainer = new ElementContainer();
        h1 title2 = new h1(htmlPubName);
        xhtmlcontainer.addElement((Element)title2);
        div creationDetail = StringUtil.isDefined((String)dateString) ? new div(htmlCreatorName + " - " + dateString) : new div(htmlCreatorName);
        creationDetail.setClass("creationDetail");
        xhtmlcontainer.addElement((Element)creationDetail);
        return xhtmlcontainer.toString();
    }

    private String toHtmlInfoModel() {
        StringBuilder sb = new StringBuilder();
        String toParse = this.modelDetail.getHtmlDisplayer();
        List textList = this.dbModelContent.getListTextParts();
        List imageList = this.dbModelContent.getListImageParts();
        Iterator textIterator = textList.iterator();
        Iterator imageIterator = imageList.iterator();
        int posit = toParse.indexOf("%WA");
        while (posit != -1) {
            if (posit > 0) {
                sb.append(toParse.substring(0, posit));
                toParse = toParse.substring(posit);
            }
            if (toParse.startsWith("%WATXTDATA%")) {
                if (textIterator.hasNext()) {
                    String textPart = (String)textIterator.next();
                    sb.append(HtmlExportGenerator.encode(textPart));
                }
                toParse = toParse.substring(11);
            } else if (toParse.startsWith("%WAIMGDATA%")) {
                if (imageIterator.hasNext()) {
                    String imagePath = (String)imageIterator.next();
                    String imageName = imagePath.substring(imagePath.lastIndexOf(File.separatorChar) + 1, imagePath.length());
                    if (FileUtil.isImage((String)imageName)) {
                        sb.append("<img border='0' src='").append(imageName).append("' />");
                    } else {
                        sb.append("<b>FileNotImage</b>");
                    }
                }
                toParse = toParse.substring(11);
            }
            posit = toParse.indexOf("%WA");
        }
        sb.append(toParse);
        return sb.toString();
    }

    public String xmlFormToHTML() {
        PublicationTemplateImpl template;
        try {
            template = (PublicationTemplateImpl)PublicationTemplateManager.getInstance().getPublicationTemplate(this.publicationDetail.getPK().getInstanceId() + ":" + this.publicationDetail.getInfoId());
        }
        catch (Exception e) {
            return "Error getting publication template !";
        }
        try {
            Form formView = template.getViewForm();
            RecordSet recordSet = template.getRecordSet();
            DataRecord dataRecord = recordSet.getRecord(this.publicationDetail.getPK().getId());
            PagesContext context = new PagesContext();
            context.setComponentId(this.publicationDetail.getPK().getInstanceId());
            context.setObjectId(this.publicationDetail.getPK().getId());
            String htmlResult = formView.toString(context, dataRecord);
            htmlResult = HtmlExportPublicationGenerator.replaceImagesPathForExport(htmlResult);
            htmlResult = HtmlExportPublicationGenerator.replaceFilesPathForExport(htmlResult);
            return htmlResult;
        }
        catch (Exception e) {
            SilverTrace.error((String)"form", (String)"HtmlExportPublicationGenerator.toHtmlXMLModel", (String)"root.MSG_GEN_PARAM_VALUE", (Throwable)e);
            return null;
        }
    }

    public String toHtml() {
        String htmlPubDescription = HtmlExportGenerator.encode(this.publicationDetail.getDescription());
        html html2 = new html();
        meta meta2 = new meta();
        meta2.setContent("text/html; charset=UTF-8");
        meta2.setHttpEquiv("Content-Type");
        head head2 = new head();
        head2.addElement((Element)meta2);
        head2.addElement(this.getHtmlStyle());
        html2.addElement((Element)head2);
        body body2 = new body();
        body2.addElement(this.toHtmlEnTetePublication());
        div content = new div();
        content.setClass("content");
        p description = new p();
        description.addElement(htmlPubDescription);
        content.addElement((Element)description);
        if (this.dbModelContent != null) {
            content.addElement(this.toHtmlInfoModel());
        } else if (this.wysiwygText != null) {
            content.addElement(this.wysiwygText);
        } else if (this.xmlModelContent != null) {
            content.addElement(this.xmlFormToHTML());
        }
        body2.addElement((Element)content);
        if (this.listAttDetail != null && !this.listAttDetail.isEmpty()) {
            div attachments = new div();
            attachments.setClass("attachments");
            attachments.addElement(this.toHtmlAttachments());
            body2.addElement((Element)attachments);
        }
        html2.addElement((Element)body2);
        return html2.toString();
    }

    private String getHtmlStyle() {
        ElementContainer xhtmlcontainer = new ElementContainer();
        StringBuilder path = new StringBuilder();
        for (int i2 = 0; i2 < this.nbThemes; ++i2) {
            path.append("../");
        }
        path.append("treeview/display.css");
        xhtmlcontainer.addElement((Element)new link().setType("text/css").setRel("stylesheet").setHref(path.toString()));
        return xhtmlcontainer.toString();
    }

    private String toHtmlAttachments() {
        ul attachments = new ul();
        attachments.setClass("list");
        if (this.listAttDetail != null && !this.listAttDetail.isEmpty()) {
            for (AttachmentDetail attDetail : this.listAttDetail) {
                attachments.addElement(HtmlExportPublicationGenerator.toHtmlAttachmentInfos(attDetail));
            }
        }
        return attachments.toString();
    }

    public static String toHtmlAttachmentInfos(AttachmentDetail attDetail) {
        ElementContainer xhtmlcontainer = new ElementContainer();
        String htmlLogicalName = attDetail.getLogicalName();
        String htmlFormatedFileSize = HtmlExportGenerator.encode(FileRepositoryManager.formatFileSize((long)attDetail.getSize()));
        li li2 = new li();
        a link2 = new a();
        link2.setHref(FileServerUtils.replaceAccentChars((String)htmlLogicalName));
        link2.addElement(FileServerUtils.replaceAccentChars((String)htmlLogicalName));
        li2.addElement((Element)link2);
        li2.addElement((Element)new br());
        li2.addElement(htmlFormatedFileSize);
        if (attDetail.getTitle() != null) {
            i i2 = new i();
            i2.addElement(" ");
            i2.addElement(attDetail.getTitle());
            li2.addElement((Element)i2);
            if (StringUtil.isDefined((String)attDetail.getInfo())) {
                li2.addElement(" - ");
                i info = new i();
                info.addElement(HtmlExportGenerator.encode(attDetail.getInfo()));
                li2.addElement((Element)info);
            }
        } else if (attDetail.getInfo() != null) {
            i i3 = new i();
            li2.addElement(" - ");
            i3.addElement(HtmlExportGenerator.encode(attDetail.getInfo()));
            li2.addElement((Element)i3);
        }
        xhtmlcontainer.addElement((Element)li2);
        return xhtmlcontainer.toString();
    }

    public static String replaceImagesPathForExport(String htmlText) {
        int debutPath;
        if (!StringUtil.isDefined((String)htmlText)) {
            return htmlText;
        }
        String lowerHtml = htmlText.toLowerCase();
        int finPath = 0;
        StringBuilder newHtmlText = new StringBuilder();
        if (lowerHtml.indexOf("src=\"", finPath) == -1) {
            return htmlText;
        }
        while ((debutPath = lowerHtml.indexOf("src=\"", finPath)) != -1) {
            newHtmlText.append(htmlText.substring(finPath, debutPath += 5));
            finPath = lowerHtml.indexOf(34, debutPath);
            String imageSrc = lowerHtml.substring(debutPath, finPath);
            int d = imageSrc.indexOf("/attached_file/");
            if (d >= 0) {
                int f = imageSrc.lastIndexOf(47);
                imageSrc = imageSrc.substring(f + 1);
                newHtmlText.append(imageSrc);
                continue;
            }
            newHtmlText.append(htmlText.substring(debutPath, finPath));
        }
        newHtmlText.append(htmlText.substring(finPath, htmlText.length()));
        return newHtmlText.toString();
    }

    public static String replaceFilesPathForExport(String htmlText) {
        int debutPath;
        String lowerHtml = htmlText.toLowerCase();
        int finPath = 0;
        StringBuilder newHtmlText = new StringBuilder();
        if (lowerHtml.indexOf("href=\"", finPath) == -1) {
            return htmlText;
        }
        while ((debutPath = lowerHtml.indexOf("href=\"", finPath)) != -1) {
            newHtmlText.append(htmlText.substring(finPath, debutPath += 6));
            finPath = lowerHtml.indexOf(34, debutPath);
            String imageSrc = lowerHtml.substring(debutPath, finPath);
            int d = imageSrc.indexOf("/attached_file/");
            if (d >= 0) {
                d += 12;
                int f = imageSrc.lastIndexOf(47);
                imageSrc = imageSrc.substring(f + 1);
                newHtmlText.append(imageSrc);
                continue;
            }
            newHtmlText.append(htmlText.substring(debutPath, finPath));
        }
        newHtmlText.append(htmlText.substring(finPath, htmlText.length()));
        return newHtmlText.toString();
    }
}

