/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.report;

import com.silverpeas.importExport.report.ComponentReport;
import com.silverpeas.importExport.report.MassiveReport;
import com.silverpeas.importExport.report.UnitReport;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ImportReport {
    private Date startDate;
    private Date endDate;
    private int nbFilesProcessed;
    private int nbFilesNotImported;
    private List<ComponentReport> listComponentReport = new ArrayList<ComponentReport>();

    public void addComponentReport(ComponentReport componentReport) {
        this.listComponentReport.add(componentReport);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getNbFilesProcessed() {
        return this.nbFilesProcessed;
    }

    public int getNbFilesNotImported() {
        return this.nbFilesNotImported;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    void setEndDate(Date date) {
        this.endDate = date;
    }

    void setStartDate(Date date) {
        this.startDate = date;
    }

    public List<ComponentReport> getListComponentReport() {
        return this.listComponentReport;
    }

    public void addNumberOfFilesProcessed(int n) {
        this.nbFilesProcessed += n;
    }

    public String getDuration() {
        return DateUtil.formatDuration((long)(this.getEndDate().getTime() - this.getStartDate().getTime()));
    }

    public void addNbFilesNotImported(int i) {
        this.nbFilesNotImported += i;
    }

    public long getTotalImportedFileSize() {
        long size = 0L;
        for (ComponentReport componentRpt : this.getListComponentReport()) {
            size += componentRpt.getTotalImportedFileSize();
        }
        return size;
    }

    public String writeToLog(ResourcesWrapper resource) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd-HH'H'mm'm'ss's']");
        String dateFormatee = dateFormat.format(new Date());
        sb.append("**********************************************\n");
        sb.append(dateFormatee).append("\n\n");
        sb.append(resource.getString("importExportPeas.StatGlobal")).append("\n\n");
        sb.append(resource.getString("importExportPeas.ImportDuration")).append(" : ");
        sb.append(this.getDuration()).append("\n");
        sb.append(resource.getString("importExportPeas.NbFilesImported")).append(" : ");
        sb.append(this.getNbFilesProcessed()).append("\n");
        sb.append(resource.getString("importExportPeas.NbFilesNotFound")).append(" : ");
        sb.append(this.getNbFilesNotImported()).append("\n");
        sb.append(resource.getString("importExportPeas.TotalFileUploadedSize")).append(" : ");
        sb.append(FileRepositoryManager.formatFileSize((long)this.getTotalImportedFileSize())).append("\n\n");
        sb.append(resource.getString("importExportPeas.StatComponent")).append("\n");
        for (ComponentReport componentRpt : this.getListComponentReport()) {
            List<MassiveReport> massiveReports;
            sb.append("\n").append(resource.getString("importExportPeas.Composant")).append(" : ");
            sb.append(componentRpt.getComponentName()).append(" : (");
            sb.append(componentRpt.getComponentId()).append(")\n");
            sb.append(resource.getString("importExportPeas.NbPubCreated")).append(" : ");
            sb.append(componentRpt.getNbPublicationsCreated()).append("\n");
            sb.append(resource.getString("importExportPeas.NbPubUpdated")).append(" : ");
            sb.append(componentRpt.getNbPublicationsUpdated()).append("\n");
            sb.append(resource.getString("importExportPeas.NbTopicCreated")).append(" : ");
            sb.append(componentRpt.getNbTopicsCreated()).append("\n");
            sb.append(resource.getString("importExportPeas.TotalFileUploadedSize")).append(" : ");
            sb.append(FileRepositoryManager.formatFileSize((long)componentRpt.getTotalImportedFileSize()));
            sb.append("\n");
            List<UnitReport> unitReports = componentRpt.getListUnitReports();
            if (unitReports != null) {
                for (UnitReport unitReport : unitReports) {
                    if (unitReport.getError() == -1) continue;
                    sb.append(this.logUnitReport(resource, unitReport));
                }
            }
            if ((massiveReports = componentRpt.getListMassiveReports()) != null) {
                for (MassiveReport massiveReport : massiveReports) {
                    sb.append(this.logMassiveReport(resource, massiveReport));
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String logUnitReport(ResourcesWrapper resource, UnitReport unitReport) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(unitReport.getLabel()).append(" : ").append(unitReport.getItemName());
        sb.append(", ").append(resource.getString("GML.error")).append(" : ");
        sb.append(resource.getString("importExportPeas.ImportError" + unitReport.getError()));
        sb.append(", ").append(resource.getString("importExportPeas.Status")).append(" : ");
        sb.append(resource.getString("importExportPeas.ImportStatus" + unitReport.getStatus()));
        sb.append("\n");
        return sb.toString();
    }

    private String logMassiveReport(ResourcesWrapper resource, MassiveReport massiveReport) {
        StringBuilder sb = new StringBuilder(500);
        sb.append(resource.getString("importExportPeas.Repository")).append(" ");
        sb.append(massiveReport.getRepositoryPath()).append("\n");
        if (massiveReport.getError() != -1) {
            sb.append(resource.getString("GML.error")).append(" : ");
            sb.append(resource.getString("importExportPeas.ImportError" + massiveReport.getError()));
            sb.append("\n");
        }
        sb.append(resource.getString("importExportPeas.NbPubCreated")).append(" : ");
        sb.append(massiveReport.getNbPublicationsCreated()).append("\n");
        sb.append(resource.getString("importExportPeas.NbPubUpdated")).append(" : ");
        sb.append(massiveReport.getNbPublicationsUpdated()).append("\n");
        sb.append(resource.getString("importExportPeas.NbTopicCreated")).append(" : ");
        sb.append(massiveReport.getNbTopicsCreated()).append("\n");
        List<UnitReport> unitReports = massiveReport.getListUnitReports();
        if (unitReports != null) {
            for (UnitReport unitReport : unitReports) {
                if (unitReport.getError() == -1) continue;
                sb.append(this.logUnitReport(resource, unitReport));
            }
        }
        return sb.toString();
    }
}

