/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importExport.report;

import com.silverpeas.importExport.report.ComponentReport;
import com.silverpeas.importExport.report.UnitReport;
import java.util.ArrayList;
import java.util.List;

public class MassiveReport {
    private String repositoryPath;
    private int error = -1;
    private ComponentReport componentReport;
    private int nbPublicationsCreated = -1;
    private int nbPublicationsUpdated = -1;
    private int nbTopicsCreated = 0;
    private List<UnitReport> listUnitReports = new ArrayList<UnitReport>();

    public ComponentReport getComponentReport() {
        return this.componentReport;
    }

    public int getError() {
        return this.error;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setComponentReport(ComponentReport report) {
        this.componentReport = report;
    }

    public void setError(int i2) {
        this.error = i2;
    }

    public void setRepositoryPath(String string) {
        this.repositoryPath = string;
    }

    public int getNbPublicationsCreated() {
        if (this.nbPublicationsCreated == -1) {
            this.processStats();
        }
        return this.nbPublicationsCreated;
    }

    public int getNbPublicationsUpdated() {
        if (this.nbPublicationsUpdated == -1) {
            this.processStats();
        }
        return this.nbPublicationsUpdated;
    }

    public int getNbTopicsCreated() {
        return this.nbTopicsCreated;
    }

    public List<UnitReport> getListUnitReports() {
        return this.listUnitReports;
    }

    public void addUnitReport(UnitReport unitReport) {
        this.listUnitReports.add(unitReport);
    }

    private void processStats() {
        this.nbPublicationsCreated = 0;
        this.nbPublicationsUpdated = 0;
        for (UnitReport unitReport : this.listUnitReports) {
            switch (unitReport.getStatus()) {
                case 0: {
                    ++this.nbPublicationsCreated;
                    break;
                }
                case 1: {
                    ++this.nbPublicationsUpdated;
                }
            }
        }
    }

    public void addOneTopicCreated() {
        ++this.nbTopicsCreated;
    }
}

