/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil.servlets;

import com.silverpeas.jcrutil.model.SilverpeasRegister;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import javax.jcr.NamespaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.commons.cnd.ParseException;

public class RepositoryAccessServlet
extends HttpServlet {
    public static final long serialVersionUID = 1L;
    private static final String CTX_PARAM_THIS = "repository.access.servlet";
    private static final String DEFAULT_JNDI_NAME = "java:jcr/local";
    private static final String JNDI_NAME = "jndi_name";
    private transient Repository repository;
    private transient String jndiName = "java:jcr/local";

    public void init() throws ServletException {
        try {
            if (this.getServletContext().getInitParameter(JNDI_NAME) != null) {
                this.jndiName = this.getServletContext().getInitParameter(JNDI_NAME);
            }
            this.log("Initializing the repository ...........");
            SilverTrace.info((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet.init()", (String)"Initializing the repository ...........");
            if (this.getServletContext().getAttribute(CTX_PARAM_THIS) != null) {
                throw new ServletException("Only one repository access servlet allowed per web-app.");
            }
            this.getServletContext().setAttribute(CTX_PARAM_THIS, (Object)this);
            SilverTrace.info((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet.init()", (String)"Spring context loaded.");
            this.repository = (Repository)new InitialContext().lookup(this.jndiName);
            SilverTrace.info((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet initialized.", (String)this.repository.toString());
            SilverTrace.info((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet.init()", (String)"RMI registred");
            this.getServletContext().setAttribute(Repository.class.getName(), (Object)this.repository);
            this.registerSilverpeasNodeTypes();
        }
        catch (NamingException e) {
            SilverTrace.error((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet error", (Throwable)e);
        }
        catch (IOException e) {
            SilverTrace.error((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet error", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (RepositoryException e) {
            SilverTrace.error((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet error", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (ParseException e) {
            SilverTrace.error((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet error", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (ServletException e) {
            SilverTrace.error((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet error", (Throwable)e);
            throw e;
        }
    }

    private void registerSilverpeasNodeTypes() throws RepositoryException, ParseException, IOException, NamespaceException {
        String cndFileName = ((Object)((Object)this)).getClass().getClassLoader().getResource("silverpeas-jcr.txt").getFile().replaceAll("%20", " ");
        SilverpeasRegister.registerNodeTypes((String)cndFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Session session = this.repository.login();
            try {
                String user = session.getUserID();
                String name = this.repository.getDescriptor("jcr.repository.name");
                SilverTrace.info((String)"jcrUtil", (String)"RepositoryAccessServlet.init()", (String)("Logged in as " + user + " to a " + name + " repository."));
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException rex) {
            SilverTrace.error((String)"RepositoryAccessServlet", (String)"jackrabbit.init", (String)"RepositoryAccessServlet service.", (Throwable)rex);
            throw new ServletException("Erreur avec le repository fourni par Spring", (Throwable)rex);
        }
    }

    private static RepositoryAccessServlet getInstance(ServletContext ctx) {
        RepositoryAccessServlet instance = (RepositoryAccessServlet)((Object)ctx.getAttribute(CTX_PARAM_THIS));
        if (instance == null) {
            throw new IllegalStateException("No RepositoryAccessServlet instance in ServletContext, RepositoryAccessServlet servlet not initialized?");
        }
        return instance;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public static Repository getRepository(ServletContext ctx) {
        return RepositoryAccessServlet.getInstance(ctx).getRepository();
    }
}

