/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil.servlets;

import com.silverpeas.jcrutil.security.impl.SilverpeasDigestCredentialsProvider;
import com.silverpeas.jcrutil.servlets.RepositoryAccessServlet;
import com.stratelia.webactiv.util.ResourceLocator;
import javax.jcr.Repository;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.silverpeas.util.crypto.CryptMD5;

public class SimpleDigestWebdavServlet
extends SimpleWebdavServlet {
    private static final long serialVersionUID = -1609493516113921269L;
    private static final int DIGEST_KEY_SIZE = 16;
    private static final ResourceLocator resources = new ResourceLocator("org.silverpeas.util.jcr", "");
    private Repository repository;

    public String getAuthenticateHeaderValue() {
        String nOnce = this.generateNOnce();
        return "Digest realm=\"" + resources.getString("jcr.authentication.realm") + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + CryptMD5.encrypt((String)nOnce) + "\"";
    }

    protected String generateNOnce() {
        String nOnceValue = RandomStringUtils.random((int)16) + ":" + System.currentTimeMillis() + ":" + resources.getString("jcr.authentication.realm");
        return CryptMD5.encrypt((String)nOnceValue);
    }

    public Repository getRepository() {
        if (this.repository == null) {
            this.repository = RepositoryAccessServlet.getRepository(this.getServletContext());
        }
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    protected CredentialsProvider getCredentialsProvider() {
        return new SilverpeasDigestCredentialsProvider();
    }
}

