/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobDomainPeas;

import com.silverpeas.jobDomainPeas.JobDomainSettings;
import com.silverpeas.jobDomainPeas.NavigationStock;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DomainNavigationStock
extends NavigationStock {
    Domain m_NavDomain = null;
    String m_DomainId = null;
    List<String> manageableGroupIds = null;

    public DomainNavigationStock(String navDomain, AdminController adc, List<String> manageableGroupIds) {
        super(adc);
        this.m_DomainId = navDomain;
        this.manageableGroupIds = manageableGroupIds;
        this.refresh();
    }

    public void refresh() {
        this.m_NavDomain = this.m_adc.getDomain(this.m_DomainId);
        this.m_SubUsers = this.m_adc.getUsersOfDomain(this.m_NavDomain.getId());
        if (this.m_SubUsers == null) {
            this.m_SubUsers = ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
        JobDomainSettings.sortUsers(this.m_SubUsers);
        this.m_SubGroups = this.m_adc.getRootGroupsOfDomain(this.m_NavDomain.getId());
        if (this.m_SubGroups == null) {
            this.m_SubGroups = ArrayUtil.EMPTY_GROUP_ARRAY;
        }
        if (this.manageableGroupIds != null) {
            this.m_SubGroups = this.filterGroupsToGroupManager(this.m_SubGroups);
        }
        JobDomainSettings.sortGroups(this.m_SubGroups);
        this.verifIndexes();
    }

    private Group[] filterGroupsToGroupManager(Group[] groups) {
        Iterator<String> itManageableGroupsIds = null;
        ArrayList<Group> temp = new ArrayList<Group>();
        String groupId = null;
        for (Group group : groups) {
            groupId = group.getId();
            if (this.manageableGroupIds.contains(groupId)) {
                temp.add(group);
                continue;
            }
            List<String> subGroupIds = Arrays.asList(this.m_adc.getAllSubGroupIdsRecursively(groupId));
            itManageableGroupsIds = this.manageableGroupIds.iterator();
            String manageableGroupId = null;
            boolean find = false;
            while (!find && itManageableGroupsIds.hasNext()) {
                manageableGroupId = itManageableGroupsIds.next();
                if (!subGroupIds.contains(manageableGroupId)) continue;
                find = true;
            }
            if (!find) continue;
            temp.add(group);
        }
        return temp.toArray(new Group[temp.size()]);
    }

    public boolean isThisDomain(String grId) {
        if (StringUtil.isDefined((String)grId)) {
            return grId.equals(this.m_NavDomain.getId());
        }
        return !DomainNavigationStock.isDomainValid(this.m_NavDomain);
    }

    public Domain getThisDomain() {
        return this.m_NavDomain;
    }

    public static boolean isDomainValid(Domain dom) {
        return dom != null && StringUtil.isDefined((String)dom.getId());
    }
}

