/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobDomainPeas;

import com.silverpeas.jobDomainPeas.JobDomainSettings;
import com.silverpeas.jobDomainPeas.NavigationStock;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GroupNavigationStock
extends NavigationStock {
    Group m_NavGroup = null;
    String m_GroupId = null;
    List<String> manageableGroupIds = null;

    public GroupNavigationStock(String navGroup, AdminController adc, List<String> manageableGroupIds) {
        super(adc);
        this.m_GroupId = navGroup;
        this.manageableGroupIds = manageableGroupIds;
        this.refresh();
    }

    public void refresh() {
        String[] subUsersIds = null;
        String[] subGroupsIds = null;
        this.m_NavGroup = this.m_adc.getGroupById(this.m_GroupId);
        subUsersIds = this.m_NavGroup.getUserIds();
        this.m_SubUsers = subUsersIds == null ? ArrayUtil.EMPTY_USER_DETAIL_ARRAY : this.m_adc.getUserDetails(subUsersIds);
        JobDomainSettings.sortUsers(this.m_SubUsers);
        subGroupsIds = this.m_adc.getAllSubGroupIds(this.m_NavGroup.getId());
        if (subGroupsIds == null) {
            this.m_SubGroups = ArrayUtil.EMPTY_GROUP_ARRAY;
        } else {
            if (this.manageableGroupIds != null) {
                subGroupsIds = this.filterGroupsToGroupManager(subGroupsIds);
            }
            this.m_SubGroups = new Group[subGroupsIds.length];
            for (int i = 0; i < subGroupsIds.length; ++i) {
                this.m_SubGroups[i] = this.m_adc.getGroupById(subGroupsIds[i]);
            }
        }
        JobDomainSettings.sortGroups(this.m_SubGroups);
        this.verifIndexes();
    }

    private String[] filterGroupsToGroupManager(String[] groupIds) {
        Iterator<String> itManageableGroupsIds = null;
        ArrayList<String> temp = new ArrayList<String>();
        String groupId = null;
        for (String groupId1 : groupIds) {
            groupId = groupId1;
            if (this.manageableGroupIds.contains(groupId)) {
                temp.add(groupId);
                continue;
            }
            List<String> subGroupIds = Arrays.asList(this.m_adc.getAllSubGroupIdsRecursively(groupId));
            itManageableGroupsIds = this.manageableGroupIds.iterator();
            String manageableGroupId = null;
            boolean find = false;
            while (!find && itManageableGroupsIds.hasNext()) {
                manageableGroupId = itManageableGroupsIds.next();
                if (!subGroupIds.contains(manageableGroupId)) continue;
                find = true;
            }
            if (!find) continue;
            temp.add(groupId);
        }
        return temp.toArray(new String[temp.size()]);
    }

    public boolean isThisGroup(String grId) {
        if (StringUtil.isDefined((String)grId)) {
            return grId.equals(this.m_NavGroup.getId());
        }
        return !GroupNavigationStock.isGroupValid(this.m_NavGroup);
    }

    public Group getThisGroup() {
        return this.m_NavGroup;
    }

    public static boolean isGroupValid(Group gr) {
        return gr != null && StringUtil.isDefined((String)gr.getId());
    }
}

