/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobDomainPeas.control;

import com.silverpeas.jobDomainPeas.DomainNavigationStock;
import com.silverpeas.jobDomainPeas.GroupNavigationStock;
import com.silverpeas.jobDomainPeas.JobDomainPeasDAO;
import com.silverpeas.jobDomainPeas.JobDomainPeasException;
import com.silverpeas.jobDomainPeas.JobDomainPeasTrappedException;
import com.silverpeas.jobDomainPeas.JobDomainSettings;
import com.silverpeas.jobDomainPeas.SynchroUserWebServiceItf;
import com.silverpeas.jobDomainPeas.control.SynchroLdapThread;
import com.silverpeas.jobDomainPeas.control.SynchroThread;
import com.silverpeas.jobDomainPeas.control.SynchroWebServiceThread;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.csv.CSVReader;
import com.silverpeas.util.csv.Variant;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.security.X509Factory;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.selection.SelectionException;
import com.stratelia.silverpeas.selection.SelectionExtraParams;
import com.stratelia.silverpeas.selection.SelectionUsersGroups;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.PairObject;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.GroupProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.exception.UtilTrappedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.admin.domain.DomainServiceFactory;
import org.silverpeas.admin.domain.DomainType;
import org.silverpeas.admin.domain.exception.DomainConflictException;
import org.silverpeas.admin.domain.exception.DomainCreationException;
import org.silverpeas.admin.domain.exception.DomainDeletionException;
import org.silverpeas.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.password.service.PasswordCheck;
import org.silverpeas.password.service.PasswordServiceFactory;
import org.silverpeas.quota.QuotaKey;
import org.silverpeas.quota.exception.QuotaException;

public class JobDomainPeasSessionController
extends AbstractComponentSessionController {
    String m_TargetUserId = null;
    String targetDomainId = "";
    DomainNavigationStock m_TargetDomain = null;
    Vector<GroupNavigationStock> m_GroupsPath = new Vector();
    SynchroThread m_theThread = null;
    Exception m_ErrorOccured = null;
    String m_SynchroReport = "";
    Selection sel = null;
    List<UserDetail> usersToImport = null;
    Hashtable<String, String> queryToImport = null;
    AdminController m_AdminCtrl = null;
    private List<String> listSelectedUsers = new ArrayList<String>();
    private int indexOfFirstItemToDisplay = 0;
    boolean refreshDomain = true;
    private static final Properties templateConfiguration = new Properties();
    private static final String USER_ACCOUNT_TEMPLATE_FILE = "userAccount_email";

    public JobDomainPeasSessionController(MainSessionController mainSessionCtrl, ComponentContext componentContext) {
        super(mainSessionCtrl, componentContext, "com.silverpeas.jobDomainPeas.multilang.jobDomainPeasBundle", "com.silverpeas.jobDomainPeas.settings.jobDomainPeasIcons", "com.silverpeas.jobDomainPeas.settings.jobDomainPeasSettings");
        this.setComponentRootName("jobDomainPeas");
        this.m_AdminCtrl = new AdminController(this.getUserId());
        this.sel = this.getSelection();
        templateConfiguration.setProperty("template.root.dir", this.getSettings().getString("templatePath"));
        templateConfiguration.setProperty("template.customer.dir", this.getSettings().getString("customersTemplatePath"));
    }

    public int getMinLengthLogin() {
        return JobDomainSettings.m_MinLengthLogin;
    }

    public boolean isUserAddingAllowedForGroupManager() {
        return JobDomainSettings.m_UserAddingAllowedForGroupManagers;
    }

    public boolean isAccessGranted() {
        return !this.getUserManageableGroupIds().isEmpty() || this.getUserDetail().isAccessAdmin() || this.getUserDetail().isAccessDomainManager();
    }

    public void setRefreshDomain(boolean refreshDomain) {
        this.refreshDomain = refreshDomain;
    }

    public void setTargetUser(String userId) {
        this.m_TargetUserId = userId;
    }

    public UserDetail getTargetUserDetail() throws JobDomainPeasException {
        UserDetail valret = null;
        if (this.m_TargetUserId != null && this.m_TargetUserId.length() > 0 && (valret = this.getOrganisationController().getUserDetail(this.m_TargetUserId)) == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.getTargetUserDetail()", 4, "jobDomainPeas.EX_USER_NOT_AVAILABLE", "UserId=" + this.m_TargetUserId);
        }
        return valret;
    }

    public UserFull getTargetUserFull() throws JobDomainPeasException {
        UserFull valret = null;
        if (this.m_TargetUserId != null && this.m_TargetUserId.length() > 0 && (valret = this.getOrganisationController().getUserFull(this.m_TargetUserId)) == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.getTargetUserFull()", 4, "jobDomainPeas.EX_USER_NOT_AVAILABLE", "UserId=" + this.m_TargetUserId);
        }
        return valret;
    }

    public String createUser(String userLogin, String userLastName, String userFirstName, String userEMail, UserAccessLevel userAccessLevel, boolean userPasswordValid, String userPassword, HashMap<String, String> properties, String groupId, HttpServletRequest req, boolean sendEmail) throws JobDomainPeasException, JobDomainPeasTrappedException {
        UserDetail theNewUser = new UserDetail();
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.createUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("userLogin=" + userLogin + " userLastName=" + userLastName + " userFirstName=" + userFirstName + " userEMail=" + userEMail + " userAccessLevel=" + userAccessLevel));
        String existingUser = this.m_AdminCtrl.getUserIdByLoginAndDomain(userLogin, this.targetDomainId);
        if (existingUser != null && existingUser.length() > 0) {
            JobDomainPeasTrappedException te = new JobDomainPeasTrappedException("JobDomainPeasSessionController.createUser()", 4, "admin.EX_ERR_LOGIN_ALREADY_USED");
            te.setGoBackPage("displayUserCreate");
            throw te;
        }
        theNewUser.setId("-1");
        if (this.targetDomainId != null && !this.targetDomainId.equals("-1") && this.targetDomainId.length() > 0) {
            theNewUser.setDomainId(this.targetDomainId);
        }
        theNewUser.setLogin(userLogin);
        theNewUser.setLastName(userLastName);
        theNewUser.setFirstName(userFirstName);
        theNewUser.seteMail(userEMail);
        theNewUser.setAccessLevel(userAccessLevel);
        String idRet = this.m_AdminCtrl.addUser(theNewUser);
        if (idRet == null || idRet.length() <= 0) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.createUser()", 4, "admin.EX_ERR_ADD_USER");
        }
        this.refresh();
        this.setTargetUser(idRet);
        theNewUser.setId(idRet);
        this.notifyUserAccount(userPasswordValid, userPassword, theNewUser, req, true, sendEmail);
        UserFull uf = this.getTargetUserFull();
        if (uf != null) {
            if (uf.isPasswordAvailable()) {
                uf.setPasswordValid(userPasswordValid);
                uf.setPassword(userPassword);
            }
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                uf.setValue(entry.getKey(), entry.getValue());
            }
            idRet = this.m_AdminCtrl.updateUserFull(uf);
            if (!StringUtil.isDefined((String)idRet)) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.createUser()", 4, "admin.EX_ERR_UPDATE_USER");
            }
        }
        this.regroupInGroup(properties, null);
        if (StringUtil.isDefined((String)groupId)) {
            this.m_AdminCtrl.addUserInGroup(idRet, groupId);
        }
        return idRet;
    }

    private void notifyUserAccount(boolean userPasswordValid, String userPassword, UserDetail user, HttpServletRequest req, boolean isNewUser, boolean sendEmail) {
        if (userPasswordValid && sendEmail && StringUtil.isDefined((String)user.geteMail()) && StringUtil.isDefined((String)userPassword)) {
            HashMap<String, SilverpeasTemplate> templates = new HashMap<String, SilverpeasTemplate>();
            String loginUrl = this.getLoginUrl(user, req);
            for (String lang : I18NHelper.getAllSupportedLanguages()) {
                templates.put(lang, this.getTemplate(user, loginUrl, userPassword, isNewUser));
            }
            NotificationMetaData notifMetaData = new NotificationMetaData(-13, this.getString("JDP.createAccountNotifTitle"), templates, USER_ACCOUNT_TEMPLATE_FILE);
            notifMetaData.addUserRecipient(new UserRecipient(user.getId()));
            NotificationSender sender = new NotificationSender(null);
            try {
                sender.notifyUser(-13, notifMetaData);
            }
            catch (NotificationManagerException e) {
                SilverTrace.error((String)"JobDomainPeasSessionController", (String)"notifyNewUserAccount", (String)"admin.MSG_ERR_NOTIFY_USER", (Throwable)e);
            }
        }
    }

    private String getLoginUrl(UserDetail user, HttpServletRequest req) {
        ResourceLocator general = new ResourceLocator("com.stratelia.silverpeas.lookAndFeel.generalLook", "");
        String loginPage = general.getString("loginPage");
        if (!StringUtil.isDefined((String)loginPage)) {
            loginPage = "/defaultLogin.jsp";
            String domainId = user.getDomainId();
            if (StringUtil.isDefined((String)domainId) && !"-1".equals(domainId)) {
                loginPage = loginPage + "?DomainId=" + domainId;
            }
        }
        return URLManager.getFullApplicationURL((HttpServletRequest)req) + loginPage;
    }

    private SilverpeasTemplate getTemplate(UserDetail userDetail, String loginURL, String userPassword, boolean isNew) {
        Properties configuration = new Properties(templateConfiguration);
        SilverpeasTemplate template = SilverpeasTemplateFactory.createSilverpeasTemplate((Properties)configuration);
        template.setAttribute("userDetail", (Object)userDetail);
        template.setAttribute("loginURL", (Object)loginURL);
        template.setAttribute("pwd", (Object)userPassword);
        if (isNew) {
            template.setAttribute("createdUser", (Object)"true");
        }
        return template;
    }

    private void regroupInGroup(HashMap<String, String> properties, String lastGroupId) throws JobDomainPeasException {
        if (!"-1".equals(this.getTargetDomain().getId()) && !"0".equals(this.getTargetDomain().getId()) && this.getTargetDomain().getDriverClassName().equals("com.stratelia.silverpeas.domains.sqldriver.SQLDriver")) {
            String[] newUserIds;
            ArrayList<String> lNewUserIds;
            List<String> lUserIds;
            String nomPropertyRegroupement;
            ResourceLocator specificRs = new ResourceLocator(this.getTargetDomain().getPropFileName(), "");
            int numPropertyRegroup = specificRs.getInteger("property.Grouping", -1);
            String nomRegroup = null;
            String theUserIdToRegroup = this.m_TargetUserId;
            if (numPropertyRegroup > -1 && (nomPropertyRegroupement = specificRs.getString("property_" + numPropertyRegroup + ".Name", null)) != null) {
                if (lastGroupId != null) {
                    Group lastGroup = this.m_AdminCtrl.getGroupById(lastGroupId);
                    lUserIds = Arrays.asList(lastGroup.getUserIds());
                    lNewUserIds = new ArrayList<String>(lUserIds);
                    lNewUserIds.remove(theUserIdToRegroup);
                    newUserIds = lNewUserIds.toArray(new String[lNewUserIds.size()]);
                    this.updateGroupSubUsers(lastGroupId, newUserIds);
                }
                String value = null;
                boolean trouve = false;
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    value = entry.getValue();
                    if (!entry.getKey().equals(nomPropertyRegroupement)) continue;
                    trouve = true;
                    break;
                }
                if (trouve) {
                    nomRegroup = value;
                }
            }
            if (nomRegroup != null && nomRegroup.length() > 0) {
                Group group = this.m_AdminCtrl.getGroupByNameInDomain(nomRegroup, this.targetDomainId);
                if (group == null) {
                    group = new Group();
                    group.setId("-1");
                    group.setDomainId(this.targetDomainId);
                    group.setSuperGroupId(null);
                    group.setName(nomRegroup);
                    group.setDescription("");
                    String groupId = this.m_AdminCtrl.addGroup(group);
                    group = this.m_AdminCtrl.getGroupById(groupId);
                }
                lUserIds = Arrays.asList(group.getUserIds());
                lNewUserIds = new ArrayList<String>(lUserIds);
                lNewUserIds.add(theUserIdToRegroup);
                newUserIds = lNewUserIds.toArray(new String[lNewUserIds.size()]);
                this.updateGroupSubUsers(group.getId(), newUserIds);
            }
        }
    }

    public void importCsvUsers(FileItem filePart, boolean sendEmail, HttpServletRequest req) throws UtilTrappedException, JobDomainPeasTrappedException, JobDomainPeasException {
        String informationSpecifiqueString;
        String address;
        String cellularPhone;
        String fax;
        String homePhone;
        String phone;
        String boss;
        String position;
        String company;
        String title;
        String motDePasse;
        String droits;
        String email;
        String login;
        String prenom;
        String nom;
        Variant[][] csvValues;
        InputStream is;
        try {
            is = filePart.getInputStream();
        }
        catch (IOException e) {
            JobDomainPeasTrappedException jdpe = new JobDomainPeasTrappedException("JobDomainPeasSessionController.importCsvUsers", 4, "jobDomainPeas.EX_CSV_FILE", e);
            jdpe.setGoBackPage("displayUsersCsvImport");
            throw jdpe;
        }
        CSVReader csvReader = new CSVReader(this.getLanguage());
        csvReader.initCSVFormat("com.silverpeas.jobDomainPeas.settings.usersCSVFormat", "User", ";", this.getTargetDomain().getPropFileName(), "property_");
        if ("-1".equals(this.getTargetDomain().getId()) || "0".equals(this.getTargetDomain().getId())) {
            csvReader.setM_specificNbCols(csvReader.getM_specificNbCols() - 2);
        }
        try {
            csvValues = csvReader.parseStream(is);
        }
        catch (UtilTrappedException ute) {
            ute.setGoBackPage("displayUsersCsvImport");
            throw ute;
        }
        StringBuilder listErrors = new StringBuilder("");
        for (int i = 0; i < csvValues.length; ++i) {
            nom = csvValues[i][0].getValueString();
            if (nom.length() == 0) {
                listErrors.append(this.getErrorMessage(i + 1, 1, nom));
                listErrors.append(this.getString("JDP.obligatoire")).append("<br/>");
            } else if (nom.length() > 100) {
                listErrors.append(this.getErrorMessage(i + 1, 1, nom));
                listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
            }
            prenom = csvValues[i][1].getValueString();
            if (prenom.length() > 100) {
                listErrors.append(this.getErrorMessage(i + 1, 2, prenom));
                listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
            }
            if ((login = csvValues[i][2].getValueString()).length() == 0) {
                listErrors.append(this.getErrorMessage(i + 1, 3, login));
                listErrors.append(this.getString("JDP.obligatoire")).append("<br/>");
            } else if (login.length() < JobDomainSettings.m_MinLengthLogin) {
                listErrors.append(this.getErrorMessage(i + 1, 3, login));
                listErrors.append(this.getString("JDP.nbCarMin")).append(" ").append(JobDomainSettings.m_MinLengthLogin).append(" ").append(this.getString("JDP.caracteres")).append("<br/>");
            } else if (login.length() > 50) {
                listErrors.append(this.getErrorMessage(i + 1, 3, login));
                listErrors.append(this.getString("JDP.nbCarMax")).append(" 50 ").append(this.getString("JDP.caracteres")).append("<br/>");
            } else {
                String existingLogin = this.m_AdminCtrl.getUserIdByLoginAndDomain(login, this.targetDomainId);
                if (existingLogin != null) {
                    listErrors.append(this.getErrorMessage(i + 1, 3, login));
                    listErrors.append(this.getString("JDP.existingLogin")).append("<br/>");
                }
            }
            email = csvValues[i][3].getValueString();
            if (email.length() > 100) {
                listErrors.append(this.getErrorMessage(i + 1, 4, email));
                listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
            }
            if (!("".equals(droits = csvValues[i][4].getValueString()) || "Admin".equals(droits) || "AdminPdc".equals(droits) || "AdminDomain".equals(droits) || "User".equals(droits) || "Guest".equals(droits))) {
                listErrors.append(this.getErrorMessage(i + 1, 5, droits));
                listErrors.append(this.getString("JDP.valeursPossibles")).append("<br/>");
            }
            if (StringUtil.isDefined((String)(motDePasse = csvValues[i][5].getValueString()))) {
                PasswordCheck passwordCheck = PasswordServiceFactory.getPasswordService().check(motDePasse);
                if (!passwordCheck.isCorrect()) {
                    listErrors.append(this.getErrorMessage(i + 1, 6, motDePasse)).append(passwordCheck.getFormattedErrorMessage(this.getLanguage()));
                    listErrors.append("<br/>");
                } else if (motDePasse.length() > 32) {
                    listErrors.append(this.getErrorMessage(i + 1, 6, motDePasse));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 32 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
            }
            if (csvReader.getM_specificNbCols() <= 0) continue;
            if ("-1".equals(this.getTargetDomain().getId()) || "0".equals(this.getTargetDomain().getId())) {
                title = csvValues[i][6].getValueString();
                if (title.length() > 100) {
                    listErrors.append(this.getErrorMessage(i + 1, 7, title));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((company = csvValues[i][7].getValueString()).length() > 100) {
                    listErrors.append(this.getErrorMessage(i + 1, 8, company));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((position = csvValues[i][8].getValueString()).length() > 100) {
                    listErrors.append(this.getErrorMessage(i + 1, 9, position));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((boss = csvValues[i][9].getValueString()).length() > 100) {
                    listErrors.append(this.getErrorMessage(i + 1, 10, boss));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 100 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((phone = csvValues[i][10].getValueString()).length() > 20) {
                    listErrors.append(this.getErrorMessage(i + 1, 11, phone));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 20 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((homePhone = csvValues[i][11].getValueString()).length() > 20) {
                    listErrors.append(this.getErrorMessage(i + 1, 12, homePhone));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 20 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((fax = csvValues[i][12].getValueString()).length() > 20) {
                    listErrors.append(this.getErrorMessage(i + 1, 13, fax));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 20 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((cellularPhone = csvValues[i][13].getValueString()).length() > 20) {
                    listErrors.append(this.getErrorMessage(i + 1, 14, cellularPhone));
                    listErrors.append(this.getString("JDP.nbCarMax")).append(" 20 ").append(this.getString("JDP.caracteres")).append("<br/>");
                }
                if ((address = csvValues[i][14].getValueString()).length() <= 500) continue;
                listErrors.append(this.getErrorMessage(i + 1, 15, address));
                listErrors.append(this.getString("JDP.nbCarMax")).append(" 500 ").append(this.getString("JDP.caracteres")).append("<br/>");
                continue;
            }
            for (int j = 0; j < csvReader.getM_specificNbCols(); ++j) {
                if (!"STRING".equals(csvReader.getM_specificColType(j)) || (informationSpecifiqueString = csvValues[i][j + 6].getValueString()).length() <= csvReader.getM_specificColMaxLength(j)) continue;
                listErrors.append(this.getErrorMessage(i + 1, j + 6, informationSpecifiqueString));
                listErrors.append(this.getString("JDP.nbCarMax")).append(" ").append(csvReader.getM_specificColMaxLength(j)).append(" ").append(this.getString("JDP.caracteres")).append("<br/>");
            }
        }
        if (listErrors.length() > 0) {
            JobDomainPeasTrappedException jdpe = new JobDomainPeasTrappedException("JobDomainPeasSessionController.importCsvUsers", 4, "jobDomainPeas.EX_CSV_FILE", listErrors.toString());
            jdpe.setGoBackPage("displayUsersCsvImport");
            throw jdpe;
        }
        for (Variant[] csvValue : csvValues) {
            nom = csvValue[0].getValueString();
            prenom = csvValue[1].getValueString();
            login = csvValue[2].getValueString();
            email = csvValue[3].getValueString();
            droits = csvValue[4].getValueString();
            UserAccessLevel userAccessLevel = "Admin".equals(droits) ? UserAccessLevel.ADMINISTRATOR : ("AdminPdc".equals(droits) ? UserAccessLevel.PDC_MANAGER : ("AdminDomain".equals(droits) ? UserAccessLevel.DOMAIN_ADMINISTRATOR : ("User".equals(droits) ? UserAccessLevel.USER : ("Guest".equals(droits) ? UserAccessLevel.GUEST : UserAccessLevel.USER))));
            motDePasse = csvValue[5].getValueString();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (csvReader.getM_specificNbCols() > 0) {
                if ("-1".equals(this.getTargetDomain().getId()) || "0".equals(this.getTargetDomain().getId())) {
                    title = csvValue[6].getValueString();
                    properties.put(csvReader.getM_specificParameterName(0), title);
                    company = csvValue[7].getValueString();
                    properties.put(csvReader.getM_specificParameterName(1), company);
                    position = csvValue[8].getValueString();
                    properties.put(csvReader.getM_specificParameterName(2), position);
                    boss = csvValue[9].getValueString();
                    properties.put(csvReader.getM_specificParameterName(3), boss);
                    phone = csvValue[10].getValueString();
                    properties.put(csvReader.getM_specificParameterName(4), phone);
                    homePhone = csvValue[11].getValueString();
                    properties.put(csvReader.getM_specificParameterName(5), homePhone);
                    fax = csvValue[12].getValueString();
                    properties.put(csvReader.getM_specificParameterName(6), fax);
                    cellularPhone = csvValue[13].getValueString();
                    properties.put(csvReader.getM_specificParameterName(7), cellularPhone);
                    address = csvValue[14].getValueString();
                    properties.put(csvReader.getM_specificParameterName(8), address);
                } else {
                    for (int j = 0; j < csvReader.getM_specificNbCols(); ++j) {
                        if ("STRING".equals(csvReader.getM_specificColType(j))) {
                            informationSpecifiqueString = csvValue[j + 6].getValueString();
                            properties.put(csvReader.getM_specificParameterName(j), informationSpecifiqueString);
                            continue;
                        }
                        if (!"BOOLEAN".equals(csvReader.getM_specificColType(j))) continue;
                        boolean informationSpecifiqueBoolean = csvValue[j + 6].getValueBoolean();
                        if (informationSpecifiqueBoolean) {
                            properties.put(csvReader.getM_specificParameterName(j), "1");
                            continue;
                        }
                        properties.put(csvReader.getM_specificParameterName(j), "0");
                    }
                }
            }
            boolean passwordValid = StringUtil.isDefined((String)motDePasse);
            this.createUser(login, nom, prenom, email, userAccessLevel, passwordValid, motDePasse, properties, null, req, sendEmail);
        }
    }

    private String getErrorMessage(int line, int column, String value) {
        StringBuilder str = new StringBuilder();
        str.append(this.getString("JDP.ligne")).append(" = ").append(line).append(", ");
        str.append(this.getString("JDP.colonne")).append(" = ").append(column).append(", ");
        str.append(this.getString("JDP.valeur")).append(" = ").append(StringUtil.truncate((String)value, (int)100)).append(", ");
        return str.toString();
    }

    private String getLastGroupId(UserFull theUser) {
        if (!"-1".equals(this.getTargetDomain().getId()) && !"0".equals(this.getTargetDomain().getId()) && this.getTargetDomain().getDriverClassName().equals("com.stratelia.silverpeas.domains.sqldriver.SQLDriver")) {
            Group group;
            String nomPropertyRegroupement;
            ResourceLocator specificRs = new ResourceLocator(this.getTargetDomain().getPropFileName(), "");
            int numPropertyRegroup = specificRs.getInteger("property.Grouping", -1);
            String nomLastGroup = null;
            if (numPropertyRegroup > -1 && (nomPropertyRegroupement = specificRs.getString("property_" + numPropertyRegroup + ".Name", null)) != null) {
                String value = null;
                boolean trouve = false;
                for (String key : theUser.getPropertiesNames()) {
                    value = theUser.getValue(key);
                    if (!key.equals(nomPropertyRegroupement)) continue;
                    trouve = true;
                    break;
                }
                if (trouve) {
                    nomLastGroup = value;
                }
            }
            if (nomLastGroup != null && nomLastGroup.length() > 0 && (group = this.m_AdminCtrl.getGroupByNameInDomain(nomLastGroup, this.targetDomainId)) != null) {
                return group.getId();
            }
        }
        return null;
    }

    public void modifyUser(String idUser, String userLastName, String userFirstName, String userEMail, UserAccessLevel userAccessLevel, boolean userPasswordValid, String userPassword, HashMap<String, String> properties, HttpServletRequest req, boolean sendEmail) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.modifyUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("UserId=" + idUser + " userLastName=" + userLastName + " userFirstName=" + userFirstName + " userEMail=" + userEMail + " userAccessLevel=" + userAccessLevel));
        UserFull theModifiedUser = this.m_AdminCtrl.getUserFull(idUser);
        if (theModifiedUser == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyUser()", 4, "admin.EX_ERR_UNKNOWN_USER");
        }
        String lastGroupId = this.getLastGroupId(theModifiedUser);
        theModifiedUser.setLastName(userLastName);
        theModifiedUser.setFirstName(userFirstName);
        theModifiedUser.seteMail(userEMail);
        theModifiedUser.setAccessLevel(userAccessLevel);
        if (theModifiedUser.isPasswordAvailable()) {
            theModifiedUser.setPasswordValid(userPasswordValid);
            theModifiedUser.setPassword(userPassword);
        }
        this.notifyUserAccount(userPasswordValid, userPassword, (UserDetail)theModifiedUser, req, false, sendEmail);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            theModifiedUser.setValue(entry.getKey(), entry.getValue());
        }
        String idRet = this.m_AdminCtrl.updateUserFull(theModifiedUser);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyUser()", 4, "admin.EX_ERR_UPDATE_USER", "UserId=" + idUser);
        }
        this.refresh();
        this.setTargetUser(idRet);
        this.regroupInGroup(properties, lastGroupId);
    }

    public void modifySynchronizedUser(String idUser, UserAccessLevel userAccessLevel) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.modifySynchronizedUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("UserId=" + idUser));
        UserDetail theModifiedUser = this.m_AdminCtrl.getUserDetail(idUser);
        if (theModifiedUser == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifySynchronizedUser()", 4, "admin.EX_ERR_UNKNOWN_USER");
        }
        theModifiedUser.setAccessLevel(userAccessLevel);
        String idRet = this.m_AdminCtrl.updateSynchronizedUser(theModifiedUser);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifySynchronizedUser()", 4, "admin.EX_ERR_UPDATE_USER", "UserId=" + idUser);
        }
        this.refresh();
        this.setTargetUser(idRet);
    }

    public void modifyUserFull(String idUser, UserAccessLevel userAccessLevel, HashMap<String, String> properties) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.modifyUserFull()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("UserId=" + idUser + " userAccessLevel=" + userAccessLevel));
        UserFull theModifiedUser = this.m_AdminCtrl.getUserFull(idUser);
        if (theModifiedUser == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyUserFull()", 4, "admin.EX_ERR_UNKNOWN_USER");
        }
        theModifiedUser.setAccessLevel(userAccessLevel);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            theModifiedUser.setValue(entry.getKey(), entry.getValue());
        }
        String idRet = this.m_AdminCtrl.updateUserFull(theModifiedUser);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyUserFull()", 4, "admin.EX_ERR_UPDATE_USER", "UserId=" + idUser);
        }
        this.refresh();
        this.setTargetUser(idRet);
    }

    public void blockUser(String userId) throws JobDomainPeasException {
        this.m_AdminCtrl.blockUser(userId);
    }

    public void unblockUser(String userId) throws JobDomainPeasException {
        this.m_AdminCtrl.unblockUser(userId);
    }

    public void deleteUser(String idUser) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.deleteUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("UserId=" + idUser));
        UserDetail user = this.getUserDetail(idUser);
        boolean deleteUser = true;
        if (!UserAccessLevel.ADMINISTRATOR.equals((Object)this.getUserAccessLevel()) && !UserAccessLevel.DOMAIN_ADMINISTRATOR.equals((Object)this.getUserAccessLevel()) && this.isGroupManager()) {
            List<String> directGroupIds = Arrays.asList(this.getOrganisationController().getDirectGroupIdsOfUser(idUser));
            List<String> manageableGroupIds = this.getUserManageableGroupIds();
            ArrayList<String> groupIdLinksToRemove = new ArrayList<String>();
            for (String directGroupId1 : directGroupIds) {
                String directGroupId = directGroupId1;
                List groupPath = this.m_AdminCtrl.getPathToGroup(directGroupId);
                String rootGroupId = groupPath != null && groupPath.size() > 0 ? (String)groupPath.get(0) : directGroupId;
                if (!manageableGroupIds.contains(rootGroupId)) {
                    deleteUser = false;
                    continue;
                }
                groupIdLinksToRemove.add(directGroupId);
            }
            if (!deleteUser) {
                for (String groupIdLinkToRemove : groupIdLinksToRemove) {
                    this.m_AdminCtrl.removeUserFromGroup(idUser, groupIdLinkToRemove);
                }
                this.refresh();
            }
        }
        if (deleteUser) {
            String idRet = this.m_AdminCtrl.deleteUser(idUser);
            if (!StringUtil.isDefined((String)idRet)) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.deleteUser()", 4, "admin.EX_ERR_DELETE_USER", "UserId=" + idUser);
            }
            if (this.m_TargetUserId.equals(idUser)) {
                this.m_TargetUserId = null;
            }
            if ((this.getDomainActions() & 0x8000L) != 0L) {
                this.revocateCertificate(user);
            }
            this.refresh();
        }
    }

    public Iterator<DomainProperty> getPropertiesToImport() throws JobDomainPeasException {
        return this.m_AdminCtrl.getSpecificPropertiesToImportUsers(this.targetDomainId, this.getLanguage()).iterator();
    }

    public void importUser(String userLogin) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.importUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("userLogin=" + userLogin));
        String idRet = this.m_AdminCtrl.synchronizeImportUser(this.targetDomainId, userLogin);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.importUser()", 4, "admin.MSG_ERR_SYNCHRONIZE_USER", "userLogin=" + userLogin);
        }
        this.refresh();
        this.setTargetUser(idRet);
    }

    public void importUsers(String[] specificIds) throws JobDomainPeasException {
        for (int i = 0; specificIds != null && i < specificIds.length; ++i) {
            SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.importUsers()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("specificId=" + specificIds[i]));
            this.m_AdminCtrl.synchronizeImportUser(this.targetDomainId, specificIds[i]);
        }
        this.refresh();
    }

    public List<UserDetail> searchUsers(Hashtable<String, String> query) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.searchUsers()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("query=" + query.toString()));
        this.queryToImport = query;
        this.usersToImport = this.m_AdminCtrl.searchUsers(this.targetDomainId, query);
        return this.usersToImport;
    }

    public List<UserDetail> getUsersToImport() {
        return this.usersToImport;
    }

    public Hashtable<String, String> getQueryToImport() {
        return this.queryToImport;
    }

    public UserFull getUser(String specificId) {
        return this.m_AdminCtrl.getUserFull(this.targetDomainId, specificId);
    }

    public void synchroUser(String idUser) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("UserId=" + idUser));
        String idRet = this.m_AdminCtrl.synchronizeUser(idUser);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.synchroUser()", 4, "admin.MSG_ERR_SYNCHRONIZE_USER");
        }
        this.refresh();
        this.setTargetUser(idRet);
    }

    public void unsynchroUser(String idUser) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.unsynchroUser()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("UserId=" + idUser));
        String idRet = this.m_AdminCtrl.synchronizeRemoveUser(idUser);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.unsynchroUser()", 4, "admin.EX_ERR_DELETE_USER");
        }
        if (this.m_TargetUserId.equals(idUser)) {
            this.m_TargetUserId = null;
        }
        this.refresh();
    }

    public void returnIntoGroup(String groupId) throws JobDomainPeasException {
        if (!StringUtil.isDefined((String)groupId)) {
            this.m_GroupsPath.clear();
        } else {
            for (int i = this.m_GroupsPath.size() - 1; i >= 0 && !this.m_GroupsPath.get(i).isThisGroup(groupId); --i) {
                this.m_GroupsPath.removeElementAt(i);
            }
        }
        this.setTargetUser(null);
    }

    public void removeGroupFromPath(String groupId) throws JobDomainPeasException {
        if (StringUtil.isDefined((String)groupId)) {
            int i;
            for (i = 0; i < this.m_GroupsPath.size() && !this.m_GroupsPath.get(i).isThisGroup(groupId); ++i) {
            }
            if (i < this.m_GroupsPath.size()) {
                this.m_GroupsPath.setSize(i);
            }
        }
    }

    public void goIntoGroup(String groupId) throws JobDomainPeasException {
        if (StringUtil.isDefined((String)groupId)) {
            Group targetGroup;
            if ((this.getTargetGroup() == null || this.getTargetGroup() != null && !this.getTargetGroup().getId().equals(groupId)) && GroupNavigationStock.isGroupValid(targetGroup = this.m_AdminCtrl.getGroupById(groupId))) {
                List<String> manageableGroupIds = null;
                if (this.isOnlyGroupManager() && !this.isGroupManagerOnGroup(groupId)) {
                    manageableGroupIds = this.getUserManageableGroupIds();
                }
                GroupNavigationStock newSubGroup = new GroupNavigationStock(groupId, this.m_AdminCtrl, manageableGroupIds);
                this.m_GroupsPath.add(newSubGroup);
            }
        } else {
            throw new JobDomainPeasException("JobDomainPeasSessionController.setTargetGroup()", 4, "jobDomainPeas.EX_GROUP_NOT_AVAILABLE", "GroupId=" + groupId);
        }
        this.setTargetUser(null);
    }

    public Group getTargetGroup() throws JobDomainPeasException {
        if (this.m_GroupsPath.size() <= 0) {
            return null;
        }
        return this.m_GroupsPath.lastElement().getThisGroup();
    }

    public List<List> getGroupManagers() throws JobDomainPeasException {
        ArrayList<List> usersAndGroups = new ArrayList<List>();
        ArrayList<UserDetail> users = new ArrayList<UserDetail>();
        ArrayList<Group> groups = new ArrayList<Group>();
        GroupProfileInst profile = this.m_AdminCtrl.getGroupProfile(this.getTargetGroup().getId());
        if (profile != null) {
            for (String groupId : profile.getAllGroups()) {
                groups.add(this.m_AdminCtrl.getGroupById(groupId));
            }
            for (String userId : profile.getAllUsers()) {
                users.add(this.getUserDetail(userId));
            }
        }
        usersAndGroups.add(users);
        usersAndGroups.add(groups);
        return usersAndGroups;
    }

    public void initUserPanelForGroupManagers(String compoURL) throws SelectionException, JobDomainPeasException {
        this.sel.resetAll();
        this.sel.setHostSpaceName(this.getMultilang().getString("JDP.jobDomain"));
        this.sel.setHostComponentName(new PairObject((Object)this.getTargetGroup().getName(), null));
        ResourceLocator generalMessage = GeneralPropertiesManager.getGeneralMultilang((String)this.getLanguage());
        PairObject[] hostPath = new PairObject[]{new PairObject((Object)(this.getMultilang().getString("JDP.roleManager") + " > " + generalMessage.getString("GML.selection")), null)};
        this.sel.setHostPath(hostPath);
        this.sel.setGoBackURL(compoURL + "groupManagersUpdate");
        this.sel.setCancelURL(compoURL + "groupManagersCancel");
        GroupProfileInst profile = this.m_AdminCtrl.getGroupProfile(this.getTargetGroup().getId());
        ArrayList allUsers = profile.getAllUsers();
        ArrayList allGroups = profile.getAllGroups();
        this.sel.setSelectedElements(allUsers.toArray(new String[allUsers.size()]));
        this.sel.setSelectedSets(allGroups.toArray(new String[allGroups.size()]));
    }

    public void updateGroupProfile() throws JobDomainPeasException {
        GroupProfileInst profile = this.m_AdminCtrl.getGroupProfile(this.getTargetGroup().getId());
        profile.removeAllGroups();
        profile.removeAllUsers();
        this.setGroupsAndUsers(profile, this.sel.getSelectedSets(), this.sel.getSelectedElements());
        this.m_AdminCtrl.updateGroupProfile(profile);
    }

    public void deleteGroupProfile() throws JobDomainPeasException {
        this.m_AdminCtrl.deleteGroupProfile(this.getTargetGroup().getId());
    }

    private void setGroupsAndUsers(GroupProfileInst profile, String[] groupIds, String[] userIds) {
        int i;
        for (i = 0; groupIds != null && i < groupIds.length; ++i) {
            if (groupIds[i] == null || groupIds[i].length() <= 0) continue;
            profile.addGroup(groupIds[i]);
        }
        for (i = 0; userIds != null && i < userIds.length; ++i) {
            if (userIds[i] == null || userIds[i].length() <= 0) continue;
            profile.addUser(userIds[i]);
        }
    }

    public boolean isGroupRoot(String groupId) throws JobDomainPeasException {
        Group gr = this.m_AdminCtrl.getGroupById(groupId);
        return GroupNavigationStock.isGroupValid(gr) && this.refreshDomain && (!StringUtil.isDefined((String)gr.getSuperGroupId()) || "-1".equals(gr.getSuperGroupId()));
    }

    public Group[] getSubGroups(boolean isParentGroup) throws JobDomainPeasException {
        Group[] groups;
        if (isParentGroup) {
            if (this.m_GroupsPath.size() <= 0) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.getTargetGroup()", 4, "jobDomainPeas.EX_GROUP_NOT_AVAILABLE");
            }
            groups = this.m_GroupsPath.lastElement().getGroupPage();
        } else {
            groups = this.m_TargetDomain.getGroupPage();
        }
        if (this.isOnlyGroupManager() && !this.isGroupManagerOnCurrentGroup()) {
            groups = this.filterGroupsToGroupManager(groups);
        }
        for (Group group : groups) {
            if (group == null) continue;
            group.setNbUsers(this.getOrganisationController().getAllSubUsersNumber(group.getId()));
        }
        return groups;
    }

    public List<UserDetail> getSubUsers(boolean isParentGroup) throws JobDomainPeasException {
        UserDetail[] usDetails;
        if (isParentGroup) {
            if (this.m_GroupsPath.isEmpty()) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.getTargetGroup()", 4, "jobDomainPeas.EX_GROUP_NOT_AVAILABLE");
            }
            usDetails = this.m_GroupsPath.lastElement().getUserPage();
        } else {
            usDetails = this.m_TargetDomain.getUserPage();
        }
        return Arrays.asList(usDetails);
    }

    public String getPath(String baseURL, String toAppendAtEnd) throws JobDomainPeasException {
        StringBuilder strPath = new StringBuilder("");
        for (int i = 0; i < this.m_GroupsPath.size(); ++i) {
            Group theGroup = this.m_GroupsPath.get(i).getThisGroup();
            if (strPath.length() > 0) {
                strPath.append(" &gt ");
            }
            if (i + 1 < this.m_GroupsPath.size() || this.m_TargetUserId != null || toAppendAtEnd != null) {
                strPath.append("<a href=\"").append(baseURL).append("groupReturn?Idgroup=").append(theGroup.getId()).append("\">").append(EncodeHelper.javaStringToHtmlString((String)theGroup.getName())).append("</a>");
                continue;
            }
            strPath.append(EncodeHelper.javaStringToHtmlString((String)theGroup.getName()));
        }
        if (this.m_TargetUserId != null) {
            if (strPath.length() > 0) {
                strPath.append(" &gt ");
            }
            if (toAppendAtEnd != null) {
                strPath.append("<a href=\"").append(baseURL).append("userContent?Iduser=").append(this.m_TargetUserId).append("\">").append(EncodeHelper.javaStringToHtmlString((String)this.getTargetUserDetail().getDisplayedName())).append("</a>");
            } else {
                strPath.append(EncodeHelper.javaStringToHtmlString((String)this.getTargetUserDetail().getDisplayedName()));
            }
        }
        if (toAppendAtEnd != null) {
            if (strPath.length() > 0) {
                strPath.append(" &gt ");
            }
            strPath.append(EncodeHelper.javaStringToHtmlString((String)toAppendAtEnd));
        }
        return strPath.toString();
    }

    public boolean createGroup(String idParent, String groupName, String groupDescription, String groupRule) throws JobDomainPeasException {
        Group theNewGroup = new Group();
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.createGroup()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("ParentId=" + idParent + " Name=" + groupName + " Desc=" + groupDescription));
        theNewGroup.setId("-1");
        if (StringUtil.isDefined((String)this.targetDomainId) && !"-1".equals(this.targetDomainId)) {
            theNewGroup.setDomainId(this.targetDomainId);
        }
        theNewGroup.setSuperGroupId(idParent);
        theNewGroup.setName(groupName);
        theNewGroup.setDescription(groupDescription);
        theNewGroup.setRule(groupRule);
        String idRet = this.m_AdminCtrl.addGroup(theNewGroup);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.createGroup()", 4, "admin.EX_ERR_ADD_GROUP");
        }
        this.refresh();
        return this.isGroupRoot(idRet);
    }

    public boolean modifyGroup(String idGroup, String groupName, String groupDescription, String groupRule) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.modifyGroup()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("GroupId=" + idGroup + " Desc=" + groupDescription));
        Group theModifiedGroup = this.m_AdminCtrl.getGroupById(idGroup);
        if (theModifiedGroup == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyGroup()", 4, "admin.EX_ERR_UNKNOWN_GROUP");
        }
        theModifiedGroup.setName(groupName);
        theModifiedGroup.setDescription(groupDescription);
        theModifiedGroup.setRule(groupRule);
        String idRet = this.m_AdminCtrl.updateGroup(theModifiedGroup);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyGroup()", 4, "admin.EX_ERR_UPDATE_GROUP");
        }
        this.refresh();
        return this.isGroupRoot(idRet);
    }

    public boolean updateGroupSubUsers(String idGroup, String[] userIds) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.updateGroupSubUsers()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("GroupId=" + idGroup));
        Group theModifiedGroup = this.m_AdminCtrl.getGroupById(idGroup);
        if (theModifiedGroup == null) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.updateGroupSubUsers()", 4, "admin.EX_ERR_UNKNOWN_GROUP");
        }
        theModifiedGroup.setUserIds(userIds);
        String idRet = this.m_AdminCtrl.updateGroup(theModifiedGroup);
        if (idRet == null || idRet.length() <= 0) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.updateGroupSubUsers()", 4, "admin.EX_ERR_UPDATE_GROUP");
        }
        this.refresh();
        return false;
    }

    public boolean deleteGroup(String idGroup) throws JobDomainPeasException {
        boolean haveToRefreshDomain = this.isGroupRoot(idGroup);
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.deleteGroup()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("GroupId=" + idGroup));
        String idRet = this.m_AdminCtrl.deleteGroupById(idGroup);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.deleteGroup()", 4, "admin.EX_ERR_DELETE_GROUP");
        }
        this.removeGroupFromPath(idGroup);
        this.refresh();
        return haveToRefreshDomain;
    }

    public boolean synchroGroup(String idGroup) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroGroup()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("GroupId=" + idGroup));
        String idRet = this.m_AdminCtrl.synchronizeGroup(idGroup);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.synchroGroup()", 4, "admin.MSG_ERR_SYNCHRONIZE_GROUP");
        }
        this.refresh();
        return this.isGroupRoot(idRet);
    }

    public boolean unsynchroGroup(String idGroup) throws JobDomainPeasException {
        boolean haveToRefreshDomain = this.isGroupRoot(idGroup);
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.unsynchroGroup()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("GroupId=" + idGroup));
        String idRet = this.m_AdminCtrl.synchronizeRemoveGroup(idGroup);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.unsynchroGroup()", 4, "admin.EX_ERR_DELETE_GROUP");
        }
        this.removeGroupFromPath(idGroup);
        this.refresh();
        return haveToRefreshDomain;
    }

    public boolean importGroup(String groupName) throws JobDomainPeasException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.importGroup()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("groupName=" + groupName));
        String idRet = this.m_AdminCtrl.synchronizeImportGroup(this.targetDomainId, groupName);
        if (!StringUtil.isDefined((String)idRet)) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.importGroup()", 4, "admin.MSG_ERR_SYNCHRONIZE_GROUP");
        }
        this.refresh();
        return this.isGroupRoot(idRet);
    }

    public void setDefaultTargetDomain() {
        UserDetail ud = this.getUserDetail();
        if (ud.isDomainAdminRestricted()) {
            this.setTargetDomain(ud.getDomainId());
        }
    }

    public void setTargetDomain(String domainId) {
        if (!StringUtil.isDefined((String)domainId)) {
            this.m_TargetDomain = null;
            this.targetDomainId = "";
        } else {
            List<String> manageableGroupIds = null;
            if (this.isOnlyGroupManager()) {
                manageableGroupIds = this.getUserManageableGroupIds();
            }
            this.m_TargetDomain = new DomainNavigationStock(domainId, this.m_AdminCtrl, manageableGroupIds);
            this.targetDomainId = domainId;
        }
    }

    public Domain getTargetDomain() {
        if (this.m_TargetDomain == null) {
            return null;
        }
        return this.m_TargetDomain.getThisDomain();
    }

    public long getDomainActions() {
        if (this.targetDomainId.length() > 0) {
            return this.m_AdminCtrl.getDomainActions(this.targetDomainId);
        }
        return 0L;
    }

    public List<Domain> getAllDomains() {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        UserDetail ud = this.getUserDetail();
        if (ud.isAccessDomainManager()) {
            domains.add(this.m_AdminCtrl.getDomain(ud.getDomainId()));
        } else if (ud.isAccessAdmin()) {
            domains.add(this.m_AdminCtrl.getDomain("-1"));
            domains.addAll(Arrays.asList(this.m_AdminCtrl.getAllDomains()));
        } else if (this.isCommunityManager()) {
            domains.add(this.m_AdminCtrl.getDomain("-1"));
            domains.add(this.m_AdminCtrl.getDomain(ud.getDomainId()));
            domains.add(this.m_AdminCtrl.getDomain("0"));
        } else if (this.isOnlyGroupManager()) {
            domains.add(this.m_AdminCtrl.getDomain("-1"));
            domains.add(this.m_AdminCtrl.getDomain(ud.getDomainId()));
        }
        return domains;
    }

    public boolean isOnlyGroupManager() {
        return this.isGroupManager() && !this.getUserDetail().isAccessAdmin() && !this.getUserDetail().isAccessDomainManager();
    }

    public boolean isCommunityManager() {
        if (!JobDomainSettings.m_UseCommunityManagement) {
            return false;
        }
        List<Group> groups = this.getUserManageableGroups();
        List<String> spaceIds = Arrays.asList(this.getUserManageableSpaceIds());
        for (String spaceId : spaceIds) {
            SpaceInstLight space = this.getOrganisationController().getSpaceInstLightById(spaceId);
            for (Group group : groups) {
                if (!space.getName().equalsIgnoreCase(group.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGroupManagerOnCurrentGroup() throws JobDomainPeasException {
        return this.getTargetGroup() != null && this.isGroupManagerOnGroup(this.getTargetGroup().getId());
    }

    public boolean isGroupManagerOnGroup(String groupId) throws JobDomainPeasException {
        List<String> manageableGroupIds = this.getUserManageableGroupIds();
        if (manageableGroupIds.contains(groupId)) {
            return true;
        }
        List groupPath = this.m_AdminCtrl.getPathToGroup(groupId);
        groupPath.retainAll(manageableGroupIds);
        return groupPath.size() > 0;
    }

    public boolean isGroupManagerDirectlyOnCurrentGroup() throws JobDomainPeasException {
        List<String> manageableGroupIds = this.getUserManageableGroupIds();
        return manageableGroupIds.contains(this.getTargetGroup().getId());
    }

    public Group[] getAllRootGroups() {
        if (this.targetDomainId.length() <= 0) {
            return ArrayUtil.EMPTY_GROUP_ARRAY;
        }
        Group[] selGroupsArray = this.m_TargetDomain.getAllGroupPage();
        if (this.isOnlyGroupManager()) {
            selGroupsArray = this.filterGroupsToGroupManager(selGroupsArray);
        }
        JobDomainSettings.sortGroups(selGroupsArray);
        return selGroupsArray;
    }

    private Group[] filterGroupsToGroupManager(Group[] groups) {
        List<String> manageableGroupIds = this.getUserManageableGroupIds();
        ArrayList<Group> temp = new ArrayList<Group>();
        for (Group group : groups) {
            if (manageableGroupIds.contains(group.getId())) {
                temp.add(group);
                continue;
            }
            List<String> subGroupIds = Arrays.asList(this.m_AdminCtrl.getAllSubGroupIdsRecursively(group.getId()));
            Iterator<String> itManageableGroupsIds = manageableGroupIds.iterator();
            boolean find = false;
            while (!find && itManageableGroupsIds.hasNext()) {
                String manageableGroupId = itManageableGroupsIds.next();
                if (!subGroupIds.contains(manageableGroupId)) continue;
                find = true;
            }
            if (!find) continue;
            temp.add(group);
        }
        return temp.toArray(new Group[temp.size()]);
    }

    public String createDomain(String domainName, String domainDescription, String domainDriver, String domainProperties, String domainAuthentication, String silverpeasServerURL, String domainTimeStamp) throws JobDomainPeasException, JobDomainPeasTrappedException {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.createDomain()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("domainName=" + domainName));
        String newDomainId = null;
        try {
            Domain theNewDomain = new Domain();
            theNewDomain.setId("-1");
            theNewDomain.setName(domainName);
            theNewDomain.setDescription(domainDescription);
            theNewDomain.setDriverClassName(domainDriver);
            theNewDomain.setPropFileName(domainProperties);
            theNewDomain.setAuthenticationServer(domainAuthentication);
            theNewDomain.setSilverpeasServerURL(silverpeasServerURL);
            theNewDomain.setTheTimeStamp(domainTimeStamp);
            DomainServiceFactory.getDomainService((DomainType)DomainType.EXTERNAL).createDomain(theNewDomain);
            this.refresh();
        }
        catch (DomainCreationException e) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.createDomain()", 4, "admin.MSG_ERR_ADD_DOMAIN", (Exception)((Object)e));
        }
        catch (DomainConflictException e) {
            JobDomainPeasTrappedException trappedException = new JobDomainPeasTrappedException("JobDomainPeasSessionController.createDomain()", 4, "admin.MSG_ERR_DOMAIN_ALREADY_EXIST_DATABASE", (Exception)((Object)e));
            trappedException.setGoBackPage("displayDomainCreate");
            throw trappedException;
        }
        return newDomainId;
    }

    public String createSQLDomain(String domainName, String domainDescription, String silverpeasServerURL, String usersInDomainQuotaMaxCount) throws JobDomainPeasException, JobDomainPeasTrappedException {
        String domainId;
        Domain domainToCreate = new Domain();
        domainToCreate.setName(domainName);
        domainToCreate.setDescription(domainDescription);
        domainToCreate.setSilverpeasServerURL(silverpeasServerURL);
        try {
            if (JobDomainSettings.usersInDomainQuotaActivated) {
                domainToCreate.setUserDomainQuotaMaxCount(usersInDomainQuotaMaxCount);
            }
            domainId = DomainServiceFactory.getDomainService((DomainType)DomainType.SQL).createDomain(domainToCreate);
            domainToCreate.setId(domainId);
            if (JobDomainSettings.usersInDomainQuotaActivated) {
                DomainServiceFactory.getUserDomainQuotaService().initialize((QuotaKey)UserDomainQuotaKey.from((Domain)domainToCreate), domainToCreate.getUserDomainQuota().getMaxCount());
            }
        }
        catch (QuotaException qe) {
            JobDomainPeasTrappedException trappedException = new JobDomainPeasTrappedException("JobDomainPeasSessionController.createSQLDomain()", 4, "admin.MSG_ERR_ADD_DOMAIN", this.getString("JDP.userDomainQuotaMaxCountError"), (Exception)((Object)qe));
            trappedException.setGoBackPage("displayDomainSQLCreate");
            throw trappedException;
        }
        catch (DomainCreationException e) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.createSQLDomain()", 4, "admin.MSG_ERR_ADD_DOMAIN", (Exception)((Object)e));
        }
        catch (DomainConflictException e) {
            JobDomainPeasTrappedException trappedException = new JobDomainPeasTrappedException("JobDomainPeasSessionController.createSQLDomain()", 4, "admin.MSG_ERR_DOMAIN_ALREADY_EXIST", (Exception)((Object)e));
            trappedException.setGoBackPage("displayDomainSQLCreate");
            throw trappedException;
        }
        return domainId;
    }

    public String modifyDomain(String domainName, String domainDescription, String domainDriver, String domainProperties, String domainAuthentication, String silverpeasServerURL, String domainTimeStamp) throws JobDomainPeasException, JobDomainPeasTrappedException {
        Domain[] tabDomain;
        Domain theNewDomain = this.getTargetDomain();
        JobDomainPeasTrappedException trappedException = new JobDomainPeasTrappedException("JobDomainPeasSessionController", 3, "jobDomainPeas.WARN_DOMAIN_SQL_NAME");
        trappedException.setGoBackPage("domainContent");
        for (Domain aTabDomain : tabDomain = this.m_AdminCtrl.getAllDomains()) {
            Domain domain = aTabDomain;
            if (domain.getId().equals(theNewDomain.getId()) || !domain.getName().toLowerCase().equals(domainName.toLowerCase())) continue;
            throw trappedException;
        }
        if (!StringUtil.isDefined((String)this.targetDomainId) || this.targetDomainId.equals("-1")) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyDomain()", 4, "admin.EX_ERR_UPDATE_DOMAIN");
        }
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.modifyDomain()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("domainName=" + domainName));
        theNewDomain.setName(domainName);
        theNewDomain.setDescription(domainDescription);
        theNewDomain.setDriverClassName(domainDriver);
        theNewDomain.setPropFileName(domainProperties);
        theNewDomain.setAuthenticationServer(domainAuthentication);
        theNewDomain.setSilverpeasServerURL(silverpeasServerURL);
        theNewDomain.setTheTimeStamp(domainTimeStamp);
        String idRet = this.m_AdminCtrl.updateDomain(theNewDomain);
        if (idRet == null || idRet.length() <= 0) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifyDomain()", 4, "admin.EX_ERR_UPDATE_DOMAIN");
        }
        this.refresh();
        return idRet;
    }

    public String modifySQLDomain(String domainName, String domainDescription, String silverpeasServerURL, String usersInDomainQuotaMaxCount) throws JobDomainPeasException, JobDomainPeasTrappedException {
        String idRet;
        Domain[] tabDomain;
        Domain theNewDomain = this.getTargetDomain();
        JobDomainPeasTrappedException trappedException = new JobDomainPeasTrappedException("JobDomainPeasSessionController", 3, "jobDomainPeas.WARN_DOMAIN_SQL_NAME");
        trappedException.setGoBackPage("domainContent");
        for (Domain aTabDomain : tabDomain = this.m_AdminCtrl.getAllDomains()) {
            Domain domain = aTabDomain;
            if (domain.getId().equals(theNewDomain.getId()) || !domain.getName().toLowerCase().equals(domainName.toLowerCase())) continue;
            throw trappedException;
        }
        if (this.targetDomainId == null || this.targetDomainId.equals("-1") || this.targetDomainId.equals("0") || this.targetDomainId.length() <= 0) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.modifySQLDomain()", 4, "admin.EX_ERR_UPDATE_DOMAIN");
        }
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.modifySQLDomain()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("domainName=" + domainName));
        theNewDomain.setName(domainName);
        theNewDomain.setDescription(domainDescription);
        theNewDomain.setSilverpeasServerURL(silverpeasServerURL);
        try {
            if (JobDomainSettings.usersInDomainQuotaActivated) {
                theNewDomain.setUserDomainQuotaMaxCount(usersInDomainQuotaMaxCount);
            }
            if ((idRet = this.m_AdminCtrl.updateDomain(theNewDomain)) == null || idRet.length() <= 0) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.modifySQLDomain()", 4, "admin.EX_ERR_UPDATE_DOMAIN");
            }
            if (JobDomainSettings.usersInDomainQuotaActivated) {
                DomainServiceFactory.getUserDomainQuotaService().initialize((QuotaKey)UserDomainQuotaKey.from((Domain)theNewDomain), theNewDomain.getUserDomainQuota().getMaxCount());
            }
        }
        catch (QuotaException qe) {
            trappedException = new JobDomainPeasTrappedException("JobDomainPeasSessionController.modifySQLDomain()", 4, "admin.EX_ERR_UPDATE_DOMAIN", this.getString("JDP.userDomainQuotaMaxCountError"), (Exception)((Object)qe));
            trappedException.setGoBackPage("displayDomainSQLCreate");
            throw trappedException;
        }
        this.refresh();
        return idRet;
    }

    public void deleteDomain() throws JobDomainPeasException {
        try {
            DomainServiceFactory.getDomainService((DomainType)DomainType.EXTERNAL).deleteDomain(this.getTargetDomain());
        }
        catch (DomainDeletionException e) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.deleteDomain()", 4, "admin.MSG_ERR_DELETE_DOMAIN", (Exception)((Object)e));
        }
    }

    public void deleteSQLDomain() throws JobDomainPeasException {
        try {
            DomainServiceFactory.getDomainService((DomainType)DomainType.SQL).deleteDomain(this.getTargetDomain());
            DomainServiceFactory.getUserDomainQuotaService().remove((QuotaKey)UserDomainQuotaKey.from((Domain)this.getTargetDomain()));
        }
        catch (DomainDeletionException e) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.deleteSQLDomain()", 4, "admin.MSG_ERR_DELETE_DOMAIN", (Exception)((Object)e));
        }
    }

    protected String getSureString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public void refresh() {
        if (this.m_TargetDomain != null) {
            this.m_TargetDomain.refresh();
        }
        for (GroupNavigationStock aM_GroupsPath : this.m_GroupsPath) {
            aM_GroupsPath.refresh();
        }
        this.setTargetUser(null);
    }

    public String initSelectionPeasForGroups(String compoURL) throws JobDomainPeasException {
        String hostSpaceName = this.getString("JDP.userPanelGroup");
        PairObject hostComponentName = new PairObject((Object)this.getTargetGroup().getName(), (Object)(compoURL + "groupContent"));
        PairObject[] hostPath = new PairObject[]{};
        String hostUrl = compoURL + "groupAddRemoveUsers";
        String cancelUrl = compoURL + "groupContent";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName(hostSpaceName);
        sel.setHostPath(hostPath);
        sel.setHostComponentName(hostComponentName);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        if (StringUtil.isDefined((String)this.targetDomainId) && !"-1".equals(this.targetDomainId)) {
            SelectionUsersGroups sug = new SelectionUsersGroups();
            sug.setDomainId(this.targetDomainId);
            sel.setExtraParams((SelectionExtraParams)sug);
        }
        sel.setSelectedElements(SelectionUsersGroups.getUserIds((UserDetail[])this.m_GroupsPath.lastElement().getAllUserPage()));
        sel.setSetSelectable(false);
        sel.setPopupMode(false);
        sel.setFirstPage("DisplayCart");
        return Selection.getSelectionURL((String)"UsersGroups");
    }

    public String[] getSelectedUsersIds() {
        return this.getSelection().getSelectedElements();
    }

    public String initSelectionPeasForOneGroupOrUser(String compoURL) throws JobDomainPeasException {
        String hostSpaceName = this.getString("JDP.userPanelDomain");
        PairObject hostComponentName = new PairObject((Object)this.getTargetDomain().getName(), (Object)(compoURL + "domainContent"));
        PairObject[] hostPath = new PairObject[]{};
        String hostUrl = compoURL + "selectUserOrGroup";
        String cancelUrl = compoURL + "domainContent";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName(hostSpaceName);
        sel.setHostPath(hostPath);
        sel.setHostComponentName(hostComponentName);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        if (!StringUtil.isDefined((String)this.targetDomainId) || "-1".equals(this.targetDomainId)) {
            sel.setElementSelectable(false);
        }
        SelectionUsersGroups sug = new SelectionUsersGroups();
        sug.setDomainId(this.targetDomainId);
        sel.setExtraParams((SelectionExtraParams)sug);
        sel.setMultiSelect(false);
        sel.setPopupMode(false);
        sel.setFirstPage("DisplayBrowse");
        return Selection.getSelectionURL((String)"UsersGroups");
    }

    public String getSelectedUserId() {
        return this.getSelection().getFirstSelectedElement();
    }

    public String getSelectedGroupId() {
        return this.getSelection().getFirstSelectedSet();
    }

    public void synchroSQLDomain() {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroSQLDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("------------SYNCHRO SQL DOMAIN APPELE----------- domainId=" + this.targetDomainId));
        if (this.m_theThread == null) {
            SynchroReport.setTraceLevel((int)2);
            SynchroReport.setState((int)1);
            this.m_theThread = new SynchroWebServiceThread(this);
            this.m_ErrorOccured = null;
            this.m_SynchroReport = "";
            this.m_theThread.startTheThread();
            SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroSQLDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"------------THREAD SYNCHRO SQL DOMAIN LANCE-----------");
        } else {
            SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroSQLDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"------------!!!! SYNCHRO DOMAIN SQL : DEUXIEME APPEL !!!!!-----------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String synchronizeSilverpeasViaWebService() {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroSQLDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("------------SYNCHRO SQL DOMAIN APPELE----------- domainId=" + this.targetDomainId));
        StringBuilder sReport = new StringBuilder();
        SynchroUserWebServiceItf synchroUserWebService = null;
        try {
            Collection<UserDetail> listUserToDelete;
            Collection<UserFull> listUserToInsertUpdate;
            Collection<Group> listGroupToInsertUpdate;
            sReport.append("D\u00e9marrage de la synchronisation...\n\n");
            SynchroReport.startSynchro();
            Domain theDomain = this.getTargetDomain();
            SynchroReport.warn((String)"jobDomainPeas.synchronizeSilverpeasViaWebService", (String)("Domaine : " + theDomain.getName() + " (id : " + theDomain.getId() + ")"), null);
            try {
                listGroupToInsertUpdate = JobDomainPeasDAO.selectGroupSynchroInsertUpdateTableDomain_Group(theDomain);
            }
            catch (SQLException e1) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.synchroSQLDomain()", 4, "admin.MSG_ERR_SYNCHRONIZE_DOMAIN", e1);
            }
            String propDomainFileName = theDomain.getPropFileName();
            ResourceLocator propDomainSql = new ResourceLocator(propDomainFileName, "");
            String nomClasseWebService = propDomainSql.getString("ExternalSynchroClass");
            try {
                synchroUserWebService = (SynchroUserWebServiceItf)Class.forName(nomClasseWebService).newInstance();
            }
            catch (Exception e) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.synchroSQLDomain()", 4, "admin.MSG_ERR_SYNCHRONIZE_DOMAIN", e);
            }
            synchroUserWebService.startConnection();
            sReport.append(synchroUserWebService.insertUpdateDomainWebService(theDomain.getId(), theDomain.getName()));
            if (listGroupToInsertUpdate != null && listGroupToInsertUpdate.size() > 0) {
                sReport.append(synchroUserWebService.insertUpdateListGroupWebService(theDomain.getId(), theDomain.getName(), listGroupToInsertUpdate));
            }
            try {
                listUserToInsertUpdate = JobDomainPeasDAO.selectUserSynchroInsertUpdateTableDomain_User(theDomain);
            }
            catch (SQLException e1) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.synchroSQLDomain()", 4, "admin.MSG_ERR_SYNCHRONIZE_DOMAIN", e1);
            }
            try {
                listUserToDelete = JobDomainPeasDAO.selectUserSynchroDeleteTableDomain_User(theDomain);
            }
            catch (SQLException e1) {
                throw new JobDomainPeasException("JobDomainPeasSessionController.synchroSQLDomain()", 4, "admin.MSG_ERR_SYNCHRONIZE_DOMAIN", e1);
            }
            if (listUserToDelete != null && !listUserToDelete.isEmpty()) {
                sReport.append(synchroUserWebService.deleteListUserWebService(theDomain.getId(), listUserToDelete));
            }
            if (listUserToInsertUpdate != null && !listUserToInsertUpdate.isEmpty()) {
                sReport.append(synchroUserWebService.insertUpdateListUserWebService(theDomain.getId(), listUserToInsertUpdate, listGroupToInsertUpdate));
            }
            sReport.append("\n\nFin de la synchronisation...");
        }
        catch (JobDomainPeasException e) {
            SilverTrace.error((String)"JobDomainPeasSessionController", (String)"JobDomainPeasSessionController.synchronizeSilverpeasViaWebService", (String)"admin.MSG_ERR_SYNCHRONIZE_DOMAIN", (Throwable)((Object)e));
            SynchroReport.error((String)"JobDomainPeasSessionController.synchronizeSilverpeasViaWebService", (String)("Probl\u00e8me lors de la synchronisation : " + e.getMessage()), null);
            sReport.append("Erreurs lors de la synchronisation : \n").append(e.getMessage());
        }
        finally {
            SynchroReport.stopSynchro();
            if (synchroUserWebService != null) {
                synchroUserWebService.endConnection();
            }
        }
        return sReport.toString();
    }

    public void synchroDomain(int traceLevel) {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("------------SYNCHRO DOMAIN APPELE----------- domainId=" + this.targetDomainId));
        if (this.m_theThread == null) {
            SynchroReport.setTraceLevel((int)traceLevel);
            SynchroReport.setState((int)1);
            this.m_theThread = new SynchroLdapThread(this, this.m_AdminCtrl, this.targetDomainId);
            this.m_ErrorOccured = null;
            this.m_SynchroReport = "";
            this.m_theThread.startTheThread();
            SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"------------THREAD SYNCHRO DOMAIN LANCE-----------");
        } else {
            SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.synchroDomain()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"------------!!!! SYNCHRO DOMAIN : DEUXIEME APPEL !!!!!-----------");
        }
    }

    public boolean isEnCours() {
        return this.m_theThread != null && this.m_theThread.isEnCours();
    }

    public String getSynchroReport() {
        if (this.m_ErrorOccured != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.m_ErrorOccured.printStackTrace(pw);
            return this.m_ErrorOccured.toString() + "\n" + sw.getBuffer().toString();
        }
        return this.m_SynchroReport;
    }

    public void threadFinished() {
        this.m_ErrorOccured = this.m_theThread.getErrorOccured();
        this.m_SynchroReport = this.m_theThread.getSynchroReport();
        this.m_theThread = null;
    }

    public void getP12(String userId) throws JobDomainPeasException {
        UserDetail user = this.getUserDetail(userId);
        try {
            X509Factory.buildP12((String)user.getId(), (String)user.getLogin(), (String)user.getLastName(), (String)user.getFirstName(), (String)user.getDomainId());
        }
        catch (UtilException e) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.getP12()", 4, "admin.MSG_ERR_CANT_GET_P12", (Exception)((Object)e));
        }
    }

    private void revocateCertificate(UserDetail user) throws JobDomainPeasException {
        try {
            X509Factory.revocateUserCertificate((String)user.getId());
        }
        catch (UtilException e) {
            throw new JobDomainPeasException("JobDomainPeasSessionController.revocateCertificate()", 4, "admin.MSG_ERR_CANT_REVOCATE_CERTIFICATE", (Exception)((Object)e));
        }
    }

    public List<String> getListSelectedUsers() {
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.getListUsersSelected()", (String)"", (String)("listSelectedUsers (taille) = (" + this.listSelectedUsers.size() + ") " + this.listSelectedUsers.toString()));
        return this.listSelectedUsers;
    }

    public void clearListSelectedUsers() {
        this.listSelectedUsers.clear();
    }

    public void setListSelectedUsers(List<String> list) {
        this.listSelectedUsers = list;
        SilverTrace.info((String)"jobDomainPeas", (String)"JobDomainPeasSessionController.setListSelectedUsers()", (String)"", (String)("listSelectedUsers (taille) = (" + this.listSelectedUsers.size() + ") " + this.listSelectedUsers.toString()));
    }

    public void setIndexOfFirstItemToDisplay(String index) {
        this.indexOfFirstItemToDisplay = Integer.parseInt(index);
    }

    public int getIndexOfFirstItemToDisplay() {
        return this.indexOfFirstItemToDisplay;
    }

    public List<Group> getUserManageableGroups() {
        List<String> groupIds = this.getUserManageableGroupIds();
        Group[] aGroups = this.getOrganisationController().getGroups(groupIds.toArray(new String[groupIds.size()]));
        return Arrays.asList(aGroups);
    }

    public UserDetail checkUser(UserDetail userToCheck) {
        UserDetail[] existingUsers;
        for (UserDetail existingUser : existingUsers = this.m_TargetDomain.getAllUserPage()) {
            if (!userToCheck.getLastName().equalsIgnoreCase(existingUser.getLastName()) || !userToCheck.getFirstName().equalsIgnoreCase(existingUser.getFirstName()) || !userToCheck.geteMail().equalsIgnoreCase(existingUser.geteMail())) continue;
            return existingUser;
        }
        return null;
    }

    public boolean isUserInAtLeastOneGroupManageableByCurrentUser() {
        if (!JobDomainSettings.m_UseCommunityManagement) {
            return false;
        }
        List<String> groupIds = this.getUserManageableGroupIds();
        for (String groupId : groupIds) {
            UserDetail[] users = this.getOrganisationController().getAllUsersOfGroup(groupId);
            UserDetail user = this.getUser(this.m_TargetUserId, users);
            if (user == null) continue;
            return true;
        }
        return false;
    }

    private UserDetail getUser(String userId, UserDetail[] users) {
        for (UserDetail userDetail : users) {
            if (!userId.equals(userDetail.getId())) continue;
            return userDetail;
        }
        return null;
    }
}

