/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobManagerPeas.control;

import com.silverpeas.jobManagerPeas.JobManagerService;
import com.silverpeas.jobManagerPeas.JobManagerSettings;
import com.stratelia.silverpeas.pdc.control.PdcBmImpl;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JobManagerPeasSessionController
extends AbstractComponentSessionController {
    private Map<String, JobManagerService> services = null;
    private String idCurrentServiceActif = null;
    private String idCurrentOperationActif = null;
    private boolean isManager = false;

    public JobManagerPeasSessionController(MainSessionController mainSessionCtrl, ComponentContext componentContext) {
        super(mainSessionCtrl, componentContext, "org.silverpeas.jobManagerPeas.multilang.jobManagerPeasBundle", "org.silverpeas.jobManagerPeas.settings.jobManagerPeasIcons", "org.silverpeas.jobManagerPeas.settings.jobManagerPeasSettings");
        this.setComponentRootName("jobManagerPeas");
        String[] ids = mainSessionCtrl.getUserManageableSpaceIds();
        if (ids != null && ids.length > 0) {
            this.isManager = true;
        }
        if (this.services == null) {
            this.initServices();
        }
    }

    private void initServices() {
        String[] id1;
        String[] id12;
        JobManagerService jKM;
        this.services = new HashMap<String, JobManagerService>(100);
        String webContext = URLManager.getApplicationURL();
        JobManagerService jdp = new JobManagerService("11", "JDP", 1, webContext + URLManager.getURL((String)"jobDomainPeas", null, null) + "Main", null, false);
        JobManagerService jspp = new JobManagerService("12", "JSPP", 1, webContext + URLManager.getURL((String)"jobStartPagePeas", null, null) + "Main", null, false);
        JobManagerService jrp = new JobManagerService("13", "JRP", 1, webContext + URLManager.getURL((String)"jobOrganizationPeas", null, null) + "Main", null, false);
        JobManagerService jsp = new JobManagerService("14", "JSP", 1, webContext + URLManager.getURL((String)"jobSearchPeas", null, null) + "Main", null, false);
        JobManagerService jImportExport = new JobManagerService("42", "JIE", 1, webContext + URLManager.getURL((String)"importExportPeas", null, null) + "Main", null, false);
        JobManagerService jSpecificAuthent = new JobManagerService("43", "JSA", 1, webContext + URLManager.getURL((String)"specificAuthent", null, null) + "Main", null, false);
        JobManagerService jtd = new JobManagerService("44", "JTD", 1, webContext + URLManager.getURL((String)"templateDesigner", null, null) + "Main", null, false);
        JobManagerService jWorkflowDesigner = new JobManagerService("45", "JWD", 1, webContext + URLManager.getURL((String)"workflowDesigner", null, null) + "Main", null, false);
        JobManagerService portletDeployer = new JobManagerService("46", "portlets", 1, webContext + "/portletDeployer", null, false);
        JobManagerService jst = new JobManagerService("47", "JST", 1, webContext + "/admin/jsp/ExploitationSilverTrace.jsp", null, false);
        JobManagerService jindex = new JobManagerService("48", "reindexation", 1, webContext + "/applicationIndexer/jsp/applicationIndexer.jsp", null, false);
        JobManagerService jcipher = new JobManagerService("49", "JCIPHER", 1, webContext + "/admin/jsp/cipherkey.jsp", null, false);
        JobManagerService jabout = new JobManagerService("50", "JAB", 1, webContext + "/silverpeasinfos.jsp", null, false);
        JobManagerService jKM1 = new JobManagerService("21", "JKM1", 1, webContext + URLManager.getURL((String)"pdc", null, null) + "Main", null, false);
        JobManagerService jKM2 = new JobManagerService("22", "JKM2", 1, webContext + URLManager.getURL((String)"thesaurus", null, null) + "Main", null, false);
        JobManagerService jSTAT1 = new JobManagerService("31", "JSTAT1", 1, webContext + URLManager.getURL((String)"silverStatisticsPeas", null, null) + "Main", null, false);
        JobManagerService jSTAT2 = new JobManagerService("32", "JSTAT2", 1, webContext + URLManager.getURL((String)"silverStatisticsPeas", null, null) + "ViewAccess", null, false);
        JobManagerService jSTAT3 = new JobManagerService("33", "JSTAT3", 1, webContext + URLManager.getURL((String)"silverStatisticsPeas", null, null) + "ViewVolumeServices", null, false);
        JobManagerService jSTAT4 = new JobManagerService("34", "JSTAT4", 1, webContext + URLManager.getURL((String)"silverStatisticsPeas", null, null) + "ViewPDCAccess", null, false);
        boolean kmServiceAllowed = false;
        int nbServices = 0;
        if (this.getUserDetail().isAccessAdmin()) {
            String[] jDesignerFunctions = new String[]{jdp.getId(), jrp.getId(), jspp.getId(), jsp.getId()};
            JobManagerService jDesigner = new JobManagerService("1", "JD", 0, null, jDesignerFunctions, false);
            String[] jSTATFunctions = new String[]{jSTAT1.getId(), jSTAT2.getId(), jSTAT3.getId(), jSTAT4.getId()};
            JobManagerService jSTAT = new JobManagerService("3", "JSTAT", 0, null, jSTATFunctions, false);
            if (JobManagerSettings.m_IsKMVisible) {
                String[] jKMFunctions = new String[]{jKM1.getId(), jKM2.getId()};
                jKM = new JobManagerService("2", "JKM", 0, null, jKMFunctions, false);
                this.services.put(jKM.getId(), jKM);
                this.services.put(jKM1.getId(), jKM1);
                this.services.put(jKM2.getId(), jKM2);
                kmServiceAllowed = true;
            }
            if (JobManagerSettings.m_IsToolsVisible && (this.isImportExportLicenseOK() || JobManagerSettings.m_IsToolSpecificAuthentVisible || JobManagerSettings.m_IsToolWorkflowDesignerVisible)) {
                ArrayList<String> ids = new ArrayList<String>(10);
                if (this.isImportExportLicenseOK()) {
                    ids.add(jImportExport.getId());
                    this.services.put(jImportExport.getId(), jImportExport);
                }
                if (JobManagerSettings.m_IsToolSpecificAuthentVisible) {
                    ids.add(jSpecificAuthent.getId());
                    this.services.put(jSpecificAuthent.getId(), jSpecificAuthent);
                }
                if (JobManagerSettings.m_IsTemplateDesignerVisible) {
                    ids.add(jtd.getId());
                    this.services.put(jtd.getId(), jtd);
                }
                if (JobManagerSettings.m_IsToolWorkflowDesignerVisible) {
                    ids.add(jWorkflowDesigner.getId());
                    this.services.put(jWorkflowDesigner.getId(), jWorkflowDesigner);
                }
                if (JobManagerSettings.m_IsPortletDeployerVisible) {
                    ids.add(portletDeployer.getId());
                    this.services.put(portletDeployer.getId(), portletDeployer);
                }
                ids.add(jst.getId());
                this.services.put(jst.getId(), jst);
                ids.add(jindex.getId());
                this.services.put(jindex.getId(), jindex);
                ids.add(jcipher.getId());
                this.services.put(jcipher.getId(), jcipher);
                ids.add(jabout.getId());
                this.services.put(jabout.getId(), jabout);
                JobManagerService jTools = new JobManagerService("4", "JTOOLS", 0, null, ids.toArray(new String[ids.size()]), false);
                this.services.put(jTools.getId(), jTools);
            }
            this.services.put(jDesigner.getId(), jDesigner);
            this.services.put(jdp.getId(), jdp);
            this.services.put(jrp.getId(), jrp);
            this.services.put(jspp.getId(), jspp);
            this.services.put(jsp.getId(), jsp);
            this.services.put(jSTAT.getId(), jSTAT);
            this.services.put(jSTAT1.getId(), jSTAT1);
            this.services.put(jSTAT2.getId(), jSTAT2);
            this.services.put(jSTAT3.getId(), jSTAT3);
            this.services.put(jSTAT4.getId(), jSTAT4);
        } else if (this.isManager) {
            String[] functionIds;
            if (this.getUserDetail().isAccessDomainManager()) {
                functionIds = new String[]{jdp.getId(), jrp.getId(), jspp.getId()};
                JobManagerService jDesigner = new JobManagerService("1", "JD", 0, null, functionIds, false);
                this.services.put(jDesigner.getId(), jDesigner);
                ++nbServices;
                this.services.put(jdp.getId(), jdp);
                this.services.put(jrp.getId(), jrp);
                this.services.put(jspp.getId(), jspp);
            } else if (this.getUserManageableGroupIds().size() > 0) {
                functionIds = new String[]{jdp.getId(), jrp.getId(), jspp.getId()};
                JobManagerService jDesigner = new JobManagerService("1", "JD", 0, null, functionIds, false);
                this.services.put(jDesigner.getId(), jDesigner);
                ++nbServices;
                this.services.put(jdp.getId(), jdp);
                this.services.put(jrp.getId(), jrp);
                this.services.put(jspp.getId(), jspp);
            } else {
                functionIds = new String[]{jrp.getId(), jspp.getId()};
                JobManagerService jDesigner = new JobManagerService("1", "JD", 0, null, functionIds, false);
                this.services.put(jDesigner.getId(), jDesigner);
                ++nbServices;
                this.services.put(jrp.getId(), jrp);
                this.services.put(jspp.getId(), jspp);
            }
            String[] id2 = new String[]{jSTAT2.getId(), jSTAT3.getId()};
            JobManagerService jSTAT = new JobManagerService("3", "JSTAT", 0, null, id2, false);
            if (this.getUserDetail().isAccessPdcManager() && JobManagerSettings.m_IsKMVisible) {
                id12 = new String[]{jKM1.getId(), jKM2.getId()};
                jKM = new JobManagerService("2", "JKM", 0, null, id12, false);
                this.services.put(jKM.getId(), jKM);
                this.services.put(jKM1.getId(), jKM1);
                this.services.put(jKM2.getId(), jKM2);
                kmServiceAllowed = true;
            }
            this.services.put(jSTAT.getId(), jSTAT);
            this.services.put(jSTAT2.getId(), jSTAT2);
            this.services.put(jSTAT3.getId(), jSTAT3);
        } else if (this.getUserDetail().isAccessPdcManager() && JobManagerSettings.m_IsKMVisible) {
            id1 = new String[]{jKM1.getId(), jKM2.getId()};
            jKM = new JobManagerService("1", "JKM", 0, null, id1, false);
            this.services.put(jKM.getId(), jKM);
            this.services.put(jKM1.getId(), jKM1);
            this.services.put(jKM2.getId(), jKM2);
            kmServiceAllowed = true;
        } else if (this.getUserDetail().isAccessDomainManager() || !this.getUserManageableGroupIds().isEmpty()) {
            id1 = new String[]{jdp.getId()};
            JobManagerService jDesigner = new JobManagerService("1", "JD", 0, null, id1, false);
            this.services.put(jDesigner.getId(), jDesigner);
            ++nbServices;
            this.services.put(jdp.getId(), jdp);
        }
        boolean isPDCManager = false;
        try {
            isPDCManager = new PdcBmImpl().isUserManager(this.getUserId());
        }
        catch (PdcException e) {
            SilverTrace.error((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.initServices()", (String)"root.MSG_GEN_PARAM_VALUE", (Throwable)e);
        }
        if (!kmServiceAllowed && isPDCManager) {
            id12 = new String[]{jKM1.getId()};
            jKM = new JobManagerService(Integer.toString(nbServices + 1), "JKM", 0, null, id12, false);
            this.services.put(jKM.getId(), jKM);
            this.services.put(jKM1.getId(), jKM1);
        }
    }

    public JobManagerService[] getServices(int level) {
        SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.getServices()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("ENTER level=" + level));
        ArrayList<JobManagerService> listServices = new ArrayList<JobManagerService>(this.services.size());
        for (JobManagerService jms : this.services.values()) {
            if (jms.getLevel() != level) continue;
            SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.getServices()", (String)"root.MSG_GEN_PARAM_VALUE", (String)(" jms id=" + jms.getId() + "  jms label=" + jms.getLabel()));
            listServices.add(jms);
        }
        return listServices.toArray(new JobManagerService[listServices.size()]);
    }

    public JobManagerService[] getSubServices(JobManagerService jmsParent) {
        SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.getSubServices(JobManagerService jmsParent)", (String)"root.MSG_GEN_PARAM_VALUE", (String)("ENTER jmsParent id=" + jmsParent.getId() + " jmsParent label=" + jmsParent.getLabel()));
        String[] idSubServices = jmsParent.getIdSubServices();
        ArrayList<JobManagerService> listChild = new ArrayList<JobManagerService>(idSubServices.length);
        for (String idSubService : idSubServices) {
            JobManagerService jmsChild = this.services.get(idSubService);
            if (jmsChild == null) continue;
            SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.getSubServices(JobManagerService jmsParent)", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Add services child jmsChild id=" + jmsChild.getId() + " jmsChild label=" + jmsChild.getLabel()));
            listChild.add(jmsChild);
        }
        return listChild.toArray(new JobManagerService[listChild.size()]);
    }

    public JobManagerService[] getSubServices(String idService) {
        return this.getSubServices(this.services.get(idService));
    }

    public JobManagerService getService(String key) {
        return this.services.get(key);
    }

    public void changeServiceActif(String idNewService) {
        SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.changeServiceActif(String idNewService)", (String)"root.MSG_GEN_PARAM_VALUE", (String)("ENTER idCurrentServiceActif=" + this.idCurrentServiceActif + " idNewService=" + idNewService));
        if (this.idCurrentServiceActif != null) {
            this.services.get(this.idCurrentServiceActif).setActif(false);
        }
        JobManagerService newService = this.services.get(idNewService);
        newService.setActif(true);
        this.idCurrentServiceActif = idNewService;
        JobManagerService[] jms = this.getSubServices(newService);
        this.idCurrentOperationActif = null;
        for (JobManagerService jm : jms) {
            if (!jm.isActif()) continue;
            this.idCurrentOperationActif = jm.getId();
        }
        if (this.idCurrentOperationActif == null) {
            JobManagerService currentOperation = this.services.get(newService.getDefautIdSubService());
            currentOperation.setActif(true);
            this.idCurrentOperationActif = newService.getDefautIdSubService();
        }
        SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.changeServiceActif(String idNewService)", (String)"root.MSG_GEN_PARAM_VALUE", (String)("END idCurrentServiceActif=" + this.idCurrentServiceActif + " idNewService=" + idNewService));
    }

    public String getIdServiceActif() {
        return this.idCurrentServiceActif;
    }

    public String getIdOperationActif() {
        return this.idCurrentOperationActif;
    }

    public void changeOperationActif(String idNewOperation) {
        this.services.get(this.idCurrentOperationActif).setActif(false);
        SilverTrace.debug((String)"jobManagerPeas", (String)"jobManagerPeasSessionController.changeOperationActif(String idNewOperation)", (String)"root.MSG_GEN_PARAM_VALUE", (String)("END idNewOperation=" + idNewOperation));
        this.services.get(idNewOperation).setActif(true);
        this.idCurrentOperationActif = idNewOperation;
    }

    public String getIdDefaultService() {
        return "1";
    }

    private boolean isImportExportLicenseOK() {
        ResourceLocator resource = new ResourceLocator("license.license", "");
        String code = resource.getString("import");
        boolean validSequence = true;
        String serial = "373957568";
        try {
            for (int i = 0; i < 9 && validSequence; ++i) {
                String groupe = code.substring(i * 3, i * 3 + 3);
                int total = 0;
                for (int j = 0; j < groupe.length(); ++j) {
                    String valeur = groupe.substring(j, j + 1);
                    total += Integer.parseInt(valeur);
                }
                if (total == Integer.parseInt(serial.substring(i, i + 1))) continue;
                validSequence = false;
            }
        }
        catch (NumberFormatException e) {
            validSequence = false;
        }
        return validSequence;
    }
}

