/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobOrganizationPeas.control;

import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.PairObject;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserFull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JobOrganizationPeasSessionController
extends AbstractComponentSessionController {
    private String currentUserId = null;
    private String currentGroupId = null;
    private AdminController myAdminController = null;
    private UserFull currentUser = null;
    private Group currentGroup = null;
    private String[][] currentGroups = null;
    private String[] currentSpaces = null;
    private List<String[]> currentProfiles = null;
    private Map<String, WAComponent> componentOfficialNames = this.getAdminController().getAllComponents();

    public JobOrganizationPeasSessionController(MainSessionController mainSessionCtrl, ComponentContext componentContext) {
        super(mainSessionCtrl, componentContext, "com.silverpeas.jobOrganizationPeas.multilang.jobOrganizationPeasBundle", "com.silverpeas.jobOrganizationPeas.settings.jobOrganizationPeasIcons");
        this.setComponentRootName("jobOrganizationPeas");
    }

    private void resetCurrentArrays() {
        this.currentGroups = null;
        this.currentUser = null;
        this.currentGroup = null;
        this.currentSpaces = null;
        this.currentProfiles = null;
    }

    public AdminController getAdminController() {
        if (this.myAdminController == null) {
            this.myAdminController = new AdminController(this.getUserId());
        }
        return this.myAdminController;
    }

    public void setCurrentUserId(String userId) {
        if (this.currentUserId != null && !this.currentUserId.equals(userId)) {
            this.resetCurrentUser();
        }
        this.currentUserId = userId;
        if (this.currentUserId != null) {
            this.resetCurrentGroup();
        }
    }

    private void resetCurrentUser() {
        this.currentUserId = null;
        this.resetCurrentArrays();
    }

    public void setCurrentGroupId(String groupId) {
        if (this.currentGroupId != null && !this.currentGroupId.equals(groupId)) {
            this.resetCurrentGroup();
        }
        this.currentGroupId = groupId;
        if (this.currentGroupId != null) {
            this.resetCurrentUser();
        }
    }

    public void resetCurrentGroup() {
        this.currentGroupId = null;
        this.resetCurrentArrays();
    }

    public String getCurrentUserId() {
        return this.currentUserId;
    }

    public String getCurrentGroupId() {
        return this.currentGroupId;
    }

    public String[][] getCurrentUserGroups() {
        if (this.currentGroups == null) {
            if (this.getCurrentUserId() == null) {
                return null;
            }
            String[] groupIds = this.getAdminController().getDirectGroupsIdsOfUser(this.getCurrentUserId());
            if (groupIds == null || groupIds.length == 0) {
                return null;
            }
            this.currentGroups = new String[groupIds.length][4];
            for (int iGrp = 0; iGrp < groupIds.length; ++iGrp) {
                Group theCurrentGroup = this.getOrganisationController().getGroup(groupIds[iGrp]);
                this.currentGroups[iGrp][0] = theCurrentGroup.getId();
                this.currentGroups[iGrp][1] = theCurrentGroup.getName();
                this.currentGroups[iGrp][2] = String.valueOf(theCurrentGroup.getUserIds().length);
                this.currentGroups[iGrp][3] = theCurrentGroup.getDescription();
            }
        }
        if (this.currentGroups == null) {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getCurrentUserInfo", (String)"root.MSG_GEN_PARAM_VALUE", (String)"Groups NULL !");
        } else {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getCurrentUserInfo", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Groups=" + Arrays.deepToString((Object[])this.currentGroups)));
        }
        return this.currentGroups;
    }

    public UserFull getCurrentUser() {
        if (this.currentUser == null) {
            if (this.getCurrentUserId() == null) {
                return null;
            }
            this.currentUser = this.getAdminController().getUserFull(this.getCurrentUserId());
        }
        if (this.currentUser == null) {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getCurrentUser", (String)"root.MSG_GEN_PARAM_VALUE", (String)"User NULL !");
        } else {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getCurrentUser", (String)"root.MSG_GEN_PARAM_VALUE", (String)("User=" + this.getCurrentUserId()));
        }
        return this.currentUser;
    }

    public Group getCurrentGroup() {
        if (this.currentGroup == null) {
            if (this.getCurrentGroupId() == null) {
                return null;
            }
            this.currentGroup = this.getAdminController().getGroupById(this.getCurrentGroupId());
        }
        if (this.currentGroup == null) {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getCurrentGroup", (String)"root.MSG_GEN_PARAM_VALUE", (String)"Group NULL !");
        } else {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getCurrentGroup", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Group=" + this.getCurrentGroupId()));
        }
        return this.currentGroup;
    }

    public String[] getCurrentSpaces() {
        if (this.currentSpaces == null) {
            String[] spaceIds = null;
            if (this.getCurrentGroupId() != null) {
                spaceIds = this.getAdminController().getGroupManageableSpaceIds(this.getCurrentGroupId());
            }
            if (this.getCurrentUserId() != null) {
                spaceIds = this.getAdminController().getUserManageableSpaceIds(this.getCurrentUserId());
            }
            if (spaceIds == null) {
                return null;
            }
            String[] spaceIdsBIS = new String[spaceIds.length];
            for (int j = 0; j < spaceIds.length; ++j) {
                spaceIdsBIS[j] = spaceIds[j] != null && spaceIds[j].startsWith("WA") ? spaceIds[j] : "WA" + spaceIds[j];
            }
            this.currentSpaces = this.getAdminController().getSpaceNames(spaceIdsBIS);
        }
        return this.currentSpaces;
    }

    public List<String[]> getCurrentProfiles() {
        if (this.currentProfiles == null) {
            ArrayList<String> distinctProfiles = new ArrayList<String>();
            String[] profileIds = null;
            if (this.getCurrentGroupId() != null) {
                profileIds = this.getAdminController().getProfileIdsOfGroup(this.getCurrentGroupId());
            }
            if (this.getCurrentUserId() != null) {
                profileIds = this.getAdminController().getProfileIds(this.getCurrentUserId());
            }
            if (profileIds == null) {
                return null;
            }
            this.currentProfiles = new ArrayList<String[]>();
            ArrayList<String> spaceIds = new ArrayList<String>();
            for (String profileId : profileIds) {
                String dProfile;
                ProfileInst currentProfile = this.getAdminController().getProfileInst(profileId);
                ComponentInst currentComponent = this.getAdminController().getComponentInst(currentProfile.getComponentFatherId());
                String spaceId = currentComponent.getDomainFatherId();
                SpaceInstLight spaceInst = this.getAdminController().getSpaceInstLight(spaceId);
                if (currentComponent.getStatus() != null || spaceInst.isPersonalSpace() || distinctProfiles.contains(dProfile = currentComponent.getId() + currentProfile.getName())) continue;
                String[] profile2Display = new String[6];
                profile2Display[1] = currentComponent.getId();
                profile2Display[2] = currentComponent.getName();
                profile2Display[3] = currentComponent.getLabel();
                profile2Display[4] = this.getComponentOfficialName(currentComponent.getName());
                profile2Display[5] = currentProfile.getLabel();
                if (!StringUtil.isDefined((String)profile2Display[5])) {
                    profile2Display[5] = this.getAdminController().getProfileLabelfromName(currentComponent.getName(), currentProfile.getName(), this.getLanguage());
                }
                this.currentProfiles.add(profile2Display);
                spaceIds.add(spaceId);
                distinctProfiles.add(dProfile);
            }
            String[] spaceNames = this.getAdminController().getSpaceNames(spaceIds.toArray(new String[spaceIds.size()]));
            for (int iProfile = 0; iProfile < this.currentProfiles.size(); ++iProfile) {
                String[] profile2Display = this.currentProfiles.get(iProfile);
                profile2Display[0] = spaceNames[iProfile];
            }
        }
        return this.currentProfiles;
    }

    private String getComponentOfficialName(String internalName) {
        try {
            WAComponent component = this.componentOfficialNames.get(internalName);
            if (component != null) {
                return (String)component.getLabel().get(this.getLanguage());
            }
            return internalName;
        }
        catch (Exception e) {
            SilverTrace.info((String)"jobOrganizationPeas", (String)"JobOrganizationPeasSessionController.getComponentOfficialName", (String)"root.MSG_GEN_PARAM_VALUE", (String)("!!!!! ERROR getting official name=" + internalName), (Throwable)e);
            return internalName;
        }
    }

    public String initSelectionPeas() {
        String m_context = URLManager.getApplicationURL();
        String hostSpaceName = this.getString("JOP.pseudoSpace");
        String cancelUrl = m_context + Selection.getSelectionURL((String)"UsersGroups");
        PairObject hostComponentName = new PairObject((Object)this.getString("JOP.pseudoPeas"), (Object)cancelUrl);
        String hostUrl = m_context + this.getComponentUrl() + "ViewUserOrGroup";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName(hostSpaceName);
        sel.setHostComponentName(hostComponentName);
        sel.setHostPath(null);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        sel.setMultiSelect(false);
        sel.setPopupMode(false);
        sel.setFirstPage("DisplayBrowse");
        return Selection.getSelectionURL((String)"UsersGroups");
    }

    public void retourSelectionPeas() {
        Selection sel = this.getSelection();
        String id = sel.getFirstSelectedElement();
        this.setCurrentUserId(id);
        id = sel.getFirstSelectedSet();
        this.setCurrentGroupId(id);
    }
}

