/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobSearchPeas.control;

import com.silverpeas.jobSearchPeas.SearchResult;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.pdcPeas.model.QueryParameters;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import com.stratelia.webactiv.util.publication.model.PublicationRuntimeException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.silverpeas.search.SearchEngineFactory;
import org.silverpeas.search.searchEngine.model.MatchingIndexEntry;
import org.silverpeas.search.searchEngine.model.ParseException;
import org.silverpeas.search.searchEngine.model.QueryDescription;

public class JobSearchPeasSessionController
extends AbstractComponentSessionController {
    private AdminController myAdminController = null;
    private PublicationBm publicationBm = null;
    private NodeBm nodeBm = null;
    private String searchField = null;
    private String category = null;
    private List<SearchResult> listResult = null;

    public JobSearchPeasSessionController(MainSessionController mainSessionCtrl, ComponentContext componentContext) {
        super(mainSessionCtrl, componentContext, "com.silverpeas.jobSearchPeas.multilang.jobSearchPeasBundle");
        this.setComponentRootName("jobSearchPeas");
    }

    public AdminController getAdminController() {
        if (null == this.myAdminController) {
            this.myAdminController = new AdminController(this.getUserId());
        }
        return this.myAdminController;
    }

    private PublicationBm getPublicationBm() {
        if (null == this.publicationBm) {
            try {
                this.publicationBm = (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
            }
            catch (Exception e) {
                throw new PublicationRuntimeException("JobSearchPeasSessionController.getPublicationBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.publicationBm;
    }

    private NodeBm getNodeBm() {
        if (null == this.nodeBm) {
            try {
                this.nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
            }
            catch (Exception e) {
                throw new PublicationRuntimeException("JobSearchPeasSessionController.getNodeBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.nodeBm;
    }

    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<SearchResult> getListResult() {
        return this.listResult;
    }

    public void setListResult(List<SearchResult> listResult) {
        this.listResult = listResult;
    }

    private String getPathSpace(String spaceId) {
        StringBuilder emplacement = new StringBuilder("");
        try {
            List spaceList = this.getAdminController().getPathToSpace(spaceId, false);
            boolean first = true;
            for (SpaceInstLight space : spaceList) {
                if (!first) {
                    emplacement.append(" > ");
                }
                emplacement.append(space.getName(this.getLanguage()));
                first = false;
            }
        }
        catch (Exception e) {
            SilverTrace.warn((String)"admin", (String)"JobSearchPeasSessionController.getPathSpace()", (String)"admin.CANT_GET_SPACE_PATH", (String)("spaceId = " + spaceId), (Throwable)e);
        }
        return emplacement.toString();
    }

    private List<SearchResult> searchResultSpaceId(String spaceId) {
        SilverTrace.info((String)"admin", (String)"JobSearchPeasSessionController.searchResultSpaceId", (String)"root.MSG_GEN_ENTER_METHOD", (String)("spaceId = " + spaceId));
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        SpaceInstLight spaceInstLight = this.getAdminController().getSpaceInstLight(spaceId);
        if (null != spaceInstLight) {
            String url;
            String nom = spaceInstLight.getName(this.getLanguage());
            String desc = spaceInstLight.getDescription();
            Date dateCrea = spaceInstLight.getCreateDate();
            String nomCrea = this.getUserName(spaceInstLight.getCreatedBy());
            ArrayList<String> listEmplacement = new ArrayList<String>();
            String emplacement = this.getPathSpace(spaceId);
            listEmplacement.add(emplacement);
            if (spaceInstLight.isRoot()) {
                url = "openSpace('" + spaceInstLight.getFullId() + "')";
            } else {
                SpaceInstLight rootSpaceInstLight = spaceInstLight;
                while (!rootSpaceInstLight.isRoot()) {
                    String fatherId = rootSpaceInstLight.getFatherId();
                    rootSpaceInstLight = this.getAdminController().getSpaceInstLight(fatherId);
                }
                url = "openSubSpace('" + rootSpaceInstLight.getFullId() + "', '" + spaceInstLight.getFullId() + "')";
            }
            SearchResult searchResult = new SearchResult();
            searchResult.setName(nom);
            searchResult.setDesc(desc);
            searchResult.setCreaDate(dateCrea);
            searchResult.setCreaName(nomCrea);
            searchResult.setPath(listEmplacement);
            searchResult.setUrl(url);
            result.add(searchResult);
        }
        return result;
    }

    private List<SearchResult> searchEngineResultSpace(String searchField) throws PdcException {
        ArrayList<SearchResult> listSearchResult = new ArrayList<SearchResult>();
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.setKeywords(searchField);
            QueryDescription query = queryParameters.getQueryDescription(this.getUserId(), "*");
            query.addSpaceComponentPair(null, "Spaces");
            List plainSearchResults = SearchEngineFactory.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry result : plainSearchResults) {
                String nomCrea = this.getUserName(Integer.parseInt(result.getCreationUser()));
                String objectId = result.getObjectId();
                String spaceId = objectId.substring(2);
                SpaceInstLight spaceInstLight = this.getAdminController().getSpaceInstLight(spaceId);
                if (null == spaceInstLight) continue;
                ArrayList<String> listEmplacement = new ArrayList<String>();
                String emplacement = this.getPathSpace(spaceId);
                listEmplacement.add(emplacement);
                SearchResult searchResult = new SearchResult();
                searchResult.setName(result.getTitle(this.getLanguage()));
                searchResult.setDesc(result.getPreview(this.getLanguage()));
                searchResult.setCreaDate(DateUtil.parse((String)result.getCreationDate(), (String)"yyyy/MM/dd"));
                searchResult.setCreaName(nomCrea);
                searchResult.setPath(listEmplacement);
                if (spaceInstLight.isRoot()) {
                    searchResult.setUrl("openSpace('" + spaceInstLight.getFullId() + "')");
                } else {
                    SpaceInstLight rootSpaceInstLight = spaceInstLight;
                    while (null != rootSpaceInstLight && !rootSpaceInstLight.isRoot()) {
                        String fatherId = rootSpaceInstLight.getFatherId();
                        rootSpaceInstLight = this.getAdminController().getSpaceInstLight(fatherId);
                    }
                    searchResult.setUrl("openSubSpace('" + rootSpaceInstLight.getFullId() + "', '" + spaceInstLight.getFullId() + "')");
                }
                listSearchResult.add(searchResult);
            }
        }
        catch (ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultSpace", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)((Object)e));
        }
        catch (java.text.ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultSpace", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)e);
        }
        return listSearchResult;
    }

    private List<SearchResult> searchResultSpace(String searchField) throws PdcException {
        List<SearchResult> result = this.searchResultSpaceId(searchField);
        List<SearchResult> listSearchResult = this.searchEngineResultSpace(searchField);
        for (SearchResult searchResult : listSearchResult) {
            result.add(searchResult);
        }
        return result;
    }

    private String getPathComponent(String componentId) {
        StringBuilder emplacement = new StringBuilder("");
        List spaceList = this.getAdminController().getPathToComponent(componentId);
        boolean first = true;
        for (SpaceInstLight space : spaceList) {
            if (!first) {
                emplacement.append(" > ");
            }
            emplacement.append(space.getName(this.getLanguage()));
            first = false;
        }
        return emplacement.toString();
    }

    private List<SearchResult> searchResultComponentId(String componentId) {
        SilverTrace.info((String)"admin", (String)"JobSearchPeasSessionController.searchResultComponentId", (String)"root.MSG_GEN_ENTER_METHOD", (String)("componentId = " + componentId));
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        ComponentInstLight componentInstLight = this.getAdminController().getComponentInstLight(componentId);
        if (null != componentInstLight) {
            String nom = componentInstLight.getLabel(this.getLanguage());
            String desc = componentInstLight.getDescription(this.getLanguage());
            Date dateCrea = componentInstLight.getCreateDate();
            String nomCrea = this.getUserName(componentInstLight.getCreatedBy());
            ArrayList<String> listEmplacement = new ArrayList<String>();
            String emplacement = this.getPathComponent(componentId);
            listEmplacement.add(emplacement);
            String url = "openComponent('" + componentInstLight.getId() + "')";
            SearchResult searchResult = new SearchResult();
            searchResult.setName(nom);
            searchResult.setDesc(desc);
            searchResult.setCreaDate(dateCrea);
            searchResult.setCreaName(nomCrea);
            searchResult.setPath(listEmplacement);
            searchResult.setUrl(url);
            result.add(searchResult);
        }
        return result;
    }

    private String getUserName(int userId) {
        UserDetail user;
        if (userId != -1 && (user = this.getAdminController().getUserDetail(Integer.toString(userId))) != null) {
            return user.getDisplayedName();
        }
        return "";
    }

    private List<SearchResult> searchEngineResultComponent(String searchField) throws PdcException {
        ArrayList<SearchResult> listSearchResult = new ArrayList<SearchResult>();
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.setKeywords(searchField);
            QueryDescription query = queryParameters.getQueryDescription(this.getUserId(), "*");
            query.addSpaceComponentPair(null, "Components");
            List plainSearchResults = SearchEngineFactory.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry result : plainSearchResults) {
                String creationDate = result.getCreationDate();
                String nomCrea = this.getUserName(Integer.parseInt(result.getCreationUser()));
                String componentId = result.getObjectId();
                ArrayList<String> listEmplacement = new ArrayList<String>();
                String emplacement = this.getPathComponent(componentId);
                listEmplacement.add(emplacement);
                SearchResult searchResult = new SearchResult();
                searchResult.setName(result.getTitle(this.getLanguage()));
                searchResult.setDesc(result.getPreview(this.getLanguage()));
                searchResult.setCreaDate(DateUtil.parse((String)creationDate, (String)"yyyy/MM/dd"));
                searchResult.setCreaName(nomCrea);
                searchResult.setPath(listEmplacement);
                searchResult.setUrl("openComponent('" + componentId + "')");
                listSearchResult.add(searchResult);
            }
        }
        catch (ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultComponent", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)((Object)e));
        }
        catch (java.text.ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultComponent", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)e);
        }
        return listSearchResult;
    }

    private List<SearchResult> searchResultService(String searchField) throws PdcException {
        List<SearchResult> result = this.searchResultComponentId(searchField);
        List<SearchResult> listSearchResult = this.searchEngineResultComponent(searchField);
        for (SearchResult searchResult : listSearchResult) {
            result.add(searchResult);
        }
        return result;
    }

    private List<SearchResult> searchResultPublication(String searchField) {
        PublicationDetail publication;
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        try {
            Integer.parseInt(searchField);
            PublicationPK pubPK = new PublicationPK(searchField);
            publication = this.getPublicationBm().getDetail(pubPK);
        }
        catch (NumberFormatException e) {
            publication = null;
        }
        if (null != publication) {
            Collection fatherPKs;
            String nom = publication.getName(this.getLanguage());
            String desc = publication.getDescription(this.getLanguage());
            Date dateCrea = publication.getCreationDate();
            String creaId = publication.getCreatorId();
            String nomCrea = this.getUserName(Integer.parseInt(creaId));
            PublicationPK pubPK = publication.getPK();
            String instanceId = pubPK.getInstanceId();
            ArrayList<String> listEmplacement = new ArrayList<String>();
            StringBuilder emplacementEspaceComposant = new StringBuilder("");
            List spaceList = this.getAdminController().getPathToComponent(instanceId);
            for (SpaceInstLight space : spaceList) {
                emplacementEspaceComposant.append(space.getName(this.getLanguage())).append(" > ");
            }
            ComponentInstLight component = this.getAdminController().getComponentInstLight(instanceId);
            if (null != component) {
                emplacementEspaceComposant.append(component.getLabel(this.getLanguage())).append(" > ");
            }
            if (null != (fatherPKs = this.getPublicationBm().getAllFatherPK(pubPK))) {
                for (NodePK pk : fatherPKs) {
                    StringBuilder emplacement = new StringBuilder(emplacementEspaceComposant);
                    Collection path = this.getNodeBm().getAnotherPath(pk);
                    ArrayList pathTab = new ArrayList(path);
                    Collections.reverse(pathTab);
                    for (NodeDetail nodeDetail : pathTab) {
                        emplacement.append(nodeDetail.getName(this.getLanguage())).append(" > ");
                    }
                    listEmplacement.add(emplacement.toString().substring(0, emplacement.length() - 3));
                }
            }
            SearchResult searchResult = new SearchResult();
            searchResult.setName(nom);
            searchResult.setDesc(desc);
            searchResult.setCreaDate(dateCrea);
            searchResult.setCreaName(nomCrea);
            searchResult.setPath(listEmplacement);
            searchResult.setUrl("openPublication('" + URLManager.getSimpleURL((int)2, (String)pubPK.getId()) + "')");
            result.add(searchResult);
        }
        return result;
    }

    private String getPathGroup(Group group) {
        StringBuilder emplacement = new StringBuilder("");
        String groupId = group.getId();
        String domainId = group.getDomainId();
        if (null == domainId) {
            domainId = "-1";
        }
        Domain domain = this.getAdminController().getDomain(domainId);
        if ("-1".equals(domainId)) {
            emplacement.append(this.getString("JSP.domainMixt"));
        } else {
            emplacement.append(domain.getName());
        }
        List groupList = this.getAdminController().getPathToGroup(groupId);
        for (String elementGroupId : groupList) {
            emplacement.append(" > ").append(this.getAdminController().getGroupName(elementGroupId));
        }
        return emplacement.toString();
    }

    private List<SearchResult> searchResultGroupId(String searchField) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        Group group = this.getAdminController().getGroupById(searchField);
        if (null != group && null != group.getId()) {
            String nom = group.getName();
            String desc = group.getDescription();
            ArrayList<String> listEmplacement = new ArrayList<String>();
            String emplacement = this.getPathGroup(group);
            listEmplacement.add(emplacement);
            String url = "openGroup('" + group.getId() + "')";
            SearchResult searchResult = new SearchResult();
            searchResult.setName(nom);
            searchResult.setDesc(desc);
            searchResult.setCreaName("");
            searchResult.setPath(listEmplacement);
            searchResult.setUrl(url);
            result.add(searchResult);
        }
        return result;
    }

    private List<SearchResult> searchEngineResultGroup(String searchField) throws PdcException {
        ArrayList<SearchResult> listSearchResult = new ArrayList<SearchResult>();
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.setKeywords(searchField);
            QueryDescription query = queryParameters.getQueryDescription(this.getUserId(), "*");
            query.addSpaceComponentPair(null, "groups");
            List plainSearchResults = SearchEngineFactory.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry result : plainSearchResults) {
                String groupId = result.getObjectId();
                Group group = this.getAdminController().getGroupById(groupId);
                ArrayList<String> listEmplacement = new ArrayList<String>();
                String emplacement = this.getPathGroup(group);
                listEmplacement.add(emplacement);
                String url = "openGroup('" + groupId + "')";
                SearchResult searchResult = new SearchResult();
                searchResult.setName(result.getTitle(this.getLanguage()));
                searchResult.setDesc(result.getPreview(this.getLanguage()));
                searchResult.setCreaDate(null);
                searchResult.setCreaName("");
                searchResult.setPath(listEmplacement);
                searchResult.setUrl(url);
                listSearchResult.add(searchResult);
            }
        }
        catch (java.text.ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultComponent", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)e);
        }
        catch (ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultComponent", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)((Object)e));
        }
        return listSearchResult;
    }

    private List<SearchResult> searchResultGroup(String searchField) throws PdcException {
        List<SearchResult> result = this.searchResultGroupId(searchField);
        List<SearchResult> listSearchResult = this.searchEngineResultGroup(searchField);
        for (SearchResult searchResult : listSearchResult) {
            result.add(searchResult);
        }
        return result;
    }

    private List<String> getListPathUser(UserDetail user) {
        ArrayList<String> listEmplacement = new ArrayList<String>();
        String userId = user.getId();
        String[] groupIds = this.getAdminController().getDirectGroupsIdsOfUser(userId);
        if (null != groupIds && 0 < groupIds.length) {
            for (String groupId : groupIds) {
                Group group = this.getOrganisationController().getGroup(groupId);
                String domainId = group.getDomainId();
                if (null == domainId) {
                    domainId = "-1";
                }
                Domain domain = this.getAdminController().getDomain(domainId);
                StringBuilder emplacement = new StringBuilder("");
                if ("-1".equals(domainId)) {
                    emplacement.append(this.getString("JSP.domainMixt"));
                } else {
                    emplacement.append(domain.getName());
                }
                List groupList = this.getAdminController().getPathToGroup(groupId);
                for (String elementGroupId : groupList) {
                    emplacement.append(" > ").append(this.getAdminController().getGroupName(elementGroupId));
                }
                emplacement.append(" > ").append(group.getName());
                listEmplacement.add(emplacement.toString());
            }
        } else {
            StringBuilder emplacement = new StringBuilder("");
            String domainId = user.getDomainId();
            if (null == domainId) {
                domainId = "-1";
            }
            Domain domain = this.getAdminController().getDomain(domainId);
            if ("-1".equals(domainId)) {
                emplacement.append(this.getString("JSP.domainMixt"));
            } else {
                emplacement.append(domain.getName());
            }
            listEmplacement.add(emplacement.toString());
        }
        return listEmplacement;
    }

    private List<SearchResult> searchResultUserId(String searchField) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        UserDetail user = this.getAdminController().getUserDetail(searchField);
        if (null != user) {
            String nom = user.getDisplayedName();
            String desc = user.geteMail();
            List<String> listEmplacement = this.getListPathUser(user);
            String url = "openUser('" + user.getId() + "')";
            SearchResult searchResult = new SearchResult();
            searchResult.setName(nom);
            searchResult.setDesc(desc);
            searchResult.setCreaName("");
            searchResult.setPath(listEmplacement);
            searchResult.setUrl(url);
            result.add(searchResult);
        }
        return result;
    }

    private List<SearchResult> searchEngineResultUser(String searchField) throws PdcException {
        ArrayList<SearchResult> listSearchResult = new ArrayList<SearchResult>();
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.setKeywords(searchField);
            QueryDescription query = queryParameters.getQueryDescription(this.getUserId(), "*");
            query.addSpaceComponentPair(null, "users");
            List plainSearchResults = SearchEngineFactory.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry result : plainSearchResults) {
                String userId = result.getObjectId();
                UserDetail user = this.getAdminController().getUserDetail(userId);
                List<String> listEmplacement = this.getListPathUser(user);
                String url = "openUser('" + userId + "')";
                SearchResult searchResult = new SearchResult();
                searchResult.setName(result.getTitle(this.getLanguage()));
                searchResult.setDesc(result.getPreview(this.getLanguage()));
                searchResult.setCreaName("");
                searchResult.setPath(listEmplacement);
                searchResult.setUrl(url);
                listSearchResult.add(searchResult);
            }
        }
        catch (java.text.ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultUser", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)e);
        }
        catch (ParseException e) {
            throw new PdcException("JobSearchPeasSessionController.searchEngineResultUser", 4, "pdcPeas.EX_CANT_GET_SEARCH_ENGINE", (Exception)((Object)e));
        }
        return listSearchResult;
    }

    private List<SearchResult> searchResultUser(String searchField) throws PdcException {
        List<SearchResult> result = this.searchResultUserId(searchField);
        List<SearchResult> listSearchResult = this.searchEngineResultUser(searchField);
        for (SearchResult searchResult : listSearchResult) {
            result.add(searchResult);
        }
        return result;
    }

    public List<SearchResult> searchResult(String searchField, String category) throws RemoteException, PdcException {
        if ("space".equals(category)) {
            return this.searchResultSpace(searchField);
        }
        if ("service".equals(category)) {
            return this.searchResultService(searchField);
        }
        if ("publication".equals(category)) {
            return this.searchResultPublication(searchField);
        }
        if ("group".equals(category)) {
            return this.searchResultGroup(searchField);
        }
        if ("user".equals(category)) {
            return this.searchResultUser(searchField);
        }
        return null;
    }
}

