/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobStartPagePeas;

import com.silverpeas.jobStartPagePeas.DisplaySorted;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.owasp.encoder.Encode;

public class NavBarManager {
    static final int SPACE = 0;
    static final int COMPONENT = 1;
    static final int COMPONENTPOPUP = 7;
    static final int SPACE_COLLAPSE = 2;
    static final int SPACE_EXPANDED = 3;
    static final int SPACE_COMPONENT = 4;
    static final int SUBSPACE_COMPONENT = 5;
    static final int SUBSPACE_LAST_COMPONENT = 6;
    static final String POPUP_PARAM_NAME = "popupDisplay";
    UserDetail m_user = null;
    AdminController m_administrationCtrl = null;
    AbstractComponentSessionController m_SessionCtrl = null;
    String m_sContext;
    HashSet<String> m_ManageableSpaces = new HashSet();
    DisplaySorted[] m_Spaces = null;
    String m_CurrentSpaceId = null;
    DisplaySorted[] m_SpaceComponents = null;
    String m_CurrentSubSpaceId = null;
    DisplaySorted[] m_SubSpaces = null;
    DisplaySorted[] m_SubSpaceComponents = null;
    long m_elmtCounter = 0L;

    public void resetSpaceCache(String theSpaceId) {
        SilverTrace.info((String)"jobStartPagePeas", (String)"NavBarManager.resetSpaceCache()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Reset Cache Space=" + theSpaceId));
        String spaceId = this.getShortSpaceId(theSpaceId);
        DisplaySorted elmt = this.getSpaceCache(spaceId);
        if (elmt != null) {
            elmt.copy(this.buildSpaceObject(spaceId));
            if (spaceId.equals(this.m_CurrentSpaceId)) {
                this.setCurrentSpace(this.m_CurrentSpaceId);
            } else if (spaceId.equals(this.m_CurrentSubSpaceId)) {
                this.setCurrentSubSpace(null);
                this.setCurrentSubSpace(spaceId);
            }
        }
    }

    public void addSpaceInCache(String theSpaceId) {
        String spaceId = this.getShortSpaceId(theSpaceId);
        this.m_ManageableSpaces.add(spaceId);
        DisplaySorted newElmt = this.buildSpaceObject(spaceId);
        if (newElmt != null) {
            if (newElmt.type == 2) {
                DisplaySorted[] oldSpaces = this.m_Spaces;
                this.m_Spaces = new DisplaySorted[oldSpaces.length + 1];
                System.arraycopy(oldSpaces, 0, this.m_Spaces, 0, oldSpaces.length);
                this.m_Spaces[oldSpaces.length] = newElmt;
                Arrays.sort(this.m_Spaces);
            } else {
                this.setCurrentSpace(this.m_CurrentSpaceId);
            }
        }
    }

    public void removeSpaceInCache(String theSpaceId) {
        String spaceId = this.getShortSpaceId(theSpaceId);
        DisplaySorted elmt = this.getSpaceCache(spaceId);
        if (elmt != null) {
            if (elmt.type == 2) {
                DisplaySorted[] oldSpaces = this.m_Spaces;
                int j = 0;
                this.m_Spaces = new DisplaySorted[oldSpaces.length - 1];
                for (DisplaySorted oldSpace : oldSpaces) {
                    if (oldSpace.id.equals(spaceId) || j >= this.m_Spaces.length) continue;
                    this.m_Spaces[j++] = oldSpace;
                }
                if (this.m_CurrentSpaceId != null && this.m_CurrentSpaceId.equals(spaceId)) {
                    this.setCurrentSpace(null);
                }
            } else {
                DisplaySorted[] oldSpaces = this.m_SubSpaces;
                int j = 0;
                this.m_SubSpaces = new DisplaySorted[oldSpaces.length - 1];
                for (DisplaySorted oldSpace : oldSpaces) {
                    if (oldSpace.id.equals(spaceId) || j >= this.m_SubSpaces.length) continue;
                    this.m_SubSpaces[j++] = oldSpace;
                }
                if (this.m_CurrentSubSpaceId != null && this.m_CurrentSubSpaceId.equals(spaceId)) {
                    this.setCurrentSubSpace(null);
                }
            }
        }
    }

    public void resetAllCache() {
        String currentSpaceId = this.m_CurrentSpaceId;
        String currentSubSpaceId = this.m_CurrentSubSpaceId;
        SilverTrace.info((String)"jobStartPagePeas", (String)"NavBarManager.resetAllCache()", (String)"root.MSG_GEN_PARAM_VALUE");
        this.initWithUser(this.m_SessionCtrl, this.m_user);
        if (currentSpaceId != null) {
            this.setCurrentSpace(currentSpaceId);
        }
        if (currentSubSpaceId != null) {
            this.setCurrentSubSpace(currentSubSpaceId);
        }
    }

    public void initWithUser(AbstractComponentSessionController msc, UserDetail user) {
        String sUserId = user.getId();
        SilverTrace.info((String)"jobStartPagePeas", (String)"NavBarManager.initWithUser()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("User=" + sUserId));
        this.m_sContext = URLManager.getApplicationURL();
        this.m_administrationCtrl = new AdminController(sUserId);
        this.m_SessionCtrl = msc;
        this.m_user = user;
        this.m_elmtCounter = 0L;
        this.m_CurrentSpaceId = null;
        this.m_CurrentSubSpaceId = null;
        this.m_SubSpaces = new DisplaySorted[0];
        this.m_SpaceComponents = new DisplaySorted[0];
        this.m_SubSpaceComponents = new DisplaySorted[0];
        if (!this.m_user.isAccessAdmin()) {
            String[] allManageableSpaceIds = this.m_administrationCtrl.getUserManageableSpaceIds(sUserId);
            this.m_ManageableSpaces.clear();
            for (String manageableSpaceId : allManageableSpaceIds) {
                this.m_ManageableSpaces.add(this.getShortSpaceId(manageableSpaceId));
            }
        }
        String[] spaceIds = this.m_administrationCtrl.getAllRootSpaceIds();
        this.m_Spaces = this.createSpaceObjects(spaceIds, false);
    }

    public DisplaySorted[] getAvailableSpaces() {
        return this.m_Spaces;
    }

    public String getCurrentSpaceId() {
        return this.m_CurrentSpaceId;
    }

    public DisplaySorted getSpace(String theSpaceId) {
        return this.getSpaceCache(this.getShortSpaceId(theSpaceId));
    }

    public boolean setCurrentSpace(String theSpaceId) {
        String spaceId;
        this.m_CurrentSpaceId = spaceId = this.getShortSpaceId(theSpaceId);
        this.m_CurrentSubSpaceId = null;
        this.m_SubSpaceComponents = new DisplaySorted[0];
        if (StringUtil.isDefined((String)this.m_CurrentSpaceId) && this.getSpaceCache(this.m_CurrentSpaceId) == null) {
            this.m_CurrentSpaceId = null;
        }
        if (!StringUtil.isDefined((String)spaceId) || this.m_CurrentSpaceId == null) {
            this.m_SpaceComponents = new DisplaySorted[0];
            this.m_SubSpaces = new DisplaySorted[0];
        } else {
            SpaceInst spaceInst = this.m_administrationCtrl.getSpaceInstById("WA" + spaceId);
            if (spaceInst == null) {
                this.m_SpaceComponents = new DisplaySorted[0];
                this.m_SubSpaces = new DisplaySorted[0];
                this.m_CurrentSpaceId = null;
            } else {
                this.m_SpaceComponents = this.createComponentObjects(spaceInst, false);
                this.m_SubSpaces = this.createSpaceObjects(spaceInst.getSubSpaceIds(), true);
            }
        }
        for (DisplaySorted ds : this.m_Spaces) {
            this.buildSpaceHTMLLine(ds);
        }
        SilverTrace.info((String)"jobStartPagePeas", (String)"NavBarManager.setCurrentSpace()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Set Current Space=" + this.m_CurrentSpaceId));
        return StringUtil.isDefined((String)this.m_CurrentSpaceId);
    }

    public DisplaySorted[] getAvailableSpaceComponents() {
        if (this.m_CurrentSpaceId == null) {
            return new DisplaySorted[0];
        }
        return this.m_SpaceComponents;
    }

    public DisplaySorted[] getAvailableSubSpaces() {
        if (this.m_CurrentSpaceId == null) {
            return new DisplaySorted[0];
        }
        return this.m_SubSpaces;
    }

    public String getCurrentSubSpaceId() {
        return this.m_CurrentSubSpaceId;
    }

    public boolean setCurrentSubSpace(String theSpaceId) {
        String subSpaceId = this.getShortSpaceId(theSpaceId);
        SpaceInst sp = null;
        this.m_CurrentSubSpaceId = subSpaceId;
        if (StringUtil.isDefined((String)this.m_CurrentSubSpaceId) && this.getSpaceCache(this.m_CurrentSubSpaceId) == null) {
            this.m_CurrentSubSpaceId = null;
        }
        if (StringUtil.isDefined((String)this.m_CurrentSubSpaceId) && (sp = this.m_administrationCtrl.getSpaceInstById("WA" + this.m_CurrentSubSpaceId)) == null) {
            this.m_CurrentSubSpaceId = null;
        }
        for (DisplaySorted m_SubSpace : this.m_SubSpaces) {
            this.buildSpaceHTMLLine(m_SubSpace);
        }
        this.m_SubSpaceComponents = StringUtil.isDefined((String)this.m_CurrentSubSpaceId) ? this.createComponentObjects(sp, true) : new DisplaySorted[0];
        SilverTrace.info((String)"jobStartPagePeas", (String)"NavBarManager.setCurrentSubSpace()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Set Current SUB Space=" + this.m_CurrentSubSpaceId));
        return StringUtil.isDefined((String)this.m_CurrentSubSpaceId);
    }

    public DisplaySorted[] getAvailableSubSpaceComponents() {
        if (this.m_CurrentSubSpaceId == null) {
            return new DisplaySorted[0];
        }
        return this.m_SubSpaceComponents;
    }

    protected DisplaySorted getSpaceCache(String spaceId) {
        if (spaceId == null) {
            return null;
        }
        for (DisplaySorted space : this.m_Spaces) {
            if (!spaceId.equals(space.id)) continue;
            return space;
        }
        for (DisplaySorted subspace : this.m_SubSpaces) {
            if (!spaceId.equals(subspace.id)) continue;
            return subspace;
        }
        return null;
    }

    protected DisplaySorted getComponentCache(String componentId) {
        if (componentId == null) {
            return null;
        }
        for (DisplaySorted spaceComponent : this.m_SpaceComponents) {
            if (!componentId.equals(spaceComponent.id)) continue;
            return spaceComponent;
        }
        for (DisplaySorted subspaceComponent : this.m_SubSpaceComponents) {
            if (!componentId.equals(subspaceComponent.id)) continue;
            return subspaceComponent;
        }
        return null;
    }

    protected DisplaySorted[] createSpaceObjects(String[] spaceIds, boolean goRecurs) {
        if (spaceIds == null) {
            return new DisplaySorted[0];
        }
        Object[] valret = new DisplaySorted[spaceIds.length];
        for (int j = 0; j < valret.length; ++j) {
            valret[j] = this.buildSpaceObject(spaceIds[j]);
        }
        Arrays.sort(valret);
        if (goRecurs) {
            Object[] parents = valret;
            ArrayList<Object> alValret = new ArrayList<Object>();
            for (Object parent : parents) {
                alValret.add(parent);
                String[] subSpaceIds = this.m_administrationCtrl.getAllSubSpaceIds(((DisplaySorted)parent).id);
                DisplaySorted[] children = this.createSpaceObjects(subSpaceIds, true);
                Collections.addAll(alValret, children);
            }
            valret = alValret.toArray(new DisplaySorted[alValret.size()]);
        }
        return valret;
    }

    protected DisplaySorted buildSpaceObject(String spaceId) {
        DisplaySorted valret = new DisplaySorted();
        valret.id = this.getShortSpaceId(spaceId);
        valret.isVisible = true;
        SpaceInstLight spaceInst = this.m_administrationCtrl.getSpaceInstLight(spaceId);
        if (spaceInst.isRoot()) {
            String[] manageableSubSpaceIds;
            valret.type = 2;
            boolean bl = valret.isAdmin = this.m_user.isAccessAdmin() || this.m_ManageableSpaces.contains(valret.id);
            if (!(valret.isAdmin || (manageableSubSpaceIds = this.m_administrationCtrl.getUserManageableSubSpaceIds(this.m_user.getId(), valret.id)) != null && manageableSubSpaceIds.length > 0)) {
                valret.isVisible = false;
            }
        } else {
            String[] manageableSubSpaceIds;
            valret.type = 3;
            boolean bl = valret.isAdmin = this.m_user.isAccessAdmin() || this.isAdminOfSpace(spaceInst);
            if (!(valret.isAdmin || (manageableSubSpaceIds = this.m_administrationCtrl.getUserManageableSubSpaceIds(this.m_user.getId(), valret.id)) != null && manageableSubSpaceIds.length > 0)) {
                valret.isVisible = false;
            }
        }
        valret.name = spaceInst.getName(this.m_SessionCtrl.getLanguage());
        valret.orderNum = spaceInst.getOrderNum();
        valret.deep = spaceInst.getLevel();
        this.buildSpaceHTMLLine(valret);
        SilverTrace.info((String)"jobStartPagePeas", (String)"NavBarManager.buildSpaceObject()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Space=" + valret.id + " Name=" + valret.name + " Type=" + valret.type));
        return valret;
    }

    protected String getShortSpaceId(String spaceId) {
        if (spaceId != null && spaceId.startsWith("WA")) {
            return spaceId.substring(2);
        }
        return spaceId == null ? "" : spaceId;
    }

    protected void buildSpaceHTMLLine(DisplaySorted space) {
        if (space.isVisible) {
            if (space.type == 3) {
                StringBuilder spacesSpaces = new StringBuilder();
                int objType = space.id.equals(this.m_CurrentSubSpaceId) ? 3 : 2;
                String link2 = "GoToSubSpace?SubSpace=" + space.id;
                String spaceName = this.m_SessionCtrl.isSpaceInMaintenance(space.id) ? space.name + " (M)" : space.name;
                for (int i = 0; i < space.deep - 1; ++i) {
                    spacesSpaces.append("&nbsp&nbsp");
                }
                space.htmlLine = spacesSpaces.toString() + "<a name=\"" + space.id + "\"/>" + this.urlFactory(link2, "space" + space.id, "", spaceName, 0, objType, this.m_sContext, "", space);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("<option ");
                if (space.id.equals(this.m_CurrentSpaceId)) {
                    sb.append("selected ");
                }
                sb.append("value=").append(space.id).append(">").append(space.name);
                if (this.m_SessionCtrl.isSpaceInMaintenance(space.id)) {
                    sb.append(" (M)");
                }
                sb.append("</option>");
                space.htmlLine = sb.toString();
            }
        } else {
            space.htmlLine = "";
        }
    }

    protected boolean isAdminOfSpace(SpaceInstLight spaceInst) {
        boolean valret = this.m_ManageableSpaces.contains(spaceInst.getShortId()) || this.m_ManageableSpaces.contains(this.getShortSpaceId(spaceInst.getFatherId()));
        SpaceInstLight parcSpaceInst = spaceInst;
        while (!valret && !parcSpaceInst.isRoot()) {
            parcSpaceInst = this.m_administrationCtrl.getSpaceInstLight(parcSpaceInst.getFatherId());
            valret = this.m_ManageableSpaces.contains(parcSpaceInst.getShortId());
        }
        return valret;
    }

    protected DisplaySorted[] createComponentObjects(SpaceInst spaceInst, boolean subSpaces) {
        ArrayList components = spaceInst.getAllComponentsInst();
        boolean isTheSpaceAdmin = this.m_user.isAccessAdmin() || this.isAdminOfSpace(new SpaceInstLight(spaceInst));
        ArrayList<DisplaySorted> result = new ArrayList<DisplaySorted>();
        int i = 0;
        for (ComponentInst ci : components) {
            DisplaySorted ds = new DisplaySorted();
            ds.name = ci.getLabel(this.m_SessionCtrl.getLanguage());
            if (ds.name == null) {
                ds.name = ci.getName();
            }
            ds.orderNum = ci.getOrderNum();
            ds.id = ci.getId();
            ds.type = 1;
            ds.isAdmin = isTheSpaceAdmin;
            ds.deep = spaceInst.getLevel();
            ds.isVisible = isTheSpaceAdmin;
            if (ds.isVisible) {
                String label = ds.name;
                String link2 = "GoToComponent?ComponentId=" + ci.getId();
                int objType = subSpaces ? (i + 1 == components.size() ? 6 : 5) : 4;
                StringBuilder componentsSpaces = new StringBuilder();
                for (int j = 0; j < ds.deep - 1; ++j) {
                    componentsSpaces.append("&nbsp;&nbsp;");
                }
                String componentIcon = ci.getName();
                if (ci.isWorkflow()) {
                    componentIcon = "processManager";
                }
                ds.htmlLine = componentsSpaces.toString() + this.urlFactory(link2, "element" + this.m_elmtCounter++, componentIcon, label, 1, objType, this.m_sContext, "startPageContent", ds);
            } else {
                ds.htmlLine = "";
            }
            result.add(ds);
            ++i;
        }
        Collections.sort(result);
        return result.toArray(new DisplaySorted[result.size()]);
    }

    protected String urlFactory(String link2, String elementLabel, String imageLinked, String labelLinked, int elementType, int imageType, String m_sContext, String target, DisplaySorted extraInfos) {
        StringBuilder result = new StringBuilder();
        String boldStart = "";
        String boldEnd = "";
        switch (elementType) {
            case 0: {
                target = "";
                boldStart = "";
                boldEnd = "";
                break;
            }
            case 1: {
                if (target != null && target.length() > 0) {
                    target = "target=\"" + target + "\"";
                }
                boldStart = "";
                boldEnd = "";
                break;
            }
            case 7: {
                target = "target=\"_blank\"";
                boldStart = "";
                boldEnd = "";
            }
        }
        String safeElementLabel = Encode.forHtml((String)elementLabel);
        imageLinked = "<img name=\"" + safeElementLabel + "\" src=\"" + m_sContext + "/util/icons/component/" + imageLinked + "Small.gif\" class=\"component-icon\"/>";
        switch (imageType) {
            case 2: {
                result.append("<a href=\"").append(link2).append("\"").append(target).append("><img src=\"").append(m_sContext).append("/util/icons/plusTree.gif\" border=\"0\" align=\"absmiddle\"></a>");
                imageLinked = "<img name=\"" + safeElementLabel + "\" src=\"" + m_sContext + "/util/icons/colorPix/1px.gif\" width=\"1\" height=\"1\" border=\"0\" align=\"absmiddle\">";
                break;
            }
            case 3: {
                result.append("<a href=\"").append(link2).append("\"").append(target).append("><img src=\"").append(m_sContext).append("/util/icons/minusTree.gif\" border=\"0\" align=\"absmiddle\"></a>");
                imageLinked = "<img name=\"" + safeElementLabel + "\" src=\"" + m_sContext + "/util/icons/colorPix/1px.gif\" width=\"1\" height=\"1\" border=\"0\" align=\"absmiddle\">";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                result.append("<img src=\"").append(m_sContext).append("/util/icons/minusTreeT.gif\" border=\"0\" align=\"absmiddle\">");
                break;
            }
            case 6: {
                result.append("<img src=\"").append(m_sContext).append("/util/icons/minusTreeL.gif\" border=\"0\" align=\"absmiddle\">");
            }
        }
        String safeLabelLinked = Encode.forHtml((String)labelLinked);
        result.append("<a href=\"").append(link2).append("\" ").append(target).append(">").append(imageLinked).append("&nbsp</a>");
        result.append("<a href=\"").append(link2).append("\" ").append(target).append(">").append(boldStart).append(safeLabelLinked).append(boldEnd).append("</a><br/>");
        return result.toString();
    }
}

