/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jobStartPagePeas.control;

import com.silverpeas.admin.components.PasteDetail;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.admin.localized.LocalizedComponent;
import com.silverpeas.admin.localized.LocalizedOption;
import com.silverpeas.admin.localized.LocalizedParameter;
import com.silverpeas.admin.spaces.SpaceTemplate;
import com.silverpeas.jobStartPagePeas.DisplaySorted;
import com.silverpeas.jobStartPagePeas.JobStartPagePeasException;
import com.silverpeas.jobStartPagePeas.JobStartPagePeasSettings;
import com.silverpeas.jobStartPagePeas.NavBarManager;
import com.silverpeas.jobStartPagePeas.SpaceLookHelper;
import com.silverpeas.look.SilverpeasLook;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.clipboard.ClipboardException;
import com.silverpeas.util.clipboard.ClipboardSelection;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.silverpeas.util.web.servlet.FileUploadUtil;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.selection.SelectionException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.PairObject;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.ComponentSelection;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.Recover;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceSelection;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.silverpeas.admin.space.SpaceServiceFactory;
import org.silverpeas.admin.space.quota.ComponentSpaceQuotaKey;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.quota.QuotaKey;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.exception.QuotaRuntimeException;
import org.silverpeas.util.GlobalContext;
import org.silverpeas.util.UnitUtil;

public class JobStartPagePeasSessionController
extends AbstractComponentSessionController {
    private final AdminController adminController;
    NavBarManager m_NavBarMgr = new NavBarManager();
    String m_ManagedSpaceId = null;
    boolean m_isManagedSpaceRoot = true;
    Selection selection = null;
    String m_ManagedInstanceId = null;
    ProfileInst m_ManagedProfile = null;
    ProfileInst m_ManagedInheritedProfile = null;
    String m_ssEspace = "";
    String m_name = "";
    String m_desc = "";
    String currentLanguage = "";
    String m_look = null;
    String m_spaceTemplate = "";
    String[][] currentSpaceTemplateProfilesGroups = new String[0][0];
    String[][] m_TemplateProfilesUsers = new String[0][0];
    String m_componentSpaceQuotaMaxCount = "";
    String m_dataStorageQuotaMaxCount = "";
    boolean m_spaceFirst = true;
    SpaceInst[] m_BrothersSpaces = new SpaceInst[0];
    ComponentInst[] m_BrothersComponents = ArrayUtil.EMPTY_COMPONENT_INSTANCE_ARRAY;
    public static final int SCOPE_BACKOFFICE = 0;
    public static final int SCOPE_FRONTOFFICE = 1;
    private int scope = 0;
    public static final int MAINTENANCE_OFF = 0;
    public static final int MAINTENANCE_PLATFORM = 1;
    public static final int MAINTENANCE_ONEPARENT = 2;
    public static final int MAINTENANCE_THISSPACE = 3;
    private static final Properties templateConfiguration = new Properties();

    public JobStartPagePeasSessionController(MainSessionController mainSessionCtrl, ComponentContext componentContext) {
        super(mainSessionCtrl, componentContext, "org.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle", "org.silverpeas.jobStartPagePeas.settings.jobStartPagePeasIcons");
        this.setComponentRootName("jobStartPagePeas");
        this.selection = this.getSelection();
        this.adminController = new AdminController(this.getUserId());
        templateConfiguration.setProperty("template.root.dir", JobStartPagePeasSettings.TEMPLATE_PATH);
        templateConfiguration.setProperty("template.customer.dir", JobStartPagePeasSettings.CUSTOMERS_TEMPLATE_PATH);
    }

    public void init() {
        this.m_NavBarMgr.initWithUser(this, this.getUserDetail());
    }

    public boolean isInheritanceEnable() {
        return JobStartPagePeasSettings.isInheritanceEnable;
    }

    public boolean isJSR168Used() {
        return JobStartPagePeasSettings.useJSR168Portlets;
    }

    public boolean isUserAdmin() {
        return this.getUserDetail().isAccessAdmin();
    }

    public SpaceInst getSpaceInstById() {
        if (!StringUtil.isDefined((String)this.getManagedSpaceId())) {
            return null;
        }
        SpaceInst space = this.adminController.getSpaceInstById("WA" + this.getManagedSpaceId());
        space.setCreator(this.getUserDetail(space.getCreatorUserId()));
        space.setUpdater(this.getUserDetail(space.getUpdaterUserId()));
        space.setRemover(this.getUserDetail(space.getRemoverUserId()));
        return space;
    }

    public void setManagedSpaceId(String sId, boolean isManagedSpaceRoot) {
        String spaceId;
        this.m_ManagedSpaceId = spaceId = this.getShortSpaceId(sId);
        this.m_isManagedSpaceRoot = isManagedSpaceRoot;
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.setManagedSpaceId()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Current Space=" + this.m_ManagedSpaceId));
    }

    public String getManagedSpaceId() {
        return this.m_ManagedSpaceId;
    }

    public DisplaySorted getManagedSpace() {
        return this.m_NavBarMgr.getSpace(this.getManagedSpaceId());
    }

    public boolean isManagedSpaceRoot() {
        return this.m_isManagedSpaceRoot;
    }

    public DisplaySorted[] getManagedSpaceComponents() {
        if (this.isManagedSpaceRoot()) {
            return this.getSpaceComponents();
        }
        return this.getSubSpaceComponents();
    }

    public void setSubSpaceId(String subSpaceId) {
        if (this.m_NavBarMgr.setCurrentSubSpace(subSpaceId)) {
            this.setManagedSpaceId(subSpaceId, false);
        } else {
            this.setManagedSpaceId(this.getSpaceId(), true);
        }
    }

    public void setSpaceId(String spaceUserId) {
        if (this.m_NavBarMgr.setCurrentSpace(spaceUserId)) {
            this.setManagedSpaceId(spaceUserId, true);
        } else {
            this.setManagedSpaceId(null, true);
        }
    }

    private String getShortSpaceId(String spaceId) {
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.getShortSpaceId()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("spaceId=" + spaceId));
        if (spaceId != null && spaceId.startsWith("WA")) {
            return spaceId.substring(2);
        }
        return spaceId == null ? "" : spaceId;
    }

    public SpaceInst getSpaceInstFromTemplate(String templateName) {
        return this.adminController.getSpaceInstFromTemplate(templateName);
    }

    public Map<String, SpaceTemplate> getAllSpaceTemplates() {
        return this.adminController.getAllSpaceTemplates();
    }

    @Override
    public String getSpaceId() {
        return this.m_NavBarMgr.getCurrentSpaceId();
    }

    public DisplaySorted[] getSpaces() {
        return this.m_NavBarMgr.getAvailableSpaces();
    }

    public DisplaySorted[] getSpaceComponents() {
        return this.m_NavBarMgr.getAvailableSpaceComponents();
    }

    public String getSubSpaceId() {
        return this.m_NavBarMgr.getCurrentSubSpaceId();
    }

    public DisplaySorted[] getSubSpaces() {
        return this.m_NavBarMgr.getAvailableSubSpaces();
    }

    public DisplaySorted[] getSubSpaceComponents() {
        return this.m_NavBarMgr.getAvailableSubSpaceComponents();
    }

    public void setSpaceMaintenance(String spaceId, boolean mode) {
        this.setSpaceModeMaintenance(spaceId, mode);
    }

    public void refreshCurrentSpaceCache() {
        this.m_NavBarMgr.resetSpaceCache(this.getManagedSpaceId());
    }

    public void setManagedInstanceId(String sId) {
        this.m_ManagedInstanceId = sId;
        this.setScope(0);
    }

    public void setManagedInstanceId(String sId, int scope) {
        this.setManagedInstanceId(sId);
        this.setScope(scope);
    }

    public String getManagedInstanceId() {
        return this.m_ManagedInstanceId;
    }

    public boolean isComponentManageable(String componentId) {
        return this.getOrganisationController().isComponentManageable(componentId, this.getUserId());
    }

    public void setManagedProfile(ProfileInst sProfile) {
        this.m_ManagedProfile = sProfile;
        this.m_ManagedInheritedProfile = sProfile != null ? this.adminController.getComponentInst(this.getManagedInstanceId()).getInheritedProfileInst(sProfile.getName()) : null;
    }

    public ProfileInst getManagedProfile() {
        return this.m_ManagedProfile;
    }

    public String getManagedProfileHelp(String componentName) {
        return this.getComponentByName(componentName).getProfile(this.getManagedProfile().getName()).getHelp(this.getLanguage());
    }

    public ProfileInst getManagedInheritedProfile() {
        return this.m_ManagedInheritedProfile;
    }

    public Boolean isProfileEditable() {
        return JobStartPagePeasSettings.m_IsProfileEditable;
    }

    public Boolean isBackupEnable() {
        return JobStartPagePeasSettings.isBackupEnable;
    }

    public String getConfigSpacePosition() {
        return JobStartPagePeasSettings.SPACEDISPLAYPOSITION_CONFIG;
    }

    public SpaceInst[] getBrotherSpaces(boolean isNew) {
        String currentSpaceId;
        String fatherId;
        SpaceInst spaceint1 = this.getSpaceInstById();
        if (isNew) {
            fatherId = spaceint1 == null ? null : "WA" + this.getManagedSpaceId();
            currentSpaceId = "";
        } else {
            fatherId = spaceint1.getDomainFatherId();
            currentSpaceId = "WA" + this.getManagedSpaceId();
        }
        String[] sids = fatherId != null && !fatherId.equals("0") ? this.adminController.getAllSubSpaceIds(fatherId) : this.adminController.getAllRootSpaceIds();
        if (sids == null || sids.length <= 0) {
            return new SpaceInst[0];
        }
        this.m_BrothersSpaces = isNew ? new SpaceInst[sids.length] : new SpaceInst[sids.length - 1];
        int j = 0;
        for (String sid : sids) {
            if (!isNew && sid.equals(currentSpaceId)) continue;
            this.m_BrothersSpaces[j++] = this.adminController.getSpaceInstById(sid);
        }
        Arrays.sort(this.m_BrothersSpaces);
        return this.m_BrothersSpaces;
    }

    public SpaceInst[] getUserManageableSpacesIds() {
        ArrayList<SpaceInst> vManageableSpaces = new ArrayList<SpaceInst>();
        String[] sids = this.getUserManageableSpaceIds();
        SpaceInst currentSpace = this.getSpaceInstById();
        String currentSpaceId = currentSpace == null ? "-1" : currentSpace.getId();
        for (String sid : sids) {
            if (!this.isSpaceInMaintenance(sid.substring(2)) && !sid.equals(currentSpaceId)) continue;
            vManageableSpaces.add(this.adminController.getSpaceInstById(sid));
        }
        Object[] aManageableSpaces = vManageableSpaces.toArray(new SpaceInst[vManageableSpaces.size()]);
        Arrays.sort(aManageableSpaces);
        return aManageableSpaces;
    }

    public void setSpacePlace(String idSpaceBefore) {
        int i;
        int orderNum = 0;
        SpaceInst theSpace = this.getSpaceInstById();
        for (i = 0; i < this.m_BrothersSpaces.length; ++i) {
            if (idSpaceBefore.equals(this.m_BrothersSpaces[i].getId())) {
                theSpace.setOrderNum(orderNum);
                this.adminController.updateSpaceOrderNum(theSpace.getId(), orderNum);
                ++orderNum;
            }
            if (this.m_BrothersSpaces[i].getOrderNum() != orderNum) {
                this.m_BrothersSpaces[i].setOrderNum(orderNum);
                this.adminController.updateSpaceOrderNum(this.m_BrothersSpaces[i].getId(), orderNum);
            }
            ++orderNum;
        }
        if (orderNum == i) {
            theSpace.setOrderNum(orderNum);
            this.adminController.updateSpaceOrderNum(theSpace.getId(), orderNum);
            ++orderNum;
        }
        this.m_NavBarMgr.resetAllCache();
    }

    public SpaceInst getSpaceInstById(String idSpace) {
        if (idSpace == null || idSpace.length() <= 0) {
            return null;
        }
        if (idSpace.length() > 2 && idSpace.substring(0, 2).equals("WA")) {
            idSpace = idSpace.substring(2);
        }
        return this.adminController.getSpaceInstById("WA" + idSpace);
    }

    public void setCreateSpaceParameters(String name, String desc, String ssEspace, String spaceTemplate, String language, String look, String componentSpaceQuotaMaxCount, String dataStorageQuotaMaxCount) {
        this.m_ssEspace = ssEspace;
        this.m_name = name;
        this.m_desc = desc;
        this.currentLanguage = language;
        this.m_spaceTemplate = spaceTemplate;
        this.m_look = look;
        this.m_componentSpaceQuotaMaxCount = componentSpaceQuotaMaxCount;
        this.m_dataStorageQuotaMaxCount = dataStorageQuotaMaxCount;
        this.m_spaceFirst = !JobStartPagePeasSettings.SPACEDISPLAYPOSITION_AFTER.equalsIgnoreCase(JobStartPagePeasSettings.SPACEDISPLAYPOSITION_CONFIG);
    }

    public String createSpace() {
        if (this.m_desc == null) {
            this.m_desc = "";
        }
        SpaceInst spaceInst = this.m_spaceTemplate != null && this.m_spaceTemplate.length() > 0 ? this.getSpaceInstFromTemplate(this.m_spaceTemplate) : new SpaceInst();
        SpaceInst spaceint1 = this.getSpaceInstById();
        String fatherId = null;
        if (this.m_ssEspace != null && this.m_ssEspace.equals("SousEspace")) {
            String idSpace = spaceint1.getId();
            if (idSpace != null) {
                spaceInst.setDomainFatherId(idSpace);
            }
        } else {
            if (spaceint1 != null) {
                fatherId = spaceint1.getDomainFatherId();
            }
            if (fatherId != null && !fatherId.equals("0")) {
                SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasRequestRouter.getDestination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"setDomainFatherId !!");
                spaceInst.setDomainFatherId("WA" + fatherId);
            }
        }
        if (this.isUserAdmin() && JobStartPagePeasSettings.componentsInSpaceQuotaActivated && StringUtil.isDefined((String)this.m_componentSpaceQuotaMaxCount)) {
            try {
                spaceInst.setComponentSpaceQuotaMaxCount((long)Integer.valueOf(this.m_componentSpaceQuotaMaxCount).intValue());
            }
            catch (QuotaException qe) {
                throw new QuotaRuntimeException("Space", 4, qe.getMessage(), (Exception)((Object)qe));
            }
        }
        if (this.isUserAdmin() && JobStartPagePeasSettings.dataStorageInSpaceQuotaActivated && StringUtil.isDefined((String)this.m_dataStorageQuotaMaxCount)) {
            try {
                spaceInst.setDataStorageQuotaMaxCount(UnitUtil.convertTo((long)Long.valueOf(this.m_dataStorageQuotaMaxCount), (UnitUtil.memUnit)UnitUtil.memUnit.MB, (UnitUtil.memUnit)UnitUtil.memUnit.B));
            }
            catch (QuotaException qe) {
                throw new QuotaRuntimeException("Space", 4, qe.getMessage(), (Exception)((Object)qe));
            }
        }
        spaceInst.setName(this.m_name);
        spaceInst.setDescription(this.m_desc);
        spaceInst.setLanguage(this.currentLanguage);
        spaceInst.setCreatorUserId(this.getUserId());
        String sSpaceInstId = this.addSpaceInst(spaceInst, this.m_spaceTemplate);
        if (sSpaceInstId != null && sSpaceInstId.length() > 0) {
            SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.createSpace()", (String)sSpaceInstId, (String)"SP", (String)spaceInst.getName(), (String)this.getUserDetail().getId(), (String)"1");
            if (this.m_ssEspace != null && this.m_ssEspace.equals("SousEspace")) {
                this.setSubSpaceId(sSpaceInstId);
            } else if (fatherId != null && !fatherId.equals("0")) {
                this.setSubSpaceId(sSpaceInstId);
            } else {
                this.setSpaceId(sSpaceInstId);
            }
        }
        spaceInst.setDisplaySpaceFirst(this.m_spaceFirst);
        return sSpaceInstId;
    }

    public String addSpaceInst(SpaceInst spaceInst, String templateName) {
        SpaceInst si;
        ArrayList acl;
        String res = this.adminController.addSpaceInst(spaceInst);
        if (res == null || res.length() == 0) {
            return res;
        }
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasRequestRouter.addSpaceInst()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"SpaceAdded");
        if (templateName != null && templateName.length() > 0 && (acl = (si = this.adminController.getSpaceInstById(res)).getAllComponentsInst()) != null) {
            for (ComponentInst ci : acl) {
                HashMap componentProfilesToCreate = new HashMap();
                SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasRequestRouter.addSpaceInst()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Looking for component " + ci.getLabel() + " - " + ci.getName()));
                for (ProfileInst profileInst : componentProfilesToCreate.values()) {
                    this.adminController.addProfileInst(profileInst);
                }
            }
        }
        this.m_NavBarMgr.addSpaceInCache(res);
        this.initializeComponentSpaceQuota(spaceInst);
        this.initializeDataStorageQuota(spaceInst);
        return res;
    }

    public String updateSpaceInst(SpaceInst spaceInst) {
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.updateSpaceInst()", (String)spaceInst.getId(), (String)"SP", (String)spaceInst.getName(), (String)this.getUserId(), (String)"3");
        spaceInst.setUpdaterUserId(this.getUserId());
        String res = this.adminController.updateSpaceInst(spaceInst);
        this.initializeComponentSpaceQuota(spaceInst);
        this.initializeDataStorageQuota(spaceInst);
        return res;
    }

    public SpaceLookHelper getSpaceLookHelper() {
        ArrayList<File> files;
        try {
            files = (ArrayList<File>)FileFolderManager.getAllFile((String)this.getSpaceLookBasePath());
        }
        catch (UtilException e) {
            files = new ArrayList<File>();
        }
        SpaceLookHelper slh = new SpaceLookHelper("Space" + this.getManagedSpaceId());
        slh.setFiles(files);
        return slh;
    }

    public boolean removeExternalElementOfSpaceAppearance(String fileName) {
        File file = new File(this.getSpaceLookBasePath(), fileName);
        return FileUtils.deleteQuietly((File)file);
    }

    public void updateSpaceAppearance(List<FileItem> items) throws Exception {
        String spacePosition;
        this.processExternalElementsOfSpaceAppearance(items);
        String selectedLook = FileUploadUtil.getParameter(items, (String)"SelectedLook");
        if (!StringUtil.isDefined((String)selectedLook)) {
            selectedLook = null;
        }
        SpaceInst space = this.getSpaceInstById();
        space.setLook(selectedLook);
        String configSpacePosition = this.getConfigSpacePosition();
        boolean isDisplaySpaceFirst = "BEFORE".equalsIgnoreCase(configSpacePosition) ? true : ("AFTER".equalsIgnoreCase(configSpacePosition) ? false : !StringUtil.isDefined((String)(spacePosition = FileUploadUtil.getParameter(items, (String)"SpacePosition"))) || !"2".equalsIgnoreCase(spacePosition));
        space.setDisplaySpaceFirst(isDisplaySpaceFirst);
        this.updateSpaceInst(space);
    }

    private void processExternalElementsOfSpaceAppearance(List<FileItem> items) throws Exception {
        String mainDir = "Space" + this.getManagedSpaceId();
        FileRepositoryManager.createAbsolutePath((String)mainDir, (String)"look");
        String path = SilverpeasLook.getSilverpeasLook().getSpaceBasePath(this.getManagedSpaceId());
        this.processSpaceWallpaper(items, path);
        this.processSpaceCSS(items, path);
    }

    private String getSpaceLookBasePath() {
        return SilverpeasLook.getSilverpeasLook().getSpaceBasePath(this.getManagedSpaceId());
    }

    private void processSpaceWallpaper(List<FileItem> items, String path) throws Exception {
        FileItem file = FileUploadUtil.getFile(items, (String)"wallPaper");
        if (file != null && StringUtil.isDefined((String)file.getName())) {
            String extension = FileRepositoryManager.getFileExtension((String)file.getName());
            if (extension != null && extension.equalsIgnoreCase("jpeg")) {
                extension = "jpg";
            }
            File dir = new File(path);
            Collection wallpapers = FileUtils.listFiles((File)dir, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"wallPaper", (IOCase)IOCase.INSENSITIVE), null);
            for (File wallpaper : wallpapers) {
                FileUtils.deleteQuietly((File)wallpaper);
            }
            file.write(new File(path + File.separator + "wallPaper." + extension.toLowerCase()));
        }
    }

    private void processSpaceCSS(List<FileItem> items, String path) throws Exception {
        FileItem file = FileUploadUtil.getFile(items, (String)"css");
        if (file != null && StringUtil.isDefined((String)file.getName())) {
            File css = new File(path, "styles.css");
            if (css != null && css.exists()) {
                css.delete();
            }
            file.write(css);
        }
    }

    public void initializeComponentSpaceQuota(SpaceInst space) {
        if (this.isUserAdmin() && JobStartPagePeasSettings.componentsInSpaceQuotaActivated) {
            try {
                SpaceServiceFactory.getComponentSpaceQuotaService().initialize((QuotaKey)ComponentSpaceQuotaKey.from((SpaceInst)space), space.getComponentSpaceQuota().getMaxCount());
            }
            catch (QuotaException qe) {
                throw new QuotaRuntimeException("Space", 4, qe.getMessage(), (Exception)((Object)qe));
            }
        }
    }

    public void initializeDataStorageQuota(SpaceInst space) {
        if (this.isUserAdmin() && JobStartPagePeasSettings.dataStorageInSpaceQuotaActivated) {
            try {
                SpaceServiceFactory.getDataStorageSpaceQuotaService().initialize((QuotaKey)DataStorageSpaceQuotaKey.from((SpaceInst)space), space.getDataStorageQuota().getMaxCount());
            }
            catch (QuotaException qe) {
                throw new QuotaRuntimeException("Space", 4, qe.getMessage(), (Exception)((Object)qe));
            }
        }
    }

    private boolean isRemovingSpaceAllowed(String spaceId) {
        if (this.isUserAdmin()) {
            return true;
        }
        List<String> spaceIds = Arrays.asList(this.getUserManageableSpaceIds());
        if (spaceIds == null || spaceIds.isEmpty()) {
            return false;
        }
        List spaces = this.getOrganisationController().getSpacePath(spaceId);
        for (SpaceInst spaceInPath : spaces) {
            if (!spaceIds.contains(spaceInPath.getId())) continue;
            return true;
        }
        return false;
    }

    public String deleteSpace(String spaceId) {
        boolean definitiveDelete;
        if (!this.isRemovingSpaceAllowed(spaceId)) {
            SilverTrace.error((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.deleteSpace()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("user #" + this.getUserId() + " is not allowed to delete space #" + spaceId));
            return "";
        }
        SpaceInst spaceint1 = this.adminController.getSpaceInstById(spaceId);
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.deleteSpace()", (String)spaceint1.getId(), (String)"SP", (String)spaceint1.getName(), (String)this.getUserDetail().getId(), (String)"2");
        boolean bl = definitiveDelete = !JobStartPagePeasSettings.isBasketEnable;
        if (JobStartPagePeasSettings.isBasketEnable && this.isUserAdmin()) {
            definitiveDelete = !JobStartPagePeasSettings.useBasketWhenAdmin;
        }
        String res = this.adminController.deleteSpaceInstById(spaceint1.getId(), definitiveDelete);
        this.m_NavBarMgr.removeSpaceInCache(res);
        if (this.isManagedSpaceRoot()) {
            this.setManagedSpaceId(null, true);
        } else {
            this.setManagedSpaceId(this.getSpaceId(), true);
        }
        return res;
    }

    public void recoverSpaceRights(String spaceId) throws AdminException {
        Recover recover = new Recover();
        if (spaceId == null) {
            recover.recoverRights();
        } else if (StringUtil.isDefined((String)spaceId)) {
            recover.recoverSpaceRights(spaceId);
        }
    }

    public String getSpaceProfileName(SpaceInst spaceint1) {
        ArrayList m_Profile = spaceint1.getAllSpaceProfilesInst();
        int i = 0;
        String name = "";
        if (i < m_Profile.size()) {
            SpaceProfileInst m_SpaceProfileInst = (SpaceProfileInst)m_Profile.get(i);
            name = m_SpaceProfileInst.getLabel();
        }
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.getSpaceProfileName()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("name avant= " + name));
        if (name != null) {
            if (name.equals("")) {
                name = this.getMultilang().getString("Manager");
            }
        } else {
            name = this.getMultilang().getString("Manager");
        }
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.getSpaceProfileName()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("name apr\u00e8s = " + name));
        return name;
    }

    private List<String> getAllCurrentGroupIdSpace(String role) {
        SpaceProfileInst m_SpaceProfileInst = this.getSpaceInstById().getSpaceProfileInst(role);
        if (m_SpaceProfileInst != null) {
            return m_SpaceProfileInst.getAllGroups();
        }
        return new ArrayList<String>();
    }

    public List<Group> getAllCurrentGroupSpace(String role) {
        SpaceProfileInst m_SpaceProfileInst = this.getSpaceInstById().getSpaceProfileInst(role);
        return this.getGroupsFromSpaceProfile(m_SpaceProfileInst);
    }

    private List<String> getAllCurrentUserIdSpace(String role) {
        SpaceProfileInst m_SpaceProfileInst = this.getSpaceInstById().getSpaceProfileInst(role);
        if (m_SpaceProfileInst != null) {
            return m_SpaceProfileInst.getAllUsers();
        }
        return new ArrayList<String>();
    }

    public List<UserDetail> getAllCurrentUserSpace(String role) {
        SpaceProfileInst m_SpaceProfileInst = this.getSpaceInstById().getSpaceProfileInst(role);
        return this.getUsersFromSpaceProfile(m_SpaceProfileInst);
    }

    private List<UserDetail> getUsersFromSpaceProfile(SpaceProfileInst profile) {
        ArrayList<UserDetail> res = new ArrayList<UserDetail>();
        if (profile != null) {
            ArrayList alUserIds = profile.getAllUsers();
            for (String alUserId : alUserIds) {
                UserDetail userDetail = this.adminController.getUserDetail(alUserId);
                if (res.contains(userDetail)) continue;
                res.add(userDetail);
            }
        }
        return res;
    }

    private List<Group> getGroupsFromSpaceProfile(SpaceProfileInst profile) {
        ArrayList<Group> res = new ArrayList<Group>();
        if (profile != null) {
            ArrayList groupIds = profile.getAllGroups();
            for (String groupId : groupIds) {
                Group group = this.adminController.getGroupById(groupId);
                if (res.contains(group)) continue;
                res.add(group);
            }
        }
        return res;
    }

    public List<UserDetail> getUsersManagerOfParentSpace() {
        ArrayList<UserDetail> res = new ArrayList<UserDetail>();
        List<SpaceInst> path = this.getCurrentSpacePath(true);
        for (SpaceInst space : path) {
            res.addAll(this.getUsersFromSpaceProfile(space.getSpaceProfileInst("Manager")));
        }
        return res;
    }

    public List<Group> getGroupsManagerOfParentSpace() {
        ArrayList<Group> res = new ArrayList<Group>();
        List<SpaceInst> path = this.getCurrentSpacePath(true);
        for (SpaceInst space : path) {
            res.addAll(this.getGroupsFromSpaceProfile(space.getSpaceProfileInst("Manager")));
        }
        return res;
    }

    private List<SpaceInst> getCurrentSpacePath(boolean excludeSpace) {
        List path = this.getOrganisationController().getSpacePath(this.getSpaceInstById().getId());
        if (!excludeSpace) {
            return path;
        }
        if (path.size() >= 2) {
            path.remove(path.size() - 1);
            return path;
        }
        return new ArrayList<SpaceInst>();
    }

    public void initUserPanelSpaceForGroupsUsers(String compoURL, String role) throws SelectionException {
        String nameProfile;
        PairObject hostComponentName;
        SpaceInst spaceint1 = this.getSpaceInstById();
        SpaceProfileInst profile = spaceint1.getSpaceProfileInst(role);
        this.selection.resetAll();
        String hostSpaceName = this.getMultilang().getString("JSPP.manageHomePage");
        this.selection.setHostSpaceName(hostSpaceName);
        String idFather = this.getSpaceInstById().getDomainFatherId();
        if (idFather != null && !idFather.equals("0")) {
            SpaceInst spaceFather = this.getSpaceInstById(idFather);
            hostComponentName = new PairObject((Object)(spaceFather.getName() + " > " + this.getSpaceInstById().getName()), null);
        } else {
            hostComponentName = new PairObject((Object)this.getSpaceInstById().getName(), null);
        }
        this.selection.setHostComponentName(hostComponentName);
        if (profile == null) {
            nameProfile = this.getMultilang().getString("JSPP." + role);
        } else {
            nameProfile = profile.getLabel();
            if (!StringUtil.isDefined((String)nameProfile)) {
                nameProfile = this.getMultilang().getString("JSPP." + role);
            }
        }
        ResourceLocator generalMessage = GeneralPropertiesManager.getGeneralMultilang((String)this.getLanguage());
        PairObject[] hostPath = new PairObject[]{new PairObject((Object)(nameProfile + " > " + generalMessage.getString("GML.selection")), null)};
        this.selection.setHostPath(hostPath);
        String hostUrl = compoURL + "EffectiveUpdateSpaceProfile?Role=" + role;
        if (profile == null) {
            hostUrl = compoURL + "EffectiveCreateSpaceProfile?Role=" + role;
        }
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.initUserPanelSpaceForGroupsUsers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("compoURL = " + compoURL + " hostSpaceName=" + hostSpaceName + " hostComponentName=" + this.getSpaceInstById().getName() + " hostUrlTest=" + hostUrl));
        this.selection.setGoBackURL(hostUrl);
        this.selection.setCancelURL(compoURL + "CancelCreateOrUpdateSpaceProfile?Role=" + role);
        List<String> users = this.getAllCurrentUserIdSpace(role);
        List<String> groups = this.getAllCurrentGroupIdSpace(role);
        this.selection.setSelectedElements(users.toArray(new String[users.size()]));
        this.selection.setSelectedSets(groups.toArray(new String[groups.size()]));
    }

    public void createSpaceRole(String role) {
        SpaceProfileInst spaceProfileInst = new SpaceProfileInst();
        spaceProfileInst.setName(role);
        if (role.equals("Manager")) {
            spaceProfileInst.setLabel("Manager d'espace");
        }
        spaceProfileInst.setSpaceFatherId(this.getSpaceInstById().getId());
        this.setGroupsAndUsers(spaceProfileInst, this.selection.getSelectedSets(), this.selection.getSelectedElements());
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.createSpaceRole", (String)spaceProfileInst.getSpaceFatherId(), (String)"N/A", (String)spaceProfileInst.getName(), (String)this.getUserId(), (String)"1");
        this.adminController.addSpaceProfileInst(spaceProfileInst, this.getUserId());
    }

    public void updateSpaceRole(String role) {
        SpaceInst spaceint1 = this.getSpaceInstById();
        SpaceProfileInst m_SpaceProfileInst = spaceint1.getSpaceProfileInst(role);
        SpaceProfileInst spaceProfileInst = new SpaceProfileInst();
        spaceProfileInst.setId(m_SpaceProfileInst.getId());
        spaceProfileInst.setSpaceFatherId(spaceint1.getId());
        spaceProfileInst.setName(m_SpaceProfileInst.getName());
        this.setGroupsAndUsers(spaceProfileInst, this.selection.getSelectedSets(), this.selection.getSelectedElements());
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.updateSpaceRole", (String)spaceProfileInst.getSpaceFatherId(), (String)"N/A", (String)spaceProfileInst.getName(), (String)this.getUserId(), (String)"3");
        this.adminController.updateSpaceProfileInst(spaceProfileInst, this.getUserId());
    }

    public void deleteSpaceRole(String role) {
        SpaceProfileInst m_SpaceProfileInst = this.getSpaceInstById().getSpaceProfileInst(role);
        if (m_SpaceProfileInst != null) {
            SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.deleteSpaceRole", (String)m_SpaceProfileInst.getSpaceFatherId(), (String)"N/A", (String)m_SpaceProfileInst.getName(), (String)this.getUserId(), (String)"2");
            this.adminController.deleteSpaceProfileInst(m_SpaceProfileInst.getId(), this.getUserId());
        }
    }

    public void updateSpaceManagersDescription(SpaceProfileInst spaceProfileInst) {
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.updateSpaceManagersDescription", (String)spaceProfileInst.getSpaceFatherId(), (String)"N/A", (String)spaceProfileInst.getName(), (String)this.getUserId(), (String)"3");
        this.adminController.updateSpaceProfileInst(spaceProfileInst, this.getUserId());
    }

    public List<SpaceInstLight> getRemovedSpaces() {
        List removedSpaces = this.adminController.getRemovedSpaces();
        for (int s = 0; removedSpaces != null && s < removedSpaces.size(); ++s) {
            SpaceInstLight space = (SpaceInstLight)removedSpaces.get(s);
            space.setRemoverName(this.getOrganisationController().getUserDetail(String.valueOf(space.getRemovedBy())).getDisplayedName());
            space.setPath(this.adminController.getPathToSpace(space.getFullId(), false));
            String name = space.getName();
            name = name.substring(0, name.indexOf(" (Restaur\u00e9)"));
            space.setName(name);
        }
        return removedSpaces;
    }

    public List<ComponentInstLight> getRemovedComponents() {
        List removedComponents = this.adminController.getRemovedComponents();
        for (int s = 0; removedComponents != null && s < removedComponents.size(); ++s) {
            ComponentInstLight component = (ComponentInstLight)removedComponents.get(s);
            component.setRemoverName(this.getOrganisationController().getUserDetail(String.valueOf(component.getRemovedBy())).getDisplayedName());
            component.setPath(this.adminController.getPathToComponent(component.getId()));
            String name = component.getLabel();
            name = name.substring(0, name.indexOf(" (Restaur\u00e9)"));
            component.setLabel(name);
        }
        return removedComponents;
    }

    public void restoreSpaceFromBin(String spaceId) {
        this.adminController.restoreSpaceFromBasket(spaceId);
        this.m_NavBarMgr.resetAllCache();
    }

    public void deleteSpaceInBin(String spaceId) {
        this.adminController.deleteSpaceInstById(spaceId, true);
    }

    public void restoreComponentFromBin(String componentId) {
        this.adminController.restoreComponentFromBasket(componentId);
    }

    public void deleteComponentInBin(String componentId) {
        this.adminController.deleteComponentInst(componentId, true);
    }

    public ComponentInst[] getBrotherComponents(boolean isNew) {
        ArrayList arc = this.getSpaceInstById().getAllComponentsInst();
        if (arc == null || arc.isEmpty()) {
            return ArrayUtil.EMPTY_COMPONENT_INSTANCE_ARRAY;
        }
        this.m_BrothersComponents = isNew ? new ComponentInst[arc.size()] : new ComponentInst[arc.size() - 1];
        int j = 0;
        for (ComponentInst theComponent : arc) {
            SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSesionController.getBrotherComponents()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Current = '" + this.getManagedInstanceId() + "' Loop = '" + theComponent.getId() + "'"));
            if (!isNew && theComponent.getId().equals(this.getManagedInstanceId())) continue;
            this.m_BrothersComponents[j++] = theComponent;
        }
        Arrays.sort(this.m_BrothersComponents);
        return this.m_BrothersComponents;
    }

    public ComponentInst[] getComponentsOfSpace(String spaceId) {
        ArrayList arc = this.getSpaceInstById(spaceId).getAllComponentsInst();
        if (arc == null || arc.isEmpty()) {
            return ArrayUtil.EMPTY_COMPONENT_INSTANCE_ARRAY;
        }
        ComponentInst[] m_Components = new ComponentInst[arc.size()];
        int j = 0;
        for (ComponentInst theComponent : arc) {
            SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSesionController.getComponentsOfSpace()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Current = '" + this.getManagedInstanceId() + "' Loop = '" + theComponent.getId() + "'"));
            m_Components[j++] = theComponent;
        }
        Arrays.sort(this.m_BrothersComponents);
        return m_Components;
    }

    public void setComponentPlace(String idComponentBefore) {
        int i;
        int orderNum = 0;
        ComponentInst theComponent = this.getComponentInst(this.getManagedInstanceId());
        for (i = 0; i < this.m_BrothersComponents.length; ++i) {
            if (idComponentBefore.equals(this.m_BrothersComponents[i].getId())) {
                theComponent.setOrderNum(orderNum);
                this.adminController.updateComponentOrderNum(theComponent.getId(), orderNum);
                ++orderNum;
            }
            if (this.m_BrothersComponents[i].getOrderNum() != orderNum) {
                this.m_BrothersComponents[i].setOrderNum(orderNum);
                this.adminController.updateComponentOrderNum(this.m_BrothersComponents[i].getId(), orderNum);
            }
            ++orderNum;
        }
        if (orderNum == i) {
            theComponent.setOrderNum(orderNum);
            this.adminController.updateComponentOrderNum(theComponent.getId(), orderNum);
            ++orderNum;
        }
        this.m_NavBarMgr.resetSpaceCache(this.getManagedSpaceId());
    }

    public void setMoveComponentToSpace(ComponentInst component, String destinationSpaceId, String idComponentBefore) throws AdminException {
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.setMoveComponentToSpace()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("component = " + component.getId() + " espace dest:" + destinationSpaceId + " idComponentBefore=" + idComponentBefore));
        String originSpace = component.getDomainFatherId();
        ComponentInst[] m_destBrothersComponents = this.getDestBrotherComponents(destinationSpaceId, true, component.getId());
        this.adminController.moveComponentInst(destinationSpaceId, component.getId(), idComponentBefore, m_destBrothersComponents);
        this.setManagedSpaceId(originSpace, false);
        this.m_NavBarMgr.resetAllCache();
    }

    public ComponentInst[] getDestBrotherComponents(String spaceId, boolean isNew, String componentId) {
        ArrayList arc = this.getSpaceInstById(spaceId).getAllComponentsInst();
        if (arc == null || arc.isEmpty()) {
            return ArrayUtil.EMPTY_COMPONENT_INSTANCE_ARRAY;
        }
        ComponentInst[] m_DestBrothersComponents = isNew ? new ComponentInst[arc.size()] : new ComponentInst[arc.size() - 1];
        int j = 0;
        for (ComponentInst theComponent : arc) {
            SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSesionController.getDestBrotherComponents()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Current = '" + componentId + "' Loop = '" + theComponent.getId() + "'"));
            if (!isNew && theComponent.getId().equals(componentId)) continue;
            m_DestBrothersComponents[j++] = theComponent;
        }
        Arrays.sort(this.m_BrothersComponents);
        return m_DestBrothersComponents;
    }

    public WAComponent[] getAllComponents() {
        Map resTable = this.adminController.getAllComponents();
        WAComponent[] componentsModels = resTable.values().toArray(new WAComponent[resTable.size()]);
        Arrays.sort(componentsModels, new Comparator<WAComponent>(){

            @Override
            public int compare(WAComponent o1, WAComponent o2) {
                String valcomp1 = o1.getSuite() + (String)o1.getLabel().get(I18NHelper.defaultLanguage);
                String valcomp2 = o2.getSuite() + (String)o2.getLabel().get(I18NHelper.defaultLanguage);
                return valcomp1.toUpperCase().compareTo(valcomp2.toUpperCase());
            }
        });
        return componentsModels;
    }

    public List<LocalizedComponent> getAllLocalizedComponents() {
        Map resTable = this.adminController.getAllComponents();
        ArrayList<LocalizedComponent> result = new ArrayList<LocalizedComponent>(resTable.size());
        for (WAComponent component : resTable.values()) {
            result.add(new LocalizedComponent(component, this.getLanguage()));
        }
        Collections.sort(result, new Comparator<LocalizedComponent>(){

            @Override
            public int compare(LocalizedComponent o1, LocalizedComponent o2) {
                String valcomp1 = o1.getSuite() + o1.getLabel();
                String valcomp2 = o2.getSuite() + o2.getLabel();
                return valcomp1.toUpperCase().compareTo(valcomp2.toUpperCase());
            }
        });
        return result;
    }

    public WAComponent getComponentByName(String name) {
        WAComponent[] compos = this.getAllComponents();
        if (compos != null) {
            for (WAComponent compo : compos) {
                if (!compo.getName().equals(name)) continue;
                return compo;
            }
        }
        return null;
    }

    public List<LocalizedParameter> getVisibleParameters(String appName, List<LocalizedParameter> parameters) {
        ArrayList<LocalizedParameter> visibleParameters = new ArrayList<LocalizedParameter>();
        for (LocalizedParameter parameter : parameters) {
            if (!parameter.isVisible()) continue;
            if (parameter.isXmlTemplate()) {
                parameter.setOptions(this.getVisibleTemplateOptions(appName, parameter));
            }
            visibleParameters.add(parameter);
        }
        return visibleParameters;
    }

    private List<LocalizedOption> getVisibleTemplateOptions(String appName, LocalizedParameter parameter) {
        GlobalContext aContext = new GlobalContext(this.getManagedSpaceId(), this.getManagedInstanceId());
        aContext.setComponentName(appName);
        PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
        List<LocalizedOption> options = parameter.getOptions();
        ArrayList<LocalizedOption> visibleOptions = new ArrayList<LocalizedOption>();
        for (LocalizedOption option : options) {
            String templateName = option.getValue();
            try {
                if (!templateManager.isPublicationTemplateVisible(templateName, aContext)) continue;
                visibleOptions.add(option);
            }
            catch (PublicationTemplateException e) {
                SilverTrace.error((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.getVisibleParameters", (String)"ERR_CANT_LOAD_TEMPLATE", (String)("templateName = " + templateName));
            }
        }
        return visibleOptions;
    }

    public String addComponentInst(ComponentInst componentInst) throws QuotaException {
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.addComponentInst()", (String)componentInst.getDomainFatherId(), (String)"CMP", (String)componentInst.getLabel(), (String)this.getUserDetail().getId(), (String)"1");
        componentInst.setCreatorUserId(this.getUserId());
        return this.adminController.addComponentInst(componentInst);
    }

    public ComponentInst getComponentInst(String sInstanceId) {
        ComponentInst component = this.adminController.getComponentInst(sInstanceId);
        component.setCreator(this.getUserDetail(component.getCreatorUserId()));
        component.setUpdater(this.getUserDetail(component.getUpdaterUserId()));
        component.setRemover(this.getUserDetail(component.getRemoverUserId()));
        return component;
    }

    public String updateComponentInst(ComponentInst componentInst) {
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.updateComponentInst()", (String)componentInst.getDomainFatherId(), (String)componentInst.getId(), (String)componentInst.getLabel(), (String)this.getUserDetail().getId(), (String)"3");
        componentInst.setUpdaterUserId(this.getUserId());
        return this.adminController.updateComponentInst(componentInst);
    }

    public String deleteComponentInst(String sInstanceId) {
        boolean definitiveDelete;
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.deleteComponentInst()", (String)"CMP", (String)sInstanceId, (String)"", (String)this.getUserDetail().getId(), (String)"2");
        boolean bl = definitiveDelete = !JobStartPagePeasSettings.isBasketEnable;
        if (JobStartPagePeasSettings.isBasketEnable && this.isUserAdmin()) {
            definitiveDelete = !JobStartPagePeasSettings.useBasketWhenAdmin;
        }
        return this.adminController.deleteComponentInst(sInstanceId, definitiveDelete);
    }

    public List<ProfileInst> getAllProfiles(ComponentInst m_FatherComponentInst) {
        String[] asAvailProfileNames;
        ArrayList<ProfileInst> alShowProfile = new ArrayList<ProfileInst>();
        String sComponentName = m_FatherComponentInst.getName();
        for (String profileName : asAvailProfileNames = this.adminController.getAllProfilesNames(sComponentName)) {
            SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.getAllProfilesNames()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("asAvailProfileNames = " + profileName));
            boolean bFound = false;
            ProfileInst profile = m_FatherComponentInst.getProfileInst(profileName);
            if (profile != null) {
                bFound = true;
                this.setProfileLabel(sComponentName, profileName, profile);
                alShowProfile.add(profile);
            }
            if (bFound) continue;
            profile = new ProfileInst();
            profile.setName(profileName);
            this.setProfileLabel(sComponentName, profileName, profile);
            alShowProfile.add(profile);
        }
        return alShowProfile;
    }

    private void setProfileLabel(String sComponentName, String profileName, ProfileInst profile) {
        String label = this.adminController.getProfileLabelfromName(sComponentName, profileName, this.getLanguage());
        if (!StringUtil.isDefined((String)label)) {
            label = this.adminController.getProfileLabelfromName(sComponentName, profileName, DisplayI18NHelper.getDefaultLanguage());
        }
        if (StringUtil.isDefined((String)label)) {
            profile.setLabel(label);
        }
    }

    public ProfileInst getProfile(String sProfileId, String sProfileName, String sProfileLabel) {
        if (StringUtil.isDefined((String)sProfileId)) {
            return this.adminController.getProfileInst(sProfileId);
        }
        ProfileInst res = new ProfileInst();
        res.setName(sProfileName);
        res.setLabel(sProfileLabel);
        return res;
    }

    public List<UserDetail> getAllCurrentUserInstance() {
        return this.userIds2users(this.getManagedProfile().getAllUsers());
    }

    public List<Group> getAllCurrentGroupInstance() {
        ArrayList alGroupIds = this.getManagedProfile().getAllGroups();
        return this.groupIds2groups(alGroupIds);
    }

    public List<Group> groupIds2groups(List<String> groupIds) {
        ArrayList<Group> res = new ArrayList<Group>();
        for (int nI = 0; groupIds != null && nI < groupIds.size(); ++nI) {
            Group theGroup = this.adminController.getGroupById(groupIds.get(nI));
            if (theGroup == null) continue;
            res.add(theGroup);
        }
        return res;
    }

    public List<UserDetail> userIds2users(List<String> userIds) {
        ArrayList<UserDetail> res = new ArrayList<UserDetail>();
        for (int nI = 0; userIds != null && nI < userIds.size(); ++nI) {
            UserDetail user = this.getUserDetail(userIds.get(nI));
            if (user == null) continue;
            res.add(user);
        }
        return res;
    }

    public void initUserPanelInstanceForGroupsUsers(String compoURL) throws SelectionException {
        String profileId = this.getManagedProfile().getId();
        String profile = this.getManagedProfile().getLabel();
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.initUserPanelInstanceForGroupsUsers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("profile = " + profile));
        String labelProfile = this.getMultilang().getString(profile.replace(' ', '_'));
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.initUserPanelInstanceForGroupsUsers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("labelProfile = " + labelProfile));
        if (!StringUtil.isDefined((String)labelProfile)) {
            labelProfile = profile;
        }
        this.selection.resetAll();
        String hostSpaceName = this.getMultilang().getString("JSPP.manageHomePage");
        this.selection.setHostSpaceName(hostSpaceName);
        SpaceInst space = this.getSpaceInstById();
        if (space != null) {
            PairObject hostComponentName;
            String idFather = space.getDomainFatherId();
            if (idFather != null && !idFather.equals("0")) {
                SpaceInst spaceFather = this.getSpaceInstById(idFather);
                hostComponentName = new PairObject((Object)(spaceFather.getName() + " > " + this.getSpaceInstById().getName()), null);
            } else {
                hostComponentName = new PairObject((Object)this.getSpaceInstById().getName(), null);
            }
            this.selection.setHostComponentName(hostComponentName);
        }
        ResourceLocator generalMessage = GeneralPropertiesManager.getGeneralMultilang((String)this.getLanguage());
        String compoName = this.getComponentInst(this.getManagedInstanceId()).getLabel();
        PairObject[] hostPath = new PairObject[]{new PairObject((Object)(compoName + " > " + labelProfile + " > " + generalMessage.getString("GML.selection")), null)};
        this.selection.setHostPath(hostPath);
        String hostUrl = compoURL + "EffectiveUpdateInstanceProfile";
        if (!StringUtil.isDefined((String)profileId)) {
            hostUrl = compoURL + "EffectiveCreateInstanceProfile";
        }
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.initUserPanelInstanceForGroupsUsers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("hostUrl=" + hostUrl));
        this.selection.setGoBackURL(hostUrl);
        this.selection.setCancelURL(compoURL + "CancelCreateOrUpdateInstanceProfile");
        ArrayList users = this.getManagedProfile().getAllUsers();
        ArrayList groups = this.getManagedProfile().getAllGroups();
        this.selection.setSelectedElements(users.toArray(new String[users.size()]));
        this.selection.setSelectedSets(groups.toArray(new String[groups.size()]));
    }

    public void createInstanceProfile() {
        ProfileInst profileInst = new ProfileInst();
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.createInstanceProfile()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("name='" + this.getManagedProfile().getName() + "'"));
        profileInst.setName(this.getManagedProfile().getName());
        profileInst.setLabel(this.getManagedProfile().getLabel());
        profileInst.setComponentFatherId(this.getManagedInstanceId());
        this.setGroupsAndUsers(profileInst, this.selection.getSelectedSets(), this.selection.getSelectedElements());
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.createInstanceProfile", (String)"unknown", (String)profileInst.getComponentFatherId(), (String)profileInst.getName(), (String)this.getUserId(), (String)"1");
        this.adminController.addProfileInst(profileInst, this.getUserId());
        this.setManagedProfile(profileInst);
    }

    public String updateInstanceProfile() {
        ProfileInst profile = new ProfileInst();
        profile.setId(this.getManagedProfile().getId());
        profile.setName(this.getManagedProfile().getName());
        profile.setLabel(this.getManagedProfile().getLabel());
        profile.setDescription(this.getManagedProfile().getDescription());
        profile.setComponentFatherId(this.getManagedProfile().getComponentFatherId());
        this.setGroupsAndUsers(profile, this.selection.getSelectedSets(), this.selection.getSelectedElements());
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.updateInstanceProfile", (String)"unknown", (String)profile.getComponentFatherId(), (String)profile.getName(), (String)this.getUserId(), (String)"3");
        this.setManagedProfile(profile);
        return this.adminController.updateProfileInst(profile, this.getUserId());
    }

    private void setGroupsAndUsers(ProfileInst profile, String[] groupIds, String[] userIds) {
        int i;
        for (i = 0; groupIds != null && i < groupIds.length; ++i) {
            if (groupIds[i] == null || groupIds[i].length() <= 0) continue;
            profile.addGroup(groupIds[i]);
        }
        for (i = 0; userIds != null && i < userIds.length; ++i) {
            if (userIds[i] == null || userIds[i].length() <= 0) continue;
            profile.addUser(userIds[i]);
        }
    }

    private void setGroupsAndUsers(SpaceProfileInst profile, String[] groupIds, String[] userIds) {
        int i;
        for (i = 0; groupIds != null && i < groupIds.length; ++i) {
            if (groupIds[i] == null || groupIds[i].length() <= 0) continue;
            profile.addGroup(groupIds[i]);
        }
        for (i = 0; userIds != null && i < userIds.length; ++i) {
            if (userIds[i] == null || userIds[i].length() <= 0) continue;
            profile.addUser(userIds[i]);
        }
    }

    public String deleteInstanceProfile() {
        ProfileInst profile = new ProfileInst();
        profile.setId(this.getManagedProfile().getId());
        profile.setName(this.getManagedProfile().getName());
        profile.setLabel(this.getManagedProfile().getLabel());
        profile.setDescription(this.getManagedProfile().getDescription());
        profile.setComponentFatherId(this.getManagedProfile().getComponentFatherId());
        SilverTrace.spy((String)"jobStartPagePeas", (String)"JobStartPagePeasSC.deleteInstanceProfile", (String)"unknown", (String)profile.getComponentFatherId(), (String)profile.getName(), (String)this.getUserId(), (String)"2");
        this.setManagedProfile(profile);
        return this.adminController.updateProfileInst(profile, this.getUserId());
    }

    public void updateProfileInstanceDescription(String name, String desc) {
        ArrayList users;
        ProfileInst profile = new ProfileInst();
        profile.setId(this.getManagedProfile().getId());
        profile.setName(this.getManagedProfile().getName());
        profile.setLabel(name);
        profile.setDescription(desc);
        profile.setComponentFatherId(this.getManagedProfile().getComponentFatherId());
        ArrayList groups = this.getManagedProfile().getAllGroups();
        if (groups != null) {
            for (String group : groups) {
                profile.addGroup(group);
            }
        }
        if ((users = this.getManagedProfile().getAllUsers()) != null) {
            for (String user : users) {
                profile.addUser(user);
            }
        }
        this.setManagedProfile(profile);
        this.adminController.updateProfileInst(profile);
    }

    public void copyComponent(String id) throws ClipboardException {
        this.copyOrCutComponent(id, false);
    }

    public void cutComponent(String id) throws ClipboardException {
        this.copyOrCutComponent(id, true);
    }

    private void copyOrCutComponent(String id, boolean cut) throws ClipboardException {
        ComponentInst componentInst = this.getComponentInst(id);
        ComponentSelection compoSelect = new ComponentSelection(componentInst);
        compoSelect.setCutted(cut);
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.copyComponent()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("clipboard = " + this.getClipboardName() + "' count=" + this.getClipboardCount()));
        this.addClipboardSelection((ClipboardSelection)compoSelect);
    }

    public void copySpace(String id) throws ClipboardException {
        this.copyOrCutSpace(id, false);
    }

    public void cutSpace(String id) throws ClipboardException {
        this.copyOrCutSpace(id, true);
    }

    private void copyOrCutSpace(String id, boolean cut) throws ClipboardException {
        SpaceInst space = this.getSpaceInstById(id);
        SpaceSelection spaceSelect = new SpaceSelection(space);
        spaceSelect.setCutted(cut);
        SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.copyOrCutSpace()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("clipboard = " + this.getClipboardName() + "' count=" + this.getClipboardCount()));
        this.addClipboardSelection((ClipboardSelection)spaceSelect);
    }

    public void paste(Map<String, String> options) throws ClipboardException, JobStartPagePeasException {
        try {
            SilverTrace.info((String)"jobStartPagePeas", (String)"JobStartPagePeasSessionController.pasteComponent()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("clipboard = " + this.getClipboardName() + " count=" + this.getClipboardCount()));
            Collection<ClipboardSelection> clipObjects = this.getClipboardSelectedObjects();
            boolean refreshCache = false;
            for (ClipboardSelection clipObject : clipObjects) {
                PasteDetail pasteDetail;
                if (clipObject == null) continue;
                if (clipObject.isDataFlavorSupported(ComponentSelection.ComponentDetailFlavor)) {
                    ComponentInst compo = (ComponentInst)clipObject.getTransferData(ComponentSelection.ComponentDetailFlavor);
                    if (clipObject.isCutted()) {
                        this.moveComponent(compo.getId());
                    } else {
                        pasteDetail = new PasteDetail(compo.getId(), this.getUserId());
                        pasteDetail.setOptions(options);
                        this.pasteComponent(pasteDetail);
                    }
                    refreshCache = true;
                    continue;
                }
                if (!clipObject.isDataFlavorSupported(SpaceSelection.SpaceFlavor)) continue;
                SpaceInst space = (SpaceInst)clipObject.getTransferData(SpaceSelection.SpaceFlavor);
                if (clipObject.isCutted()) {
                    this.moveSpace(space.getId());
                } else {
                    pasteDetail = new PasteDetail(this.getUserId());
                    pasteDetail.setFromSpaceId(space.getId());
                    pasteDetail.setOptions(options);
                    this.pasteSpace(pasteDetail);
                }
                refreshCache = true;
            }
            if (refreshCache) {
                this.m_NavBarMgr.resetAllCache();
            }
        }
        catch (Exception e) {
            throw new JobStartPagePeasException("JobStartPagePeasSessionController.paste()", 4, "jobStartPagePeas.EX_PASTE_ERROR", e);
        }
        this.clipboardPasteDone();
    }

    public Set<String> getCopiedComponents() throws JobStartPagePeasException {
        HashSet<String> copiedComponents = new HashSet<String>();
        try {
            Collection<ClipboardSelection> clipObjects = this.getClipboardSelectedObjects();
            for (ClipboardSelection clipObject : clipObjects) {
                String[] componentIds;
                if (clipObject == null) continue;
                if (clipObject.isDataFlavorSupported(ComponentSelection.ComponentDetailFlavor)) {
                    ComponentInst compo = (ComponentInst)clipObject.getTransferData(ComponentSelection.ComponentDetailFlavor);
                    if (clipObject.isCutted()) continue;
                    copiedComponents.add(compo.getName());
                    continue;
                }
                if (!clipObject.isDataFlavorSupported(SpaceSelection.SpaceFlavor)) continue;
                SpaceInst space = (SpaceInst)clipObject.getTransferData(SpaceSelection.SpaceFlavor);
                if (clipObject.isCutted()) continue;
                for (String componentId : componentIds = this.getOrganisationController().getAllComponentIdsRecur(space.getId())) {
                    String componentName = StringUtil.splitByCharacterType((String)componentId)[0];
                    copiedComponents.add(componentName);
                }
            }
        }
        catch (Exception e) {
            throw new JobStartPagePeasException("JobStartPagePeasSessionController.getCopiedComponents()", 4, "jobStartPagePeas.EX_PASTE_ERROR", e);
        }
        return copiedComponents;
    }

    private void pasteComponent(PasteDetail pasteDetail) throws JobStartPagePeasException {
        try {
            pasteDetail.setToSpaceId(this.getManagedSpaceId());
            String sComponentId = this.adminController.copyAndPasteComponent(pasteDetail);
            if (StringUtil.isDefined((String)sComponentId)) {
                this.setManagedInstanceId(sComponentId);
                this.refreshCurrentSpaceCache();
            }
        }
        catch (Exception e) {
            throw new JobStartPagePeasException("JobStartPagePeasSessionController.pasteComponent()", 4, "jobStartPagePeas.EX_PASTE_ERROR", "componentId = " + pasteDetail.getFromComponentId() + " in space " + this.getManagedSpaceId(), e);
        }
    }

    private void moveComponent(String componentId) throws AdminException {
        this.adminController.moveComponentInst(this.getManagedSpaceId(), componentId, null, null);
    }

    private void pasteSpace(PasteDetail pasteDetail) throws JobStartPagePeasException {
        try {
            pasteDetail.setToSpaceId(this.getManagedSpaceId());
            String newSpaceId = this.adminController.copyAndPasteSpace(pasteDetail);
            if (StringUtil.isDefined((String)newSpaceId)) {
                if (StringUtil.isDefined((String)this.getManagedSpaceId())) {
                    this.refreshCurrentSpaceCache();
                } else {
                    this.m_NavBarMgr.addSpaceInCache(newSpaceId);
                }
            }
        }
        catch (Exception e) {
            throw new JobStartPagePeasException("JobStartPagePeasSessionController.pasteSpace()", 4, "jobStartPagePeas.EX_PASTE_ERROR", "spaceId = " + pasteDetail.getFromSpaceId() + " in space " + this.getManagedSpaceId(), e);
        }
    }

    private void moveSpace(String spaceId) throws AdminException {
        this.moveSpace(spaceId, this.getManagedSpaceId());
    }

    public void moveSpace(String spaceId, String targetSpaceId) throws AdminException {
        this.adminController.moveSpace(spaceId, targetSpaceId);
    }

    public int getCurrentSpaceMaintenanceState() {
        if (this.isAppInMaintenance()) {
            return 1;
        }
        if (this.isSpaceInMaintenance(this.getManagedSpaceId())) {
            return 3;
        }
        List spaces = this.getOrganisationController().getSpacePath(this.getManagedSpaceId());
        for (SpaceInst space : spaces) {
            if (!this.isSpaceInMaintenance(space.getId())) continue;
            return 2;
        }
        return 0;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getScope() {
        return this.scope;
    }

    public SilverpeasTemplate getSilverpeasTemplate() {
        Properties configuration = new Properties(templateConfiguration);
        SilverpeasTemplate template = SilverpeasTemplateFactory.createSilverpeasTemplate((Properties)configuration);
        return template;
    }
}

