/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.look;

import com.silverpeas.look.LookHelper;
import com.silverpeas.look.PublicationHelper;
import com.silverpeas.look.Shortcut;
import com.silverpeas.look.SilverpeasLook;
import com.silverpeas.look.TopItem;
import com.silverpeas.personalization.UserMenuDisplay;
import com.silverpeas.personalization.service.PersonalizationService;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.session.SessionManagementFactory;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.ejb.EJBException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.OrganisationController;

public class LookSilverpeasV5Helper
implements LookHelper {
    private OrganisationController orga = null;
    private ResourceLocator resources = null;
    private ResourceLocator messages = null;
    private ResourceLocator defaultMessages = null;
    private MainSessionController mainSC = null;
    private String userId = null;
    private boolean displayPDCInNav = false;
    private boolean shouldDisplayPDCFrame = false;
    private boolean shouldDisplayContextualPDC = true;
    private boolean shouldDisplaySpaceIcons = true;
    private boolean shouldDisplayConnectedUsers = true;
    private boolean displayPDCInHomePage = true;
    private List<TopItem> topItems = null;
    private List<String> topSpaceIds = null;
    private String mainFrame = "MainFrameSilverpeasV5.jsp";
    private String spaceId = null;
    private String subSpaceId = null;
    private String componentId = null;
    private SimpleDateFormat formatter = null;
    private PublicationHelper kmeliaTransversal = null;
    private PublicationBm publicationBm = null;
    private UserMenuDisplay displayUserMenu = UserMenuDisplay.DISABLE;
    private boolean enableUFSContainsState = false;

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
        if (!spaceId.startsWith("WA")) {
            this.spaceId = "WA" + spaceId;
        }
    }

    @Override
    public String getSubSpaceId() {
        return this.subSpaceId;
    }

    @Override
    public void setSubSpaceId(String subSpaceId) {
        this.subSpaceId = subSpaceId;
        if (!subSpaceId.startsWith("WA")) {
            this.subSpaceId = "WA" + subSpaceId;
        }
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    @Override
    public void setSpaceIdAndSubSpaceId(String spaceId) {
        if (StringUtil.isDefined((String)spaceId)) {
            List spacePath = this.orga.getSpacePath(spaceId);
            if (!spacePath.isEmpty()) {
                SpaceInst space = (SpaceInst)spacePath.get(0);
                SpaceInst subSpace = (SpaceInst)spacePath.get(spacePath.size() - 1);
                this.setSpaceId(space.getId());
                this.setSubSpaceId(subSpace.getId());
            }
            this.setComponentId(null);
        }
    }

    @Override
    public void setComponentIdAndSpaceIds(String spaceId, String subSpaceId, String componentId) {
        this.setComponentId(componentId);
        if (!StringUtil.isDefined((String)spaceId)) {
            List spacePath = this.orga.getSpacePathToComponent(componentId);
            if (!spacePath.isEmpty()) {
                SpaceInst space = (SpaceInst)spacePath.get(0);
                SpaceInst subSpace = (SpaceInst)spacePath.get(spacePath.size() - 1);
                this.setSpaceId(space.getId());
                this.setSubSpaceId(subSpace.getId());
            }
        } else {
            this.setSpaceId(spaceId);
            this.setSubSpaceId(subSpaceId);
        }
    }

    public LookSilverpeasV5Helper(MainSessionController mainSessionController, ResourceLocator resources) {
        this.init(mainSessionController, resources);
    }

    @Override
    public final void init(MainSessionController mainSessionController, ResourceLocator resources) {
        this.mainSC = mainSessionController;
        this.orga = mainSessionController.getOrganisationController();
        this.userId = mainSessionController.getUserId();
        this.resources = resources;
        this.defaultMessages = new ResourceLocator("com.silverpeas.lookSilverpeasV5.multilang.lookBundle", mainSessionController.getFavoriteLanguage());
        if (StringUtil.isDefined((String)resources.getString("MessageBundle"))) {
            this.messages = new ResourceLocator(resources.getString("MessageBundle"), mainSessionController.getFavoriteLanguage());
        }
        this.initProperties();
        this.getTopItems();
    }

    private void initProperties() {
        this.displayPDCInNav = this.resources.getBoolean("displayPDCInNav", false);
        this.shouldDisplayPDCFrame = this.resources.getBoolean("displayPDCFrame", false);
        this.shouldDisplayContextualPDC = this.resources.getBoolean("displayContextualPDC", true);
        this.shouldDisplaySpaceIcons = this.resources.getBoolean("displaySpaceIcons", true);
        this.shouldDisplayConnectedUsers = this.resources.getBoolean("displayConnectedUsers", true);
        this.displayPDCInHomePage = this.resources.getBoolean("displayPDCInHomePage", true);
        if (this.isAnonymousUser()) {
            this.displayUserMenu = UserMenuDisplay.DISABLE;
        } else {
            this.displayUserMenu = UserMenuDisplay.valueOf((String)this.resources.getString("displayUserFavoriteSpace", PersonalizationService.DEFAULT_MENU_DISPLAY_MODE.name()).toUpperCase());
            if (this.isMenuPersonalisationEnabled() && this.mainSC.getPersonalization().getDisplay().isNotDefault()) {
                this.displayUserMenu = this.mainSC.getPersonalization().getDisplay();
            }
            this.enableUFSContainsState = this.resources.getBoolean("enableUFSContainsState", false);
        }
    }

    @Override
    public boolean isMenuPersonalisationEnabled() {
        return UserMenuDisplay.DISABLE != UserMenuDisplay.valueOf((String)this.resources.getString("displayUserFavoriteSpace", PersonalizationService.DEFAULT_MENU_DISPLAY_MODE.name()).toUpperCase());
    }

    protected MainSessionController getMainSessionController() {
        return this.mainSC;
    }

    protected OrganisationController getOrganisationController() {
        return this.orga;
    }

    @Override
    public String getUserFullName(String userId) {
        return this.orga.getUserDetail(userId).getDisplayedName();
    }

    @Override
    public String getUserFullName() {
        return this.orga.getUserDetail(this.userId).getDisplayedName();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public UserDetail getUserDetail() {
        return this.orga.getUserDetail(this.userId);
    }

    public UserFull getUserFull() {
        return this.orga.getUserFull(this.userId);
    }

    @Override
    public String getLanguage() {
        return this.mainSC.getFavoriteLanguage();
    }

    @Override
    public boolean isAnonymousUser() {
        if (StringUtil.isDefined((String)this.userId)) {
            return UserDetail.isAnonymousUser((String)this.userId);
        }
        return false;
    }

    @Override
    public boolean displayPDCInNavigationFrame() {
        return this.displayPDCInNav;
    }

    @Override
    public boolean displayPDCFrame() {
        return this.shouldDisplayPDCFrame;
    }

    @Override
    public boolean displayContextualPDC() {
        return this.shouldDisplayContextualPDC;
    }

    @Override
    public boolean displaySpaceIcons() {
        return this.shouldDisplaySpaceIcons;
    }

    @Override
    public String getSpaceId(String componentId) {
        ComponentInstLight component = this.orga.getComponentInstLight(componentId);
        if (component != null) {
            return component.getDomainFatherId();
        }
        return null;
    }

    @Override
    public String getWallPaper(String spaceId) {
        String hasWallpaper = "0";
        if (StringUtil.isDefined((String)spaceId) && SilverpeasLook.getSilverpeasLook().hasSpaceWallpaper(spaceId)) {
            hasWallpaper = "1";
        }
        return hasWallpaper;
    }

    @Override
    public int getNBConnectedUsers() {
        int nbConnectedUsers = 0;
        if (this.shouldDisplayConnectedUsers) {
            SessionManagementFactory factory = SessionManagementFactory.getFactory();
            SessionManagement sessionManagement = factory.getSessionManagement();
            nbConnectedUsers = sessionManagement.getNbConnectedUsersList(this.getMainSessionController().getCurrentUserDetail()) - 1;
        }
        return nbConnectedUsers;
    }

    @Override
    public boolean isAnonymousAccess() {
        return this.isAnonymousUser();
    }

    @Override
    public boolean getSettings(String key) {
        return this.resources.getBoolean(key, false);
    }

    @Override
    public boolean getSettings(String key, boolean defaultValue) {
        return this.resources.getBoolean(key, defaultValue);
    }

    @Override
    public String getSettings(String key, String defaultValue) {
        return this.resources.getString(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        if (key.startsWith("lookSilverpeasV5")) {
            return this.defaultMessages.getString(key, "");
        }
        return this.messages.getString(key, "");
    }

    @Override
    public boolean isBackOfficeVisible() {
        return this.mainSC.isBackOfficeVisible();
    }

    @Override
    public List<TopItem> getTopItems() {
        if (this.topItems == null) {
            this.topItems = new ArrayList<TopItem>();
            this.topSpaceIds = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.resources.getString("componentsTop", ""), ",");
            while (tokenizer.hasMoreTokens()) {
                String itemId = tokenizer.nextToken();
                if (itemId.startsWith("WA")) {
                    if (!this.orga.isSpaceAvailable(itemId, this.userId)) continue;
                    SpaceInstLight space = this.orga.getSpaceInstLightById(itemId);
                    SpaceInstLight rootSpace = this.orga.getRootSpace(itemId);
                    TopItem item = new TopItem();
                    item.setLabel(space.getName(this.getLanguage()));
                    item.setSpaceId(rootSpace.getFullId());
                    item.setSubSpaceId(itemId);
                    this.topItems.add(item);
                    this.topSpaceIds.add(item.getSpaceId());
                    continue;
                }
                if (!this.orga.isComponentAvailable(itemId, this.userId)) continue;
                ComponentInstLight component = this.orga.getComponentInstLight(itemId);
                String currentSpaceId = component.getDomainFatherId();
                SpaceInstLight rootSpace = this.orga.getRootSpace(currentSpaceId);
                TopItem item = new TopItem();
                item.setLabel(component.getLabel(this.getLanguage()));
                item.setComponentId(itemId);
                item.setSpaceId(rootSpace.getFullId());
                item.setSubSpaceId(currentSpaceId);
                this.topItems.add(item);
            }
        }
        return this.topItems;
    }

    @Override
    public List<String> getTopSpaceIds() {
        return this.topSpaceIds;
    }

    @Override
    public String getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public void setMainFrame(String newMainFrame) {
        if (StringUtil.isDefined((String)newMainFrame)) {
            this.mainFrame = newMainFrame;
        }
    }

    @Override
    public String getSpaceWallPaper() {
        String theSpaceId = this.getCurrentDeepestSpaceId();
        if (StringUtil.isDefined((String)theSpaceId)) {
            return SilverpeasLook.getSilverpeasLook().getWallpaperOfSpace(theSpaceId);
        }
        return null;
    }

    @Override
    public String getSpaceWithCSSToApply() {
        String spaceId = this.getCurrentDeepestSpaceId();
        if (StringUtil.isDefined((String)spaceId)) {
            return SilverpeasLook.getSilverpeasLook().getSpaceWithCSS(spaceId);
        }
        return null;
    }

    private String getCurrentDeepestSpaceId() {
        String theSpaceId = this.getSpaceId();
        if (StringUtil.isDefined((String)theSpaceId) && StringUtil.isDefined((String)this.getSubSpaceId())) {
            theSpaceId = this.getSubSpaceId();
        }
        return theSpaceId;
    }

    public String getComponentURL(String key, String function) {
        String currentFunction = function;
        String currentComponentId = this.resources.getString(key);
        if (!StringUtil.isDefined((String)function)) {
            currentFunction = "Main";
        }
        return URLManager.getApplicationURL() + URLManager.getURL((String)"useless", (String)currentComponentId) + currentFunction;
    }

    @Override
    public String getComponentURL(String key) {
        return this.getComponentURL(key, "Main");
    }

    @Override
    public String getDate() {
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat(this.resources.getString("DateFormat", "dd/MM/yyyy"), new Locale(this.mainSC.getFavoriteLanguage()));
        }
        return this.formatter.format(new Date());
    }

    @Override
    public String getDefaultSpaceId() {
        String defaultSpaceId = this.resources.getString("DefaultSpaceId");
        if (!StringUtil.isDefined((String)defaultSpaceId)) {
            defaultSpaceId = this.mainSC.getFavoriteSpace();
        }
        return defaultSpaceId;
    }

    private PublicationHelper getPublicationHelper() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.kmeliaTransversal == null) {
            String helperClassName = this.resources.getString("publicationHelper", "com.stratelia.webactiv.kmelia.KmeliaTransversal");
            Class<?> helperClass = Class.forName(helperClassName);
            this.kmeliaTransversal = (PublicationHelper)helperClass.newInstance();
            this.kmeliaTransversal.setMainSessionController(this.mainSC);
        }
        return this.kmeliaTransversal;
    }

    @Override
    public List<PublicationDetail> getLatestPublications(String spaceId, int nbPublis) {
        try {
            return this.getPublicationHelper().getPublications(spaceId, nbPublis);
        }
        catch (ClassNotFoundException ex) {
            return new ArrayList<PublicationDetail>();
        }
        catch (InstantiationException ex) {
            return new ArrayList<PublicationDetail>();
        }
        catch (IllegalAccessException ex) {
            return new ArrayList<PublicationDetail>();
        }
    }

    @Override
    public List<PublicationDetail> getValidPublications(NodePK nodePK) {
        List publis = (List)this.getPublicationBm().getDetailsByFatherPK(nodePK, null, true);
        ArrayList<PublicationDetail> filteredPublis = new ArrayList<PublicationDetail>();
        for (int i = 0; publis != null && i < publis.size(); ++i) {
            PublicationDetail publi = (PublicationDetail)publis.get(i);
            if (!"Valid".equalsIgnoreCase(publi.getStatus())) continue;
            filteredPublis.add(publi);
        }
        return filteredPublis;
    }

    public PublicationBm getPublicationBm() {
        if (this.publicationBm == null) {
            try {
                this.publicationBm = (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
        return this.publicationBm;
    }

    public String getSpaceHomePage(String spaceId, HttpServletRequest request) throws UnsupportedEncodingException {
        SpaceInst spaceStruct = this.getOrganisationController().getSpaceInstById(spaceId);
        if (spaceStruct != null && spaceStruct.getFirstPageType() == 1 && spaceStruct.getFirstPageExtraParam() != null && spaceStruct.getFirstPageExtraParam().length() > 0 && this.getOrganisationController().isComponentAvailable(spaceStruct.getFirstPageExtraParam(), this.getUserId())) {
            return URLManager.getSimpleURL((int)1, (String)spaceStruct.getFirstPageExtraParam());
        }
        if (spaceStruct != null && spaceStruct.getFirstPageType() == 3 && spaceStruct.getFirstPageExtraParam() != null && spaceStruct.getFirstPageExtraParam().length() > 0) {
            String destination = spaceStruct.getFirstPageExtraParam();
            destination = this.getParsedDestination(destination, "%ST_USER_LOGIN%", this.getMainSessionController().getCurrentUserDetail().getLogin());
            destination = this.getParsedDestination(destination, "%ST_USER_FULLNAME%", URLEncoder.encode(this.getMainSessionController().getCurrentUserDetail().getDisplayedName(), "UTF-8"));
            destination = this.getParsedDestination(destination, "%ST_USER_ID%", URLEncoder.encode(this.getMainSessionController().getUserId(), "UTF-8"));
            destination = this.getParsedDestination(destination, "%ST_SESSION_ID%", URLEncoder.encode(request.getSession().getId(), "UTF-8"));
            HttpSession session = request.getSession();
            return this.getParsedDestination(destination, "%ST_USER_PASSWORD%", (String)session.getAttribute("Silverpeas_pwdForHyperlink"));
        }
        return null;
    }

    private String getParsedDestination(String sDestination, String sKeyword, String sValue) {
        String parsedDestination = sDestination;
        int nLoginIndex = sDestination.indexOf(sKeyword);
        if (nLoginIndex != -1) {
            String sParsed = sDestination.substring(0, nLoginIndex);
            sParsed = sParsed + sValue;
            if (sDestination.length() > nLoginIndex + sKeyword.length()) {
                sParsed = sParsed + sDestination.substring(nLoginIndex + sKeyword.length(), sDestination.length());
            }
            parsedDestination = sParsed;
        }
        return parsedDestination;
    }

    @Override
    public UserMenuDisplay getDisplayUserMenu() {
        return this.displayUserMenu;
    }

    @Override
    public void setDisplayUserMenu(UserMenuDisplay displayUserMenu) {
        this.displayUserMenu = displayUserMenu;
    }

    @Override
    public boolean isEnableUFSContainsState() {
        return this.enableUFSContainsState;
    }

    public List<Shortcut> getShortcuts(String id, int nb) {
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (int i = 1; i <= nb; ++i) {
            String prefix = "Shortcut." + id + "." + i;
            String url = this.getSettings(prefix + ".Url", "toBeDefined");
            String target = this.getSettings(prefix + ".Target", "toBeDefined");
            String altText = this.getSettings(prefix + ".AltText", "toBeDefined");
            String iconUrl = this.getSettings(prefix + ".IconUrl", "toBeDefined");
            Shortcut shortcut = new Shortcut(iconUrl, target, url, altText);
            shortcuts.add(shortcut);
        }
        return shortcuts;
    }

    @Override
    public boolean isDisplayPDCInHomePage() {
        return this.displayPDCInHomePage;
    }
}

