/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.look;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.silverpeas.core.admin.OrganisationController;

public class SilverpeasLook {
    public static final String DEFAULT_WALLPAPER_PROPERTY = "wallPaper";
    public static final String SPACE_CSS = "styles";
    private static SilverpeasLook look = new SilverpeasLook();
    @Inject
    private OrganisationController organizationController;

    public static SilverpeasLook getSilverpeasLook() {
        return look;
    }

    public boolean hasSpaceWallpaper(String spaceId) {
        return StringUtil.isDefined((String)this.getWallPaperURL(spaceId));
    }

    public String getWallpaperOfSpace(String spaceId) {
        List path = this.organizationController.getSpacePath(spaceId);
        for (int i = path.size() - 1; i >= 0; --i) {
            SpaceInst space = (SpaceInst)path.get(i);
            String wallpaperURL = this.getWallPaperURL(space.getId());
            if (!StringUtil.isDefined((String)wallpaperURL)) continue;
            return wallpaperURL;
        }
        return null;
    }

    public String getWallpaperOfSpaceOrDefaultOne(String spaceId) {
        GraphicElementFactory elementFactory;
        String wallpaperURL = this.getWallpaperOfSpace(spaceId);
        if (!StringUtil.isDefined((String)wallpaperURL) && !StringUtil.isDefined((String)(wallpaperURL = (elementFactory = new GraphicElementFactory("Initial")).getIcon(DEFAULT_WALLPAPER_PROPERTY)))) {
            wallpaperURL = FileServerUtils.getApplicationContext() + "/admin/jsp/icons/silverpeasV5/bandeauTop.jpg";
        }
        return wallpaperURL;
    }

    private String getWallPaperURL(String spaceId) {
        String id = this.getShortSpaceId(spaceId);
        String basePath = this.getSpaceBasePath(id);
        File dir = new File(basePath);
        if (dir.exists() && dir.isDirectory()) {
            Collection wallpapers = FileUtils.listFiles((File)dir, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)DEFAULT_WALLPAPER_PROPERTY, (IOCase)IOCase.INSENSITIVE), null);
            for (File wallpaper : wallpapers) {
                if (!wallpaper.isFile() || !FileUtil.isImage((String)wallpaper.getName())) continue;
                return this.getURLOfElement(id, wallpaper.getName());
            }
        }
        return null;
    }

    public String getSpaceWithCSS(String spaceId) {
        List path = this.organizationController.getSpacePath(spaceId);
        Collections.reverse(path);
        for (SpaceInst space : path) {
            String url = this.getSpaceCSSURL(space.getId());
            if (!StringUtil.isDefined((String)url)) continue;
            return this.getShortSpaceId(space.getId());
        }
        return null;
    }

    public String getCSSOfSpace(String spaceId) {
        List path = this.organizationController.getSpacePath(spaceId);
        Collections.reverse(path);
        for (SpaceInst space : path) {
            String url = this.getSpaceCSSURL(space.getId());
            if (!StringUtil.isDefined((String)url)) continue;
            return url;
        }
        return null;
    }

    private String getSpaceCSSURL(String spaceId) {
        String filename;
        File css;
        String id = this.getShortSpaceId(spaceId);
        File dir = new File(this.getSpaceBasePath(id));
        if (dir.exists() && dir.isDirectory() && (css = new File(dir, filename = "styles.css")) != null && css.exists()) {
            return this.getURLOfElement(id, filename);
        }
        return null;
    }

    public String getSpaceBasePath(String spaceId) {
        return FileRepositoryManager.getAbsolutePath((String)("Space" + spaceId), (String[])new String[]{"look"});
    }

    private String getURLOfElement(String spaceId, String filename) {
        return FileServerUtils.getOnlineURL((String)("Space" + spaceId), (String)filename, (String)filename, (String)FileUtil.getMimeType((String)filename), (String)"look");
    }

    private String getShortSpaceId(String spaceId) {
        if (spaceId.startsWith("WA")) {
            return spaceId.substring(2);
        }
        return spaceId;
    }

    private SilverpeasLook() {
    }
}

