/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.pdc.web.AxisValueCriterion;
import com.silverpeas.pdc.web.PdcEntity;
import com.silverpeas.pdc.web.PdcFilterCriteria;
import com.silverpeas.pdc.web.PdcServiceProvider;
import com.silverpeas.pdc.web.UserThesaurusHolder;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.web.RESTWebService;
import com.stratelia.silverpeas.pdc.model.UsedAxis;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="pdc/filter")
@Authenticated
public class FilteredPdcResource
extends RESTWebService {
    @Inject
    private PdcServiceProvider pdcServiceProvider;

    @GET
    @Produces(value={"application/json"})
    @Path(value="used")
    public PdcEntity getPdcFilteredByClassifiedContents(@QueryParam(value="workspaceId") String workspaceId, @QueryParam(value="componentId") String componentId, @QueryParam(value="withSecondaryAxis") boolean withSecondaryAxis, @QueryParam(value="values") String axisValues) {
        PdcFilterCriteria criteria = new PdcFilterCriteria().onWorkspace(workspaceId).onComponentInstance(componentId).onSecondaryAxisInclusion(withSecondaryAxis).onUser(this.getUserDetail());
        this.setAxisValues(criteria, axisValues);
        try {
            List<UsedAxis> axis = this.pdcServiceProvider().getAxisUsedInClassificationsByCriteria(criteria);
            UserPreferences userPreferences = this.getUserPreferences();
            return PdcEntity.aPdcEntityWithUsedAxis(PdcEntity.withAxis(axis), PdcEntity.inLanguage(userPreferences.getLanguage()), PdcEntity.atURI(this.getUriInfo().getRequestUri()), this.withThesaurusAccordingTo(userPreferences));
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, ex.getMessage());
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public String getComponentId() {
        return null;
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private void setAxisValues(PdcFilterCriteria criteria, String axisValues) {
        List<AxisValueCriterion> axisValuesCriteria = AxisValueCriterion.fromFlattenedAxisValues(axisValues);
        criteria.onAxisValues(axisValuesCriteria);
    }

    private UserThesaurusHolder withThesaurusAccordingTo(UserPreferences userPreferences) {
        UserThesaurusHolder thesaurus = PdcEntity.NoThesaurus;
        if (userPreferences.isThesaurusEnabled()) {
            thesaurus = this.pdcServiceProvider().getThesaurusOfUser(this.getUserDetail());
        }
        return thesaurus;
    }
}

