/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.pdc.web.LocalizedValue;
import com.stratelia.silverpeas.classifyEngine.ClassifyEngineException;
import com.stratelia.silverpeas.pdc.model.ClassifyValue;
import com.stratelia.silverpeas.pdc.model.Value;
import java.util.List;

public class LocalizedClassifyValue
extends ClassifyValue
implements LocalizedValue {
    private static final long serialVersionUID = -8345717889242896633L;
    private final String language;
    private final ClassifyValue decoratedValue;

    public static LocalizedClassifyValue decorate(ClassifyValue value, String forLanguage) {
        return new LocalizedClassifyValue(value, forLanguage);
    }

    @Override
    public String getLocalizedPath() {
        String path = this.getFullPath().size() > 5 ? this.buildTruncatedPath() : this.buildPathBetween(0, this.getFullPath().size());
        if (path.equals(" / ")) {
            path = "";
        }
        return path;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public String getAxisName() {
        return this.getDecoratedValue().getAxisName();
    }

    public List<Value> getFullPath() {
        return this.getDecoratedValue().getFullPath();
    }

    public void setAxisName(String axisName) {
        this.getDecoratedValue().setAxisName(axisName);
    }

    public void setFullPath(List<Value> fullPath) {
        this.getDecoratedValue().setFullPath(fullPath);
    }

    public String toString() {
        return this.getDecoratedValue().toString();
    }

    public void checkValue() throws ClassifyEngineException {
        this.getDecoratedValue().checkValue();
    }

    public int getAxisId() {
        return this.getDecoratedValue().getAxisId();
    }

    public int getPhysicalAxisId() {
        return this.getDecoratedValue().getPhysicalAxisId();
    }

    public String getValue() {
        return this.getDecoratedValue().getValue();
    }

    public void setAxisId(int nGivenAxisId) {
        this.getDecoratedValue().setAxisId(nGivenAxisId);
    }

    public void setPhysicalAxisId(int id) {
        this.getDecoratedValue().setPhysicalAxisId(id);
    }

    public void setValue(String sGivenValue) {
        this.getDecoratedValue().setValue(sGivenValue);
    }

    public boolean equals(Object o) {
        return this.getDecoratedValue().equals(o);
    }

    public int hashCode() {
        return this.getDecoratedValue().hashCode();
    }

    private LocalizedClassifyValue(ClassifyValue value, String language) {
        this.decoratedValue = value;
        this.language = language;
    }

    private ClassifyValue getDecoratedValue() {
        return this.decoratedValue;
    }

    private String buildTruncatedPath() {
        int nodeCount = this.getFullPath().size();
        return this.buildPathBetween(0, 2) + " / " + " ... " + " / " + this.buildPathBetween(nodeCount - 2, nodeCount);
    }

    private String buildPathBetween(int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= this.getFullPath().size() || endIndex < startIndex) {
            throw new IndexOutOfBoundsException("The indexes are out of bounds (startIndex=" + startIndex + ", endIndex=" + endIndex + ")");
        }
        String path = "";
        for (int i = 0; i < endIndex; ++i) {
            Value value = this.getFullPath().get(i);
            path = path + value.getName(this.getLanguage()) + " / ";
        }
        return path.substring(0, path.length() - 2);
    }
}

