/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.pdc.model.PdcAxisValue;
import com.silverpeas.pdc.web.LocalizedValue;
import com.stratelia.silverpeas.pdc.model.ClassifyValue;
import com.stratelia.silverpeas.pdc.model.PdcException;
import java.util.Set;

public class LocalizedPdcAxisValue
extends PdcAxisValue
implements LocalizedValue {
    private static final long serialVersionUID = 3041692821847135712L;
    private final String language;
    private final PdcAxisValue decoratedValue;

    public static LocalizedPdcAxisValue decorate(PdcAxisValue value, String forLanguage) {
        return new LocalizedPdcAxisValue(value, forLanguage);
    }

    @Override
    public String getLocalizedPath() {
        String path = this.getMeaningTranslatedIn(this.getLanguage());
        String[] pathNodes = path.split("/");
        if (pathNodes.length > 5) {
            path = this.buildTruncatedPath(pathNodes);
        }
        if (path.equals(" / ")) {
            path = "";
        }
        return path;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public String toString() {
        return this.decoratedValue.toString();
    }

    public ClassifyValue toClassifyValue() throws PdcException {
        return this.decoratedValue.toClassifyValue();
    }

    public boolean isBaseValue() {
        return this.decoratedValue.isBaseValue();
    }

    public String getValuePath() {
        return this.decoratedValue.getValuePath();
    }

    public String getTermTranslatedIn(String language) {
        return this.decoratedValue.getTermTranslatedIn(language);
    }

    public String getTerm() {
        return this.decoratedValue.getTerm();
    }

    public PdcAxisValue getParentValue() {
        return this.decoratedValue.getParentValue();
    }

    public String getMeaningTranslatedIn(String language) {
        return this.decoratedValue.getMeaningTranslatedIn(language);
    }

    public String getMeaning() {
        return this.decoratedValue.getMeaning();
    }

    public String getId() {
        return this.decoratedValue.getId();
    }

    public Set<PdcAxisValue> getChildValues() {
        return this.decoratedValue.getChildValues();
    }

    public String getAxisId() {
        return this.decoratedValue.getAxisId();
    }

    private LocalizedPdcAxisValue(PdcAxisValue value, String forLanguage) {
        this.decoratedValue = value;
        this.language = forLanguage;
    }

    private String buildTruncatedPath(String[] splitedPath) {
        int nodeCount = splitedPath.length;
        return this.buildPathBetween(splitedPath, 0, 2) + " / " + " ... " + " / " + this.buildPathBetween(splitedPath, nodeCount - 2, nodeCount);
    }

    private String buildPathBetween(String[] splitedPath, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= splitedPath.length || endIndex < startIndex) {
            throw new IndexOutOfBoundsException("The indexes are out of bounds (startIndex=" + startIndex + ", endIndex=" + endIndex + ")");
        }
        String path = "";
        for (int i = startIndex; i < endIndex; ++i) {
            path = path + splitedPath[i] + " / ";
        }
        return path.substring(0, path.length() - 2);
    }
}

