/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.pdc.web.PdcValueEntity;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.pdc.model.Value;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class PdcAxisValueEntity
extends PdcValueEntity {
    private static final long serialVersionUID = -1689709605873362349L;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private String term;
    @XmlElement(required=true)
    @NotNull
    @Min(value=0L)
    private int level;
    @XmlElement(defaultValue="false")
    private boolean ascendant = false;
    @XmlElement(defaultValue="false")
    private boolean origin = false;
    @XmlElement(defaultValue="0")
    private int classifiedContentsCount = 0;

    public static PdcAxisValueEntity fromValue(Value value, String inLanguage) {
        String axisId = value.getAxisId();
        if (!StringUtil.isDefined((String)axisId) || axisId.equalsIgnoreCase("unknown")) {
            axisId = value.getTreeId();
        }
        PdcAxisValueEntity axisValue = new PdcAxisValueEntity(PdcAxisValueEntity.withId(value.getFullPath()), PdcAxisValueEntity.withTerm(value.getName(inLanguage)), PdcAxisValueEntity.inAxis(axisId)).withClassifiedContents(value.getNbObjects()).inTree(value.getTreeId(), PdcAxisValueEntity.atLevel(value.getLevelNumber()));
        return axisValue;
    }

    public String getTerm() {
        return this.term;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isAscendant() {
        return this.ascendant;
    }

    public int getClassifiedContentsCount() {
        return this.classifiedContentsCount;
    }

    @XmlTransient
    public boolean isRootValue() {
        return this.getId().equals("/0/");
    }

    public boolean isOrigin() {
        return this.origin;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcAxisValueEntity other = (PdcAxisValueEntity)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.term == null ? other.term != null : !this.term.equals(other.term)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.ascendant != other.ascendant) {
            return false;
        }
        return this.origin == other.origin;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 83 * super.hashCode();
        hash = 83 * hash + (this.term != null ? this.term.hashCode() : 0);
        hash = 83 * hash + this.level;
        hash = 83 * hash + (this.ascendant ? 1 : 0);
        hash = 83 * hash + (this.origin ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder synonymArray = new StringBuilder("[");
        for (String synonym : this.getSynonyms()) {
            synonymArray.append(synonym).append(", ");
        }
        if (synonymArray.length() > 1) {
            synonymArray.replace(synonymArray.length() - 2, synonymArray.length(), "]");
        } else {
            synonymArray.append("]");
        }
        return "PdcAxisValue{id=" + this.getId() + ", axisId=" + this.getAxisId() + ", treeId=" + this.getTreeId() + ", term=" + this.getTerm() + ", level=" + this.getLevel() + ", ascendant=" + this.isAscendant() + ", origin=" + this.isOrigin() + ", classifiedContentsCount=" + this.getClassifiedContentsCount() + ", synonyms=" + synonymArray.toString() + "}";
    }

    private static String withId(String id) {
        return id;
    }

    private static String withTerm(String term) {
        return term;
    }

    private static int inAxis(String axisId) {
        return Integer.valueOf(axisId);
    }

    private static int atLevel(int levelNumber) {
        return levelNumber;
    }

    protected PdcAxisValueEntity() {
    }

    protected void setAsOriginValue() {
        this.origin = true;
        this.ascendant = false;
    }

    protected void setAsAscendant() {
        this.ascendant = true;
        this.origin = false;
    }

    private PdcAxisValueEntity(String withId, String withTerm, int inAxisId) {
        super(withId, inAxisId);
        this.term = withTerm;
    }

    private PdcAxisValueEntity inTree(String treeId, int levelInTree) {
        this.setTreeId(treeId);
        this.level = levelInTree;
        return this;
    }

    private PdcAxisValueEntity withClassifiedContents(int count) {
        this.classifiedContentsCount = count;
        return this;
    }
}

