/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.pdc.web.PdcClassificationEntity;
import com.silverpeas.pdc.web.PdcPositionDeletionException;
import com.silverpeas.pdc.web.PdcPositionEntity;
import com.silverpeas.pdc.web.PdcServiceProvider;
import com.silverpeas.pdc.web.UserThesaurusHolder;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.web.RESTWebService;
import com.stratelia.silverpeas.contentManager.ContentManagerException;
import com.stratelia.silverpeas.pdc.model.ClassifyPosition;
import com.stratelia.silverpeas.pdc.model.PdcException;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="pdc/classification/{componentId:[a-zA-Z]+[0-9]+}/{contentId}")
@Authorized
public class PdcClassificationResource
extends RESTWebService {
    @Inject
    private PdcServiceProvider pdcServiceProvider;
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="contentId")
    private String contentId;

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    protected String getContentId() {
        return this.contentId;
    }

    @GET
    @Produces(value={"application/json"})
    public PdcClassificationEntity getPdCClassification() {
        try {
            URI itsURI = this.getUriInfo().getAbsolutePath();
            return this.thePdcClassificationOfTheRequestedResource(PdcClassificationResource.identifiedBy(itsURI));
        }
        catch (ContentManagerException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (PdcException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @DELETE
    @Path(value="{positionId}")
    public void deletePdcPosition(@PathParam(value="positionId") int positionId) {
        try {
            this.pdcServiceProvider().deletePosition(positionId, PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
        }
        catch (ContentManagerException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getMessage());
        }
        catch (PdcPositionDeletionException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getMessage());
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        catch (PdcException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getMessage());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addPdcPosition(PdcPositionEntity newPosition) {
        if (newPosition.getPositionValues().isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ClassifyPosition position = newPosition.toClassifyPosition();
            this.pdcServiceProvider().addPosition(position, PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
            String positionId = String.valueOf(position.getPositionId());
            URI newPositionURI = this.getUriInfo().getAbsolutePathBuilder().path(positionId).build(new Object[0]);
            URI itsURI = this.getUriInfo().getAbsolutePath();
            return Response.created((URI)newPositionURI).entity((Object)this.thePdcClassificationOfTheRequestedResource(PdcClassificationResource.identifiedBy(itsURI))).build();
        }
        catch (ContentManagerException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (PdcException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{positionId}")
    public PdcClassificationEntity updatePdcPosition(@PathParam(value="positionId") String positionId, PdcPositionEntity modifiedPosition) {
        if (!positionId.equals(modifiedPosition.getId()) || modifiedPosition.getPositionValues().isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ClassifyPosition position = modifiedPosition.toClassifyPosition();
            this.pdcServiceProvider().updatePosition(position, PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
            URI itsURI = this.getUriInfo().getBaseUriBuilder().path("pdc/classification/{componentId}/{contentId}").build(new Object[]{this.getComponentId(), this.getContentId()});
            return this.thePdcClassificationOfTheRequestedResource(PdcClassificationResource.identifiedBy(itsURI));
        }
        catch (ContentManagerException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (PdcException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private PdcClassificationEntity thePdcClassificationOfTheRequestedResource(URI uri) throws Exception {
        UserPreferences userPreferences = this.getUserPreferences();
        List<ClassifyPosition> contentPositions = this.pdcServiceProvider().getAllPositions(PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
        PdcClassificationEntity theClassificationEntity = PdcClassificationEntity.aPdcClassificationEntity(PdcClassificationEntity.fromPositions(contentPositions), PdcClassificationEntity.inLanguage(userPreferences.getLanguage()), PdcClassificationEntity.atURI(uri));
        if (userPreferences.isThesaurusEnabled()) {
            UserThesaurusHolder theUserThesaurus = this.pdcServiceProvider().getThesaurusOfUser(this.getUserDetail());
            theClassificationEntity.withSynonymsFrom(theUserThesaurus);
        }
        return theClassificationEntity;
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private static URI identifiedBy(URI uri) {
        return uri;
    }
}

