/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.pdc.web.PdcAxis;
import com.silverpeas.pdc.web.UserThesaurusHolder;
import com.silverpeas.thesaurus.ThesaurusException;
import com.silverpeas.web.Exposable;
import com.stratelia.silverpeas.pdc.model.Axis;
import com.stratelia.silverpeas.pdc.model.UsedAxis;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class PdcEntity
implements Exposable {
    private static final long serialVersionUID = 6798294501268706300L;
    public static final UserThesaurusHolder NoThesaurus = null;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement
    private List<PdcAxis> axis = new ArrayList<PdcAxis>();

    public static PdcEntity aPdcEntityWithUsedAxis(List<UsedAxis> usedAxis, String inLanguage, URI atURI, UserThesaurusHolder withThesaurus) throws ThesaurusException {
        return new PdcEntity(atURI).withAsAxis(PdcEntity.fromUsedAxis(usedAxis, inLanguage, withThesaurus));
    }

    public static PdcEntity aPdcEntityWithAxis(List<Axis> usedAxis, String inLanguage, URI atURI, UserThesaurusHolder withThesaurus) throws ThesaurusException {
        return new PdcEntity(atURI).withAsAxis(PdcEntity.fromAxis(usedAxis, inLanguage, withThesaurus));
    }

    public static List<UsedAxis> withAxis(List<UsedAxis> axis) {
        return axis;
    }

    public static String inLanguage(String language) {
        return language;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public List<PdcAxis> getAxis() {
        return Collections.unmodifiableList(this.axis);
    }

    public PdcEntity withAsAxis(List<PdcAxis> axis) {
        this.axis.addAll(axis);
        return this;
    }

    public static URI atURI(URI uri) {
        return uri;
    }

    protected PdcEntity() {
    }

    private static List<PdcAxis> fromUsedAxis(List<UsedAxis> theAxisToUse, String inLanguage, UserThesaurusHolder usingThesaurus) throws ThesaurusException {
        ArrayList<PdcAxis> axis = new ArrayList<PdcAxis>();
        for (UsedAxis usedAxis : theAxisToUse) {
            axis.add(PdcAxis.fromTheUsedAxis(usedAxis, inLanguage, usingThesaurus));
        }
        return axis;
    }

    private static List<PdcAxis> fromAxis(List<Axis> theAxis, String inLanguage, UserThesaurusHolder usingThesaurus) throws ThesaurusException {
        ArrayList<PdcAxis> axis = new ArrayList<PdcAxis>();
        for (Axis anAxis : theAxis) {
            axis.add(PdcAxis.fromTheAxis(anAxis, inLanguage, usingThesaurus));
        }
        return axis;
    }

    private PdcEntity(URI atURI) {
        this.uri = atURI;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcEntity other = (PdcEntity)obj;
        if (!(this.uri == other.uri || this.uri != null && this.uri.equals(other.uri))) {
            return false;
        }
        return this.axis == other.axis || this.axis != null && ((Object)this.axis).equals(other.axis);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 47 * hash + (this.axis != null ? ((Object)this.axis).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder axisArray = new StringBuilder("[");
        for (PdcAxis anAxis : this.getAxis()) {
            axisArray.append(anAxis.toString()).append(", ");
        }
        if (axisArray.length() > 1) {
            axisArray.replace(axisArray.length() - 2, axisArray.length(), "]");
        } else {
            axisArray.append("]");
        }
        return "PdcEntity{uri=" + this.getURI() + ", axis=" + axisArray.toString() + '}';
    }
}

