/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.pdc.model.PdcClassification;
import com.silverpeas.pdc.web.PdcClassificationEntity;
import com.silverpeas.pdc.web.PdcServiceProvider;
import com.silverpeas.pdc.web.UserThesaurusHolder;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.web.RESTWebService;
import com.stratelia.silverpeas.pdc.model.PdcException;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="pdc/classification/{componentId:[a-zA-Z]+[0-9]+}")
@Authorized
public class PdcPredefinedClassificationResource
extends RESTWebService {
    private static final String BASE_URI_PATH = "pdc/classification/{componentId:[a-zA-Z]+[0-9]+}";
    @Inject
    private PdcServiceProvider pdcServiceProvider;
    @PathParam(value="componentId")
    private String componentId;

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Produces(value={"application/json"})
    public PdcClassificationEntity getPredefinedPdCClassificationForContentsInNode(@QueryParam(value="nodeId") String nodeId) {
        try {
            PdcClassification theClassification = this.pdcServiceProvider().findPredefinedClassificationForContentsIn(nodeId, this.getComponentId());
            return this.asWebEntity(theClassification, PdcPredefinedClassificationResource.identifiedBy(this.theUriOf(theClassification)));
        }
        catch (PdcException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createPredefinedPdcClassification(@QueryParam(value="nodeId") String nodeId, PdcClassificationEntity classification) {
        PdcClassification alreadyExistingClassification = this.pdcServiceProvider().getPredefinedClassification(nodeId, this.getComponentId());
        if (alreadyExistingClassification != PdcClassification.NONE_CLASSIFICATION) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        try {
            PdcClassification savedClassification = this.pdcServiceProvider().saveOrUpdatePredefinedClassification(this.fromWebEntity(classification));
            URI theClassificationURI = this.theUriOf(savedClassification);
            return Response.created((URI)theClassificationURI).entity((Object)this.asWebEntity(savedClassification, PdcPredefinedClassificationResource.identifiedBy(theClassificationURI))).build();
        }
        catch (ConstraintViolationException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (PdcException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PdcClassificationEntity updatePredefinedPdcClassification(@QueryParam(value="nodeId") String nodeId, PdcClassificationEntity classification) {
        try {
            PdcClassification classificationToUpdate = this.pdcServiceProvider().findPredefinedClassificationForContentsIn(nodeId, this.getComponentId());
            if (nodeId != null && !nodeId.equals(classificationToUpdate.getNodeId())) {
                throw new PdcException(PdcPredefinedClassificationResource.class.getSimpleName(), 4, "root.EX_NO_MESSAGE");
            }
            classificationToUpdate = (classification.isModifiable() ? classificationToUpdate.modifiable() : classificationToUpdate.unmodifiable()).withPositions(classification.getPdcPositions());
            PdcClassification updatedClassification = this.pdcServiceProvider().saveOrUpdatePredefinedClassification(classificationToUpdate);
            return this.asWebEntity(updatedClassification, PdcPredefinedClassificationResource.identifiedBy(this.theUriOf(updatedClassification)));
        }
        catch (ConstraintViolationException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (PdcException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private PdcClassificationEntity asWebEntity(PdcClassification classification, URI uri) throws Exception {
        PdcClassificationEntity theClassificationEntity;
        if (classification == PdcClassification.NONE_CLASSIFICATION) {
            theClassificationEntity = PdcClassificationEntity.undefinedClassification();
            theClassificationEntity.setModifiable(false);
        } else {
            UserPreferences userPreferences = this.getUserPreferences();
            theClassificationEntity = PdcClassificationEntity.aPdcClassificationEntity(PdcClassificationEntity.fromPdcClassification(classification), PdcClassificationEntity.inLanguage(userPreferences.getLanguage()), PdcClassificationEntity.atURI(uri));
            theClassificationEntity.setModifiable(classification.isModifiable());
            if (userPreferences.isThesaurusEnabled()) {
                UserThesaurusHolder theUserThesaurus = this.pdcServiceProvider().getThesaurusOfUser(this.getUserDetail());
                theClassificationEntity.withSynonymsFrom(theUserThesaurus);
            }
        }
        return theClassificationEntity;
    }

    private PdcClassification fromWebEntity(PdcClassificationEntity entity) {
        String nodeId = (String)this.getUriInfo().getQueryParameters().getFirst((Object)"nodeId");
        PdcClassification classification = PdcClassification.aPredefinedPdcClassificationForComponentInstance((String)this.getComponentId()).forNode(nodeId).withPositions(entity.getPdcPositions());
        if (entity.isModifiable()) {
            classification.modifiable();
        } else {
            classification.unmodifiable();
        }
        return classification;
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private static URI identifiedBy(URI uri) {
        return uri;
    }

    private URI theUriOf(PdcClassification classification) {
        URI uri = null;
        uri = classification.isPredefinedForANode() ? this.getUriInfo().getBaseUriBuilder().path(BASE_URI_PATH).queryParam("nodeId", new Object[]{classification.getNodeId()}).build(new Object[]{classification.getComponentInstanceId()}) : this.getUriInfo().getBaseUriBuilder().path(BASE_URI_PATH).build(new Object[]{classification.getComponentInstanceId()});
        return uri;
    }
}

