/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.pdc.web.PdcEntity;
import com.silverpeas.pdc.web.PdcServiceProvider;
import com.silverpeas.pdc.web.UserThesaurusHolder;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import com.silverpeas.web.UserPriviledgeValidation;
import com.silverpeas.web.UserPriviledgeValidationFactory;
import com.stratelia.silverpeas.contentManager.ContentManagerException;
import com.stratelia.silverpeas.pdc.model.Axis;
import com.stratelia.silverpeas.pdc.model.UsedAxis;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="pdc")
@Authenticated
public class PdcResource
extends RESTWebService {
    @Inject
    private PdcServiceProvider pdcServiceProvider;
    private String componentId;

    @GET
    @Path(value="{componentId:[a-zA-Z]+[0-9]+}")
    @Produces(value={"application/json"})
    public PdcEntity getPdcForClassification(@PathParam(value="componentId") String component, @QueryParam(value="contentId") String content) {
        this.setComponentId(component);
        try {
            List<UsedAxis> axis = StringUtil.isDefined((String)content) ? this.pdcServiceProvider().getAxisUsedInPdcToClassify(content, PdcServiceProvider.inComponentOfId(this.getComponentId())) : this.pdcServiceProvider().getAxisUsedInPdcFor(this.getComponentId());
            UserPreferences userPreferences = this.getUserPreferences();
            return PdcEntity.aPdcEntityWithUsedAxis(axis, PdcEntity.inLanguage(userPreferences.getLanguage()), PdcEntity.atURI(this.getUriInfo().getRequestUri()), this.withThesaurusAccordingTo(userPreferences));
        }
        catch (ContentManagerException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public PdcEntity getPdc() {
        try {
            List<Axis> axis = this.pdcServiceProvider().getAllAxis();
            UserPreferences userPreferences = this.getUserPreferences();
            return PdcEntity.aPdcEntityWithAxis(axis, PdcEntity.inLanguage(userPreferences.getLanguage()), PdcEntity.atURI(this.getUriInfo().getRequestUri()), this.withThesaurusAccordingTo(userPreferences));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    private void setComponentId(String componentId) {
        int index = componentId.indexOf("?contentId");
        this.componentId = index > 0 ? componentId.substring(0, index) : componentId;
        UserPriviledgeValidationFactory factory = UserPriviledgeValidationFactory.getFactory();
        UserPriviledgeValidation validation = factory.getUserPriviledgeValidation();
        this.validateUserAuthorization(validation);
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private UserThesaurusHolder withThesaurusAccordingTo(UserPreferences userPreferences) {
        UserThesaurusHolder thesaurus = PdcEntity.NoThesaurus;
        if (userPreferences.isThesaurusEnabled()) {
            thesaurus = this.pdcServiceProvider().getThesaurusOfUser(this.getUserDetail());
        }
        return thesaurus;
    }
}

