/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.pdc.model.PdcClassification;
import com.silverpeas.pdc.service.PdcClassificationService;
import com.silverpeas.pdc.web.AxisValueCriterion;
import com.silverpeas.pdc.web.PdcFilterCriteria;
import com.silverpeas.pdc.web.PdcPositionDeletionException;
import com.silverpeas.pdc.web.UserThesaurusHolder;
import com.silverpeas.thesaurus.control.ThesaurusManager;
import com.stratelia.silverpeas.contentManager.ContentManager;
import com.stratelia.silverpeas.contentManager.ContentManagerException;
import com.stratelia.silverpeas.pdc.control.PdcBm;
import com.stratelia.silverpeas.pdc.model.Axis;
import com.stratelia.silverpeas.pdc.model.AxisHeader;
import com.stratelia.silverpeas.pdc.model.ClassifyPosition;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.pdc.model.SearchContext;
import com.stratelia.silverpeas.pdc.model.SearchCriteria;
import com.stratelia.silverpeas.pdc.model.UsedAxis;
import com.stratelia.silverpeas.pdc.model.Value;
import com.stratelia.webactiv.beans.admin.ComponentSearchCriteria;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.admin.OrganisationController;

@Named
public class PdcServiceProvider {
    @Inject
    private PdcBm pdcBm;
    @Inject
    private ThesaurusManager thesaurusManager;
    @Inject
    private ContentManager contentManager;
    @Inject
    private PdcClassificationService classificationService;
    @Inject
    private OrganisationController organisationController;

    public static String inComponentOfId(String componentId) {
        return componentId;
    }

    public static String forContentOfId(String contentId) {
        return contentId;
    }

    public void addPosition(ClassifyPosition position, String contentId, String componentId) throws ContentManagerException, PdcException {
        int silverObjectId = this.getSilverObjectId(contentId, componentId);
        int positionId = this.getPdcBm().addPosition(silverObjectId, position, componentId);
        position.setPositionId(positionId);
    }

    public void updatePosition(ClassifyPosition position, String contentId, String componentId) throws ContentManagerException, PdcException {
        int silverObjectId = this.getSilverObjectId(contentId, componentId);
        this.getPdcBm().updatePosition(position, componentId, silverObjectId);
    }

    public void deletePosition(int positionId, String contentId, String componentId) throws PdcException, ContentManagerException {
        List<UsedAxis> axis = this.getAxisUsedInPdcFor(componentId);
        List<ClassifyPosition> positions = this.getAllPositions(contentId, componentId);
        if (positions.size() == 1) {
            for (UsedAxis anAxis : axis) {
                if (anAxis.getMandatory() != 1) continue;
                throw new PdcPositionDeletionException(this.getClass().getSimpleName(), 4, "Pdc.CANNOT_DELETE_VALUE");
            }
        }
        this.getPdcBm().deletePosition(positionId, componentId);
    }

    public List<ClassifyPosition> getAllPositions(String contentId, String componentId) throws ContentManagerException, PdcException {
        int silverObjectId = this.getSilverObjectId(contentId, componentId);
        return this.getPdcBm().getPositions(silverObjectId, componentId);
    }

    PdcClassification findPredefinedClassificationForContentsIn(String nodeId, String componentId) {
        return this.classificationService.findAPreDefinedClassification(nodeId, componentId);
    }

    PdcClassification getPredefinedClassification(String nodeId, String componentId) {
        return this.classificationService.getPreDefinedClassification(nodeId, componentId);
    }

    PdcClassification saveOrUpdatePredefinedClassification(PdcClassification predefinedClassification) {
        PdcClassification savedClassification = this.classificationService.savePreDefinedClassification(predefinedClassification);
        if (savedClassification == PdcClassification.NONE_CLASSIFICATION) {
            savedClassification = this.findPredefinedClassificationForContentsIn(predefinedClassification.getNodeId(), predefinedClassification.getComponentInstanceId());
        }
        return savedClassification;
    }

    public List<UsedAxis> getAxisUsedInPdcToClassify(String contentId, String inComponentId) throws ContentManagerException, PdcException {
        int silverObjectId = this.getSilverObjectId(contentId, inComponentId);
        return this.getPdcBm().getUsedAxisToClassify(inComponentId, silverObjectId);
    }

    public List<UsedAxis> getAxisUsedInPdcFor(String componentId) throws PdcException {
        return this.getPdcBm().getUsedAxisToClassify(componentId, -1);
    }

    public UserThesaurusHolder getThesaurusOfUser(UserDetail user) {
        return UserThesaurusHolder.holdThesaurus(this.getThesaurusManager(), UserThesaurusHolder.forUser(user));
    }

    public List<UsedAxis> getAxisUsedInClassificationsByCriteria(PdcFilterCriteria criteria) throws PdcException {
        ArrayList<UsedAxis> usedAxis = new ArrayList<UsedAxis>();
        ComponentSearchCriteria searchCriteria = new ComponentSearchCriteria().onComponentInstance(criteria.getComponentInstanceId()).onWorkspace(criteria.getWorkspaceId()).onUser(criteria.getUser());
        SearchContext searchContext = this.setUpSearchContextFromCriteria(criteria);
        List availableComponents = this.getOrganisationController().getSearchableComponentsByCriteria(searchCriteria);
        List allAxis = this.getPdcBm().getAxisByType("P");
        List<UsedAxis> filteredAxis = this.filterAxis(allAxis, searchContext, availableComponents);
        usedAxis.addAll(filteredAxis);
        if (criteria.hasSecondaryAxisToBeIncluded()) {
            allAxis = this.getPdcBm().getAxisByType("S");
            filteredAxis = this.filterAxis(allAxis, searchContext, availableComponents);
            usedAxis.addAll(filteredAxis);
        }
        return usedAxis;
    }

    public List<Axis> getAllAxis() throws PdcException {
        ArrayList<Axis> pdcAxis = new ArrayList<Axis>();
        List headers = this.getPdcBm().getAxis();
        for (AxisHeader aHeader : headers) {
            String treeId = this.getPdcBm().getTreeId(aHeader.getPK().getId());
            List values = this.getPdcBm().getAxisValues(Integer.valueOf(treeId).intValue());
            pdcAxis.add(new Axis(aHeader, values));
        }
        return pdcAxis;
    }

    private PdcBm getPdcBm() {
        return this.pdcBm;
    }

    private ContentManager getContentManager() {
        return this.contentManager;
    }

    private ThesaurusManager getThesaurusManager() {
        return this.thesaurusManager;
    }

    public OrganisationController getOrganisationController() {
        return this.organisationController;
    }

    private int getSilverObjectId(String ofTheContent, String inTheComponent) throws ContentManagerException {
        return this.getContentManager().getSilverContentId(ofTheContent, inTheComponent);
    }

    private SearchContext setUpSearchContextFromCriteria(PdcFilterCriteria criteria) {
        SearchContext context = new SearchContext();
        if (criteria.hasCriterionOnUser()) {
            context.setUserId(criteria.getUser().getId());
        }
        if (criteria.hasCriterionOnAxisValues()) {
            for (AxisValueCriterion axisValueCriterion : criteria.getAxisValues()) {
                context.addCriteria((SearchCriteria)axisValueCriterion);
            }
        }
        return context;
    }

    private UsedAxis createUsedAxis(AxisHeader axisHeader, List<Value> values) throws PdcException {
        UsedAxis axis = new UsedAxis(axisHeader.getPK().getId(), "", axisHeader.getRootId(), 0, 0, 1);
        axis._setAxisHeader(axisHeader);
        axis._setAxisName(axisHeader.getName());
        axis._setAxisType(axisHeader.getAxisType());
        axis._setBaseValueName(axisHeader.getName());
        axis._setAxisRootId(Integer.parseInt(this.getPdcBm().getRoot(axisHeader.getPK().getId()).getValuePK().getId()));
        axis._setAxisValues(values);
        return axis;
    }

    private List<UsedAxis> filterAxis(List<AxisHeader> axisHeaders, SearchContext searchContext, List<String> availableComponents) throws PdcException {
        ArrayList<UsedAxis> filteredAxis = new ArrayList<UsedAxis>();
        for (AxisHeader axisHeader : axisHeaders) {
            List values = this.getPdcBm().getPertinentDaughterValuesByInstanceIds(searchContext, axisHeader.getPK().getId(), "0", availableComponents);
            if (values == null || values.isEmpty()) continue;
            UsedAxis usedAxis = this.createUsedAxis(axisHeader, values);
            filteredAxis.add(usedAxis);
        }
        return filteredAxis;
    }
}

