/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.pdc.web;

import com.silverpeas.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class PdcValueEntity
implements Serializable {
    private static final long serialVersionUID = 7830451202912691112L;
    @XmlElement(required=true)
    private String id;
    @XmlElement(required=true)
    private int axisId;
    @XmlElement(defaultValue="")
    private String treeId = "";
    @XmlElement
    private List<String> synonyms = new ArrayList<String>();

    public String getId() {
        return this.id;
    }

    @XmlTransient
    public String getTermId() {
        String[] idNodes = this.id.split("/");
        return idNodes[idNodes.length - 1];
    }

    public int getAxisId() {
        return this.axisId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public boolean belongToATree() {
        return StringUtil.isDefined((String)this.treeId) && !this.treeId.isEmpty();
    }

    public List<String> getSynonyms() {
        return Collections.unmodifiableList(this.synonyms);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PdcValueEntity)) {
            return false;
        }
        PdcValueEntity other = (PdcValueEntity)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.axisId != other.axisId) {
            return false;
        }
        if (this.treeId == null ? other.treeId != null : !this.treeId.equals(other.treeId)) {
            return false;
        }
        return this.synonyms == other.synonyms || this.synonyms != null && ((Object)this.synonyms).equals(other.synonyms);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 89 * hash + this.axisId;
        hash = 89 * hash + (this.treeId != null ? this.treeId.hashCode() : 0);
        hash = 89 * hash + (this.synonyms != null ? ((Object)this.synonyms).hashCode() : 0);
        return hash;
    }

    protected PdcValueEntity() {
    }

    protected PdcValueEntity(String id, int axisId) {
        this.id = id;
        this.axisId = axisId;
    }

    protected void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    protected void setSynonyms(Collection<String> synonyms) {
        this.synonyms.clear();
        this.synonyms.addAll(synonyms);
    }
}

