/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.peasUtil;

import com.silverpeas.look.LookHelper;
import com.silverpeas.peasUtil.AccessForbiddenException;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.SilverpeasWebUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.silverpeas.util.Charsets;

public abstract class GoTo
extends HttpServlet {
    private static final long serialVersionUID = -8381001443484846645L;
    protected static SilverpeasWebUtil util = new SilverpeasWebUtil();

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        SilverTrace.info((String)"peasUtil", (String)"GoTo.doPost", (String)"root.MSG_GEN_ENTER_METHOD");
        String id = this.getObjectId(req);
        try {
            SilverTrace.info((String)"peasUtil", (String)"GoTo.doPost", (String)"root.MSG_GEN_PARAM_VALUE", (String)("id = " + id));
            String redirect = this.getDestination(id, req, res);
            if (!StringUtil.isDefined((String)redirect)) {
                this.objectNotFound(req, res);
            } else if (!res.isCommitted()) {
                if (redirect == null || !redirect.startsWith("http")) {
                    redirect = URLManager.getApplicationURL() + "/autoRedirect.jsp?" + redirect;
                }
                res.sendRedirect(res.encodeRedirectURL(redirect));
            }
        }
        catch (AccessForbiddenException afe) {
            this.accessForbidden(req, res);
        }
        catch (Exception e) {
            this.objectNotFound(req, res);
        }
    }

    public abstract String getDestination(String var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    private void objectNotFound(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean isLoggedIn = this.isUserLogin(req);
        if (!isLoggedIn) {
            res.sendRedirect("/weblib/notFound.html");
        } else {
            res.sendRedirect(URLManager.getApplicationURL() + "/admin/jsp/documentNotFound.jsp");
        }
    }

    private void accessForbidden(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.sendRedirect(URLManager.getApplicationURL() + "/admin/jsp/accessForbidden.jsp");
    }

    public String getObjectId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo.substring(1);
        }
        return null;
    }

    public boolean isUserLogin(HttpServletRequest req) {
        return util.getMainSessionController(req) != null;
    }

    public boolean isUserAllowed(HttpServletRequest req, String componentId) {
        MainSessionController mainSessionCtrl = util.getMainSessionController(req);
        if (componentId == null) {
            return true;
        }
        return mainSessionCtrl.getOrganisationController().isComponentAvailable(componentId, mainSessionCtrl.getUserId());
    }

    public String getUserId(HttpServletRequest req) {
        return util.getMainSessionController(req).getUserId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayError(HttpServletResponse res) {
        SilverTrace.info((String)"peasUtil", (String)"GoToFile.displayError()", (String)"root.MSG_GEN_ENTER_METHOD");
        res.setContentType("text/html");
        ServletOutputStream out = null;
        StringBuilder message = new StringBuilder(255);
        message.append("<HTML>").append("<BODY>").append("</BODY>").append("</HTML>");
        try {
            out = res.getOutputStream();
            out.write(message.toString().getBytes(Charsets.UTF_8));
        }
        catch (IOException e) {
            SilverTrace.warn((String)"peasUtil", (String)"GoToFile.displayError", (String)"root.EX_CANT_READ_FILE");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    protected void setGefSpaceId(HttpServletRequest req, String componentId) {
        if (StringUtil.isDefined((String)componentId)) {
            HttpSession session = req.getSession(true);
            GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
            LookHelper helper = (LookHelper)session.getAttribute("Silverpeas_LookHelper");
            if (gef != null && helper != null) {
                helper.setComponentIdAndSpaceIds(null, null, componentId);
                String helperSpaceId = helper.getSubSpaceId();
                if (!StringUtil.isDefined((String)helperSpaceId)) {
                    helperSpaceId = helper.getSpaceId();
                }
                gef.setSpaceId(helperSpaceId);
            }
        }
    }
}

