/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.peasUtil;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.exporters.RSS_2_0_Exporter;
import de.nava.informa.impl.basic.Channel;
import de.nava.informa.impl.basic.Item;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public abstract class RssServlet<T>
extends HttpServlet {
    private static final long serialVersionUID = 1756308502037077021L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        SilverTrace.info((String)"peasUtil", (String)"RssServlet.doPost", (String)"root.MSG_GEN_ENTER_METHOD");
        String instanceId = this.getObjectId(req);
        String userId = this.getUserId(req);
        String login = this.getLogin(req);
        String password = this.getPassword(req);
        if (this.isComponentRss(instanceId)) {
            try {
                SilverTrace.info((String)"peasUtil", (String)"RssServlet.doPost", (String)"root.MSG_GEN_PARAM_VALUE", (String)("InstanceId = " + instanceId));
                AdminController adminController = new AdminController(null);
                UserFull user = adminController.getUserFull(userId);
                if (user != null && login.equals(user.getLogin()) && password.equals(user.getPassword()) && this.isComponentAvailable(adminController, instanceId, userId)) {
                    String serverURL = this.getServerURL(adminController, user.getDomainId());
                    Channel channel = new Channel();
                    int nbReturnedElements = this.getNbReturnedElements();
                    Collection<T> listElements = this.getListElements(instanceId, nbReturnedElements);
                    for (T element : listElements) {
                        String title = this.getElementTitle(element, userId);
                        URL link2 = new URL(serverURL + this.getElementLink(element, userId));
                        String description = this.getElementDescription(element, userId);
                        Date dateElement = this.getElementDate(element);
                        String creatorId = this.getElementCreatorId(element);
                        Item item = new Item();
                        item.setTitle(title);
                        item.setLink(link2);
                        item.setDescription(description);
                        item.setDate(dateElement);
                        if (StringUtil.isDefined((String)creatorId)) {
                            UserDetail creator = adminController.getUserDetail(creatorId);
                            if (creator != null) {
                                item.setCreator(creator.getDisplayedName());
                            }
                        } else if (StringUtil.isDefined((String)this.getExternalCreatorId(element))) {
                            item.setCreator(this.getExternalCreatorId(element));
                        }
                        channel.addItem((ItemIF)item);
                    }
                    channel.setTitle(this.getChannelTitle(instanceId));
                    URL componentUrl = new URL(serverURL + URLManager.getApplicationURL() + URLManager.getURL((String)"useless", (String)instanceId));
                    channel.setLocation(componentUrl);
                    res.setContentType("application/rss+xml");
                    res.setHeader("Content-Disposition", "inline; filename=feeds.rss");
                    PrintWriter writer = res.getWriter();
                    RSS_2_0_Exporter rssExporter = new RSS_2_0_Exporter((Writer)writer, "UTF-8");
                    rssExporter.write((ChannelIF)channel);
                } else {
                    this.objectNotFound(req, res);
                }
            }
            catch (Exception e) {
                this.objectNotFound(req, res);
            }
        }
    }

    public String getChannelTitle(String instanceId) {
        ComponentInstLight instance = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(instanceId);
        if (instance != null) {
            return instance.getLabel();
        }
        return "";
    }

    public String getServerURL(AdminController admin, String domainId) {
        Domain defaultDomain = admin.getDomain(domainId);
        return defaultDomain.getSilverpeasServerURL();
    }

    public boolean isComponentRss(String instanceId) {
        String paramRssValue = OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(instanceId, "rss");
        return "yes".equalsIgnoreCase(paramRssValue);
    }

    public boolean isComponentAvailable(AdminController admin, String instanceId, String userId) {
        return admin.isComponentAvailable(instanceId, userId);
    }

    public int getNbReturnedElements() {
        return 15;
    }

    public abstract Collection<T> getListElements(String var1, int var2) throws RemoteException;

    public abstract String getElementTitle(T var1, String var2);

    public abstract String getElementLink(T var1, String var2);

    public abstract String getElementDescription(T var1, String var2);

    public abstract Date getElementDate(T var1);

    public abstract String getElementCreatorId(T var1);

    public String getExternalCreatorId(T element) {
        return "";
    }

    protected String getObjectId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo.substring(1);
        }
        return null;
    }

    protected String getUserId(HttpServletRequest request) {
        return request.getParameter("userId");
    }

    protected String getLogin(HttpServletRequest request) {
        return request.getParameter("login");
    }

    protected String getPassword(HttpServletRequest request) {
        return request.getParameter("password");
    }

    protected MainSessionController getMainSessionController(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        MainSessionController mainSessionCtrl = (MainSessionController)session.getAttribute("SilverSessionController");
        return mainSessionCtrl;
    }

    protected boolean isUserLogin(HttpServletRequest req) {
        return this.getMainSessionController(req) != null;
    }

    protected void objectNotFound(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean isLoggedIn = this.isUserLogin(req);
        if (!isLoggedIn) {
            res.sendRedirect("/weblib/notFound.html");
        } else {
            res.sendRedirect(URLManager.getApplicationURL() + "/admin/jsp/documentNotFound.jsp");
        }
    }
}

