/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.portlets.portal.portletwindow;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURL;
import com.sun.portal.container.ChannelURLType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletWindowURL
implements ChannelURL {
    private String desktopURL;
    private Map<String, String[]> parametersMap;
    private Map<String, List<String>> properties;
    private ChannelURLType urlType;
    private ChannelMode newPortletWindowMode;
    private ChannelState newWindowState;
    private boolean secure = false;
    private String cacheLevel;
    private String resourceID;
    private static Logger logger = Logger.getLogger("com.silverpeas.portlets.portal.portletwindow", "org.silverpeas.portlets.PCDLogMessages");

    public PortletWindowURL(String desktopURL) {
        this.desktopURL = desktopURL;
    }

    public void setChannelMode(ChannelMode newChannelMode) {
        this.newPortletWindowMode = newChannelMode;
    }

    public void setWindowState(ChannelState newWindowState) {
        this.newWindowState = newWindowState;
    }

    public void setURLType(ChannelURLType urlType) {
        this.urlType = urlType;
    }

    public void setParameter(String name, String value) {
        String[] values = new String[]{value};
        this.setParameter(name, values);
    }

    public void setParameter(String name, String[] values) {
        if (this.parametersMap == null) {
            this.parametersMap = new HashMap<String, String[]>();
        }
        this.parametersMap.put(name, values);
    }

    public void setParameters(Map<String, String[]> parametersMap) {
        this.parametersMap = parametersMap;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.properties.put(name, values);
    }

    public void addProperty(String name, String value) {
        if (name == null) {
            return;
        }
        List<String> values = null;
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        } else {
            values = this.properties.get(name);
        }
        if (values == null) {
            values = new ArrayList<String>();
        }
        if (value == null) {
            value = "";
        }
        values.add(value);
        this.properties.put(name, values);
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setCacheLevel(String cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public ChannelState getWindowState() {
        return this.newWindowState;
    }

    public ChannelMode getChannelMode() {
        return this.newPortletWindowMode;
    }

    public ChannelURLType getURLType() {
        return this.urlType;
    }

    public Map<String, String[]> getParameters() {
        return this.parametersMap;
    }

    public Map<String, List<String>> getProperties() {
        return this.properties;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getCacheLevel() {
        return this.cacheLevel;
    }

    public String toString() {
        Object values;
        String key;
        Set<Map.Entry<String, Object>> entries;
        StringBuffer buffer = new StringBuffer();
        int index = this.desktopURL.indexOf("?");
        String processURL = index != -1 ? this.desktopURL.substring(index + 1) : this.desktopURL;
        StringTokenizer tokens = new StringTokenizer(processURL, "&");
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int equalIndex = token.indexOf("=");
            if (equalIndex == -1) continue;
            String internalKey = token.substring(0, equalIndex);
            String internalValue = token.substring(equalIndex + 1);
            keyValueMap.put(internalKey, internalValue);
        }
        buffer.append(this.desktopURL.substring(0, index));
        buffer.append("?");
        keyValueMap.put("pc.portletAction", this.urlType.toString());
        if (this.urlType.toString().equals("RESOURCE")) {
            keyValueMap.put("dt.driverAction", "RESOURCE");
        }
        if (this.newWindowState != null) {
            keyValueMap.put("pc.newWindowState", this.newWindowState.toString());
        }
        if (this.newPortletWindowMode != null) {
            keyValueMap.put("pc.newPortletMode", this.newPortletWindowMode.toString());
        }
        if (this.resourceID != null) {
            try {
                keyValueMap.put("pc.resourceID", URLEncoder.encode(this.resourceID, "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                logger.log(Level.WARNING, "PSPCD_CSPPD0049", uee);
            }
        }
        if (this.cacheLevel != null) {
            keyValueMap.put("pc.cacheLevel", this.cacheLevel);
        }
        for (Map.Entry entry : keyValueMap.entrySet()) {
            String key2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            buffer.append("&").append(key2);
            buffer.append("=").append(value);
        }
        if (this.parametersMap != null) {
            entries = this.parametersMap.entrySet();
            for (Map.Entry<String, Object> mapEntry : entries) {
                key = mapEntry.getKey();
                values = (String[])mapEntry.getValue();
                try {
                    if (this.isEncodingNeeded(key)) {
                        key = URLEncoder.encode(key, "UTF-8");
                    }
                    for (int j = 0; j < ((String[])values).length; ++j) {
                        buffer.append("&").append(key);
                        if (this.isEncodingNeeded((String)values[j])) {
                            buffer.append("=").append(URLEncoder.encode((String)values[j], "UTF-8"));
                            continue;
                        }
                        buffer.append("=").append((String)values[j]);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.log(Level.INFO, "PSPCD_CSPPD0009", uee.toString());
                }
            }
        }
        if (this.properties != null) {
            entries = this.properties.entrySet();
            for (Map.Entry<String, Object> mapEntry : entries) {
                key = mapEntry.getKey();
                values = (List)mapEntry.getValue();
                try {
                    if (this.isEncodingNeeded(key)) {
                        key = URLEncoder.encode(key, "UTF-8");
                    }
                    Iterator i$ = values.iterator();
                    while (i$.hasNext()) {
                        String value = (String)i$.next();
                        buffer.append("&").append(key);
                        if (this.isEncodingNeeded(value)) {
                            buffer.append("=").append(URLEncoder.encode(value, "UTF-8"));
                            continue;
                        }
                        buffer.append("=").append(value);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.log(Level.INFO, "PSPCD_CSPPD0009", uee.toString());
                }
            }
        }
        return buffer.toString();
    }

    private boolean isEncodingNeeded(String value) {
        boolean needsEncoding = false;
        if (value != null) {
            int length = value.length();
            for (int i = 0; !needsEncoding && i < length; ++i) {
                char c = value.charAt(i);
                needsEncoding = !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '-' || c == '*' || c == '_');
            }
        }
        return needsEncoding;
    }
}

