/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProfileResourceBaseURIs {
    public static final String USERS_BASE_URI = "profile/users";
    public static final String GROUPS_BASE_URI = "profile/groups";

    public static URI uriOfUser(String userId) {
        try {
            return new URI("profile/users/" + userId);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProfileResourceBaseURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static URI uriOfUser(UserDetail user, String atUsersUri) {
        try {
            return new URI(atUsersUri + "/" + user.getId());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProfileResourceBaseURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static URI computeParentUriOfGroupByUri(URI groupUri) {
        String uri = groupUri.toString();
        String parentUri = uri.replaceAll("/groups/[0-9]+$", "");
        if (parentUri.endsWith("profile")) {
            return null;
        }
        try {
            return new URI(parentUri);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProfileResourceBaseURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static URI uriOfGroup(Group group, String atGroupsUri) {
        try {
            return new URI(atGroupsUri + "/" + group.getId());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProfileResourceBaseURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static URI computeChildrenUriOfGroupByUri(URI groupUri) {
        try {
            return new URI(groupUri.toString() + "/groups");
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProfileResourceBaseURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static URI computeUsersUriOfGroupById(URI groupUri, String groupId) {
        try {
            return new URI(ProfileResourceBaseURIs.getUsersBaseUriFromGroupUri(groupUri) + "?group=" + groupId);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProfileResourceBaseURIs.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String getUsersBaseUriFromGroupUri(URI groupUri) {
        String groupUriAsString = groupUri.toString();
        return groupUriAsString.substring(0, groupUriAsString.indexOf(GROUPS_BASE_URI)) + USERS_BASE_URI;
    }
}

