/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.silverpeas.profile.web.ProfileResourceBaseURIs;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.Exposable;
import com.stratelia.webactiv.beans.admin.Group;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class UserGroupProfileEntity
extends Group
implements Exposable {
    private static final long serialVersionUID = 6383835034479351000L;
    @XmlElement
    private URI uri;
    @XmlElement
    private URI parentUri;
    @XmlElement
    private URI childrenUri;
    @XmlElement
    private URI usersUri;
    @XmlElement
    private int userCount = -1;
    @XmlElement
    @NotNull
    @Size(min=1)
    private String domainName;
    private final Group group;

    public static UserGroupProfileEntity fromGroup(Group group) {
        return new UserGroupProfileEntity(group);
    }

    public static UserGroupProfileEntity[] fromGroups(List<? extends Group> groups, URI groupsURI) {
        UserGroupProfileEntity[] selectableGroups = new UserGroupProfileEntity[groups.size()];
        String fromGroupsUri = groupsURI.toString();
        int i = 0;
        for (Group group : groups) {
            selectableGroups[i++] = UserGroupProfileEntity.fromGroup(group).withAsUri(ProfileResourceBaseURIs.uriOfGroup(group, fromGroupsUri));
        }
        return selectableGroups;
    }

    private UserGroupProfileEntity(Group group) {
        this.group = group;
        this.domainName = Group.getOrganisationController().getDomain(group.getDomainId()).getName();
        this.userCount = group.getTotalNbUsers();
    }

    protected UserGroupProfileEntity() {
        this.group = new Group();
    }

    public UserGroupProfileEntity withAsUri(URI groupUri) {
        this.uri = groupUri;
        this.childrenUri = ProfileResourceBaseURIs.computeChildrenUriOfGroupByUri(groupUri);
        if (StringUtil.isDefined((String)this.getSuperGroupId())) {
            this.parentUri = ProfileResourceBaseURIs.computeParentUriOfGroupByUri(groupUri);
        }
        this.usersUri = ProfileResourceBaseURIs.computeUsersUriOfGroupById(groupUri, this.getId());
        return this;
    }

    public URI getParentUri() {
        return this.parentUri;
    }

    public URI getChildrenUri() {
        return this.childrenUri;
    }

    public URI getUsersUri() {
        return this.usersUri;
    }

    @XmlElement
    public String getDescription() {
        return this.group.getDescription();
    }

    @XmlElement
    public String getId() {
        return this.group.getId();
    }

    @XmlElement
    public String getName() {
        return this.group.getName();
    }

    public int getNbUsers() {
        return this.group.getNbUsers();
    }

    public int getTotalNbUsers() {
        if (this.userCount == -1) {
            this.userCount = this.group.getTotalNbUsers();
        }
        return this.userCount;
    }

    @XmlElement
    public String getSpecificId() {
        return this.group.getSpecificId();
    }

    public void setDescription(String newDescription) {
        this.group.setDescription(newDescription);
    }

    public void setId(String newId) {
        this.group.setId(newId);
    }

    public void setName(String newName) {
        this.group.setName(newName);
    }

    public void setNbUsers(int nbUsers) {
        this.group.setNbUsers(nbUsers);
    }

    @XmlElement
    public String getDomainId() {
        return this.group.getDomainId();
    }

    @XmlElement
    public String getSuperGroupId() {
        return this.group.getSuperGroupId();
    }

    public void setDomainId(String newDomainId) {
        this.group.setDomainId(newDomainId);
        this.domainName = Group.getOrganisationController().getDomain(newDomainId).getName();
    }

    public void setSpecificId(String newSpecificId) {
        this.group.setSpecificId(newSpecificId);
    }

    public void setSuperGroupId(String newSuperGroupId) {
        this.group.setSuperGroupId(newSuperGroupId);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<? extends Group> getSubGroups() {
        return this.group.getSubGroups();
    }

    public void traceGroup() {
        this.group.traceGroup();
    }

    public void setUserIds(String[] sUserIds) {
        this.group.setUserIds(sUserIds);
    }

    public void setRule(String rule) {
        this.group.setRule(rule);
    }

    public boolean isSynchronized() {
        return this.group.isSynchronized();
    }

    public boolean isRoot() {
        return this.group.isRoot();
    }

    public String[] getUserIds() {
        return this.group.getUserIds();
    }

    public String getRule() {
        return this.group.getRule();
    }

    public int compareTo(Group o) {
        return this.group.compareTo(o);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserGroupProfileEntity) {
            return this.group.equals((Object)((UserGroupProfileEntity)obj).group);
        }
        return this.group.equals(obj);
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }
}

