/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.profile.web.UserGroupProfileEntity;
import com.silverpeas.profile.web.UserGroupsSearchCriteriaBuilder;
import com.silverpeas.profile.web.UserProfileService;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.GroupsSearchCriteria;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.silverpeas.util.ListSlice;

@Service
@RequestScoped
@Path(value="profile/groups")
@Authenticated
public class UserGroupProfileResource
extends RESTWebService {
    public static final String RESPONSE_HEADER_GROUPSIZE = "X-Silverpeas-GroupSize";
    @Inject
    private UserProfileService profileService;

    @GET
    @Produces(value={"application/json"})
    public Response getAllRootGroups(@QueryParam(value="ids") Set<String> groupIds, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain) {
        String domainId;
        UserGroupsSearchCriteriaBuilder criteriaBuilder = UserGroupsSearchCriteriaBuilder.aSearchCriteria();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            criteriaBuilder.withGroupIds(groupIds.toArray(new String[groupIds.size()]));
        } else {
            criteriaBuilder.withRootGroupSet();
        }
        String string = domainId = "-1".equals(domain) ? null : domain;
        if (this.getUserDetail().isDomainRestricted()) {
            domainId = this.getUserDetail().getDomainId();
            criteriaBuilder.withMixedDomainId();
        }
        criteriaBuilder.withDomainId(domainId).withName(name).withPaginationPage(this.fromPage(page));
        ListSlice allGroups = this.getOrganisationController().searchGroups(criteriaBuilder.build());
        UserGroupProfileEntity[] entities = this.asWebEntity((List<? extends Group>)allGroups, UserGroupProfileResource.locatedAt(this.getUriInfo().getAbsolutePath()));
        return Response.ok((Object)entities).header(RESPONSE_HEADER_GROUPSIZE, (Object)allGroups.getOriginalListSize()).build();
    }

    @GET
    @Path(value="application/{instanceId}")
    @Produces(value={"application/json"})
    public Response getGroupsInApplication(@PathParam(value="instanceId") String instanceId, @QueryParam(value="roles") String roles, @QueryParam(value="resource") String resource, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain) {
        GroupsSearchCriteria criteria;
        String domainId;
        String[] roleNames = StringUtil.isDefined((String)roles) ? roles.split(",") : new String[]{};
        String string = domainId = "-1".equals(domain) ? null : domain;
        if (this.getUserDetail().isDomainRestricted()) {
            domainId = this.getUserDetail().getDomainId();
            criteria = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withComponentInstanceId(instanceId).withRoles(roleNames).withResourceId(resource).withDomainId(domainId).withMixedDomainId().withName(name).withPaginationPage(this.fromPage(page)).build();
        } else {
            criteria = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withComponentInstanceId(instanceId).withRoles(roleNames).withResourceId(resource).withDomainId(domainId).withName(name).withPaginationPage(this.fromPage(page)).build();
        }
        ListSlice groups = this.getOrganisationController().searchGroups(criteria);
        URI groupsUri = this.getUriInfo().getBaseUriBuilder().path("profile/groups").build(new Object[0]);
        return Response.ok((Object)this.asWebEntity((List<? extends Group>)groups, UserGroupProfileResource.locatedAt(groupsUri))).header(RESPONSE_HEADER_GROUPSIZE, (Object)groups.getOriginalListSize()).build();
    }

    @GET
    @Path(value="{path: [0-9]+(/groups/[0-9]+)*}")
    @Produces(value={"application/json"})
    public UserGroupProfileEntity getGroup(@PathParam(value="path") String groupPath) {
        String[] groupIds = groupPath.split("/groups/");
        String groupId = groupIds[groupIds.length - 1];
        Group theGroup = this.profileService.getGroupAccessibleToUser(groupId, this.getUserDetail());
        return this.asWebEntity(theGroup, UserGroupProfileResource.identifiedBy(this.getUriInfo().getAbsolutePath()));
    }

    @GET
    @Path(value="{path:[0-9]+/groups(/[0-9]+/groups)*}")
    @Produces(value={"application/json"})
    public Response getSubGroups(@PathParam(value="path") String groups, @QueryParam(value="name") String name, @QueryParam(value="page") String page) {
        GroupsSearchCriteria criteria;
        String[] groupIds = groups.split("/groups/?");
        String groupId = groupIds[groupIds.length - 1];
        this.profileService.getGroupAccessibleToUser(groupId, this.getUserDetail());
        if (this.getUserDetail().isDomainRestricted()) {
            String domainId = this.getUserDetail().getDomainId();
            criteria = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withSuperGroupId(groupId).withDomainId(domainId).withMixedDomainId().withName(name).withPaginationPage(this.fromPage(page)).build();
        } else {
            criteria = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withSuperGroupId(groupId).withName(name).withPaginationPage(this.fromPage(page)).build();
        }
        ListSlice subgroups = this.getOrganisationController().searchGroups(criteria);
        return Response.ok((Object)this.asWebEntity((List<? extends Group>)subgroups, UserGroupProfileResource.locatedAt(this.getUriInfo().getAbsolutePath()))).header(RESPONSE_HEADER_GROUPSIZE, (Object)subgroups.getOriginalListSize()).build();
    }

    @Override
    public String getComponentId() {
        throw new UnsupportedOperationException("The UserGroupProfileResource doesn't belong to any component instances");
    }

    protected static URI locatedAt(URI uri) {
        return uri;
    }

    protected static URI identifiedBy(URI uri) {
        return uri;
    }

    private UserGroupProfileEntity[] asWebEntity(List<? extends Group> allGroups, URI baseUri) {
        return UserGroupProfileEntity.fromGroups(allGroups, baseUri);
    }

    private UserGroupProfileEntity asWebEntity(Group group, URI groupUri) {
        return UserGroupProfileEntity.fromGroup(group).withAsUri(groupUri);
    }

    private PaginationPage fromPage(String page) {
        PaginationPage paginationPage = null;
        if (page != null && !page.isEmpty()) {
            String[] pageAttributes = page.split(";");
            int nth = Integer.valueOf(pageAttributes[0]);
            int count = Integer.valueOf(pageAttributes[1]);
            paginationPage = new PaginationPage(nth, count);
        }
        return paginationPage;
    }
}

