/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.GroupsSearchCriteria;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.UserDetailsSearchCriteria;

public class UserGroupsSearchCriteriaBuilder {
    private GroupsSearchCriteria searchCriteria = new GroupsSearchCriteria();
    private String domainId = null;
    private boolean withMixedDomain = false;

    public static UserGroupsSearchCriteriaBuilder aSearchCriteria() {
        return new UserGroupsSearchCriteriaBuilder();
    }

    public UserGroupsSearchCriteriaBuilder withName(String name) {
        if (StringUtil.isDefined((String)name)) {
            String filterByName = name.replaceAll("\\*", "%");
            this.searchCriteria.onName(filterByName);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined((String)instanceId)) {
            this.searchCriteria.onComponentInstanceId(instanceId);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withResourceId(String resourceId) {
        if (StringUtil.isDefined((String)resourceId)) {
            this.searchCriteria.onResourceId(resourceId);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withRoles(String[] roleIds) {
        if (roleIds != null && roleIds.length > 0) {
            this.searchCriteria.onRoleNames(roleIds);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withGroupId(String groupId) {
        if (StringUtil.isDefined((String)groupId)) {
            if (groupId.equals("all")) {
                this.searchCriteria.onGroupIds(UserDetailsSearchCriteria.ANY_GROUPS);
            } else {
                this.searchCriteria.onGroupIds(new String[]{groupId});
            }
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withGroupIds(String[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            this.searchCriteria.onGroupIds(groupIds);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withSuperGroupId(String groupId) {
        if (StringUtil.isDefined((String)groupId)) {
            this.searchCriteria.onSuperGroupId(groupId);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withRootGroupSet() {
        this.searchCriteria.onAsRootGroup();
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withMixedDomainId() {
        this.withMixedDomain = true;
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withUserIds(String[] userIds) {
        if (userIds != null && userIds.length > 0) {
            this.searchCriteria.onUserIds(userIds);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withPaginationPage(PaginationPage page) {
        this.searchCriteria.onPagination(page);
        return this;
    }

    public GroupsSearchCriteria build() {
        if (this.withMixedDomain) {
            this.searchCriteria.onMixedDomainOrOnDomainId(this.domainId);
        } else if (StringUtil.isDefined((String)this.domainId)) {
            this.searchCriteria.onDomainId(this.domainId);
        }
        return this.searchCriteria;
    }

    private UserGroupsSearchCriteriaBuilder() {
    }
}

