/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.profile.web.ProfileResourceBaseURIs;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.Exposable;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class UserProfileEntity
extends UserDetail
implements Exposable {
    private static final long serialVersionUID = -5011846708353591604L;
    private UserDetail user = null;
    @XmlElement(required=true)
    private URI uri;
    @XmlElement
    private String webPage;
    @XmlElement
    private String tchatPage;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private String avatar;
    @XmlElement
    private String domainName;
    @XmlElement(required=true, defaultValue="")
    @NotNull
    private String fullName = "";
    @XmlElement(defaultValue="")
    private String language = "";
    @XmlElement(defaultValue="false")
    private boolean connected = false;
    @XmlElement(defaultValue="false")
    private boolean anonymous = false;

    public static UserProfileEntity fromUser(UserDetail user) {
        return new UserProfileEntity(user);
    }

    public static UserProfileEntity[] fromUsers(List<? extends UserDetail> users, URI usersUri) {
        UserProfileEntity[] selectableUsers = new UserProfileEntity[users.size()];
        String fromUsersUri = usersUri.toString();
        int i = 0;
        for (UserDetail userDetail : users) {
            selectableUsers[i++] = UserProfileEntity.fromUser(userDetail).withAsUri(ProfileResourceBaseURIs.uriOfUser(userDetail, fromUsersUri));
        }
        return selectableUsers;
    }

    protected UserProfileEntity(UserDetail user) {
        this.user = user;
        UserPreferences prefs = this.getUserPreferences();
        this.language = prefs != null ? prefs.getLanguage() : DisplayI18NHelper.getDefaultLanguage();
        this.domainName = user.getDomain() == null ? "" : user.getDomain().getName();
        this.fullName = user.getDisplayedName();
        this.avatar = this.getAvatarURI();
        this.connected = this.user.isConnected();
        this.webPage = this.getUserProfileWebPageURI();
        this.tchatPage = this.getTchatWebPageURI();
        this.anonymous = user.isAnonymous();
    }

    @XmlElement(required=true)
    public String getId() {
        return this.user.getId();
    }

    @XmlElement(required=true)
    public UserAccessLevel getAccessLevel() {
        return this.user.getAccessLevel();
    }

    @XmlElement
    public String getDomainId() {
        return this.user.getDomainId();
    }

    @XmlElement(required=true)
    public String getFirstName() {
        return this.user.getFirstName();
    }

    @XmlElement(required=true)
    public String getLastName() {
        return this.user.getLastName();
    }

    @XmlElement
    public String geteMail() {
        return this.user.geteMail();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setAccessLevel(UserAccessLevel accessLevel) {
        this.user.setAccessLevel(accessLevel);
    }

    public void setDomainId(String sDomainId) {
        this.user.setDomainId(sDomainId);
        this.domainName = this.user.getDomain().getId();
    }

    public void setFirstName(String sFirstName) {
        this.user.setFirstName(sFirstName);
        this.fullName = this.user.getDisplayedName();
    }

    public void setLastName(String sLastName) {
        this.user.setLastName(sLastName);
        this.fullName = this.user.getDisplayedName();
    }

    public void seteMail(String seMail) {
        this.user.seteMail(seMail);
    }

    public String getAvatar() {
        if (!StringUtil.isDefined((String)this.avatar)) {
            this.avatar = this.getAvatarURI();
        }
        return this.avatar;
    }

    public String getWebPage() {
        if (!StringUtil.isDefined((String)this.webPage)) {
            this.webPage = this.getUserProfileWebPageURI();
        }
        return this.webPage;
    }

    public String getTchatPage() {
        if (!StringUtil.isDefined((String)this.tchatPage)) {
            this.tchatPage = this.getUserProfileWebPageURI();
        }
        return this.tchatPage;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @XmlElement
    public String getSpecificId() {
        return this.user.getSpecificId();
    }

    public void setSpecificId(String sSpecificId) {
        this.user.setSpecificId(sSpecificId);
    }

    @XmlElement
    public String getLogin() {
        return this.user.getLogin();
    }

    public void setLogin(String sLogin) {
        this.user.setLogin(sLogin);
    }

    @XmlElement(defaultValue="")
    public String getStatus() {
        return this.user.getStatus();
    }

    public void setStatus(String newStatus) {
    }

    public String getDomainName() {
        return this.domainName;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public UserProfileEntity withAsUri(URI userUri) {
        this.uri = userUri;
        return this;
    }

    public UserDetail toUserDetail() {
        return this.user;
    }

    protected UserProfileEntity() {
        this.user = new UserDetail();
    }

    public void setId(String id) {
        this.user.setId(id);
    }

    public boolean equals(Object other) {
        if (other instanceof UserProfileEntity) {
            return this.user.equals((Object)((UserProfileEntity)other).user);
        }
        return this.user.equals(other);
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    private String getAvatarURI() {
        String avatarURI = this.user.getAvatar();
        WebApplicationContext context = ContextLoaderListener.getCurrentWebApplicationContext();
        if (context != null) {
            avatarURI = context.getServletContext().getContextPath() + avatarURI;
        }
        return avatarURI;
    }

    private String getUserProfileWebPageURI() {
        String pageUri = "/Rprofil/jsp/Main?userId=" + this.user.getId();
        WebApplicationContext context = ContextLoaderListener.getCurrentWebApplicationContext();
        pageUri = context != null ? context.getServletContext().getContextPath() + pageUri : URLManager.getApplicationURL() + pageUri;
        return pageUri;
    }

    private String getTchatWebPageURI() {
        String pageUri = "/RcommunicationUser/jsp/OpenDiscussion?userId=" + this.user.getId();
        WebApplicationContext context = ContextLoaderListener.getCurrentWebApplicationContext();
        pageUri = context != null ? context.getServletContext().getContextPath() + pageUri : URLManager.getApplicationURL() + pageUri;
        return pageUri;
    }
}

